/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.dtrace;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.dtrace.SimpleProfilerSettingsState;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.fields.IntegerField;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import java.util.Collection;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\tH\u0016J\b\u0010\u0013\u001a\u00020\tH\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u000fH\u0016J\u0011\u0010\u0017\u001a\u00020\t*\u00070\t\u00a2\u0006\u0002\b\u0018H\u0003R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\t8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/profiler/dtrace/DTraceConfigurable;", "Lcom/intellij/openapi/options/SearchableConfigurable;", "settings", "Lcom/intellij/profiler/dtrace/SimpleProfilerSettingsState;", "Lcom/intellij/profiler/dtrace/DTraceSettingsState;", "(Lcom/intellij/profiler/dtrace/SimpleProfilerSettingsState;)V", "commandLine", "Lcom/intellij/ui/components/JBTextField;", "commandLineStr", "", "executable", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "frequency", "Lcom/intellij/ui/components/fields/IntegerField;", "apply", "", "createComponent", "Lcom/intellij/openapi/ui/DialogPanel;", "getDisplayName", "getId", "isModified", "", "reset", "withTrailingColon", "Lorg/jetbrains/annotations/Nls;", "Companion", "intellij.profiler.common"})
public final class DTraceConfigurable
implements SearchableConfigurable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SimpleProfilerSettingsState settings;
    @NotNull
    private final TextFieldWithBrowseButton executable;
    @NotNull
    private final IntegerField frequency;
    @NlsSafe
    @NotNull
    private final String commandLineStr;
    @NotNull
    private final JBTextField commandLine;
    @NotNull
    public static final String ID = "dynamic.analysis.tools.profiler.dtrace";

    /*
     * WARNING - void declaration
     */
    public DTraceConfigurable(@NotNull SimpleProfilerSettingsState settings) {
        void $this$frequency_u24lambda_u241;
        TextFieldWithBrowseButton $this$executable_u24lambda_u240;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        Intrinsics.checkNotNullParameter((Object)((Object)settings), (String)"settings");
        this.settings = settings;
        String string = CommonProfilerBundleKt.profilerMessage("dtrace.executable", new Object[0]);
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)fileChooserDescriptor, (String)"createSingleFolderDescriptor(...)");
        TextFieldWithBrowseButton textFieldWithBrowseButton2 = textFieldWithBrowseButton = ComponentsKt.textFieldWithBrowseButton$default(null, (String)string, (FileChooserDescriptor)fileChooserDescriptor, null, (int)8, null);
        DTraceConfigurable dTraceConfigurable = this;
        boolean bl = false;
        String string2 = this.settings.getExecutablePath();
        if (string2 == null) {
            string2 = "";
        }
        $this$executable_u24lambda_u240.setText(string2);
        dTraceConfigurable.executable = textFieldWithBrowseButton;
        $this$executable_u24lambda_u240 = textFieldWithBrowseButton = new IntegerField(null, 0, Integer.MAX_VALUE);
        dTraceConfigurable = this;
        boolean bl2 = false;
        $this$frequency_u24lambda_u241.setValue(Integer.valueOf(this.settings.getSamplingFrequency()));
        $this$frequency_u24lambda_u241.setDefaultValue(Integer.valueOf(this.settings.getSamplingFrequency()));
        dTraceConfigurable.frequency = textFieldWithBrowseButton;
        this.commandLineStr = CollectionsKt.joinToString$default((Iterable)this.settings.getDefaultCmdArgs(), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        this.commandLine = new JBTextField(this.commandLineStr);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isModified() {
        String string = this.executable.getText();
        String string2 = this.settings.getExecutablePath();
        if (string2 == null) {
            string2 = "";
        }
        if (!Intrinsics.areEqual((Object)string, (Object)string2)) return true;
        Integer n = this.frequency.getValue();
        int n2 = this.settings.getSamplingFrequency();
        if (n == null) return true;
        if (n != n2) return true;
        if (Intrinsics.areEqual((Object)this.commandLine.getText(), (Object)this.commandLineStr)) return false;
        return true;
    }

    @NotNull
    public String getId() {
        return ID;
    }

    @NotNull
    public String getDisplayName() {
        return CommonProfilerBundleKt.profilerMessage("dtrace.name", new Object[0]);
    }

    @NotNull
    public DialogPanel createComponent() {
        return BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(this){
            final /* synthetic */ DTraceConfigurable this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                $this$panel.row(DTraceConfigurable.access$withTrailingColon(this.this$0, CommonProfilerBundleKt.profilerMessage("dtrace.executable", new Object[0])), (Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ DTraceConfigurable this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        $this$row.cell((JComponent)DTraceConfigurable.access$getExecutable$p(this.this$0)).align((Align)AlignX.FILL.INSTANCE);
                    }
                });
                $this$panel.row(DTraceConfigurable.access$withTrailingColon(this.this$0, CommonProfilerBundleKt.profilerMessage("dtrace.sampling.frequency", new Object[0])), (Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ DTraceConfigurable this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        Cell.comment$default((Cell)$this$row.cell((JComponent)DTraceConfigurable.access$getFrequency$p(this.this$0)), (String)CommonProfilerBundleKt.profilerMessage("dtrace.comment.sample.per.second", new Object[0]), (int)0, null, (int)6, null).align((Align)AlignX.FILL.INSTANCE);
                    }
                });
                $this$panel.row(DTraceConfigurable.access$withTrailingColon(this.this$0, CommonProfilerBundleKt.profilerMessage("dtrace.command.line.arguments", new Object[0])), (Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ DTraceConfigurable this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        Cell.comment$default((Cell)$this$row.cell((JComponent)DTraceConfigurable.access$getCommandLine$p(this.this$0)), (String)CommonProfilerBundleKt.profilerMessage("dtrace.comment.command.line", new Object[0]), (int)0, null, (int)6, null).align((Align)AlignX.FILL.INSTANCE);
                    }
                });
            }
        }));
    }

    @Nls
    private final String withTrailingColon(String $this$withTrailingColon) {
        return $this$withTrailingColon + ":";
    }

    public void apply() {
        this.settings.setExecutablePath(this.executable.getText());
        Integer n = this.frequency.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getValue(...)");
        this.settings.setSamplingFrequency(((Number)n).intValue());
        String string = this.commandLine.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        char[] cArray = new char[]{' '};
        this.settings.setDefaultCmdArgs(CollectionsKt.toMutableList((Collection)StringsKt.split$default((CharSequence)string, (char[])cArray, (boolean)false, (int)0, (int)6, null)));
    }

    public void reset() {
        String string = this.settings.getExecutablePath();
        if (string == null) {
            string = "";
        }
        this.executable.setText(string);
        this.frequency.setValue(Integer.valueOf(this.settings.getSamplingFrequency()));
        this.commandLine.setText(this.commandLineStr);
    }

    public static final /* synthetic */ String access$withTrailingColon(DTraceConfigurable $this, String $receiver) {
        return $this.withTrailingColon($receiver);
    }

    public static final /* synthetic */ TextFieldWithBrowseButton access$getExecutable$p(DTraceConfigurable $this) {
        return $this.executable;
    }

    public static final /* synthetic */ IntegerField access$getFrequency$p(DTraceConfigurable $this) {
        return $this.frequency;
    }

    public static final /* synthetic */ JBTextField access$getCommandLine$p(DTraceConfigurable $this) {
        return $this.commandLine;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/profiler/dtrace/DTraceConfigurable$Companion;", "", "()V", "ID", "", "intellij.profiler.common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

