/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler;

import com.intellij.codeInsight.daemon.impl.PsiElementListNavigator;
import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.CommonProfilerUISettings;
import com.intellij.profiler.CommonProfilerUiOptions;
import com.intellij.profiler.ProfilerToolWindowManager;
import com.intellij.profiler.SnapshotFile;
import com.intellij.profiler.UtilsKt;
import com.intellij.profiler.api.BaseCallStackElement;
import com.intellij.profiler.api.ProfilerDumpWriterBase;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Consumer;
import com.intellij.util.SystemProperties;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0098\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t\u001a\u0013\u0010\u000e\u001a\u00070\u0001\u00a2\u0006\u0002\b\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0013\u0010\u0012\u001a\u00070\t\u00a2\u0006\u0002\b\u00132\u0006\u0010\u0014\u001a\u00020\u0015\u001a\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b\u001a\u0006\u0010\u001d\u001a\u00020\u0019\u001a9\u0010\u001e\u001a\u00020\u001f2\u000e\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\"0!2\u0006\u0010#\u001a\u00020$2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u001f0&H\u0002\u00a2\u0006\u0002\u0010'\u001aX\u0010(\u001a\u00020\u001f2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010#\u001a\u00020$2\u000e\b\u0002\u0010-\u001a\b\u0012\u0004\u0012\u00020\u001f0.2\b\b\u0002\u0010/\u001a\u00020\u00192\b\b\u0002\u00100\u001a\u00020\u00192\u0014\b\u0002\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u001f0&\u001a*\u00101\u001a\u00020\u001f2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u00102\u001a\u0002032\n\b\u0002\u00104\u001a\u0004\u0018\u000105\u001a\"\u00106\u001a\u00020\u001f2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\"2\b\b\u0002\u00107\u001a\u00020\u0019H\u0002\u001a\u0016\u00108\u001a\u00020\t*\u0002092\b\b\u0001\u0010:\u001a\u00020\tH\u0007\u001a\n\u0010;\u001a\u00020\u0011*\u00020\t\u001a\n\u0010<\u001a\u00020\u000b*\u00020\t\"\u001b\u0010\u0000\u001a\u00020\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0002\u0010\u0003*\u0016\u0010=\"\b\u0012\u0004\u0012\u00020\t0>2\b\u0012\u0004\u0012\u00020\t0>\u00a8\u0006?"}, d2={"profilerDumpsDir", "Ljava/io/File;", "getProfilerDumpsDir", "()Ljava/io/File;", "profilerDumpsDir$delegate", "Lkotlin/Lazy;", "createSnapshotFile", "Lcom/intellij/profiler/SnapshotFile;", "name", "", "timestamp", "", "type", "ext", "dtraceOutputFile", "Lorg/jetbrains/annotations/NotNull;", "pid", "", "durationToCompactString", "Lcom/intellij/openapi/util/NlsSafe;", "duration", "Ljava/time/Duration;", "getDefaultSnapshotFolder", "Ljava/nio/file/Path;", "isPrefixTo", "", "magic", "", "array", "keepTempProfilerFiles", "navigateOrCreatePopup", "", "navigatables", "", "Lcom/intellij/psi/NavigatablePsiElement;", "popupPoint", "Lcom/intellij/ui/awt/RelativePoint;", "doNavigate", "Lkotlin/Function1;", "([Lcom/intellij/psi/NavigatablePsiElement;Lcom/intellij/ui/awt/RelativePoint;Lkotlin/jvm/functions/Function1;)V", "navigateToSourceInBackground", "project", "Lcom/intellij/openapi/project/Project;", "element", "Lcom/intellij/profiler/api/BaseCallStackElement;", "onDumb", "Lkotlin/Function0;", "showWarnings", "openInPreviewTab", "navigateToSourceWithSingleClick", "component", "Ljavax/swing/JComponent;", "event", "Ljava/awt/event/MouseEvent;", "performNavigate", "preview", "explain", "", "prefix", "parseHexInt", "parseHexLong", "StringCallStackElement", "Lcom/intellij/profiler/ValueCallStackElement;", "intellij.profiler.common"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\ncom/intellij/profiler/UtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,185:1\n1#2:186\n*E\n"})
public final class UtilsKt {
    @NotNull
    private static final Lazy profilerDumpsDir$delegate = LazyKt.lazy((Function0)profilerDumpsDir.2.INSTANCE);

    public static final long parseHexLong(@NotNull String $this$parseHexLong) {
        Intrinsics.checkNotNullParameter((Object)$this$parseHexLong, (String)"<this>");
        return Long.parseLong(StringsKt.startsWith$default((String)$this$parseHexLong, (String)"0x", (boolean)false, (int)2, null) ? StringsKt.drop((String)$this$parseHexLong, (int)2) : $this$parseHexLong, CharsKt.checkRadix((int)16));
    }

    public static final int parseHexInt(@NotNull String $this$parseHexInt) {
        Intrinsics.checkNotNullParameter((Object)$this$parseHexInt, (String)"<this>");
        return Integer.parseInt(StringsKt.startsWith$default((String)$this$parseHexInt, (String)"0x", (boolean)false, (int)2, null) ? StringsKt.drop((String)$this$parseHexInt, (int)2) : $this$parseHexInt, CharsKt.checkRadix((int)16));
    }

    public static final boolean keepTempProfilerFiles() {
        Application it = ApplicationManager.getApplication();
        boolean bl = false;
        return it.isInternal() || it.isUnitTestMode();
    }

    @NotNull
    public static final File dtraceOutputFile(int pid2) {
        File file2 = FileUtil.createTempFile((File)UtilsKt.getProfilerDumpsDir(), (String)("raw-dtrace-" + pid2), (String)".dump", (boolean)true, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"createTempFile(...)");
        return file2;
    }

    private static final File getProfilerDumpsDir() {
        Lazy lazy = profilerDumpsDir$delegate;
        return (File)lazy.getValue();
    }

    @NlsSafe
    @NotNull
    public static final String explain(@NotNull Throwable $this$explain, @Nls @NotNull String prefix) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$explain, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        if (!(((CharSequence)prefix).length() > 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        StringBuilder $this$explain_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$explain_u24lambda_u241.append(prefix);
        $this$explain_u24lambda_u241.append(": ");
        $this$explain_u24lambda_u241.append($this$explain.getClass().getCanonicalName());
        if ($this$explain.getMessage() != null) {
            $this$explain_u24lambda_u241.append(": " + $this$explain.getMessage());
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public static final SnapshotFile createSnapshotFile(@NotNull String name, long timestamp, @NotNull String type, @NotNull String ext) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)ext, (String)"ext");
        temp = false;
        dumpFile = null;
        v0 = ((CommonProfilerUiOptions)CommonProfilerUISettings.Companion.getInstance().getState()).getSnapshotOptions().getFolder();
        if (v0 == null) ** GOTO lbl-1000
        p0 = var9_6 = v0;
        $i$a$-takeIf-UtilsKt$createSnapshotFile$snapshotsFolder$1 = false;
        v0 = StringsKt.isBlank((CharSequence)p0) == false != false ? var9_6 : null;
        if (v0 != null) {
            p0 = v0;
            $i$a$-let-UtilsKt$createSnapshotFile$snapshotsFolder$2 = false;
            v1 = Path.of(p0, new String[0]);
        } else lbl-1000:
        // 2 sources

        {
            v1 = null;
        }
        var8_9 = v1;
        snapshotsFolder = var8_9 == null ? UtilsKt.getDefaultSnapshotFolder() : var8_9;
        v2 = new LinkOption[]{};
        if (Files.exists(snapshotsFolder, Arrays.copyOf(v2, v2.length))) {
            dumpFileName = new ProfilerDumpWriterBase(name, timestamp){

                public void writeDump(@NotNull File outputFile, @NotNull ProgressIndicator indicator) {
                    Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                }
            }.getDumpFileName();
            temp = ApplicationManager.getApplication().isUnitTestMode();
            v3 = FileUtil.findSequentNonexistentFile((File)snapshotsFolder.toFile(), (String)FileUtil.sanitizeFileName((String)dumpFileName), (String)ext);
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"findSequentNonexistentFile(...)");
            dumpFile = v3;
        } else {
            temp = true;
            v4 = FileUtil.createTempFile((String)type, (String)("." + ext), (boolean)false);
            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"createTempFile(...)");
            dumpFile = v4;
        }
        return new SnapshotFile(dumpFile, temp);
    }

    @NotNull
    public static final Path getDefaultSnapshotFolder() {
        String custom = System.getProperty("snapshots.path");
        if (custom != null) {
            Path path = Path.of(custom, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
            return path;
        }
        String[] stringArray = new String[]{"IdeaSnapshots"};
        Path path = Path.of(SystemProperties.getUserHome(), stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
        return path;
    }

    public static final void navigateToSourceWithSingleClick(@NotNull Project project, @NotNull BaseCallStackElement element2, @NotNull JComponent component, @Nullable MouseEvent event) {
        block2: {
            Serializable serializable;
            block4: {
                block3: {
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
                    Intrinsics.checkNotNullParameter((Object)component, (String)"component");
                    if (!((CommonProfilerUiOptions)CommonProfilerUISettings.Companion.getInstance().getState()).getFlameGraphState().getNavigateWithSingleClick()) break block2;
                    serializable = event;
                    if (serializable == null || (serializable = serializable.getLocationOnScreen()) == null) break block3;
                    Serializable it = serializable;
                    boolean bl = false;
                    RelativePoint relativePoint = RelativePoint.fromScreen((Point)it);
                    serializable = relativePoint;
                    if (relativePoint != null) break block4;
                }
                serializable = RelativePoint.getCenterOf((JComponent)component);
            }
            Serializable serializable2 = serializable;
            Intrinsics.checkNotNull((Object)serializable2);
            Serializable point = serializable2;
            UtilsKt.navigateToSourceInBackground$default(project, element2, (RelativePoint)point, null, false, true, null, 72, null);
        }
    }

    public static /* synthetic */ void navigateToSourceWithSingleClick$default(Project project, BaseCallStackElement baseCallStackElement, JComponent jComponent, MouseEvent mouseEvent, int n, Object object) {
        if ((n & 8) != 0) {
            mouseEvent = null;
        }
        UtilsKt.navigateToSourceWithSingleClick(project, baseCallStackElement, jComponent, mouseEvent);
    }

    private static final void performNavigate(Project project, NavigatablePsiElement element2, boolean preview) {
        ApplicationManager.getApplication().executeOnPooledThread(() -> UtilsKt.performNavigate$lambda$4(element2, project, preview));
    }

    static /* synthetic */ void performNavigate$default(Project project, NavigatablePsiElement navigatablePsiElement, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        UtilsKt.performNavigate(project, navigatablePsiElement, bl);
    }

    public static final void navigateToSourceInBackground(@NotNull Project project, @NotNull BaseCallStackElement element2, @NotNull RelativePoint popupPoint, @NotNull Function0<Unit> onDumb, boolean showWarnings, boolean openInPreviewTab, @NotNull Function1<? super NavigatablePsiElement, Unit> doNavigate) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)popupPoint, (String)"popupPoint");
        Intrinsics.checkNotNullParameter(onDumb, (String)"onDumb");
        Intrinsics.checkNotNullParameter(doNavigate, (String)"doNavigate");
        String string = CommonProfilerBundleKt.profilerMessage("ui.action.navigate", new Object[0]);
        PerformInBackgroundOption performInBackgroundOption = Task.Backgroundable.ALWAYS_BACKGROUND;
        new Task.Backgroundable(project, onDumb, element2, showWarnings, popupPoint, doNavigate, string, performInBackgroundOption){
            final /* synthetic */ Project $project;
            final /* synthetic */ Function0<Unit> $onDumb;
            final /* synthetic */ BaseCallStackElement $element;
            final /* synthetic */ boolean $showWarnings;
            final /* synthetic */ RelativePoint $popupPoint;
            final /* synthetic */ Function1<NavigatablePsiElement, Unit> $doNavigate;
            {
                this.$project = $project;
                this.$onDumb = $onDumb;
                this.$element = $element;
                this.$showWarnings = $showWarnings;
                this.$popupPoint = $popupPoint;
                this.$doNavigate = $doNavigate;
                super($project, $super_call_param$1, true, $super_call_param$2);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                if (DumbService.Companion.isDumb(this.$project)) {
                    this.$onDumb.invoke();
                    return;
                }
                NavigatablePsiElement[] navigatables = this.$element.calcNavigatables(this.$project);
                if (navigatables.length == 0) {
                    if (this.$showWarnings) {
                        ProfilerToolWindowManager.Companion.getInstance(this.$project).showWarningBalloon(CommonProfilerBundleKt.profilerMessage("profiler.declarationNotFound", new Object[0]));
                    }
                    return;
                }
                indicator.checkCanceled();
                ApplicationManager.getApplication().invokeLater(() -> navigateToSourceInBackground.3.run$lambda$0(navigatables, this.$popupPoint, this.$doNavigate));
            }

            private static final void run$lambda$0(NavigatablePsiElement[] $navigatables, RelativePoint $popupPoint, Function1 $doNavigate) {
                Intrinsics.checkNotNullParameter((Object)$navigatables, (String)"$navigatables");
                Intrinsics.checkNotNullParameter((Object)$popupPoint, (String)"$popupPoint");
                Intrinsics.checkNotNullParameter((Object)$doNavigate, (String)"$doNavigate");
                UtilsKt.access$navigateOrCreatePopup($navigatables, $popupPoint, $doNavigate);
            }
        }.queue();
    }

    public static /* synthetic */ void navigateToSourceInBackground$default(Project project, BaseCallStackElement baseCallStackElement, RelativePoint relativePoint, Function0 function0, boolean bl, boolean bl2, Function1 function1, int n, Object object) {
        if ((n & 8) != 0) {
            function0 = navigateToSourceInBackground.1.INSTANCE;
        }
        if ((n & 0x10) != 0) {
            bl = true;
        }
        if ((n & 0x20) != 0) {
            bl2 = false;
        }
        if ((n & 0x40) != 0) {
            function1 = (Function1)new Function1<NavigatablePsiElement, Unit>(project, bl2){
                final /* synthetic */ Project $project;
                final /* synthetic */ boolean $openInPreviewTab;
                {
                    this.$project = $project;
                    this.$openInPreviewTab = $openInPreviewTab;
                    super(1);
                }

                public final void invoke(@NotNull NavigatablePsiElement it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    UtilsKt.access$performNavigate(this.$project, it, this.$openInPreviewTab);
                }
            };
        }
        UtilsKt.navigateToSourceInBackground(project, baseCallStackElement, relativePoint, (Function0<Unit>)function0, bl, bl2, (Function1<? super NavigatablePsiElement, Unit>)function1);
    }

    private static final void navigateOrCreatePopup(NavigatablePsiElement[] navigatables, RelativePoint popupPoint, Function1<? super NavigatablePsiElement, Unit> doNavigate) {
        Consumer elementsConsumer = arg_0 -> UtilsKt.navigateOrCreatePopup$lambda$5(doNavigate, arg_0);
        JBPopup jBPopup = PsiElementListNavigator.navigateOrCreatePopup((NavigatablePsiElement[])navigatables, (String)CommonProfilerBundleKt.profilerMessage("profiler.selectOverload", new Object[0]), null, (ListCellRenderer)((ListCellRenderer)new DefaultPsiElementCellRenderer()), null, (Consumer)elementsConsumer);
        if (jBPopup != null) {
            jBPopup.show(popupPoint);
        }
    }

    public static final boolean isPrefixTo(@NotNull byte[] magic, @NotNull byte[] array) {
        Intrinsics.checkNotNullParameter((Object)magic, (String)"magic");
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        if (magic.length > array.length) {
            return false;
        }
        int n = magic.length;
        for (int i = 0; i < n; ++i) {
            if (magic[i] == array[i]) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static final String durationToCompactString(@NotNull Duration duration) {
        String string;
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        long hours = duration.toHours();
        int minutes = duration.toMinutesPart();
        int seconds2 = duration.toSecondsPart();
        if (hours == 0L) {
            String string2 = "%02d:%02d";
            Object[] objectArray = new Object[]{minutes, seconds2};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        } else {
            String string4 = "%02d:%02d:%02d";
            Object[] objectArray = new Object[]{hours, minutes, seconds2};
            String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(...)");
        }
        return string;
    }

    private static final void performNavigate$lambda$4$lambda$3(Project $project, VirtualFile $file, int $textOffset, boolean $preview) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
        new OpenFileDescriptor($project, $file, $textOffset).setUsePreviewTab($preview).navigateInEditor($project, false);
    }

    private static final void performNavigate$lambda$4(NavigatablePsiElement $element, Project $project, boolean $preview) {
        Intrinsics.checkNotNullParameter((Object)$element, (String)"$element");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        VirtualFile virtualFile = (VirtualFile)ActionsKt.runReadAction((Function0)((Function0)new Function0<VirtualFile>($element){
            final /* synthetic */ NavigatablePsiElement $element;
            {
                this.$element = $element;
                super(0);
            }

            @Nullable
            public final VirtualFile invoke() {
                PsiElement psiElement = this.$element.getNavigationElement();
                return psiElement != null && (psiElement = psiElement.getContainingFile()) != null ? psiElement.getVirtualFile() : null;
            }
        }));
        if (virtualFile == null) {
            return;
        }
        VirtualFile file2 = virtualFile;
        int textOffset2 = ((Number)ActionsKt.runReadAction((Function0)((Function0)new Function0<Integer>($element){
            final /* synthetic */ NavigatablePsiElement $element;
            {
                this.$element = $element;
                super(0);
            }

            @NotNull
            public final Integer invoke() {
                return this.$element.getTextOffset();
            }
        }))).intValue();
        ApplicationManager.getApplication().invokeLater(() -> UtilsKt.performNavigate$lambda$4$lambda$3($project, file2, textOffset2, $preview));
    }

    private static final void navigateOrCreatePopup$lambda$5(Function1 $doNavigate, NavigatablePsiElement[] elements) {
        Intrinsics.checkNotNullParameter((Object)$doNavigate, (String)"$doNavigate");
        Intrinsics.checkNotNull((Object)elements);
        for (NavigatablePsiElement element2 : elements) {
            if (!element2.isValid()) continue;
            $doNavigate.invoke((Object)element2);
        }
    }

    public static final /* synthetic */ void access$navigateOrCreatePopup(NavigatablePsiElement[] navigatables, RelativePoint popupPoint, Function1 doNavigate) {
        UtilsKt.navigateOrCreatePopup(navigatables, popupPoint, (Function1<? super NavigatablePsiElement, Unit>)doNavigate);
    }

    public static final /* synthetic */ void access$performNavigate(Project project, NavigatablePsiElement element2, boolean preview) {
        UtilsKt.performNavigate(project, element2, preview);
    }
}

