/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler;

import com.intellij.execution.ui.RunContentManagerImpl;
import com.intellij.icons.AllIcons;
import com.intellij.ide.impl.ContentManagerWatcher;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.RegisterToolWindowTask;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.profiler.AbstractProfilerToolWindowPanel;
import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.CommonProfilerUISettings;
import com.intellij.profiler.CommonProfilerUiOptions;
import com.intellij.profiler.ProfilerDataManager;
import com.intellij.profiler.ProfilerDumpPanel;
import com.intellij.profiler.ProfilerProcessPanel;
import com.intellij.profiler.ProfilerToolWindowManager;
import com.intellij.profiler.ProfilerToolWindowManagerKt;
import com.intellij.profiler.TabNameFormatToggleAction;
import com.intellij.profiler.ToolWindowActivationProperties;
import com.intellij.profiler.api.Attached;
import com.intellij.profiler.api.DataReady;
import com.intellij.profiler.api.ProfilerError;
import com.intellij.profiler.api.ProfilerErrorWithContext;
import com.intellij.profiler.api.ProfilerProcess;
import com.intellij.profiler.api.ProfilerState;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.ContentsUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009b\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b*\u0001\f\b\u0007\u0018\u0000 E2\u00020\u0001:\u0001EB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0015J\u001a\u0010\u0016\u001a\u00020\u00112\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u001c\u0010\u0016\u001a\u00020\u00112\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00182\b\b\u0002\u0010\u001b\u001a\u00020\u0015J\u0018\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u001d2\b\b\u0002\u0010\u0014\u001a\u00020\u0015J\u0018\u0010\u001c\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\b\b\u0001\u0010!\u001a\u00020\"J\u001c\u0010#\u001a\u0004\u0018\u00010\u001e2\u0006\u0010$\u001a\u00020%2\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0018J\u0010\u0010#\u001a\u0004\u0018\u00010\u001e2\u0006\u0010&\u001a\u00020'J\u0013\u0010(\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001e0)\u00a2\u0006\u0002\u0010*J\b\u0010+\u001a\u0004\u0018\u00010\u001eJ\b\u0010,\u001a\u00020%H\u0002J\u000e\u0010-\u001a\u00020\u00112\u0006\u0010.\u001a\u00020%J\u000e\u0010/\u001a\u00020\u00112\u0006\u00100\u001a\u00020\u001eJ.\u00101\u001a\u00020\u00112\b\b\u0001\u00102\u001a\u00020\"2\u0006\u00103\u001a\u0002042\u0014\b\u0002\u00105\u001a\u000e\u0012\u0004\u0012\u000207\u0012\u0004\u0012\u00020\u001106J8\u00101\u001a\u00020\u00112\b\b\u0001\u00108\u001a\u00020\"2\b\b\u0001\u00102\u001a\u00020\"2\u0006\u00103\u001a\u0002092\u0014\b\u0002\u00105\u001a\u000e\u0012\u0004\u0012\u000207\u0012\u0004\u0012\u00020\u001106J\u0010\u0010:\u001a\u00020\u00112\b\b\u0001\u00102\u001a\u00020\"J\u0010\u0010;\u001a\u00020\u00112\b\b\u0001\u00102\u001a\u00020\"JK\u0010<\u001a\u00020\u00112\n\b\u0001\u00108\u001a\u0004\u0018\u00010\"2\b\b\u0001\u00100\u001a\u00020\"2\u0006\u00103\u001a\u0002092\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00182\u0012\u0010=\u001a\n\u0012\u0006\b\u0001\u0012\u00020>0)\"\u00020>H\u0002\u00a2\u0006\u0002\u0010?J\u0010\u0010@\u001a\u00020\u00112\b\b\u0001\u00102\u001a\u00020\"J\u0014\u0010A\u001a\u00020\"2\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0018H\u0003J\u0014\u0010!\u001a\u00020\"2\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0018H\u0003J\u001c\u0010B\u001a\u00020\u00152\u0006\u0010$\u001a\u00020%2\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0018H\u0002J\u0010\u0010C\u001a\u00020\u00112\u0006\u0010D\u001a\u00020\u0015H\u0002R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lcom/intellij/profiler/ProfilerToolWindowManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "baseIcon", "Ljavax/swing/Icon;", "getBaseIcon", "()Ljavax/swing/Icon;", "myActiveSessionsCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "myListener", "com/intellij/profiler/ProfilerToolWindowManager$myListener$1", "Lcom/intellij/profiler/ProfilerToolWindowManager$myListener$1;", "myListenerAdded", "Ljava/util/concurrent/atomic/AtomicBoolean;", "addProfilerDumpTab", "", "panel", "Lcom/intellij/profiler/ProfilerDumpPanel;", "activate", "", "addProfilerProcessTab", "profilerProcess", "Lcom/intellij/profiler/api/ProfilerProcess;", "properties", "Lcom/intellij/profiler/ToolWindowActivationProperties;", "activateToolWindow", "addTab", "Lcom/intellij/profiler/AbstractProfilerToolWindowPanel;", "Lcom/intellij/ui/content/Content;", "component", "Ljavax/swing/JComponent;", "tabName", "", "findToolWindowContent", "tw", "Lcom/intellij/openapi/wm/ToolWindow;", "file", "Ljava/io/File;", "getAllTabs", "", "()[Lcom/intellij/ui/content/Content;", "getCurrentTab", "getToolWindow", "initToolWindow", "toolWindow", "openExistingTab", "content", "showBalloon", "message", "type", "Lcom/intellij/openapi/ui/MessageType;", "beforeNotify", "Lkotlin/Function1;", "Lcom/intellij/notification/Notification;", "title", "Lcom/intellij/notification/NotificationType;", "showErrorBalloon", "showInfoBalloon", "showOpenProfilerTabBalloon", "additionalActions", "Lcom/intellij/notification/NotificationAction;", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/notification/NotificationType;Lcom/intellij/profiler/api/ProfilerProcess;[Lcom/intellij/notification/NotificationAction;)V", "showWarningBalloon", "tabDescription", "twIsVisibleAndThisProcessTabSelected", "updateToolWindowIcon", "hasRunningSessions", "Companion", "intellij.profiler.common"})
@SourceDebugExtension(value={"SMAP\nProfilerToolWindowManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProfilerToolWindowManager.kt\ncom/intellij/profiler/ProfilerToolWindowManager\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,324:1\n11065#2:325\n11400#2,3:326\n1155#3,3:329\n*S KotlinDebug\n*F\n+ 1 ProfilerToolWindowManager.kt\ncom/intellij/profiler/ProfilerToolWindowManager\n*L\n78#1:325\n78#1:326,3\n156#1:329,3\n*E\n"})
public final class ProfilerToolWindowManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private AtomicInteger myActiveSessionsCounter;
    @NotNull
    private final AtomicBoolean myListenerAdded;
    @NotNull
    private final myListener.1 myListener;
    @NotNull
    public static final String TOOLWINDOW_ID = "Profiler";
    @NotNull
    private static final NotificationGroup TOOLWINDOW_BALLOON_GROUP = NotificationGroup.Companion.toolWindowGroup$default((NotificationGroup.Companion)NotificationGroup.Companion, (String)"ProfilerBalloon", (String)"Profiler", (boolean)false, (int)4, null);

    public ProfilerToolWindowManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.myActiveSessionsCounter = new AtomicInteger(0);
        this.myListenerAdded = new AtomicBoolean(false);
        this.myListener = new ContentManagerListener(this){
            final /* synthetic */ ProfilerToolWindowManager this$0;
            {
                this.this$0 = $receiver;
            }

            public void selectionChanged(@NotNull ContentManagerEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                ProfilerDataManager profilerDataManager = ProfilerDataManager.Companion.getInstance(ProfilerToolWindowManager.access$getProject$p(this.this$0));
                JComponent jComponent = event.getContent().getComponent();
                Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
                ContentManagerEvent.ContentOperation contentOperation = event.getOperation();
                Intrinsics.checkNotNullExpressionValue((Object)contentOperation, (String)"getOperation(...)");
                profilerDataManager.onProfilerDumpSelectionChange(jComponent, contentOperation);
            }
        };
    }

    private final Icon getBaseIcon() {
        Icon icon = AllIcons.Toolwindows.ToolWindowProfiler;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"ToolWindowProfiler");
        return icon;
    }

    private final ToolWindow getToolWindow() {
        ToolWindow toolWindow;
        ToolWindowManager manager = ToolWindowManager.Companion.getInstance(this.project);
        ToolWindow toolWindow2 = manager.getToolWindow(TOOLWINDOW_ID);
        if (toolWindow2 == null) {
            ToolWindow toolWindow3;
            ToolWindowAnchor toolWindowAnchor = ToolWindowAnchor.BOTTOM;
            Intrinsics.checkNotNullExpressionValue((Object)toolWindowAnchor, (String)"BOTTOM");
            ToolWindow it = toolWindow3 = manager.registerToolWindow(new RegisterToolWindowTask(TOOLWINDOW_ID, toolWindowAnchor, null, false, false, false, false, null, null, CommonProfilerBundleKt.profilerMessagePointer("profiler.configurable.name", new Object[0]), 508, null));
            boolean bl = false;
            this.initToolWindow(it);
            ContentManagerWatcher.watchContentManager((ToolWindow)it, (ContentManager)it.getContentManager());
            toolWindow2 = toolWindow3;
        }
        ToolWindow it = toolWindow = toolWindow2;
        boolean bl = false;
        if (this.myListenerAdded.compareAndSet(false, true)) {
            it.getContentManager().addContentManagerListener((ContentManagerListener)this.myListener);
        }
        return toolWindow;
    }

    /*
     * WARNING - void declaration
     */
    public final void initToolWindow(@NotNull ToolWindow toolWindow) {
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        toolWindow.setIcon(this.getBaseIcon());
        toolWindow.setToHideOnEmptyContent(false);
        if (toolWindow instanceof ToolWindowEx) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            DefaultActionGroup defaultActionGroup;
            DefaultActionGroup $this$initToolWindow_u24lambda_u243 = defaultActionGroup = new DefaultActionGroup(CommonProfilerBundleKt.profilerMessage("ui.tabs.format.name", new Object[0]), true);
            boolean bl = false;
            CommonProfilerUiOptions.TabNameFormat[] tabNameFormatArray = CommonProfilerUiOptions.TabNameFormat.values();
            DefaultActionGroup defaultActionGroup2 = $this$initToolWindow_u24lambda_u243;
            boolean $i$f$map = false;
            void var9_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var15_14 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                ContentManager contentManager = ((ToolWindowEx)toolWindow).getContentManager();
                Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"getContentManager(...)");
                collection.add(new TabNameFormatToggleAction((CommonProfilerUiOptions.TabNameFormat)it, contentManager));
            }
            defaultActionGroup2.addAll((Collection)((List)destination$iv$iv));
            DefaultActionGroup tabFormatGroup = defaultActionGroup;
            toolWindow.setAdditionalGearActions((ActionGroup)tabFormatGroup);
        }
    }

    public final void addProfilerDumpTab(@NotNull ProfilerDumpPanel panel2, boolean activate2) {
        Intrinsics.checkNotNullParameter((Object)((Object)panel2), (String)"panel");
        this.addTab(panel2, activate2);
    }

    public static /* synthetic */ void addProfilerDumpTab$default(ProfilerToolWindowManager profilerToolWindowManager, ProfilerDumpPanel profilerDumpPanel, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        profilerToolWindowManager.addProfilerDumpTab(profilerDumpPanel, bl);
    }

    public final void addProfilerProcessTab(@NotNull ProfilerProcess<?> profilerProcess, boolean activateToolWindow) {
        Intrinsics.checkNotNullParameter(profilerProcess, (String)"profilerProcess");
        this.addProfilerProcessTab(profilerProcess, new ToolWindowActivationProperties(activateToolWindow, false, null, 6, null));
    }

    public static /* synthetic */ void addProfilerProcessTab$default(ProfilerToolWindowManager profilerToolWindowManager, ProfilerProcess profilerProcess, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        profilerToolWindowManager.addProfilerProcessTab(profilerProcess, bl);
    }

    public final void addProfilerProcessTab(@NotNull ProfilerProcess<?> profilerProcess, @NotNull ToolWindowActivationProperties properties) {
        Intrinsics.checkNotNullParameter(profilerProcess, (String)"profilerProcess");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        profilerProcess.addStateChangedListener((Function2<ProfilerState, ProfilerState, Unit>)((Function2)new Function2<ProfilerState, ProfilerState, Unit>(this, profilerProcess, properties){
            final /* synthetic */ ProfilerToolWindowManager this$0;
            final /* synthetic */ ProfilerProcess<?> $profilerProcess;
            final /* synthetic */ ToolWindowActivationProperties $properties;
            {
                this.this$0 = $receiver;
                this.$profilerProcess = $profilerProcess;
                this.$properties = $properties;
                super(2);
            }

            public final void invoke(@NotNull ProfilerState oldState, @NotNull ProfilerState newState) {
                ProfilerState profilerState;
                Intrinsics.checkNotNullParameter((Object)oldState, (String)"oldState");
                Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
                if (oldState == Attached.INSTANCE && ProfilerToolWindowManager.access$getMyActiveSessionsCounter$p(this.this$0).decrementAndGet() == 0) {
                    ProfilerToolWindowManager.access$updateToolWindowIcon(this.this$0, false);
                }
                if ((profilerState = newState) instanceof ProfilerErrorWithContext) {
                    NotificationAction[] notificationActionArray = ((ProfilerErrorWithContext)newState).getActions();
                    ProfilerToolWindowManager.access$showOpenProfilerTabBalloon(this.this$0, CommonProfilerBundleKt.profilerMessage("profiler.state.error", new Object[0]), ((ProfilerErrorWithContext)newState).getReasonHtml(), NotificationType.ERROR, this.$profilerProcess, Arrays.copyOf(notificationActionArray, notificationActionArray.length));
                } else if (profilerState instanceof ProfilerError) {
                    Object[] objectArray = new Object[1];
                    Intrinsics.checkNotNullExpressionValue((Object)StringUtil.escapeXmlEntities((String)((ProfilerError)newState).getReason()), (String)"escapeXmlEntities(...)");
                    ProfilerToolWindowManager.access$showOpenProfilerTabBalloon(this.this$0, null, CommonProfilerBundleKt.profilerMessage("profiler.state.error.0", objectArray) + "<br>", NotificationType.ERROR, this.$profilerProcess, new NotificationAction[0]);
                } else if (profilerState instanceof DataReady && ((Boolean)this.$properties.getShowProfilerDataReadyBalloon().invoke()).booleanValue()) {
                    ProfilerToolWindowManager.access$showOpenProfilerTabBalloon(this.this$0, null, CommonProfilerBundleKt.profilerMessage("run.profiler.data.ready", new Object[0]), NotificationType.INFORMATION, this.$profilerProcess, new NotificationAction[0]);
                }
            }
        }));
        String tabName = this.tabName(profilerProcess);
        String tabDescription = this.tabDescription(profilerProcess);
        UIUtil.invokeLaterIfNeeded(() -> ProfilerToolWindowManager.addProfilerProcessTab$lambda$5(this, profilerProcess, tabName, properties, tabDescription));
        profilerProcess.startNotify();
    }

    private final void updateToolWindowIcon(boolean hasRunningSessions) {
        Icon newIcon = hasRunningSessions ? RunContentManagerImpl.Companion.getLiveIndicator(this.getBaseIcon()) : this.getBaseIcon();
        UIUtil.invokeLaterIfNeeded(() -> ProfilerToolWindowManager.updateToolWindowIcon$lambda$6(this, newIcon));
    }

    @NlsSafe
    private final String tabName(ProfilerProcess<?> profilerProcess) {
        String string = DateFormatUtil.formatDateTime((long)profilerProcess.getAttachedTimestamp());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatDateTime(...)");
        String suffix = string;
        return profilerProcess.getTargetProcess().getShortName() + " " + suffix;
    }

    @Nls
    private final String tabDescription(ProfilerProcess<?> profilerProcess) {
        String string;
        String profilerConfigurationName = profilerProcess.getProfilerConfiguration().getDisplayName();
        String target = profilerProcess.getTargetProcess().getFullName();
        Object[] objectArray = (Object[])profilerConfigurationName;
        if (objectArray == null || objectArray.length() == 0) {
            string = target;
        } else {
            objectArray = new Object[]{target, profilerConfigurationName};
            string = CommonProfilerBundleKt.profilerMessage("profiler.with.configuration.tab.title", objectArray);
        }
        String oldTabNameFormat = string;
        String string2 = new HtmlBuilder().append((HtmlChunk)HtmlChunk.div((String)"white-space: nowrap").addText(oldTabNameFormat)).wrapWithHtmlBody().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    public final void addTab(@NotNull AbstractProfilerToolWindowPanel panel2, boolean activate2) {
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)panel2), (String)"panel");
        Sequence sequence2 = SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])this.getAllTabs()), (Function1)addTab.existingNames.1.INSTANCE);
        Collection destination$iv = new HashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            Content content2 = (Content)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(it.getDisplayName());
        }
        HashSet existingNames2 = (HashSet)destination$iv;
        ToolWindow toolWindow = this.getToolWindow();
        ContentManager contentManager = toolWindow.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"getContentManager(...)");
        ContentManager contentManager2 = contentManager;
        ContentsUtil.addContent((ContentManager)contentManager2, (Content)panel2.getContent(), (boolean)true);
        panel2.onPanelAdd();
        if (activate2) {
            toolWindow.activate(null);
        }
        panel2.getContent().setDisplayName(ProfilerToolWindowManagerKt.access$formatTabName(((CommonProfilerUiOptions)CommonProfilerUISettings.Companion.getInstance().getState()).getTabNameFormat(), panel2.getTabName(), panel2.getTime(), existingNames2));
    }

    public static /* synthetic */ void addTab$default(ProfilerToolWindowManager profilerToolWindowManager, AbstractProfilerToolWindowPanel abstractProfilerToolWindowPanel, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        profilerToolWindowManager.addTab(abstractProfilerToolWindowPanel, bl);
    }

    @NotNull
    public final Content addTab(@NotNull JComponent component, @NlsContexts.TabTitle @NotNull String tabName) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)tabName, (String)"tabName");
        ContentManager contentManager = this.getToolWindow().getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"getContentManager(...)");
        ContentManager cm = contentManager;
        Content content2 = ContentFactory.getInstance().createContent(component, tabName, true);
        Intrinsics.checkNotNullExpressionValue((Object)content2, (String)"createContent(...)");
        Content content3 = content2;
        ContentsUtil.addContent((ContentManager)cm, (Content)content3, (boolean)true);
        return content3;
    }

    @NotNull
    public final Content[] getAllTabs() {
        Content[] contentArray = this.getToolWindow().getContentManager().getContents();
        Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"getContents(...)");
        return contentArray;
    }

    @Nullable
    public final Content getCurrentTab() {
        return this.getToolWindow().getContentManager().getSelectedContent();
    }

    public final void showWarningBalloon(@NlsContexts.NotificationContent @NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        MessageType messageType = MessageType.WARNING;
        Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"WARNING");
        TOOLWINDOW_BALLOON_GROUP.createNotification(message2, messageType).notify(this.project);
    }

    public final void showInfoBalloon(@NlsContexts.NotificationContent @NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        MessageType messageType = MessageType.INFO;
        Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"INFO");
        TOOLWINDOW_BALLOON_GROUP.createNotification(message2, messageType).notify(this.project);
    }

    public final void showErrorBalloon(@NlsContexts.NotificationContent @NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        MessageType messageType = MessageType.ERROR;
        Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"ERROR");
        TOOLWINDOW_BALLOON_GROUP.createNotification(message2, messageType).notify(this.project);
    }

    public final void showBalloon(@NlsContexts.NotificationContent @NotNull String message2, @NotNull MessageType type, @NotNull Function1<? super Notification, Unit> beforeNotify) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter(beforeNotify, (String)"beforeNotify");
        Notification notification = TOOLWINDOW_BALLOON_GROUP.createNotification(message2, type);
        beforeNotify.invoke((Object)notification);
        notification.notify(this.project);
    }

    public static /* synthetic */ void showBalloon$default(ProfilerToolWindowManager profilerToolWindowManager, String string, MessageType messageType, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = showBalloon.1.INSTANCE;
        }
        profilerToolWindowManager.showBalloon(string, messageType, (Function1<? super Notification, Unit>)function1);
    }

    public final void showBalloon(@NlsContexts.NotificationTitle @NotNull String title, @NlsContexts.NotificationContent @NotNull String message2, @NotNull NotificationType type, @NotNull Function1<? super Notification, Unit> beforeNotify) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter(beforeNotify, (String)"beforeNotify");
        Notification notification = TOOLWINDOW_BALLOON_GROUP.createNotification(title, message2, type);
        beforeNotify.invoke((Object)notification);
        notification.notify(this.project);
    }

    public static /* synthetic */ void showBalloon$default(ProfilerToolWindowManager profilerToolWindowManager, String string, String string2, NotificationType notificationType, Function1 function1, int n, Object object) {
        if ((n & 8) != 0) {
            function1 = showBalloon.2.INSTANCE;
        }
        profilerToolWindowManager.showBalloon(string, string2, notificationType, (Function1<? super Notification, Unit>)function1);
    }

    private final void showOpenProfilerTabBalloon(@NlsContexts.NotificationTitle String title, @NlsContexts.NotificationContent String content2, NotificationType type, ProfilerProcess<?> profilerProcess, NotificationAction ... additionalActions) {
        ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(this.project).getToolWindow(TOOLWINDOW_ID);
        if (toolWindow == null) {
            return;
        }
        ToolWindow toolWindow2 = toolWindow;
        if (this.twIsVisibleAndThisProcessTabSelected(toolWindow2, profilerProcess)) {
            return;
        }
        String string = CommonProfilerBundleKt.profilerMessage("run.profiler.open.action", new Object[0]);
        NotificationAction openAction2 = new NotificationAction(this, toolWindow2, profilerProcess, string){
            final /* synthetic */ ProfilerToolWindowManager this$0;
            final /* synthetic */ ToolWindow $toolWindow;
            final /* synthetic */ ProfilerProcess<?> $profilerProcess;
            {
                this.this$0 = $receiver;
                this.$toolWindow = $toolWindow;
                this.$profilerProcess = $profilerProcess;
                super($super_call_param$1);
            }

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                Content content2 = this.this$0.findToolWindowContent(this.$toolWindow, this.$profilerProcess);
                if (content2 != null) {
                    Content content3 = content2;
                    ToolWindow toolWindow = this.$toolWindow;
                    Content it = content3;
                    boolean bl = false;
                    toolWindow.getContentManager().setSelectedContent(it);
                }
                this.$toolWindow.activate(null);
            }
        };
        Notification notification = title != null ? TOOLWINDOW_BALLOON_GROUP.createNotification(title, content2, type) : TOOLWINDOW_BALLOON_GROUP.createNotification(content2, type);
        notification.addAction((AnAction)openAction2);
        for (NotificationAction action : additionalActions) {
            notification.addAction((AnAction)action);
        }
        notification.notify(this.project);
    }

    private final boolean twIsVisibleAndThisProcessTabSelected(ToolWindow tw, ProfilerProcess<?> profilerProcess) {
        if (!tw.isVisible()) {
            return false;
        }
        Content content2 = this.findToolWindowContent(tw, profilerProcess);
        if (content2 == null) {
            return false;
        }
        Content tab = content2;
        return Intrinsics.areEqual((Object)tw.getContentManager().getSelectedContent(), (Object)tab);
    }

    @Nullable
    public final Content findToolWindowContent(@NotNull ToolWindow tw, @NotNull ProfilerProcess<?> profilerProcess) {
        Object object;
        block1: {
            Intrinsics.checkNotNullParameter((Object)tw, (String)"tw");
            Intrinsics.checkNotNullParameter(profilerProcess, (String)"profilerProcess");
            Content[] contentArray = tw.getContentManager().getContents();
            Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"getContents(...)");
            for (Object object2 : (Object[])contentArray) {
                JComponent comp2;
                Content it = (Content)object2;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it.getComponent(), (String)"getComponent(...)");
                if (!(comp2 instanceof ProfilerProcessPanel && Intrinsics.areEqual(((ProfilerProcessPanel)((Object)comp2)).getProfilerProcess(), profilerProcess))) continue;
                object = object2;
                break block1;
            }
            object = null;
        }
        return (Content)object;
    }

    @Nullable
    public final Content findToolWindowContent(@NotNull File file2) {
        Object object;
        block1: {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Content[] contentArray = this.getToolWindow().getContentManager().getContents();
            Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"getContents(...)");
            for (Object object2 : (Object[])contentArray) {
                File snapshotFile;
                JComponent comp2;
                Content it = (Content)object2;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it.getComponent(), (String)"getComponent(...)");
                if (!(!(comp2 instanceof ProfilerDumpPanel) ? false : (((ProfilerDumpPanel)((Object)comp2)).getSnapshotFile() == null ? false : snapshotFile.exists() && Files.isSameFile(snapshotFile.toPath(), file2.toPath())))) continue;
                object = object2;
                break block1;
            }
            object = null;
        }
        return (Content)object;
    }

    public final void openExistingTab(@NotNull Content content2) {
        ToolWindow toolWindow;
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        ToolWindow $this$openExistingTab_u24lambda_u2410 = toolWindow = this.getToolWindow();
        boolean bl = false;
        $this$openExistingTab_u24lambda_u2410.show();
        $this$openExistingTab_u24lambda_u2410.getContentManager().setSelectedContent(content2);
    }

    /*
     * WARNING - void declaration
     */
    private static final void addProfilerProcessTab$lambda$5(ProfilerToolWindowManager this$0, ProfilerProcess $profilerProcess, String $tabName, ToolWindowActivationProperties $properties, String $tabDescription) {
        void it;
        ProfilerProcessPanel profilerProcessPanel;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$profilerProcess, (String)"$profilerProcess");
        Intrinsics.checkNotNullParameter((Object)$tabName, (String)"$tabName");
        Intrinsics.checkNotNullParameter((Object)$properties, (String)"$properties");
        Intrinsics.checkNotNullParameter((Object)$tabDescription, (String)"$tabDescription");
        ProfilerProcessPanel profilerProcessPanel2 = profilerProcessPanel = new ProfilerProcessPanel($profilerProcess, $tabName);
        ProfilerToolWindowManager profilerToolWindowManager = this$0;
        boolean bl = false;
        it.getContent().setDescription($tabDescription);
        profilerToolWindowManager.addTab(profilerProcessPanel, $properties.getActivateToolWindow());
        if ($profilerProcess.getState() == Attached.INSTANCE && this$0.myActiveSessionsCounter.getAndIncrement() == 0) {
            this$0.updateToolWindowIcon(true);
        }
        if ($properties.getShowProfilerAttachedBalloon()) {
            this$0.showOpenProfilerTabBalloon(null, CommonProfilerBundleKt.profilerMessage("run.profiler.attached", new Object[0]), NotificationType.INFORMATION, $profilerProcess, new NotificationAction[0]);
        }
    }

    private static final void updateToolWindowIcon$lambda$6(ProfilerToolWindowManager this$0, Icon $newIcon) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$newIcon, (String)"$newIcon");
        this$0.getToolWindow().setIcon($newIcon);
    }

    @JvmStatic
    @NotNull
    public static final ProfilerToolWindowManager getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    public static final /* synthetic */ AtomicInteger access$getMyActiveSessionsCounter$p(ProfilerToolWindowManager $this) {
        return $this.myActiveSessionsCounter;
    }

    public static final /* synthetic */ void access$updateToolWindowIcon(ProfilerToolWindowManager $this, boolean hasRunningSessions) {
        $this.updateToolWindowIcon(hasRunningSessions);
    }

    public static final /* synthetic */ void access$showOpenProfilerTabBalloon(ProfilerToolWindowManager $this, String title, String content2, NotificationType type, ProfilerProcess profilerProcess, NotificationAction ... additionalActions) {
        $this.showOpenProfilerTabBalloon(title, content2, type, profilerProcess, additionalActions);
    }

    public static final /* synthetic */ Project access$getProject$p(ProfilerToolWindowManager $this) {
        return $this.project;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/profiler/ProfilerToolWindowManager$Companion;", "", "()V", "TOOLWINDOW_BALLOON_GROUP", "Lcom/intellij/notification/NotificationGroup;", "TOOLWINDOW_ID", "", "getInstance", "Lcom/intellij/profiler/ProfilerToolWindowManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.profiler.common"})
    @SourceDebugExtension(value={"SMAP\nProfilerToolWindowManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProfilerToolWindowManager.kt\ncom/intellij/profiler/ProfilerToolWindowManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,324:1\n31#2,2:325\n*S KotlinDebug\n*F\n+ 1 ProfilerToolWindowManager.kt\ncom/intellij/profiler/ProfilerToolWindowManager$Companion\n*L\n263#1:325,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ProfilerToolWindowManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<ProfilerToolWindowManager> serviceClass$iv = ProfilerToolWindowManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (ProfilerToolWindowManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

