/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler;

import com.intellij.execution.TerminateRemoteProcessDialog;
import com.intellij.execution.process.NopProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.ui.BaseContentCloseListener;
import com.intellij.execution.ui.RunContentManagerImpl;
import com.intellij.icons.AllIcons;
import com.intellij.notification.NotificationAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LoadingDecorator;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.profiler.AbstractProfilerToolWindowPanel;
import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.FileBasedProfilerProcess;
import com.intellij.profiler.ProfilerDataManager;
import com.intellij.profiler.ProfilerProcessPanel;
import com.intellij.profiler.UtilsKt;
import com.intellij.profiler.actions.ExportProfilerResultAction;
import com.intellij.profiler.api.Attached;
import com.intellij.profiler.api.DataReady;
import com.intellij.profiler.api.Inactive;
import com.intellij.profiler.api.ParsingData;
import com.intellij.profiler.api.ProfilerDumpWriter;
import com.intellij.profiler.api.ProfilerError;
import com.intellij.profiler.api.ProfilerErrorWithContext;
import com.intellij.profiler.api.ProfilerProcess;
import com.intellij.profiler.api.ProfilerState;
import com.intellij.profiler.api.ReadingData;
import com.intellij.profiler.api.Terminated;
import com.intellij.profiler.api.configurations.ProfilerConfigurationState;
import com.intellij.profiler.api.configurations.ProfilerConfigurationStateKt;
import com.intellij.profiler.api.configurations.ProfilerConfigurationType;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.components.AnActionLink;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.File;
import java.time.Duration;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0002*+B\u001b\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\n\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020\u0019H\u0016J3\u0010 \u001a\u00020\u00192\b\b\u0001\u0010!\u001a\u00020\u00052\b\b\u0002\u0010\"\u001a\u00020#2\u0010\b\u0002\u0010$\u001a\n\u0012\u0006\b\u0001\u0012\u00020&0%H\u0002\u00a2\u0006\u0002\u0010'J\u0012\u0010(\u001a\u00020\u00192\b\b\u0001\u0010!\u001a\u00020\u0005H\u0002J\b\u0010)\u001a\u00020\u0019H\u0002R\u0019\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006,"}, d2={"Lcom/intellij/profiler/ProfilerProcessPanel;", "Lcom/intellij/profiler/AbstractProfilerToolWindowPanel;", "profilerProcess", "Lcom/intellij/profiler/api/ProfilerProcess;", "tabName", "", "(Lcom/intellij/profiler/api/ProfilerProcess;Ljava/lang/String;)V", "content", "Lcom/intellij/ui/content/Content;", "Lorg/jetbrains/annotations/NotNull;", "getContent", "()Lcom/intellij/ui/content/Content;", "getProfilerProcess", "()Lcom/intellij/profiler/api/ProfilerProcess;", "smallLoadingPanel", "Lcom/intellij/ui/components/JBLoadingPanel;", "tabIcon", "Ljavax/swing/Icon;", "getTabName", "()Ljava/lang/String;", "time", "", "getTime", "()J", "dispose", "", "getSnapshotFile", "Ljava/io/File;", "newUpdateUI", "state", "Lcom/intellij/profiler/api/ProfilerState;", "onPanelAdd", "setCenteredText", "text", "raw", "", "actions", "", "Lcom/intellij/notification/NotificationAction;", "(Ljava/lang/String;Z[Lcom/intellij/notification/NotificationAction;)V", "setReadingData", "stopLoading", "ActiveProfilingPlaceholder", "CloseListener", "intellij.profiler.common"})
@SourceDebugExtension(value={"SMAP\nProfilerProcessPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProfilerProcessPanel.kt\ncom/intellij/profiler/ProfilerProcessPanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n*L\n1#1,266:1\n1#2:267\n26#3:268\n*S KotlinDebug\n*F\n+ 1 ProfilerProcessPanel.kt\ncom/intellij/profiler/ProfilerProcessPanel\n*L\n145#1:268\n*E\n"})
public final class ProfilerProcessPanel
extends AbstractProfilerToolWindowPanel {
    @NotNull
    private final ProfilerProcess<?> profilerProcess;
    @NotNull
    private final String tabName;
    private final long time;
    @NotNull
    private final Icon tabIcon;
    @NotNull
    private final Content content;
    @NotNull
    private final JBLoadingPanel smallLoadingPanel;

    /*
     * WARNING - void declaration
     */
    public ProfilerProcessPanel(@NotNull ProfilerProcess<?> profilerProcess, @NlsContexts.TabTitle @NotNull String tabName) {
        void $this$smallLoadingPanel_u24lambda_u242;
        void $this$content_u24lambda_u240;
        Content content2;
        Intrinsics.checkNotNullParameter(profilerProcess, (String)"profilerProcess");
        Intrinsics.checkNotNullParameter((Object)tabName, (String)"tabName");
        this.profilerProcess = profilerProcess;
        this.tabName = tabName;
        this.time = this.profilerProcess.getAttachedTimestamp();
        ProfilerConfigurationType<ProfilerConfigurationState> profilerConfigurationType = ProfilerConfigurationStateKt.getConfigurationType(this.profilerProcess.getProfilerConfiguration());
        if (profilerConfigurationType == null || (profilerConfigurationType = profilerConfigurationType.getIcon()) == null) {
            Icon icon = AllIcons.RunConfigurations.Application;
            profilerConfigurationType = icon;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Application");
        }
        this.tabIcon = profilerConfigurationType;
        Content content3 = content2 = ContentFactory.getInstance().createContent((JComponent)((Object)this), this.getTabName(), true);
        ProfilerProcessPanel profilerProcessPanel = this;
        boolean bl = false;
        $this$content_u24lambda_u240.setCloseable(true);
        $this$content_u24lambda_u240.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)true);
        $this$content_u24lambda_u240.setIcon(this.profilerProcess.getState().isActive() ? ExecutionUtil.getLiveIndicator((Icon)this.tabIcon) : this.tabIcon);
        Content content4 = content2;
        Intrinsics.checkNotNullExpressionValue((Object)content4, (String)"apply(...)");
        profilerProcessPanel.content = content4;
        JBLoadingPanel jBLoadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), arg_0 -> ProfilerProcessPanel.smallLoadingPanel$lambda$1(this, arg_0));
        content2 = jBLoadingPanel;
        profilerProcessPanel = this;
        boolean bl2 = false;
        $this$smallLoadingPanel_u24lambda_u242.setBackground(EditorColorsManager.getInstance().getGlobalScheme().getDefaultBackground());
        profilerProcessPanel.smallLoadingPanel = jBLoadingPanel;
        String string = this.profilerProcess.getHelpId();
        if (string != null) {
            String it = string;
            boolean bl3 = false;
            this.getContent().setHelpId(it);
        }
        this.newUpdateUI(this.profilerProcess.getState());
        this.profilerProcess.addStateChangedListener((Function2<ProfilerState, ProfilerState, Unit>)((Function2)new Function2<ProfilerState, ProfilerState, Unit>(){

            public final void invoke(@NotNull ProfilerState profilerState, @NotNull ProfilerState newState) {
                Intrinsics.checkNotNullParameter((Object)profilerState, (String)"<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
                this.newUpdateUI(newState);
            }
        }));
    }

    @NotNull
    public final ProfilerProcess<?> getProfilerProcess() {
        return this.profilerProcess;
    }

    @Override
    @NotNull
    public String getTabName() {
        return this.tabName;
    }

    @Override
    public long getTime() {
        return this.time;
    }

    @Override
    @NotNull
    public Content getContent() {
        return this.content;
    }

    private final void newUpdateUI(ProfilerState state) {
        UIUtil.invokeLaterIfNeeded(() -> ProfilerProcessPanel.newUpdateUI$lambda$5(this, state));
    }

    @Override
    @Nullable
    public File getSnapshotFile() {
        File file2;
        if (this.profilerProcess.getState() instanceof DataReady) {
            ProfilerProcess<?> profilerProcess = this.profilerProcess;
            FileBasedProfilerProcess fileBasedProfilerProcess = profilerProcess instanceof FileBasedProfilerProcess ? (FileBasedProfilerProcess)profilerProcess : null;
            file2 = fileBasedProfilerProcess != null ? fileBasedProfilerProcess.getDumpFileWhenTargetProcessFinished() : null;
        } else {
            file2 = null;
        }
        return file2;
    }

    private final void setReadingData(@Nls String text2) {
        JComponent component = this.getContent();
        if (component == this.smallLoadingPanel) {
            this.smallLoadingPanel.setLoadingText(text2);
        } else {
            ActiveProfilingPlaceholder activeProfilingPlaceholder = component instanceof ActiveProfilingPlaceholder ? (ActiveProfilingPlaceholder)component : null;
            if (activeProfilingPlaceholder != null) {
                activeProfilingPlaceholder.stop();
            }
            this.smallLoadingPanel.setLoadingText(text2);
            this.smallLoadingPanel.startLoading();
            this.setContent((JComponent)this.smallLoadingPanel);
        }
    }

    @Override
    public void onPanelAdd() {
        new CloseListener();
    }

    @Override
    public void dispose() {
        super.dispose();
        ProfilerDataManager.Companion.getInstance(this.profilerProcess.getProject()).onProfilerDumpClosed((Object)this);
        Disposer.dispose((Disposable)this.profilerProcess);
    }

    private final void stopLoading() {
        JComponent jComponent = this.getComponent();
        ActiveProfilingPlaceholder activeProfilingPlaceholder = jComponent instanceof ActiveProfilingPlaceholder ? (ActiveProfilingPlaceholder)jComponent : null;
        if (activeProfilingPlaceholder != null) {
            activeProfilingPlaceholder.stop();
        }
        jComponent = this.getComponent();
        JBLoadingPanel jBLoadingPanel = jComponent instanceof JBLoadingPanel ? (JBLoadingPanel)jComponent : null;
        if (jBLoadingPanel != null) {
            jBLoadingPanel.stopLoading();
        }
        this.getContent().setIcon(this.tabIcon);
    }

    private final void setCenteredText(@NlsContexts.Label String text2, boolean raw, NotificationAction[] actions) {
        JBLabel jBLabel;
        String string;
        if (raw) {
            String string2 = StringUtil.escapeXmlEntities((String)text2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"escapeXmlEntities(...)");
            string = StringsKt.replace$default((String)string2, (String)"\n", (String)"<br>", (boolean)false, (int)4, null);
        } else {
            string = text2;
        }
        String body = string;
        String string3 = new HtmlBuilder().append((HtmlChunk)HtmlChunk.div((String)"text-align: center").addRaw(body)).wrapWithHtmlBody().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        String html = string3;
        JBLabel $this$setCenteredText_u24lambda_u246 = jBLabel = new JBLabel(html);
        boolean bl = false;
        $this$setCenteredText_u24lambda_u246.setHorizontalAlignment(0);
        $this$setCenteredText_u24lambda_u246.setBackground(EditorColorsManager.getInstance().getGlobalScheme().getDefaultBackground());
        JBLabel label = jBLabel;
        BorderLayoutPanel content2 = new BorderLayoutPanel();
        content2.addToCenter((Component)label);
        if (!(actions.length == 0)) {
            BorderLayoutPanel actionsPanel = new BorderLayoutPanel();
            for (NotificationAction action : actions) {
                AnAction anAction = (AnAction)action;
                String string4 = action.getTemplatePresentation().getText();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getText(...)");
                actionsPanel.add((Component)new AnActionLink(anAction, string4));
            }
        }
        this.setContent((JComponent)new BorderLayoutPanel().addToCenter((Component)label));
    }

    static /* synthetic */ void setCenteredText$default(ProfilerProcessPanel profilerProcessPanel, String string, boolean bl, NotificationAction[] notificationActionArray, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            boolean $i$f$emptyArray = false;
            notificationActionArray = new NotificationAction[]{};
        }
        profilerProcessPanel.setCenteredText(string, bl, notificationActionArray);
    }

    private static final LoadingDecorator smallLoadingPanel$lambda$1(ProfilerProcessPanel this$0, JPanel panel2) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
        return new LoadingDecorator((JComponent)panel2, (Disposable)this$0, 0, true, new AsyncProcessIcon("ProfilerProcessLoading"));
    }

    private static final void newUpdateUI$lambda$5(ProfilerProcessPanel this$0, ProfilerState $state) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$state, (String)"$state");
        if (Disposer.isDisposed((Disposable)this$0)) {
            return;
        }
        ProfilerState profilerState = $state;
        if (profilerState instanceof Inactive) {
            ProfilerProcessPanel.setCenteredText$default(this$0, CommonProfilerBundleKt.profilerMessage("profiler.state.inactive", new Object[0]), false, null, 6, null);
        } else if (profilerState instanceof Attached) {
            this$0.setContent(new ActiveProfilingPlaceholder(this$0.profilerProcess, this$0));
        } else if (profilerState instanceof ReadingData) {
            this$0.setReadingData(CommonProfilerBundleKt.profilerMessage("profiler.state.reading.data", new Object[0]));
        } else if (profilerState instanceof ParsingData) {
            this$0.setReadingData(CommonProfilerBundleKt.profilerMessage("profiler.state.parsing.data", new Object[0]));
        } else if (profilerState instanceof DataReady) {
            this$0.stopLoading();
            ProfilerDumpWriter profilerDumpWriter = ((DataReady)$state).getWriter();
            if (profilerDumpWriter != null) {
                ProfilerDumpWriter it = profilerDumpWriter;
                boolean bl = false;
                this$0.getMyToolbarActions().add((AnAction)new ExportProfilerResultAction(it));
                this$0.updateToolbar();
            }
            this$0.setContent(((DataReady)$state).getData().createTopLevelComponent(this$0.profilerProcess.getProject(), this$0));
            ProfilerDataManager.Companion.getInstance(this$0.profilerProcess.getProject()).onProfilerDumpOpen(((DataReady)$state).getData(), (Object)this$0);
        } else if (profilerState instanceof ProfilerErrorWithContext) {
            this$0.stopLoading();
            Object[] objectArray = new Object[]{((ProfilerErrorWithContext)$state).getReasonHtml()};
            this$0.setCenteredText(CommonProfilerBundleKt.profilerMessage("profiler.state.error.0", objectArray), false, ((ProfilerErrorWithContext)$state).getActions());
        } else if (profilerState instanceof ProfilerError) {
            this$0.stopLoading();
            Object[] objectArray = new Object[]{((ProfilerError)$state).getReason()};
            ProfilerProcessPanel.setCenteredText$default(this$0, CommonProfilerBundleKt.profilerMessage("profiler.state.error.0", objectArray), false, null, 6, null);
        } else if (profilerState instanceof Terminated) {
            this$0.stopLoading();
            ProfilerProcessPanel.setCenteredText$default(this$0, CommonProfilerBundleKt.profilerMessage("profiler.state.terminated", new Object[0]), false, null, 6, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0006\u0010\u0010\u001a\u00020\u000fJ\b\u0010\u0011\u001a\u00020\u000fH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/profiler/ProfilerProcessPanel$ActiveProfilingPlaceholder;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/Disposable;", "profilerProcess", "Lcom/intellij/profiler/api/ProfilerProcess;", "parent", "(Lcom/intellij/profiler/api/ProfilerProcess;Lcom/intellij/openapi/Disposable;)V", "duration", "Lcom/intellij/ui/SimpleColoredComponent;", "durationTimeComponent", "durationUpdater", "Ljava/util/concurrent/ScheduledFuture;", "processNameComponent", "profiling", "dispose", "", "stop", "updateProfilingDuration", "intellij.profiler.common"})
    private static final class ActiveProfilingPlaceholder
    extends JPanel
    implements Disposable {
        @NotNull
        private final ProfilerProcess<?> profilerProcess;
        @NotNull
        private final SimpleColoredComponent profiling;
        @NotNull
        private final SimpleColoredComponent processNameComponent;
        @NotNull
        private final SimpleColoredComponent duration;
        @NotNull
        private final SimpleColoredComponent durationTimeComponent;
        @Nullable
        private ScheduledFuture<?> durationUpdater;

        /*
         * WARNING - void declaration
         */
        public ActiveProfilingPlaceholder(@NotNull ProfilerProcess<?> profilerProcess, @NotNull Disposable parent) {
            void $this$duration_u24lambda_u242;
            SimpleColoredComponent $this$processNameComponent_u24lambda_u241;
            SimpleColoredComponent $this$profiling_u24lambda_u240;
            SimpleColoredComponent simpleColoredComponent;
            Intrinsics.checkNotNullParameter(profilerProcess, (String)"profilerProcess");
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            super(new GridBagLayout());
            this.profilerProcess = profilerProcess;
            SimpleColoredComponent simpleColoredComponent2 = simpleColoredComponent = new SimpleColoredComponent();
            ActiveProfilingPlaceholder activeProfilingPlaceholder = this;
            boolean bl = false;
            $this$profiling_u24lambda_u240.append(CommonProfilerBundleKt.profilerMessage("profiler.placeholder.profiling", new Object[0]), StatusText.DEFAULT_ATTRIBUTES);
            activeProfilingPlaceholder.profiling = simpleColoredComponent;
            $this$profiling_u24lambda_u240 = simpleColoredComponent = new SimpleColoredComponent();
            activeProfilingPlaceholder = this;
            boolean bl2 = false;
            $this$processNameComponent_u24lambda_u241.append(this.profilerProcess.getTargetProcess().getFullName() + "...", StatusText.DEFAULT_ATTRIBUTES);
            activeProfilingPlaceholder.processNameComponent = simpleColoredComponent;
            $this$processNameComponent_u24lambda_u241 = simpleColoredComponent = new SimpleColoredComponent();
            activeProfilingPlaceholder = this;
            boolean bl3 = false;
            $this$duration_u24lambda_u242.append(CommonProfilerBundleKt.profilerMessage("profiler.placeholder.duration", new Object[0]), StatusText.DEFAULT_ATTRIBUTES);
            activeProfilingPlaceholder.duration = simpleColoredComponent;
            this.durationTimeComponent = new SimpleColoredComponent();
            this.durationUpdater = EdtExecutorService.getScheduledExecutorInstance().scheduleWithFixedDelay(this::updateProfilingDuration, 0L, 1L, TimeUnit.SECONDS);
            Disposer.register((Disposable)parent, (Disposable)this);
            GridBag gridBag = new GridBag().setDefaultInsets(0, 0, 4, 10).setDefaultAnchor(17);
            Intrinsics.checkNotNullExpressionValue((Object)gridBag, (String)"setDefaultAnchor(...)");
            GridBag bag = gridBag;
            this.add((Component)this.profiling, bag.nextLine().next());
            this.add((Component)this.processNameComponent, bag.next().coverLine());
            this.add((Component)this.duration, bag.nextLine().next());
            this.add((Component)this.durationTimeComponent, bag.next().coverLine());
            this.add((Component)new SimpleColoredComponent(), bag.nextLine().next().coverLine());
            if (this.profilerProcess.canBeStopped()) {
                JButton jButton;
                JButton $this$_init__u24lambda_u244 = jButton = new JButton();
                boolean bl4 = false;
                $this$_init__u24lambda_u244.setOpaque(false);
                $this$_init__u24lambda_u244.setFocusable(false);
                $this$_init__u24lambda_u244.setText(CommonProfilerBundleKt.profilerMessage("run.profiler.stopAndShow", new Object[0]));
                $this$_init__u24lambda_u244.addActionListener(arg_0 -> ActiveProfilingPlaceholder.lambda$4$lambda$3(this, $this$_init__u24lambda_u244, arg_0));
                JButton stopBtn = jButton;
                this.add((Component)stopBtn, bag.nextLine().next().coverLine().insetTop(4));
            } else {
                SimpleColoredComponent simpleColoredComponent3;
                SimpleColoredComponent $this$_init__u24lambda_u245 = simpleColoredComponent3 = new SimpleColoredComponent();
                boolean bl5 = false;
                $this$_init__u24lambda_u245.append(CommonProfilerBundleKt.profilerMessage("profiler.link.stop.and.get", new Object[0]), StatusText.DEFAULT_ATTRIBUTES);
                SimpleColoredComponent stopTargetToGetResults = simpleColoredComponent3;
                this.add((Component)stopTargetToGetResults, bag.nextLine().next().coverLine());
            }
            this.setBackground(EditorColorsManager.getInstance().getGlobalScheme().getDefaultBackground());
        }

        private final void updateProfilingDuration() {
            Duration duration = Duration.ofMillis(System.currentTimeMillis() - this.profilerProcess.getAttachedTimestamp());
            this.durationTimeComponent.clear();
            Intrinsics.checkNotNull((Object)duration);
            this.durationTimeComponent.append(UtilsKt.durationToCompactString(duration), StatusText.DEFAULT_ATTRIBUTES);
            this.revalidate();
            this.repaint();
        }

        public final void stop() {
            ScheduledFuture<?> scheduledFuture = this.durationUpdater;
            if (scheduledFuture != null) {
                scheduledFuture.cancel(true);
            }
            this.durationUpdater = null;
        }

        public void dispose() {
            this.stop();
        }

        private static final void lambda$4$lambda$3(ActiveProfilingPlaceholder this$0, JButton $this_apply, ActionEvent it) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$this_apply, (String)"$this_apply");
            if (this$0.profilerProcess.stop()) {
                $this_apply.setEnabled(false);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0014J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\n"}, d2={"Lcom/intellij/profiler/ProfilerProcessPanel$CloseListener;", "Lcom/intellij/execution/ui/BaseContentCloseListener;", "(Lcom/intellij/profiler/ProfilerProcessPanel;)V", "closeQuery", "", "content", "Lcom/intellij/ui/content/Content;", "modal", "disposeContent", "", "intellij.profiler.common"})
    @SourceDebugExtension(value={"SMAP\nProfilerProcessPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProfilerProcessPanel.kt\ncom/intellij/profiler/ProfilerProcessPanel$CloseListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,266:1\n1#2:267\n*E\n"})
    private final class CloseListener
    extends BaseContentCloseListener {
        public CloseListener() {
            super(ProfilerProcessPanel.this.getContent(), ProfilerProcessPanel.this.getProfilerProcess().getProject(), (Disposable)ProfilerProcessPanel.this);
        }

        protected void disposeContent(@NotNull Content content2) {
            Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
            if (ProfilerProcessPanel.this.getProfilerProcess().getState().isActive()) {
                Disposer.dispose((Disposable)ProfilerProcessPanel.this);
            }
            content2.release();
        }

        protected boolean closeQuery(@NotNull Content content2, boolean modal) {
            NopProcessHandler nopProcessHandler;
            Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
            if (!ProfilerProcessPanel.this.getProfilerProcess().getState().isActive()) {
                return true;
            }
            NopProcessHandler $this$closeQuery_u24lambda_u240 = nopProcessHandler = new NopProcessHandler();
            boolean bl = false;
            $this$closeQuery_u24lambda_u240.startNotify();
            NopProcessHandler proxy = nopProcessHandler;
            proxy.putUserData(RunContentManagerImpl.ALWAYS_USE_DEFAULT_STOPPING_BEHAVIOUR_KEY, (Object)true);
            ProfilerProcessPanel.this.getProfilerProcess().addStateChangedListener((Function2<ProfilerState, ProfilerState, Unit>)((Function2)new Function2<ProfilerState, ProfilerState, Unit>(proxy){
                final /* synthetic */ NopProcessHandler $proxy;
                {
                    this.$proxy = $proxy;
                    super(2);
                }

                public final void invoke(@NotNull ProfilerState profilerState, @NotNull ProfilerState newState) {
                    Intrinsics.checkNotNullParameter((Object)profilerState, (String)"<anonymous parameter 0>");
                    Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
                    if (!newState.isActive()) {
                        ApplicationManager.getApplication().executeOnPooledThread(() -> closeQuery.1.invoke$lambda$0(this.$proxy));
                    }
                }

                private static final void invoke$lambda$0(NopProcessHandler $proxy) {
                    Intrinsics.checkNotNullParameter((Object)$proxy, (String)"$proxy");
                    Thread.sleep(200L);
                    $proxy.destroyProcess();
                }
            }));
            String sessionName = "Profiler for '" + ProfilerProcessPanel.this.getTabName() + "'";
            if (TerminateRemoteProcessDialog.show((Project)ProfilerProcessPanel.this.getProfilerProcess().getProject(), (String)sessionName, (ProcessHandler)((ProcessHandler)proxy)) == null) {
                return false;
            }
            ProfilerProcessPanel.this.getProfilerProcess().terminate();
            return true;
        }
    }
}

