/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler;

import com.intellij.credentialStore.Credentials;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.profiler.sudo.ExecSudoCommandKt;
import com.intellij.profiler.sudo.SudoAuthDialogKt;
import com.intellij.profiler.sudo.ValidationResult;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ0\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\b\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J&\u0010\u0013\u001a\u00020\r2\b\b\u0001\u0010\u000e\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u001a\u0010\u0014\u001a\u00020\r2\b\b\u0001\u0010\u000e\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tJ&\u0010\u0015\u001a\u00020\r2\b\b\u0001\u0010\u000e\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/profiler/ProfilerManager;", "", "()V", "GROUP_WITH_LOG", "Lcom/intellij/notification/NotificationGroup;", "kotlin.jvm.PlatformType", "getSudoPassword", "", "project", "Lcom/intellij/openapi/project/Project;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "showNotification", "", "content", "notificationType", "Lcom/intellij/notification/NotificationType;", "anAction", "Lcom/intellij/openapi/project/DumbAwareAction;", "showStickyError", "showStickyInfo", "showStickyWarning", "intellij.profiler.common"})
public final class ProfilerManager {
    @NotNull
    public static final ProfilerManager INSTANCE = new ProfilerManager();
    private static final NotificationGroup GROUP_WITH_LOG = NotificationGroupManager.getInstance().getNotificationGroup("ProfilerNotification");

    private ProfilerManager() {
    }

    @Nullable
    public final String getSudoPassword(@NotNull Project project, @Nullable ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Credentials credentials = SudoAuthDialogKt.getStoredSudoPassword();
        String pwd = credentials != null ? credentials.getPasswordAsString() : null;
        ProgressIndicator progressIndicator = indicator;
        boolean bl = progressIndicator != null ? progressIndicator.isCanceled() : false;
        if (bl) {
            return null;
        }
        if (pwd == null) {
            Credentials credentials2 = (Credentials)ActionsKt.invokeAndWaitIfNeeded$default(null, (Function0)((Function0)new Function0<Credentials>(project){
                final /* synthetic */ Project $project;
                {
                    this.$project = $project;
                    super(0);
                }

                @Nullable
                public final Credentials invoke() {
                    return SudoAuthDialogKt.showSudoAuthDialog(null, this.$project);
                }
            }), (int)1, null);
            return credentials2 != null ? credentials2.getPasswordAsString() : null;
        }
        return switch (WhenMappings.$EnumSwitchMapping$0[ExecSudoCommandKt.validateSudoPassword$default(pwd, indicator, 0, 4, null).ordinal()]) {
            case 1 -> {
                SudoAuthDialogKt.removeOldSudoPassword();
                Credentials v4 = (Credentials)ActionsKt.invokeAndWaitIfNeeded$default(null, (Function0)((Function0)new Function0<Credentials>(project){
                    final /* synthetic */ Project $project;
                    {
                        this.$project = $project;
                        super(0);
                    }

                    @Nullable
                    public final Credentials invoke() {
                        return SudoAuthDialogKt.showSudoAuthDialog(null, this.$project);
                    }
                }), (int)1, null);
                if (v4 != null) {
                    yield v4.getPasswordAsString();
                }
                yield null;
            }
            case 2 -> null;
            case 3 -> pwd;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public final void showStickyWarning(@NlsContexts.NotificationContent @NotNull String content2, @Nullable Project project, @Nullable DumbAwareAction anAction) {
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        this.showNotification(content2, NotificationType.WARNING, project, anAction);
    }

    public static /* synthetic */ void showStickyWarning$default(ProfilerManager profilerManager, String string, Project project, DumbAwareAction dumbAwareAction, int n, Object object) {
        if ((n & 4) != 0) {
            dumbAwareAction = null;
        }
        profilerManager.showStickyWarning(string, project, dumbAwareAction);
    }

    public final void showStickyError(@NlsContexts.NotificationContent @NotNull String content2, @Nullable Project project, @Nullable DumbAwareAction anAction) {
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        this.showNotification(content2, NotificationType.ERROR, project, anAction);
    }

    public static /* synthetic */ void showStickyError$default(ProfilerManager profilerManager, String string, Project project, DumbAwareAction dumbAwareAction, int n, Object object) {
        if ((n & 4) != 0) {
            dumbAwareAction = null;
        }
        profilerManager.showStickyError(string, project, dumbAwareAction);
    }

    public final void showStickyInfo(@NlsContexts.NotificationContent @NotNull String content2, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        ProfilerManager.showNotification$default(this, content2, NotificationType.INFORMATION, project, null, 8, null);
    }

    private final void showNotification(@NlsContexts.NotificationContent String content2, NotificationType notificationType, Project project, DumbAwareAction anAction) {
        Notification notification;
        Notification $this$showNotification_u24lambda_u240 = notification = GROUP_WITH_LOG.createNotification(content2, notificationType);
        boolean bl = false;
        if (anAction != null) {
            $this$showNotification_u24lambda_u240.addAction((AnAction)anAction);
        }
        notification.notify(project);
    }

    static /* synthetic */ void showNotification$default(ProfilerManager profilerManager, String string, NotificationType notificationType, Project project, DumbAwareAction dumbAwareAction, int n, Object object) {
        if ((n & 8) != 0) {
            dumbAwareAction = null;
        }
        profilerManager.showNotification(string, notificationType, project, dumbAwareAction);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ValidationResult.values().length];
            try {
                nArray[ValidationResult.INVALID.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValidationResult.CANCELED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValidationResult.VALID.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

