/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.providers.vswin.utilities;

import com.intellij.ide.startup.importSettings.TransferableIdeVersionId;
import com.intellij.ide.startup.importSettings.providers.vswin.parsers.VSIsolationIniParser;
import com.intellij.ide.startup.importSettings.providers.vswin.parsers.VSRegistryParserNew;
import com.intellij.ide.startup.importSettings.providers.vswin.utilities.VSHiveKt;
import com.intellij.ide.startup.importSettings.providers.vswin.utilities.Version2;
import java.io.File;
import java.nio.file.Path;
import java.util.Date;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 ,2\u00020\u0001:\u0002,-B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010(\u001a\u00020\u0005H\u0002J\b\u0010)\u001a\u00020\u0005H\u0016J\u0006\u0010*\u001a\u00020+R\u001d\u0010\b\u001a\u0004\u0018\u00010\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u0011\u0010\r\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\nR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\nR\u001b\u0010\u0010\u001a\u00020\u00118FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\f\u001a\u0004\b\u0010\u0010\u0012R\u001d\u0010\u0014\u001a\u0004\u0018\u00010\u00158FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\f\u001a\u0004\b\u0016\u0010\u0017R\u001b\u0010\u0019\u001a\u00020\u001a8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\f\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001e\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\nR\u001d\u0010 \u001a\u0004\u0018\u00010!8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010\f\u001a\u0004\b\"\u0010#R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'\u00a8\u0006."}, d2={"Lcom/intellij/ide/startup/importSettings/providers/vswin/utilities/VSHive;", "", "version", "Lcom/intellij/ide/startup/importSettings/providers/vswin/utilities/Version2;", "instanceId", "", "rootSuffix", "(Lcom/intellij/ide/startup/importSettings/providers/vswin/utilities/Version2;Ljava/lang/String;Ljava/lang/String;)V", "edition", "getEdition", "()Ljava/lang/String;", "edition$delegate", "Lkotlin/Lazy;", "hiveString", "getHiveString", "getInstanceId", "isInstalled", "", "()Z", "isInstalled$delegate", "isolation", "Lcom/intellij/ide/startup/importSettings/providers/vswin/parsers/VSIsolationIniParser;", "getIsolation", "()Lcom/intellij/ide/startup/importSettings/providers/vswin/parsers/VSIsolationIniParser;", "isolation$delegate", "lastUsage", "Ljava/util/Date;", "getLastUsage", "()Ljava/util/Date;", "lastUsage$delegate", "presentationString", "getPresentationString", "registry", "Lcom/intellij/ide/startup/importSettings/providers/vswin/parsers/VSRegistryParserNew;", "getRegistry", "()Lcom/intellij/ide/startup/importSettings/providers/vswin/parsers/VSRegistryParserNew;", "registry$delegate", "getRootSuffix", "getVersion", "()Lcom/intellij/ide/startup/importSettings/providers/vswin/utilities/Version2;", "productVersionTextRepresentation", "toString", "transferableVersion", "Lcom/intellij/ide/startup/importSettings/TransferableIdeVersionId;", "Companion", "Types", "intellij.ide.startup.importSettings"})
public final class VSHive {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Version2 version;
    @Nullable
    private final String instanceId;
    @Nullable
    private final String rootSuffix;
    @NotNull
    private final Lazy registry$delegate;
    @NotNull
    private final Lazy isolation$delegate;
    @NotNull
    private final Lazy isInstalled$delegate;
    @NotNull
    private final Lazy lastUsage$delegate;
    @NotNull
    private final Lazy edition$delegate;
    public static final int LATEST_VS_VERSION = 16;
    @NotNull
    private static final Regex regex = new Regex("\\b(?:(?:([0-9]{1,2}).([0-9]))(?:_([a-fA-F0-9]{8}))?([a-zA-Z0-9]*))\\b");

    public VSHive(@NotNull Version2 version, @Nullable String instanceId, @Nullable String rootSuffix) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        this.version = version;
        this.instanceId = instanceId;
        this.rootSuffix = rootSuffix;
        this.registry$delegate = LazyKt.lazy((Function0)((Function0)new Function0<VSRegistryParserNew>(this){
            final /* synthetic */ VSHive this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final VSRegistryParserNew invoke() {
                return VSRegistryParserNew.Companion.create(this.this$0);
            }
        }));
        this.isolation$delegate = LazyKt.lazy((Function0)((Function0)new Function0<VSIsolationIniParser>(this){
            final /* synthetic */ VSHive this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final VSIsolationIniParser invoke() {
                return VSIsolationIniParser.Companion.create(this.this$0);
            }
        }));
        this.isInstalled$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ VSHive this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                Pair<Path, File> pair = this.this$0.getRegistry();
                File it = pair != null && (pair = pair.getEnvPath()) != null ? (File)pair.getSecond() : null;
                boolean bl = false;
                return it != null && it.exists();
            }
        }));
        this.lastUsage$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Date>(this){
            final /* synthetic */ VSHive this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Date invoke() {
                Object object = this.this$0.getRegistry();
                Long it = object != null && (object = ((VSRegistryParserNew)object).getSettingsFile()) != null ? Long.valueOf(((File)object).lastModified()) : null;
                boolean bl = false;
                Long l2 = it;
                return new Date(l2 != null ? l2 : 0L);
            }
        }));
        this.edition$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ VSHive this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final String invoke() {
                VSIsolationIniParser vSIsolationIniParser = this.this$0.getIsolation();
                return vSIsolationIniParser != null ? vSIsolationIniParser.getEdition() : null;
            }
        }));
        if (this.version.getMajor() >= 15) {
            String string = this.instanceId;
            if (!(string != null ? string.length() == 8 : false)) {
                throw new IllegalArgumentException("Since Visual Studio 15 instanceId is required or bad instanceId is supplied (" + this.instanceId + ")");
            }
        }
    }

    public /* synthetic */ VSHive(Version2 version2, String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        this(version2, string, string2);
    }

    @NotNull
    public final Version2 getVersion() {
        return this.version;
    }

    @Nullable
    public final String getInstanceId() {
        return this.instanceId;
    }

    @Nullable
    public final String getRootSuffix() {
        return this.rootSuffix;
    }

    @NotNull
    public final String getHiveString() {
        Object object = this.instanceId == null ? "" : "_" + this.instanceId;
        String string = this.rootSuffix;
        if (string == null) {
            string = "";
        }
        return this.version + (String)object + string;
    }

    @NotNull
    public final String getPresentationString() {
        return "Visual Studio " + this.productVersionTextRepresentation();
    }

    @Nullable
    public final VSRegistryParserNew getRegistry() {
        Lazy lazy = this.registry$delegate;
        return (VSRegistryParserNew)lazy.getValue();
    }

    @Nullable
    public final VSIsolationIniParser getIsolation() {
        Lazy lazy = this.isolation$delegate;
        return (VSIsolationIniParser)lazy.getValue();
    }

    public final boolean isInstalled() {
        Lazy lazy = this.isInstalled$delegate;
        return (Boolean)lazy.getValue();
    }

    @NotNull
    public final Date getLastUsage() {
        Lazy lazy = this.lastUsage$delegate;
        return (Date)lazy.getValue();
    }

    @Nullable
    public final String getEdition() {
        Lazy lazy = this.edition$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public String toString() {
        return "Visual Studio " + this.productVersionTextRepresentation() + " (" + this.getHiveString() + ")";
    }

    private final String productVersionTextRepresentation() {
        return switch (this.version.getMajor()) {
            case 17 -> "2022";
            case 16 -> "2019";
            case 15 -> "2017";
            case 14 -> "2015";
            case 12 -> "2013";
            case 11 -> "2012";
            default -> "Ver. " + this.version.getMajor() + "." + this.version.getMinor();
        };
    }

    @NotNull
    public final TransferableIdeVersionId transferableVersion() {
        return switch (this.version.getMajor()) {
            case 17 -> TransferableIdeVersionId.V2022;
            case 16 -> TransferableIdeVersionId.V2019;
            case 15 -> TransferableIdeVersionId.V2017;
            case 14 -> TransferableIdeVersionId.V2015;
            case 12 -> TransferableIdeVersionId.V2013;
            case 11 -> TransferableIdeVersionId.V2012;
            default -> TransferableIdeVersionId.Unknown;
        };
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ide/startup/importSettings/providers/vswin/utilities/VSHive$Companion;", "", "()V", "LATEST_VS_VERSION", "", "regex", "Lkotlin/text/Regex;", "getRegex", "()Lkotlin/text/Regex;", "parse", "Lcom/intellij/ide/startup/importSettings/providers/vswin/utilities/VSHive;", "hive", "", "type", "Lcom/intellij/ide/startup/importSettings/providers/vswin/utilities/VSHive$Types;", "intellij.ide.startup.importSettings"})
    @SourceDebugExtension(value={"SMAP\nVSHive.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VSHive.kt\ncom/intellij/ide/startup/importSettings/providers/vswin/utilities/VSHive$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,113:1\n1#2:114\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Regex getRegex() {
            return regex;
        }

        @Nullable
        public final VSHive parse(@NotNull String hive, @NotNull Types type) {
            Object object;
            Object object2;
            Version2 version2;
            Object object3;
            Intrinsics.checkNotNullParameter((Object)hive, (String)"hive");
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            VSHiveKt.access$getLogger$p().info("Starting " + hive + " on type " + type);
            MatchResult matchResult = Regex.find$default((Regex)this.getRegex(), (CharSequence)hive, (int)0, (int)2, null);
            if (matchResult == null) {
                return null;
            }
            MatchResult spl = matchResult;
            MatchResult.Destructured destructured = spl.getDestructured();
            String maj = (String)destructured.getMatch().getGroupValues().get(1);
            String min2 = (String)destructured.getMatch().getGroupValues().get(2);
            String instId = (String)destructured.getMatch().getGroupValues().get(3);
            String rtSuf = (String)destructured.getMatch().getGroupValues().get(4);
            try {
                object3 = new Version2(Integer.parseInt(maj), Integer.parseInt(min2));
            }
            catch (NumberFormatException e) {
                VSHiveKt.access$getLogger$p().warn("Bad major or minor version number (" + hive + ")");
                return null;
            }
            Version2 ver = object3;
            if (type == Types.Old && ver.getMajor() != 11 && ver.getMajor() != 12 && ver.getMajor() != 14) {
                VSHiveKt.access$getLogger$p().trace("Wanted to access only old versions, returning (" + hive + ")");
                return null;
            }
            if (type == Types.New && instId.length() != 8) {
                VSHiveKt.access$getLogger$p().warn("Requested only new vs, but got something other (" + hive + ")");
                return null;
            }
            if (Integer.parseInt(maj) < 14) {
                VSHiveKt.access$getLogger$p().warn("Unsupported version (" + hive + ")");
                return null;
            }
            VSHiveKt.access$getLogger$p().info("Parsed " + hive);
            Version2 version22 = ver;
            object3 = instId;
            if (object3.length() == 0) {
                version2 = version22;
                boolean bl = false;
                object2 = null;
                version22 = version2;
            } else {
                object2 = object3;
            }
            String string = (String)object2;
            object3 = rtSuf;
            if (object3.length() == 0) {
                String string2 = string;
                version2 = version22;
                boolean bl = false;
                Object var15_16 = null;
                version22 = version2;
                string = string2;
                object = var15_16;
            } else {
                object = object3;
            }
            String string3 = (String)object;
            String string4 = string;
            Version2 version23 = version22;
            Object $this$parse_u24lambda_u242 = object3 = new VSHive(version23, string4, string3);
            boolean bl = false;
            VSHiveKt.access$getLogger$p().assertTrue(Intrinsics.areEqual((Object)hive, (Object)((VSHive)$this$parse_u24lambda_u242).getHiveString()), (Object)"different hive string");
            return object3;
        }

        public static /* synthetic */ VSHive parse$default(Companion companion, String string, Types types, int n, Object object) {
            if ((n & 2) != 0) {
                types = Types.All;
            }
            return companion.parse(string, types);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ide/startup/importSettings/providers/vswin/utilities/VSHive$Types;", "", "(Ljava/lang/String;I)V", "Old", "New", "All", "intellij.ide.startup.importSettings"})
    public static final class Types
    extends Enum<Types> {
        public static final /* enum */ Types Old = new Types();
        public static final /* enum */ Types New = new Types();
        public static final /* enum */ Types All = new Types();
        private static final /* synthetic */ Types[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Types[] values() {
            return (Types[])$VALUES.clone();
        }

        public static Types valueOf(String value) {
            return Enum.valueOf(Types.class, value);
        }

        @NotNull
        public static EnumEntries<Types> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = typesArray = new Types[]{Types.Old, Types.New, Types.All};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

