/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.jb;

import com.intellij.configurationStore.XmlSerializer;
import com.intellij.ide.startup.importSettings.jb.JbImportServiceImpl;
import com.intellij.ide.startup.importSettings.jb.JbImportXmlHandler;
import com.intellij.ide.ui.NotRoamableUiSettings;
import com.intellij.ide.util.BasePropertyService;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.io.PathKt;
import com.intellij.util.xmlb.DomAdapter;
import com.intellij.util.xmlb.JdomAdapter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ide/startup/importSettings/jb/OtherXmlHandler;", "Lcom/intellij/ide/startup/importSettings/jb/JbImportXmlHandler;", "()V", "MAX_FILE_SIZE", "", "name", "", "getName", "()Ljava/lang/String;", "process", "", "configDir", "Ljava/nio/file/Path;", "processDFMInPropertiesService", "componentElement", "Lorg/jdom/Element;", "processExperimentalToolbar", "intellij.ide.startup.importSettings"})
@SourceDebugExtension(value={"SMAP\nJbImportSpecialHandlers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JbImportSpecialHandlers.kt\ncom/intellij/ide/startup/importSettings/jb/OtherXmlHandler\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,78:1\n215#2,2:79\n*S KotlinDebug\n*F\n+ 1 JbImportSpecialHandlers.kt\ncom/intellij/ide/startup/importSettings/jb/OtherXmlHandler\n*L\n66#1:79,2\n*E\n"})
final class OtherXmlHandler
implements JbImportXmlHandler {
    @NotNull
    public static final OtherXmlHandler INSTANCE = new OtherXmlHandler();
    private static final long MAX_FILE_SIZE = 0x1000000L;
    @NotNull
    private static final String name = "OtherXmlHandler";

    private OtherXmlHandler() {
    }

    @Override
    @NotNull
    public String getName() {
        return name;
    }

    @Override
    public void process(@NotNull Path configDir) {
        Intrinsics.checkNotNullParameter((Object)configDir, (String)"configDir");
        Path path = configDir.resolve("options");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        Path path2 = path.resolve("other.xml");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        Path otherXmlFile = path2;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.isRegularFile(otherXmlFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) || PathKt.fileSizeSafe((Path)otherXmlFile, (long)0x1000000L) >= 0x1000000L) {
            JbImportServiceImpl.Companion.getLOG$intellij_ide_startup_importSettings().warn("Won't process handler " + this.getName() + ", because the file is missing or too large");
            return;
        }
        Element element2 = JDOMUtil.load((Path)otherXmlFile);
        Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"load(...)");
        Element otherXmlDocument = element2;
        for (Element component : otherXmlDocument.getChildren()) {
            if (!Intrinsics.areEqual((Object)component.getAttributeValue("name"), (Object)"PropertyService")) continue;
            Intrinsics.checkNotNull((Object)component);
            this.processDFMInPropertiesService(component);
        }
        this.processExperimentalToolbar();
    }

    public final void processDFMInPropertiesService(@NotNull Element componentElement) {
        Intrinsics.checkNotNullParameter((Object)componentElement, (String)"componentElement");
        PropertiesComponent propertiesService = PropertiesComponent.getInstance();
        BasePropertyService.MyState extState = (BasePropertyService.MyState)XmlSerializer.getJdomSerializer().deserialize((Object)componentElement, BasePropertyService.MyState.class, (DomAdapter)JdomAdapter.INSTANCE);
        Map $this$forEach$iv = extState.getKeyToString();
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry2 = element$iv = iterator2.next();
            boolean bl = false;
            String key = (String)entry2.getKey();
            String value = (String)entry2.getValue();
            if (!StringsKt.contains$default((CharSequence)key, (CharSequence)"DISTRACTION.MODE.", (boolean)false, (int)2, null)) continue;
            propertiesService.setValue(key, value);
        }
    }

    public final void processExperimentalToolbar() {
        if (NotRoamableUiSettings.Companion.getInstance().getExperimentalSingleStripe()) {
            NotRoamableUiSettings.Companion.getInstance().setExperimentalSingleStripe(false);
        }
    }
}

