/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process.mediator.client.launcher;

import com.intellij.execution.process.mediator.client.launcher.ProcessMediatorConnection;
import com.intellij.execution.process.mediator.common.QuotaOptions;
import com.intellij.execution.process.mediator.common.QuotaState;
import com.intellij.openapi.Disposable;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import com.intellij.util.io.MultiCloseable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010\u0013\u001a\u00020\u0010H\u0016J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0004H\u0002J\b\u0010\u0015\u001a\u00020\u0004H\u0002J\u0006\u0010\u0016\u001a\u00020\u0004J\u000e\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0004J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u0004H\u0002R\u0014\u0010\u0006\u001a\u00020\u00048CX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/execution/process/mediator/client/launcher/ProcessMediatorConnectionManager;", "Lcom/intellij/openapi/Disposable;", "connectionProvider", "Lkotlin/Function0;", "Lcom/intellij/execution/process/mediator/client/launcher/ProcessMediatorConnection;", "(Lkotlin/jvm/functions/Function0;)V", "activeConnection", "getOrCreateConnection", "()Lcom/intellij/execution/process/mediator/client/launcher/ProcessMediatorConnection;", "activeConnectionLazy", "Lcom/intellij/util/concurrency/SynchronizedClearableLazy;", "isDisposed", "", "parkedConnections", "", "adjustQuota", "", "quotaOptions", "Lcom/intellij/execution/process/mediator/common/QuotaOptions;", "dispose", "getActiveConnectionOrNull", "launchDaemonAndConnect", "launchDaemonAndConnectIfNeeded", "parkConnection", "expectedConnection", "removeParkedConnection", "connection", "intellij.execution.process.mediator.client"})
@SourceDebugExtension(value={"SMAP\nProcessMediatorConnectionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProcessMediatorConnectionManager.kt\ncom/intellij/execution/process/mediator/client/launcher/ProcessMediatorConnectionManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,78:1\n1#2:79\n37#3,2:80\n*S KotlinDebug\n*F\n+ 1 ProcessMediatorConnectionManager.kt\ncom/intellij/execution/process/mediator/client/launcher/ProcessMediatorConnectionManager\n*L\n71#1:80,2\n*E\n"})
public final class ProcessMediatorConnectionManager
implements Disposable {
    @NotNull
    private final Function0<ProcessMediatorConnection> connectionProvider;
    private boolean isDisposed;
    @NotNull
    private final List<ProcessMediatorConnection> parkedConnections;
    @NotNull
    private final SynchronizedClearableLazy<ProcessMediatorConnection> activeConnectionLazy;

    public ProcessMediatorConnectionManager(@NotNull Function0<? extends ProcessMediatorConnection> connectionProvider) {
        Intrinsics.checkNotNullParameter(connectionProvider, (String)"connectionProvider");
        this.connectionProvider = connectionProvider;
        this.parkedConnections = new ArrayList();
        this.activeConnectionLazy = new SynchronizedClearableLazy((Function0)new Function0<ProcessMediatorConnection>(this){
            final /* synthetic */ ProcessMediatorConnectionManager this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ProcessMediatorConnection invoke() {
                ProcessMediatorConnection processMediatorConnection = ProcessMediatorConnectionManager.access$launchDaemonAndConnect(this.this$0);
                ProcessMediatorConnectionManager processMediatorConnectionManager = this.this$0;
                ProcessMediatorConnection $this$invoke_u24lambda_u240 = processMediatorConnection;
                boolean bl = false;
                FlowKt.launchIn((Flow)FlowKt.onCompletion((Flow)FlowKt.onEach($this$invoke_u24lambda_u240.getClient().getStateUpdateFlow(), (Function2)((Function2)new Function2<QuotaState, Continuation<? super Unit>, Object>(processMediatorConnectionManager, $this$invoke_u24lambda_u240, null){
                    int label;
                    /* synthetic */ Object L$0;
                    final /* synthetic */ ProcessMediatorConnectionManager this$0;
                    final /* synthetic */ ProcessMediatorConnection $this_connection;
                    {
                        this.this$0 = $receiver;
                        this.$this_connection = $receiver2;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                QuotaState it = (QuotaState)this.L$0;
                                if (it instanceof QuotaState.Expired) {
                                    this.this$0.parkConnection(this.$this_connection);
                                }
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                        var3_3.L$0 = value;
                        return (Continuation)var3_3;
                    }

                    @Nullable
                    public final Object invoke(@NotNull QuotaState p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                })), (Function3)((Function3)new Function3<FlowCollector<? super QuotaState>, Throwable, Continuation<? super Unit>, Object>(processMediatorConnectionManager, $this$invoke_u24lambda_u240, null){
                    int label;
                    final /* synthetic */ ProcessMediatorConnectionManager this$0;
                    final /* synthetic */ ProcessMediatorConnection $this_connection;
                    {
                        this.this$0 = $receiver;
                        this.$this_connection = $receiver2;
                        super(3, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                ProcessMediatorConnectionManager.access$removeParkedConnection(this.this$0, this.$this_connection);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @Nullable
                    public final Object invoke(@NotNull FlowCollector<? super QuotaState> p1, @Nullable Throwable p2, @Nullable Continuation<? super Unit> p3) {
                        return new /* invalid duplicate definition of identical inner class */.invokeSuspend(Unit.INSTANCE);
                    }
                })), (CoroutineScope)$this$invoke_u24lambda_u240.getClient().getCoroutineScope$intellij_execution_process_mediator_client());
                return processMediatorConnection;
            }
        });
    }

    @JvmName(name="getOrCreateConnection")
    private final ProcessMediatorConnection getOrCreateConnection() {
        return (ProcessMediatorConnection)this.activeConnectionLazy.getValue();
    }

    @NotNull
    public final ProcessMediatorConnection launchDaemonAndConnectIfNeeded() {
        return this.getOrCreateConnection();
    }

    private final ProcessMediatorConnection getActiveConnectionOrNull() {
        return (ProcessMediatorConnection)this.activeConnectionLazy.getValueIfInitialized();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void parkConnection(@NotNull ProcessMediatorConnection expectedConnection) {
        Intrinsics.checkNotNullParameter((Object)expectedConnection, (String)"expectedConnection");
        ProcessMediatorConnectionManager processMediatorConnectionManager = this;
        synchronized (processMediatorConnectionManager) {
            boolean bl = false;
            if (this.activeConnectionLazy.compareAndDrop((Object)expectedConnection)) {
                this.parkedConnections.add(expectedConnection);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void removeParkedConnection(ProcessMediatorConnection connection) {
        ProcessMediatorConnectionManager processMediatorConnectionManager = this;
        synchronized (processMediatorConnectionManager) {
            boolean bl = false;
            if (!this.activeConnectionLazy.compareAndDrop((Object)connection)) {
                this.parkedConnections.remove(connection);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void adjustQuota(@NotNull QuotaOptions quotaOptions2) {
        Intrinsics.checkNotNullParameter((Object)quotaOptions2, (String)"quotaOptions");
        ProcessMediatorConnectionManager processMediatorConnectionManager = this;
        synchronized (processMediatorConnectionManager) {
            boolean bl = false;
            ProcessMediatorConnection processMediatorConnection = this.getActiveConnectionOrNull();
            if (processMediatorConnection == null) {
                return;
            }
            ProcessMediatorConnection connection = processMediatorConnection;
            connection.getClient().adjustQuotaBlocking(quotaOptions2);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ProcessMediatorConnection launchDaemonAndConnect() {
        ProcessMediatorConnectionManager processMediatorConnectionManager = this;
        synchronized (processMediatorConnectionManager) {
            boolean bl = false;
            if (!(!this.isDisposed)) {
                boolean bl2 = false;
                String string = "Already disposed";
                throw new IllegalStateException(string.toString());
            }
            ProcessMediatorConnection processMediatorConnection = (ProcessMediatorConnection)this.connectionProvider.invoke();
            return processMediatorConnection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        ProcessMediatorConnection[] processMediatorConnectionArray;
        ProcessMediatorConnectionManager processMediatorConnectionManager = this;
        synchronized (processMediatorConnectionManager) {
            ProcessMediatorConnection[] processMediatorConnectionArray2;
            boolean bl = false;
            if (this.isDisposed) {
                return;
            }
            this.isDisposed = true;
            ProcessMediatorConnection processMediatorConnection = (ProcessMediatorConnection)this.activeConnectionLazy.drop();
            if (processMediatorConnection != null) {
                ProcessMediatorConnection it = processMediatorConnection;
                boolean bl2 = false;
                this.parkedConnections.add(it);
            }
            Collection $this$toTypedArray$iv = this.parkedConnections;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            ProcessMediatorConnection[] it = processMediatorConnectionArray2 = thisCollection$iv.toArray(new ProcessMediatorConnection[0]);
            boolean bl3 = false;
            this.parkedConnections.clear();
            processMediatorConnectionArray = processMediatorConnectionArray2;
        }
        ProcessMediatorConnection[] connections = processMediatorConnectionArray;
        MultiCloseable.closeAll((AutoCloseable[])Arrays.copyOf(connections, connections.length));
    }

    public static final /* synthetic */ ProcessMediatorConnection access$launchDaemonAndConnect(ProcessMediatorConnectionManager $this) {
        return $this.launchDaemonAndConnect();
    }

    public static final /* synthetic */ void access$removeParkedConnection(ProcessMediatorConnectionManager $this, ProcessMediatorConnection connection) {
        $this.removeParkedConnection(connection);
    }
}

