/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl.navigation;

import com.intellij.model.Pointer;
import com.intellij.navigation.NavigatableSymbol;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.impl.navigation.LspNavigationTarget;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.lsp4j.LocationLink;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00000\bH\u0016J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/platform/lsp/impl/navigation/LspNavigatableSymbol;", "Lcom/intellij/navigation/NavigatableSymbol;", "targetFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "locationLink", "Lorg/eclipse/lsp4j/LocationLink;", "(Lcom/intellij/openapi/vfs/VirtualFile;Lorg/eclipse/lsp4j/LocationLink;)V", "createPointer", "Lcom/intellij/model/Pointer;", "getNavigationTargets", "", "Lcom/intellij/platform/lsp/impl/navigation/LspNavigationTarget;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.lsp.impl"})
final class LspNavigatableSymbol
implements NavigatableSymbol {
    @NotNull
    private final VirtualFile targetFile;
    @NotNull
    private final LocationLink locationLink;

    public LspNavigatableSymbol(@NotNull VirtualFile targetFile, @NotNull LocationLink locationLink) {
        Intrinsics.checkNotNullParameter((Object)targetFile, (String)"targetFile");
        Intrinsics.checkNotNullParameter((Object)locationLink, (String)"locationLink");
        this.targetFile = targetFile;
        this.locationLink = locationLink;
    }

    @NotNull
    public Pointer<LspNavigatableSymbol> createPointer() {
        return () -> LspNavigatableSymbol.V(this);
    }

    @NotNull
    public List<LspNavigationTarget> getNavigationTargets(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return CollectionsKt.listOf((Object)new LspNavigationTarget(project, this.targetFile, this.locationLink));
    }

    private static final LspNavigatableSymbol V(LspNavigatableSymbol lspNavigatableSymbol) {
        Intrinsics.checkNotNullParameter((Object)lspNavigatableSymbol, (String)"this$0");
        return lspNavigatableSymbol.targetFile.isValid() ? new LspNavigatableSymbol(lspNavigatableSymbol.targetFile, lspNavigatableSymbol.locationLink) : null;
    }
}

