/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl.documentation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.model.Pointer;
import com.intellij.openapi.project.Project;
import com.intellij.platform.backend.documentation.DocumentationResult;
import com.intellij.platform.backend.documentation.DocumentationTarget;
import com.intellij.platform.backend.presentation.TargetPresentation;
import com.intellij.platform.lsp.impl.documentation.LspDocumentationDataKt;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.lsp4j.MarkupContent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B$\u0012\r\u0010\u0002\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0017J\b\u0010\f\u001a\u00020\rH\u0016J\u001b\u0010\u000e\u001a\u0015\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00000\u00000\u000f\u00a2\u0006\u0002\b\u0011H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0002\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/platform/lsp/impl/documentation/LspDocumentationTarget;", "Lcom/intellij/platform/backend/documentation/DocumentationTarget;", "presentableText", "", "Lcom/intellij/openapi/util/NlsSafe;", "markupContent", "Lorg/eclipse/lsp4j/MarkupContent;", "project", "Lcom/intellij/openapi/project/Project;", "(Ljava/lang/String;Lorg/eclipse/lsp4j/MarkupContent;Lcom/intellij/openapi/project/Project;)V", "computeDocumentation", "Lcom/intellij/platform/backend/documentation/DocumentationResult;", "computePresentation", "Lcom/intellij/platform/backend/presentation/TargetPresentation;", "createPointer", "Lcom/intellij/model/Pointer;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.lsp.impl"})
final class LspDocumentationTarget
implements DocumentationTarget {
    @Nullable
    private final String presentableText;
    @NotNull
    private final MarkupContent markupContent;
    @NotNull
    private final Project project;

    public LspDocumentationTarget(@Nullable String presentableText, @NotNull MarkupContent markupContent, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)markupContent, (String)"markupContent");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.presentableText = presentableText;
        this.markupContent = markupContent;
        this.project = project;
    }

    @NotNull
    public Pointer<LspDocumentationTarget> createPointer() {
        Pointer pointer2 = Pointer.hardPointer((Object)this);
        Intrinsics.checkNotNullExpressionValue((Object)pointer2, (String)"hardPointer(...)");
        return pointer2;
    }

    @NotNull
    public TargetPresentation computePresentation() {
        String string = this.presentableText;
        if (string == null) {
            String string2 = CodeInsightBundle.message((String)"documentation.tool.window.title", (Object[])new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        }
        TargetPresentation targetPresentation = TargetPresentation.Companion.builder(string).presentation();
        Intrinsics.checkNotNullExpressionValue((Object)targetPresentation, (String)"presentation(...)");
        return targetPresentation;
    }

    @RequiresReadLock
    @NotNull
    public DocumentationResult computeDocumentation() {
        return (DocumentationResult)LspDocumentationDataKt.createLspDocumentationData(this.markupContent).toQuickDocHtml(this.project);
    }
}

