/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl.connector;

import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.platform.lsp.impl.LspServerImpl;
import com.intellij.platform.lsp.impl.connector.LspServerProcessListenerBase;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.io.IOUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/platform/lsp/impl/connector/LspServerProcessListener;", "Lcom/intellij/platform/lsp/impl/connector/LspServerProcessListenerBase;", "lspServer", "Lcom/intellij/platform/lsp/impl/LspServerImpl;", "(Lcom/intellij/platform/lsp/impl/LspServerImpl;)V", "outputStreamWriter", "Ljava/io/OutputStreamWriter;", "pipedInputStream", "Ljava/io/PipedInputStream;", "getPipedInputStream", "()Ljava/io/PipedInputStream;", "pipedOutputStream", "Ljava/io/PipedOutputStream;", "onTextAvailable", "", "event", "Lcom/intellij/execution/process/ProcessEvent;", "outputType", "Lcom/intellij/openapi/util/Key;", "processTerminated", "intellij.platform.lsp.impl"})
@SourceDebugExtension(value={"SMAP\nLsp4jServerConnectorStdio.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Lsp4jServerConnectorStdio.kt\ncom/intellij/platform/lsp/impl/connector/LspServerProcessListener\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,69:1\n9#2:70\n*S KotlinDebug\n*F\n+ 1 Lsp4jServerConnectorStdio.kt\ncom/intellij/platform/lsp/impl/connector/LspServerProcessListener\n*L\n65#1:70\n*E\n"})
final class LspServerProcessListener
extends LspServerProcessListenerBase {
    @NotNull
    private final LspServerImpl lspServer;
    @NotNull
    private final PipedOutputStream pipedOutputStream;
    @NotNull
    private final OutputStreamWriter outputStreamWriter;
    @NotNull
    private final PipedInputStream pipedInputStream;

    public LspServerProcessListener(@NotNull LspServerImpl lspServer) {
        Intrinsics.checkNotNullParameter((Object)lspServer, (String)"lspServer");
        super(lspServer);
        this.lspServer = lspServer;
        this.pipedOutputStream = new PipedOutputStream();
        this.outputStreamWriter = new OutputStreamWriter((OutputStream)this.pipedOutputStream, StandardCharsets.UTF_8);
        this.pipedInputStream = new PipedInputStream(this.pipedOutputStream);
    }

    @NotNull
    public final PipedInputStream getPipedInputStream() {
        return this.pipedInputStream;
    }

    public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key<?> outputType) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
        if (ProcessOutputType.isStdout(outputType)) {
            try {
                this.outputStreamWriter.write(event.getText());
                this.outputStreamWriter.flush();
            }
            catch (IOException iOException) {
                String[] stringArray = new String[]{"readSide", "writeSide", "closedByReader", "closedByWriter"};
                String string = ReflectionUtil.dumpFields(PipedInputStream.class, (Object)this.pipedInputStream, (String[])stringArray);
                this.lspServer.logError$intellij_platform_lsp_impl("Problem proxying data to the listener: " + iOException.getMessage() + "\nStopping LSP server process: " + event.getProcessHandler() + "\n" + string);
                ExecutionManagerImpl.Companion.stopProcess(event.getProcessHandler());
            }
        } else if (ProcessOutputType.isStderr(outputType)) {
            String string = event.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            this.lspServer.logInfo$intellij_platform_lsp_impl("STDERR: " + ((Object)StringsKt.trimEnd((CharSequence)string)).toString());
        }
    }

    @Override
    public void processTerminated(@NotNull ProcessEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Closeable[] closeableArray = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(LspServerProcessListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        closeableArray = new Closeable[]{this.outputStreamWriter, this.pipedOutputStream};
        IOUtil.closeSafe((Logger)logger, (Closeable[])closeableArray);
        super.processTerminated(event);
    }
}

