/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl.connector;

import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.platform.lsp.impl.LspServerImpl;
import com.intellij.platform.lsp.impl.connector.Lsp4jServerConnector;
import com.intellij.platform.lsp.impl.connector.LspServerProcessListener;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\b\u0010\u0015\u001a\u00020\u0012H\u0014J\b\u0010\u0016\u001a\u00020\u0012H\u0014R\u0014\u0010\u0005\u001a\u00020\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0017"}, d2={"Lcom/intellij/platform/lsp/impl/connector/Lsp4jServerConnectorStdio;", "Lcom/intellij/platform/lsp/impl/connector/Lsp4jServerConnector;", "lspServer", "Lcom/intellij/platform/lsp/impl/LspServerImpl;", "(Lcom/intellij/platform/lsp/impl/LspServerImpl;)V", "ideToServerStream", "Ljava/io/OutputStream;", "getIdeToServerStream", "()Ljava/io/OutputStream;", "processHandler", "Lcom/intellij/execution/process/OSProcessHandler;", "processListener", "Lcom/intellij/platform/lsp/impl/connector/LspServerProcessListener;", "serverToIdeStream", "Ljava/io/InputStream;", "getServerToIdeStream", "()Ljava/io/InputStream;", "disconnect", "", "isConnectionAlive", "", "prepareConnect", "startNotify", "intellij.platform.lsp.impl"})
public final class Lsp4jServerConnectorStdio
extends Lsp4jServerConnector {
    @NotNull
    private final LspServerImpl lspServer;
    @NotNull
    private final OSProcessHandler processHandler;
    @NotNull
    private final LspServerProcessListener processListener;
    @NotNull
    private final OutputStream ideToServerStream;
    @NotNull
    private final InputStream serverToIdeStream;

    public Lsp4jServerConnectorStdio(@NotNull LspServerImpl lspServer) {
        LspServerProcessListener lspServerProcessListener;
        Intrinsics.checkNotNullParameter((Object)lspServer, (String)"lspServer");
        super(lspServer);
        this.lspServer = lspServer;
        this.processHandler = this.lspServer.getDescriptor().startServerProcess();
        LspServerProcessListener lspServerProcessListener2 = lspServerProcessListener = new LspServerProcessListener(this.lspServer);
        Lsp4jServerConnectorStdio lsp4jServerConnectorStdio = this;
        boolean bl = false;
        this.processHandler.addProcessListener((ProcessListener)lspServerProcessListener2);
        lsp4jServerConnectorStdio.processListener = lspServerProcessListener;
        OutputStream outputStream = this.processHandler.getProcessInput();
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"getProcessInput(...)");
        this.ideToServerStream = outputStream;
        this.serverToIdeStream = this.processListener.getPipedInputStream();
    }

    @Override
    @NotNull
    protected OutputStream getIdeToServerStream() {
        return this.ideToServerStream;
    }

    @Override
    @NotNull
    protected InputStream getServerToIdeStream() {
        return this.serverToIdeStream;
    }

    @Override
    protected void prepareConnect() {
    }

    @Override
    protected void startNotify() {
        this.processHandler.startNotify();
    }

    @Override
    protected boolean isConnectionAlive() {
        return this.processHandler.isStartNotified() && !this.processHandler.isProcessTerminated();
    }

    @Override
    public void disconnect() {
        if (!this.processHandler.isProcessTerminated()) {
            this.lspServer.logInfo$intellij_platform_lsp_impl("Stopping LSP server process: " + this.processHandler.getCommandLine());
            ExecutionManagerImpl.Companion.stopProcess((ProcessHandler)this.processHandler);
        }
    }
}

