/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl.connector;

import com.google.gson.JsonParseException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.lsp.api.Lsp4jClient;
import com.intellij.platform.lsp.api.LspServerDescriptor;
import com.intellij.platform.lsp.impl.LspServerImpl;
import com.intellij.platform.lsp.impl.connector.Lsp4jServerConnectorKt;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLockAbsence;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.InitializedParams;
import org.eclipse.lsp4j.jsonrpc.Endpoint;
import org.eclipse.lsp4j.jsonrpc.MessageConsumer;
import org.eclipse.lsp4j.jsonrpc.RemoteEndpoint;
import org.eclipse.lsp4j.jsonrpc.json.MessageJsonHandler;
import org.eclipse.lsp4j.jsonrpc.json.MethodProvider;
import org.eclipse.lsp4j.jsonrpc.json.StreamMessageConsumer;
import org.eclipse.lsp4j.jsonrpc.json.StreamMessageProducer;
import org.eclipse.lsp4j.jsonrpc.messages.Message;
import org.eclipse.lsp4j.jsonrpc.services.ServiceEndpoints;
import org.eclipse.lsp4j.services.LanguageServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\b \u0018\u00002\u00020\u0001B\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J!\u0010\u0018\u001a\u00020\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00190\u001bH\u0001\u00a2\u0006\u0002\b\u001dJ\b\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u00020\u0019H$J\u001c\u0010!\u001a\u00020\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00190\u001bH\u0003J\b\u0010\"\u001a\u00020#H$J\b\u0010$\u001a\u00020\u0019H$J\r\u0010%\u001a\u00020\u0019H\u0001\u00a2\u0006\u0002\b&J\b\u0010'\u001a\u00020\u0019H$R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\bX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u00060\u000ej\u0002`\u000fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0012\u0010\u0014\u001a\u00020\u0015X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006("}, d2={"Lcom/intellij/platform/lsp/impl/connector/Lsp4jServerConnector;", "", "lspServer", "Lcom/intellij/platform/lsp/impl/LspServerImpl;", "(Lcom/intellij/platform/lsp/impl/LspServerImpl;)V", "descriptor", "Lcom/intellij/platform/lsp/api/LspServerDescriptor;", "ideToServerStream", "Ljava/io/OutputStream;", "getIdeToServerStream", "()Ljava/io/OutputStream;", "lsp4jClient", "Lcom/intellij/platform/lsp/api/Lsp4jClient;", "lsp4jServer", "Lorg/eclipse/lsp4j/services/LanguageServer;", "Lcom/intellij/platform/lsp/api/Lsp4jServer;", "getLsp4jServer", "()Lorg/eclipse/lsp4j/services/LanguageServer;", "setLsp4jServer", "(Lorg/eclipse/lsp4j/services/LanguageServer;)V", "serverToIdeStream", "Ljava/io/InputStream;", "getServerToIdeStream", "()Ljava/io/InputStream;", "connect", "", "onSuccess", "Lkotlin/Function1;", "Lorg/eclipse/lsp4j/InitializeResult;", "connect$intellij_platform_lsp_impl", "V", "Lorg/eclipse/lsp4j/jsonrpc/json/MessageJsonHandler;", "disconnect", "V", "isConnectionAlive", "", "prepareConnect", "shutdownExitDisconnect", "shutdownExitDisconnect$intellij_platform_lsp_impl", "startNotify", "intellij.platform.lsp.impl"})
public abstract class Lsp4jServerConnector {
    @NotNull
    private final LspServerDescriptor descriptor;
    @NotNull
    private final Lsp4jClient lsp4jClient;
    public LanguageServer lsp4jServer;

    protected Lsp4jServerConnector(@NotNull LspServerImpl lspServer) {
        Intrinsics.checkNotNullParameter((Object)lspServer, (String)"lspServer");
        this.descriptor = lspServer.getDescriptor();
        this.lsp4jClient = this.descriptor.createLsp4jClient(lspServer.getServerNotificationsHandler$intellij_platform_lsp_impl());
    }

    @NotNull
    public final LanguageServer getLsp4jServer() {
        LanguageServer languageServer = this.lsp4jServer;
        if (languageServer != null) {
            return languageServer;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"lsp4jServer");
        return null;
    }

    public final void setLsp4jServer(@NotNull LanguageServer languageServer) {
        Intrinsics.checkNotNullParameter((Object)languageServer, (String)"<set-?>");
        this.lsp4jServer = languageServer;
    }

    @NotNull
    protected abstract OutputStream getIdeToServerStream();

    @NotNull
    protected abstract InputStream getServerToIdeStream();

    protected abstract void prepareConnect();

    protected abstract void startNotify();

    protected abstract boolean isConnectionAlive();

    protected abstract void disconnect();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresBackgroundThread
    @RequiresReadLockAbsence
    public final void connect$intellij_platform_lsp_impl(@NotNull Function1<? super InitializeResult, Unit> onSuccess2) {
        Intrinsics.checkNotNullParameter(onSuccess2, (String)"onSuccess");
        try {
            this.prepareConnect();
            MessageJsonHandler messageJsonHandler = this.V();
            RemoteEndpoint remoteEndpoint = new RemoteEndpoint((MessageConsumer)new StreamMessageConsumer(this.getIdeToServerStream(), messageJsonHandler), ServiceEndpoints.toEndpoint((Object)this.lsp4jClient));
            messageJsonHandler.setMethodProvider((MethodProvider)remoteEndpoint);
            Object object = ServiceEndpoints.toServiceObject((Endpoint)((Endpoint)remoteEndpoint), this.descriptor.getLsp4jServerClass());
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"toServiceObject(...)");
            this.setLsp4jServer((LanguageServer)object);
            ApplicationManager.getApplication().executeOnPooledThread(() -> Lsp4jServerConnector.W(this, messageJsonHandler, remoteEndpoint));
        }
        finally {
            this.startNotify();
        }
        this.V(onSuccess2);
    }

    @RequiresBackgroundThread
    @RequiresReadLockAbsence
    private final void V(Function1<? super InitializeResult, Unit> function1) {
        Lsp4jServerConnectorKt.access$getLogger$p().debug(this.descriptor + ": initializing LSP server");
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        this.getLsp4jServer().initialize(this.descriptor.createInitializeParams()).whenComplete((arg_0, arg_1) -> Lsp4jServerConnector.V((Function2)new Function2<InitializeResult, Throwable, Unit>(this, function1, (Ref.ObjectRef<Throwable>)objectRef, countDownLatch){
            final /* synthetic */ Lsp4jServerConnector this$0;
            final /* synthetic */ Function1<InitializeResult, Unit> $onSuccess;
            final /* synthetic */ Ref.ObjectRef<Throwable> $error;
            final /* synthetic */ CountDownLatch $countDownLatch;
            {
                this.this$0 = $receiver;
                this.$onSuccess = $onSuccess;
                this.$error = $error;
                this.$countDownLatch = $countDownLatch;
                super(2);
            }

            public final void invoke(@Nullable InitializeResult result, @Nullable Throwable th) {
                if (result != null) {
                    this.this$0.getLsp4jServer().initialized(new InitializedParams());
                    this.$onSuccess.invoke((Object)result);
                } else {
                    Throwable throwable = th;
                    if (throwable == null) {
                        throwable = new RuntimeException("No InitializeResult");
                    }
                    this.$error.element = throwable;
                }
                this.$countDownLatch.countDown();
            }
        }, arg_0, arg_1));
        boolean bl = countDownLatch.await(100L, TimeUnit.SECONDS);
        if (!bl) {
            throw new RuntimeException("'initialized' response not received from the server");
        }
        if (objectRef.element != null) {
            throw new RuntimeException("LSP server failed to initialize", (Throwable)objectRef.element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresBackgroundThread
    @RequiresReadLockAbsence
    public final void shutdownExitDisconnect$intellij_platform_lsp_impl() {
        try {
            if (this.lsp4jServer != null && this.isConnectionAlive()) {
                CompletableFuture completableFuture = this.getLsp4jServer().shutdown();
                completableFuture.get(10L, TimeUnit.SECONDS);
            }
        }
        catch (Exception exception) {
            Lsp4jServerConnectorKt.access$getLogger$p().warn(this.descriptor + ": `shutdown` request failed: " + exception);
        }
        finally {
            try {
                if (this.lsp4jServer != null && this.isConnectionAlive()) {
                    this.getLsp4jServer().exit();
                }
            }
            finally {
                this.disconnect();
            }
        }
    }

    private final MessageJsonHandler V() {
        Class<? extends LanguageServer> clazz = this.descriptor.getLsp4jServerClass();
        Map map = new LinkedHashMap(ServiceEndpoints.getSupportedMethods(clazz));
        Map map2 = ServiceEndpoints.getSupportedMethods(this.lsp4jClient.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getSupportedMethods(...)");
        map.putAll(map2);
        return new MessageJsonHandler(map, this){
            final /* synthetic */ Lsp4jServerConnector this$0;
            {
                this.this$0 = $receiver;
                super($supportedMethods);
            }

            @NotNull
            public String serialize(@NotNull Message message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                String string = super.serialize(message);
                Lsp4jServerConnectorKt.access$getLogger$p().debug("--> " + Lsp4jServerConnector.access$getDescriptor$p(this.this$0) + ": " + StringUtil.shortenTextWithEllipsis((String)string, (int)3000, (int)500));
                Intrinsics.checkNotNull((Object)string);
                return string;
            }

            @NotNull
            public Message parseMessage(@NotNull CharSequence input) throws JsonParseException {
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                Lsp4jServerConnectorKt.access$getLogger$p().debug("<-- " + Lsp4jServerConnector.access$getDescriptor$p(this.this$0) + ": " + StringUtil.shortenTextWithEllipsis((String)((Object)input).toString(), (int)3000, (int)500));
                Message message = super.parseMessage(input);
                Intrinsics.checkNotNullExpressionValue((Object)message, (String)"parseMessage(...)");
                return message;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void V(Lsp4jServerConnector lsp4jServerConnector, MessageJsonHandler messageJsonHandler, RemoteEndpoint remoteEndpoint) {
        Intrinsics.checkNotNullParameter((Object)lsp4jServerConnector, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)messageJsonHandler, (String)"$messageJsonHandler");
        Intrinsics.checkNotNullParameter((Object)remoteEndpoint, (String)"$remoteEndpoint");
        Lsp4jServerConnectorKt.access$getLogger$p().debug(lsp4jServerConnector.descriptor + ": LSP server listener thread started");
        try {
            Closeable closeable = (Closeable)new StreamMessageProducer(lsp4jServerConnector.getServerToIdeStream(), messageJsonHandler);
            Throwable throwable = null;
            try {
                StreamMessageProducer streamMessageProducer = (StreamMessageProducer)closeable;
                boolean bl = false;
                streamMessageProducer.listen((MessageConsumer)remoteEndpoint);
                streamMessageProducer = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Throwable throwable) {
            Lsp4jServerConnectorKt.access$getLogger$p().error(lsp4jServerConnector.descriptor.toString(), throwable);
        }
        Lsp4jServerConnectorKt.access$getLogger$p().debug(lsp4jServerConnector.descriptor + ": LSP server listener thread finished");
    }

    private static final void W(Lsp4jServerConnector lsp4jServerConnector, MessageJsonHandler messageJsonHandler, RemoteEndpoint remoteEndpoint) {
        Intrinsics.checkNotNullParameter((Object)lsp4jServerConnector, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)messageJsonHandler, (String)"$messageJsonHandler");
        Intrinsics.checkNotNullParameter((Object)remoteEndpoint, (String)"$remoteEndpoint");
        ConcurrencyUtil.runUnderThreadName((String)("LSP Listener: " + lsp4jServerConnector.descriptor), () -> Lsp4jServerConnector.V(lsp4jServerConnector, messageJsonHandler, remoteEndpoint));
    }

    private static final void V(Function2 function2, Object object, Object object2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"$tmp0");
        function2.invoke(object, object2);
    }

    public static final /* synthetic */ LspServerDescriptor access$getDescriptor$p(Lsp4jServerConnector $this) {
        return $this.descriptor;
    }
}

