/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.impl.TextRangeAndMarkupContent;
import com.intellij.platform.lsp.util.Lsp4jUtilKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.Range;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lcom/intellij/platform/lsp/impl/TextRangeAndMarkupContent;", "", "textRange", "Lcom/intellij/openapi/util/TextRange;", "markupContent", "Lorg/eclipse/lsp4j/MarkupContent;", "(Lcom/intellij/openapi/util/TextRange;Lorg/eclipse/lsp4j/MarkupContent;)V", "getMarkupContent", "()Lorg/eclipse/lsp4j/MarkupContent;", "getTextRange", "()Lcom/intellij/openapi/util/TextRange;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "intellij.platform.lsp.impl"})
public final class TextRangeAndMarkupContent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TextRange textRange;
    @NotNull
    private final MarkupContent markupContent;

    public TextRangeAndMarkupContent(@NotNull TextRange textRange, @NotNull MarkupContent markupContent) {
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
        Intrinsics.checkNotNullParameter((Object)markupContent, (String)"markupContent");
        this.textRange = textRange;
        this.markupContent = markupContent;
    }

    @NotNull
    public final TextRange getTextRange() {
        return this.textRange;
    }

    @NotNull
    public final MarkupContent getMarkupContent() {
        return this.markupContent;
    }

    @NotNull
    public final TextRange component1() {
        return this.textRange;
    }

    @NotNull
    public final MarkupContent component2() {
        return this.markupContent;
    }

    @NotNull
    public final TextRangeAndMarkupContent copy(@NotNull TextRange textRange, @NotNull MarkupContent markupContent) {
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
        Intrinsics.checkNotNullParameter((Object)markupContent, (String)"markupContent");
        return new TextRangeAndMarkupContent(textRange, markupContent);
    }

    public static /* synthetic */ TextRangeAndMarkupContent copy$default(TextRangeAndMarkupContent textRangeAndMarkupContent, TextRange textRange, MarkupContent markupContent, int n2, Object object) {
        if ((n2 & 1) != 0) {
            textRange = textRangeAndMarkupContent.textRange;
        }
        if ((n2 & 2) != 0) {
            markupContent = textRangeAndMarkupContent.markupContent;
        }
        return textRangeAndMarkupContent.copy(textRange, markupContent);
    }

    @NotNull
    public String toString() {
        return "TextRangeAndMarkupContent(textRange=" + this.textRange + ", markupContent=" + this.markupContent + ")";
    }

    public int hashCode() {
        int n2 = this.textRange.hashCode();
        n2 = n2 * 31 + this.markupContent.hashCode();
        return n2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TextRangeAndMarkupContent)) {
            return false;
        }
        TextRangeAndMarkupContent textRangeAndMarkupContent = (TextRangeAndMarkupContent)other;
        if (!Intrinsics.areEqual((Object)this.textRange, (Object)textRangeAndMarkupContent.textRange)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.markupContent, (Object)textRangeAndMarkupContent.markupContent);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/platform/lsp/impl/TextRangeAndMarkupContent$Companion;", "", "()V", "fromHover", "Lcom/intellij/platform/lsp/impl/TextRangeAndMarkupContent;", "hover", "Lorg/eclipse/lsp4j/Hover;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "offset", "", "fromHover$intellij_platform_lsp_impl", "intellij.platform.lsp.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TextRangeAndMarkupContent fromHover$intellij_platform_lsp_impl(@NotNull Hover hover2, @NotNull VirtualFile file2, int offset) {
            TextRange textRange;
            Intrinsics.checkNotNullParameter((Object)hover2, (String)"hover");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Document document = FileDocumentManager.getInstance().getDocument(file2);
            if (document != null && hover2.getRange() != null) {
                Range range = hover2.getRange();
                Intrinsics.checkNotNullExpressionValue((Object)range, (String)"getRange(...)");
                v1 = Lsp4jUtilKt.getRangeInDocument(document, range);
                if (v1 == null) {
                    v1 = new TextRange(offset, offset);
                }
            } else {
                v1 = textRange = new TextRange(offset, offset);
            }
            if (hover2.getContents().isRight()) {
                Object object = hover2.getContents().getRight();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getRight(...)");
                return new TextRangeAndMarkupContent(textRange, (MarkupContent)object);
            }
            Object object = hover2.getContents().getLeft();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getLeft(...)");
            String string = CollectionsKt.joinToString$default((Iterable)((Iterable)object), (CharSequence)"\n\n", null, null, (int)0, null, (Function1)fromHover.markup.1.INSTANCE, (int)30, null);
            return new TextRangeAndMarkupContent(textRange, new MarkupContent("markdown", string));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

