/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.api.LspServer;
import com.intellij.platform.lsp.api.LspServerDescriptor;
import com.intellij.platform.lsp.api.LspServerManager;
import com.intellij.platform.lsp.api.LspServerManagerListener;
import com.intellij.platform.lsp.api.LspServerState;
import com.intellij.platform.lsp.api.LspServerSupportProvider;
import com.intellij.platform.lsp.impl.LspServerImpl;
import com.intellij.platform.lsp.impl.LspServerManagerImpl;
import com.intellij.platform.lsp.impl.LspServerManagerImplKt;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.EventDispatcher;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\b\u0007\u0018\u0000 92\u00020\u00012\u00020\u0002:\u00029:B\u000f\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0019H\u0017J\b\u0010\u001a\u001a\u00020\u0015H\u0016J%\u0010\u001b\u001a\u00020\u00152\u000e\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0001\u00a2\u0006\u0002\b!J'\u0010\"\u001a\u0004\u0018\u00010\u00132\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00190$H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\b%J\u001e\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00130'2\u000e\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001e0\u001dH\u0016J\u001b\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00130'2\u0006\u0010)\u001a\u00020*H\u0000\u00a2\u0006\u0002\b+J\u001d\u0010,\u001a\u00020\u00152\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020*H\u0000\u00a2\u0006\u0002\b0J\r\u00101\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b2J\u0018\u00103\u001a\u00020\u00152\u000e\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001e0\u001dH\u0016J\u0018\u00104\u001a\u00020\u00152\u000e\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001e0\u001dH\u0016J\u001d\u00105\u001a\u00020\u00152\u0006\u0010-\u001a\u00020\u00132\u0006\u00106\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b7J\u0018\u00108\u001a\u00020\u00152\u000e\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001e0\u001dH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u000b\u001a\u0015\u0012\f\u0012\n \r*\u0004\u0018\u00010\n0\n0\f\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006;"}, d2={"Lcom/intellij/platform/lsp/impl/LspServerManagerImpl;", "Lcom/intellij/platform/lsp/api/LspServerManager;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "CLOSE_FILES_COALESCE_OBJECT", "", "START_SERVER_COALESCE_OBJECT", "eventBroadcaster", "Lcom/intellij/platform/lsp/api/LspServerManagerListener;", "eventDispatcher", "Lcom/intellij/util/EventDispatcher;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "highlightingQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "lspServers", "", "Lcom/intellij/platform/lsp/impl/LspServerImpl;", "addLspServerManagerListener", "", "listener", "parentDisposable", "sendEventsForExistingServers", "", "dispose", "ensureServerStarted", "providerClass", "Ljava/lang/Class;", "Lcom/intellij/platform/lsp/api/LspServerSupportProvider;", "descriptor", "Lcom/intellij/platform/lsp/api/LspServerDescriptor;", "ensureServerStarted$intellij_platform_lsp_impl", "findRunningServer", "condition", "Lkotlin/Function1;", "findRunningServer$intellij_platform_lsp_impl", "getServersForProvider", "", "getServersWithThisFileOpen", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getServersWithThisFileOpen$intellij_platform_lsp_impl", "onDiagnosticsReceived", "lspServer", "Lcom/intellij/platform/lsp/api/LspServer;", "virtualFile", "onDiagnosticsReceived$intellij_platform_lsp_impl", "scheduleClosingFilesThatAreNotOfInterest", "scheduleClosingFilesThatAreNotOfInterest$intellij_platform_lsp_impl", "startServersIfNeeded", "stopAndRestartIfNeeded", "stopServer", "shutdownNormally", "stopServer$intellij_platform_lsp_impl", "stopServers", "Companion", "LspServerStarterImpl", "intellij.platform.lsp.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nLspServerManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LspServerManagerImpl.kt\ncom/intellij/platform/lsp/impl/LspServerManagerImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 LspServerImpl.kt\ncom/intellij/platform/lsp/impl/LspServerImpl\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,280:1\n1#2:281\n766#3:282\n857#3,2:283\n766#3:285\n857#3,2:286\n1747#3,3:288\n1855#3,2:291\n1855#3,2:294\n1855#3,2:296\n1747#3,2:298\n1749#3:302\n1747#3,2:303\n1749#3:307\n91#4:293\n12474#5,2:300\n12474#5,2:305\n*S KotlinDebug\n*F\n+ 1 LspServerManagerImpl.kt\ncom/intellij/platform/lsp/impl/LspServerManagerImpl\n*L\n72#1:282\n72#1:283,2\n75#1:285\n75#1:286,2\n129#1:288,3\n147#1:291,2\n195#1:294,2\n252#1:296,2\n99#1:298,2\n99#1:302\n106#1:303,2\n106#1:307\n195#1:293\n100#1:300,2\n107#1:305,2\n*E\n"})
public final class LspServerManagerImpl
implements LspServerManager,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Collection<LspServerImpl> lspServers;
    @NotNull
    private final MergingUpdateQueue highlightingQueue;
    @NotNull
    private final EventDispatcher<LspServerManagerListener> eventDispatcher;
    @NotNull
    private final LspServerManagerListener eventBroadcaster;
    @NotNull
    private final Object START_SERVER_COALESCE_OBJECT;
    @NotNull
    private final Object CLOSE_FILES_COALESCE_OBJECT;

    public LspServerManagerImpl(@NotNull Project project) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        boolean bl2 = bl = !this.project.isDefault();
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "LspServerManager doesn't make sense for the default project";
            throw new AssertionError((Object)string);
        }
        ExtensionPointListener<LspServerSupportProvider> extensionPointListener2 = new ExtensionPointListener<LspServerSupportProvider>(this){
            final /* synthetic */ LspServerManagerImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public void extensionAdded(@NotNull LspServerSupportProvider extension, @NotNull PluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                this.this$0.startServersIfNeeded(extension.getClass());
            }

            public void extensionRemoved(@NotNull LspServerSupportProvider extension, @NotNull PluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                this.this$0.stopServers(extension.getClass());
            }
        };
        LspServerSupportProvider.Companion.getEP_NAME().getPoint().addExtensionPointListener((ExtensionPointListener)extensionPointListener2, false, (Disposable)this);
        List list = ContainerUtil.createLockFreeCopyOnWriteList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"createLockFreeCopyOnWriteList(...)");
        this.lspServers = list;
        this.highlightingQueue = new MergingUpdateQueue("LSP highlighting queue", 100, true, null, (Disposable)this, null, true);
        EventDispatcher eventDispatcher = EventDispatcher.create(LspServerManagerListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        this.eventDispatcher = eventDispatcher;
        this.eventBroadcaster = new LspServerManagerListener(this){
            final /* synthetic */ LspServerManagerImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public void serverStateChanged(@NotNull LspServer lspServer) {
                Intrinsics.checkNotNullParameter((Object)lspServer, (String)"lspServer");
                ((LspServerManagerListener)LspServerManagerImpl.access$getEventDispatcher$p(this.this$0).getMulticaster()).serverStateChanged(lspServer);
            }

            public void fileOpened(@NotNull LspServer lspServer, @NotNull VirtualFile file2) {
                Intrinsics.checkNotNullParameter((Object)lspServer, (String)"lspServer");
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                ((LspServerManagerListener)LspServerManagerImpl.access$getEventDispatcher$p(this.this$0).getMulticaster()).fileOpened(lspServer, file2);
            }

            public void diagnosticsReceived(@NotNull LspServer lspServer, @NotNull VirtualFile file2) {
                Intrinsics.checkNotNullParameter((Object)lspServer, (String)"lspServer");
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                ((LspServerManagerListener)LspServerManagerImpl.access$getEventDispatcher$p(this.this$0).getMulticaster()).diagnosticsReceived(lspServer, file2);
            }
        };
        this.START_SERVER_COALESCE_OBJECT = new Object();
        this.CLOSE_FILES_COALESCE_OBJECT = new Object();
    }

    @NotNull
    public Collection<LspServerImpl> getServersForProvider(@NotNull Class<? extends LspServerSupportProvider> providerClass) {
        Intrinsics.checkNotNullParameter(providerClass, (String)"providerClass");
        Iterable iterable = this.lspServers;
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList();
        boolean bl2 = false;
        for (Object t2 : iterable2) {
            LspServerImpl lspServerImpl = (LspServerImpl)t2;
            boolean bl3 = false;
            if (!Intrinsics.areEqual(lspServerImpl.getProviderClass(), providerClass)) continue;
            collection.add(t2);
        }
        return (List)collection;
    }

    @NotNull
    public final Collection<LspServerImpl> getServersWithThisFileOpen$intellij_platform_lsp_impl(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Iterable iterable = this.lspServers;
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList();
        boolean bl2 = false;
        for (Object t2 : iterable2) {
            LspServerImpl lspServerImpl = (LspServerImpl)t2;
            boolean bl3 = false;
            if (!lspServerImpl.isFileOpened$intellij_platform_lsp_impl(file2)) continue;
            collection.add(t2);
        }
        return (List)collection;
    }

    @Nullable
    public final LspServerImpl findRunningServer$intellij_platform_lsp_impl(@NotNull Function1<? super LspServerImpl, Boolean> condition) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(condition, (String)"condition");
            boolean bl = false;
            Iterable iterable = this.lspServers;
            for (Object t2 : iterable) {
                LspServerImpl lspServerImpl = (LspServerImpl)t2;
                boolean bl2 = false;
                if (!(lspServerImpl.getState() == LspServerState.Running && (Boolean)condition.invoke((Object)lspServerImpl) != false)) continue;
                v0 = t2;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Override
    public void startServersIfNeeded(@NotNull Class<? extends LspServerSupportProvider> providerClass) {
        Intrinsics.checkNotNullParameter(providerClass, (String)"providerClass");
        LspServerSupportProvider lspServerSupportProvider = (LspServerSupportProvider)LspServerSupportProvider.Companion.getEP_NAME().findExtension(providerClass);
        if (lspServerSupportProvider == null) {
            LspServerManagerImplKt.access$getLogger$p().error(providerClass.getName() + " is not loaded");
            return;
        }
        Object[] objectArray = new Object[]{providerClass, this.START_SERVER_COALESCE_OBJECT};
        ReadAction.nonBlocking(() -> LspServerManagerImpl.V(this, providerClass, lspServerSupportProvider)).expireWith((Disposable)this).coalesceBy(objectArray).finishOnUiThread(ModalityState.nonModal(), arg_0 -> LspServerManagerImpl.W((Function1)new Function1<List<? extends LspServerDescriptor>, Unit>(this, providerClass){
            final /* synthetic */ LspServerManagerImpl this$0;
            final /* synthetic */ Class<? extends LspServerSupportProvider> $providerClass;
            {
                this.this$0 = $receiver;
                this.$providerClass = $providerClass;
                super(1);
            }

            public final void invoke(@NotNull List<? extends LspServerDescriptor> descriptorsToStart) {
                Intrinsics.checkNotNullParameter(descriptorsToStart, (String)"descriptorsToStart");
                Iterable iterable = descriptorsToStart;
                LspServerManagerImpl lspServerManagerImpl = this.this$0;
                Class<? extends LspServerSupportProvider> clazz = this.$providerClass;
                boolean bl = false;
                for (T t2 : iterable) {
                    LspServerDescriptor lspServerDescriptor = (LspServerDescriptor)t2;
                    boolean bl2 = false;
                    lspServerManagerImpl.ensureServerStarted$intellij_platform_lsp_impl(clazz, lspServerDescriptor);
                }
            }
        }, arg_0)).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    @RequiresEdt
    public final void ensureServerStarted$intellij_platform_lsp_impl(@NotNull Class<? extends LspServerSupportProvider> providerClass, @NotNull LspServerDescriptor descriptor) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter(providerClass, (String)"providerClass");
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            Iterable iterable = this.lspServers;
            boolean bl2 = false;
            if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                bl = false;
            } else {
                for (Object t2 : iterable) {
                    LspServerImpl lspServerImpl = (LspServerImpl)t2;
                    boolean bl3 = false;
                    boolean bl4 = Intrinsics.areEqual(lspServerImpl.getProviderClass(), providerClass) && Arrays.equals(lspServerImpl.getDescriptor().getRoots(), descriptor.getRoots());
                    if (!bl4) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        if (this.lspServers.size() >= 10) {
            LspServerManagerImplKt.access$getLogger$p().error(this.lspServers.size() + " LSP servers are already running and one more wants to start.To save system resources, this request will be ignored: " + descriptor);
            return;
        }
        WriteAction.run(() -> LspServerManagerImpl.V(providerClass, descriptor, this));
    }

    @Override
    public void stopServers(@NotNull Class<? extends LspServerSupportProvider> providerClass) {
        Intrinsics.checkNotNullParameter(providerClass, (String)"providerClass");
        Iterable iterable = this.getServersForProvider(providerClass);
        boolean bl = false;
        for (Object t2 : iterable) {
            LspServerImpl lspServerImpl = (LspServerImpl)t2;
            boolean bl2 = false;
            this.stopServer$intellij_platform_lsp_impl(lspServerImpl, true);
        }
    }

    public final void stopServer$intellij_platform_lsp_impl(@NotNull LspServerImpl lspServer, boolean shutdownNormally) {
        Intrinsics.checkNotNullParameter((Object)lspServer, (String)"lspServer");
        LspServerState[] lspServerStateArray = new LspServerState[]{LspServerState.Initializing, LspServerState.Running};
        if (ArraysKt.contains((Object[])lspServerStateArray, (Object)((Object)lspServer.getState())) && !this.lspServers.contains(lspServer)) {
            LspServerManagerImplKt.access$getLogger$p().error("LspServerManager doesn't know the server that it is asked to stop: " + lspServer);
        }
        if (shutdownNormally) {
            this.lspServers.remove(lspServer);
        }
        if (ArraysKt.contains((Object[])(lspServerStateArray = new LspServerState[]{LspServerState.ShutdownNormally, LspServerState.ShutdownUnexpectedly}), (Object)((Object)lspServer.getState()))) {
            return;
        }
        if (lspServer.getState() == LspServerState.Running) {
            this.highlightingQueue.queue(Update.create((Object)this, () -> LspServerManagerImpl.V(this)));
        }
        lspServer.cleanupShutdownAndExit$intellij_platform_lsp_impl(shutdownNormally);
    }

    @Override
    public void stopAndRestartIfNeeded(@NotNull Class<? extends LspServerSupportProvider> providerClass) {
        Intrinsics.checkNotNullParameter(providerClass, (String)"providerClass");
        this.stopServers(providerClass);
        this.startServersIfNeeded(providerClass);
    }

    @Override
    @ApiStatus.Internal
    public void addLspServerManagerListener(@NotNull LspServerManagerListener listener2, @NotNull Disposable parentDisposable, boolean sendEventsForExistingServers) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.eventDispatcher.addListener((EventListener)listener2, parentDisposable);
        if (sendEventsForExistingServers) {
            for (LspServerImpl lspServerImpl : this.lspServers) {
                if (lspServerImpl.getState() == LspServerState.ShutdownUnexpectedly) {
                    ((LspServerManagerListener)this.eventDispatcher.getMulticaster()).serverStateChanged(lspServerImpl);
                }
                LspServerImpl lspServerImpl2 = lspServerImpl;
                boolean bl = false;
                Iterable iterable = LspServerImpl.access$getOpenedFiles$p(lspServerImpl2);
                boolean bl2 = false;
                for (Object t2 : iterable) {
                    VirtualFile virtualFile = (VirtualFile)t2;
                    boolean bl3 = false;
                    ((LspServerManagerListener)this.eventDispatcher.getMulticaster()).fileOpened(lspServerImpl, virtualFile);
                }
            }
        }
    }

    public final void onDiagnosticsReceived$intellij_platform_lsp_impl(@NotNull LspServer lspServer, @NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)lspServer, (String)"lspServer");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        ReadAction.run(() -> LspServerManagerImpl.W(this, virtualFile, lspServer));
    }

    public final void scheduleClosingFilesThatAreNotOfInterest$intellij_platform_lsp_impl() {
        if (this.lspServers.isEmpty()) {
            return;
        }
        Object[] objectArray = new Object[]{this.CLOSE_FILES_COALESCE_OBJECT};
        ReadAction.nonBlocking(() -> LspServerManagerImpl.V(this)).expireWith((Disposable)this).coalesceBy(objectArray).finishOnUiThread(ModalityState.nonModal(), arg_0 -> LspServerManagerImpl.V(scheduleClosingFilesThatAreNotOfInterest.2.INSTANCE, arg_0)).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    public void dispose() {
        Iterable iterable = this.lspServers;
        boolean bl = false;
        for (Object t2 : iterable) {
            LspServerImpl lspServerImpl = (LspServerImpl)t2;
            boolean bl2 = false;
            this.stopServer$intellij_platform_lsp_impl(lspServerImpl, true);
        }
    }

    private static final List V(LspServerManagerImpl lspServerManagerImpl, Class clazz, LspServerSupportProvider lspServerSupportProvider) {
        Intrinsics.checkNotNullParameter((Object)lspServerManagerImpl, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"$providerClass");
        Collection<LspServerImpl> collection = lspServerManagerImpl.getServersForProvider(clazz);
        List list = new ArrayList();
        VirtualFile[] virtualFileArray = FileEditorManager.getInstance((Project)lspServerManagerImpl.project).getOpenFiles();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getOpenFiles(...)");
        for (VirtualFile virtualFile : virtualFileArray) {
            boolean bl;
            Object object;
            block12: {
                boolean bl2;
                VirtualFile virtualFile2;
                VirtualFile virtualFile3;
                int n2;
                int n3;
                boolean bl3;
                VirtualFile[] virtualFileArray2;
                boolean bl4;
                Object object2;
                Object t2;
                Iterator iterator;
                boolean bl5;
                boolean bl6;
                block10: {
                    ProgressManager.checkCanceled();
                    if (!virtualFile.isInLocalFileSystem() || !ProjectFileIndex.getInstance((Project)lspServerManagerImpl.project).isInContent(virtualFile)) continue;
                    object = collection;
                    bl6 = false;
                    if (object instanceof Collection && ((Collection)object).isEmpty()) {
                        bl5 = false;
                    } else {
                        iterator = object.iterator();
                        while (iterator.hasNext()) {
                            boolean bl7;
                            block9: {
                                t2 = iterator.next();
                                object2 = (LspServerImpl)t2;
                                bl4 = false;
                                virtualFileArray2 = ((LspServerImpl)object2).getDescriptor().getRoots();
                                bl3 = false;
                                n3 = virtualFileArray2.length;
                                for (n2 = 0; n2 < n3; ++n2) {
                                    virtualFile2 = virtualFile3 = virtualFileArray2[n2];
                                    bl2 = false;
                                    if (!VfsUtilCore.isAncestor((VirtualFile)virtualFile2, (VirtualFile)virtualFile, (boolean)true)) continue;
                                    bl7 = true;
                                    break block9;
                                }
                                bl7 = false;
                            }
                            if (!bl7) continue;
                            bl5 = true;
                            break block10;
                        }
                        bl5 = false;
                    }
                }
                if (bl5) continue;
                object = list;
                bl6 = false;
                if (object instanceof Collection && ((Collection)object).isEmpty()) {
                    bl = false;
                } else {
                    iterator = object.iterator();
                    while (iterator.hasNext()) {
                        boolean bl8;
                        block11: {
                            t2 = iterator.next();
                            object2 = (LspServerDescriptor)t2;
                            bl4 = false;
                            virtualFileArray2 = ((LspServerDescriptor)object2).getRoots();
                            bl3 = false;
                            n3 = virtualFileArray2.length;
                            for (n2 = 0; n2 < n3; ++n2) {
                                virtualFile2 = virtualFile3 = virtualFileArray2[n2];
                                bl2 = false;
                                if (!VfsUtilCore.isAncestor((VirtualFile)virtualFile2, (VirtualFile)virtualFile, (boolean)true)) continue;
                                bl8 = true;
                                break block11;
                            }
                            bl8 = false;
                        }
                        if (!bl8) continue;
                        bl = true;
                        break block12;
                    }
                    bl = false;
                }
            }
            if (bl) continue;
            object = new LspServerStarterImpl();
            Project project = lspServerManagerImpl.project;
            Intrinsics.checkNotNull((Object)virtualFile);
            lspServerSupportProvider.fileOpened(project, virtualFile, (LspServerSupportProvider.LspServerStarter)object);
            UtilKt.addIfNotNull((List)list, (Object)((LspServerStarterImpl)object).getDescriptor());
        }
        return list;
    }

    private static final void W(Function1 function1, Object object) {
        Intrinsics.checkNotNullParameter((Object)function1, (String)"$tmp0");
        function1.invoke(object);
    }

    private static final void V(Class clazz, LspServerDescriptor lspServerDescriptor, LspServerManagerImpl lspServerManagerImpl) {
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"$providerClass");
        Intrinsics.checkNotNullParameter((Object)lspServerDescriptor, (String)"$descriptor");
        Intrinsics.checkNotNullParameter((Object)lspServerManagerImpl, (String)"this$0");
        LspServerImpl lspServerImpl = new LspServerImpl(clazz, lspServerDescriptor, lspServerManagerImpl.eventBroadcaster);
        lspServerImpl.start$intellij_platform_lsp_impl();
        lspServerManagerImpl.lspServers.add(lspServerImpl);
    }

    private static final void V(LspServerManagerImpl lspServerManagerImpl) {
        Intrinsics.checkNotNullParameter((Object)lspServerManagerImpl, (String)"this$0");
        DaemonCodeAnalyzer.getInstance((Project)lspServerManagerImpl.project).restart();
    }

    private static final void V(LspServerManagerImpl lspServerManagerImpl, VirtualFile virtualFile, LspServer lspServer) {
        Intrinsics.checkNotNullParameter((Object)lspServerManagerImpl, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"$virtualFile");
        Intrinsics.checkNotNullParameter((Object)lspServer, (String)"$lspServer");
        if (!FileEditorManager.getInstance((Project)lspServerManagerImpl.project).isFileOpen(virtualFile)) {
            return;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)lspServerManagerImpl.project).findFile(virtualFile);
        if (psiFile == null) {
            return;
        }
        PsiFile psiFile2 = psiFile;
        DaemonCodeAnalyzer.getInstance((Project)lspServerManagerImpl.project).restart(psiFile2);
        lspServerManagerImpl.eventBroadcaster.diagnosticsReceived(lspServer, virtualFile);
    }

    private static final void W(LspServerManagerImpl lspServerManagerImpl, VirtualFile virtualFile, LspServer lspServer) {
        Intrinsics.checkNotNullParameter((Object)lspServerManagerImpl, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"$virtualFile");
        Intrinsics.checkNotNullParameter((Object)lspServer, (String)"$lspServer");
        if (lspServerManagerImpl.project.isDisposed()) {
            return;
        }
        if (!FileEditorManager.getInstance((Project)lspServerManagerImpl.project).isFileOpen(virtualFile)) {
            return;
        }
        if (PsiManager.getInstance((Project)lspServerManagerImpl.project).findFile(virtualFile) == null) {
            LspServerManagerImplKt.access$getLogger$p().debug("Unable to find a PsiFile for " + virtualFile);
            return;
        }
        lspServerManagerImpl.highlightingQueue.queue(Update.create((Object)virtualFile, () -> LspServerManagerImpl.V(lspServerManagerImpl, virtualFile, lspServer)));
    }

    private static final MultiMap V(LspServerManagerImpl lspServerManagerImpl) {
        Intrinsics.checkNotNullParameter((Object)lspServerManagerImpl, (String)"this$0");
        MultiMap multiMap = new MultiMap();
        for (LspServerImpl lspServerImpl : lspServerManagerImpl.lspServers) {
            Collection<VirtualFile> collection = lspServerImpl.getFilesToClose$intellij_platform_lsp_impl();
            if (collection.isEmpty()) continue;
            multiMap.put((Object)lspServerImpl, collection);
        }
        return multiMap;
    }

    private static final void V(Function1 function1, Object object) {
        Intrinsics.checkNotNullParameter((Object)function1, (String)"$tmp0");
        function1.invoke(object);
    }

    public static final /* synthetic */ EventDispatcher access$getEventDispatcher$p(LspServerManagerImpl $this) {
        return $this.eventDispatcher;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u0006H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\b\bJ\u0015\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\rJ\r\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0011"}, d2={"Lcom/intellij/platform/lsp/impl/LspServerManagerImpl$Companion;", "", "()V", "forEachRunningServerInEachProject", "", "action", "Lkotlin/Function1;", "Lcom/intellij/platform/lsp/impl/LspServerImpl;", "forEachRunningServerInEachProject$intellij_platform_lsp_impl", "getInstanceImpl", "Lcom/intellij/platform/lsp/impl/LspServerManagerImpl;", "project", "Lcom/intellij/openapi/project/Project;", "getInstanceImpl$intellij_platform_lsp_impl", "isAnyServerRunning", "", "isAnyServerRunning$intellij_platform_lsp_impl", "intellij.platform.lsp.impl"})
    @SourceDebugExtension(value={"SMAP\nLspServerManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LspServerManagerImpl.kt\ncom/intellij/platform/lsp/impl/LspServerManagerImpl$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,280:1\n13309#2:281\n13310#2:284\n12474#2:285\n12475#2:289\n1855#3,2:282\n1747#3,3:286\n*S KotlinDebug\n*F\n+ 1 LspServerManagerImpl.kt\ncom/intellij/platform/lsp/impl/LspServerManagerImpl$Companion\n*L\n268#1:281\n268#1:284\n275#1:285\n275#1:289\n269#1:282,2\n276#1:286,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LspServerManagerImpl getInstanceImpl$intellij_platform_lsp_impl(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            LspServerManager lspServerManager = LspServerManager.Companion.getInstance(project);
            Intrinsics.checkNotNull((Object)lspServerManager, (String)"null cannot be cast to non-null type com.intellij.platform.lsp.impl.LspServerManagerImpl");
            return (LspServerManagerImpl)lspServerManager;
        }

        public final void forEachRunningServerInEachProject$intellij_platform_lsp_impl(@NotNull Function1<? super LspServerImpl, Unit> action) {
            Intrinsics.checkNotNullParameter(action, (String)"action");
            boolean bl = false;
            Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
            Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
            Object[] objectArray = projectArray;
            boolean bl2 = false;
            for (Object object : objectArray) {
                Project project = (Project)object;
                boolean bl3 = false;
                Intrinsics.checkNotNull((Object)project);
                Iterable iterable = Companion.getInstanceImpl$intellij_platform_lsp_impl(project).lspServers;
                boolean bl4 = false;
                for (Object t2 : iterable) {
                    LspServerImpl lspServerImpl = (LspServerImpl)t2;
                    boolean bl5 = false;
                    if (lspServerImpl.getState() != LspServerState.Running) continue;
                    action.invoke((Object)lspServerImpl);
                }
            }
        }

        public final boolean isAnyServerRunning$intellij_platform_lsp_impl() {
            boolean bl;
            block5: {
                Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
                Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
                Object[] objectArray = projectArray;
                boolean bl2 = false;
                for (Object object : objectArray) {
                    boolean bl3;
                    block4: {
                        Project project = (Project)object;
                        boolean bl4 = false;
                        Intrinsics.checkNotNull((Object)project);
                        Iterable iterable = Companion.getInstanceImpl$intellij_platform_lsp_impl(project).lspServers;
                        boolean bl5 = false;
                        if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                            bl3 = false;
                        } else {
                            for (Object t2 : iterable) {
                                LspServerImpl lspServerImpl = (LspServerImpl)t2;
                                boolean bl6 = false;
                                if (!(lspServerImpl.getState() == LspServerState.Running)) continue;
                                bl3 = true;
                                break block4;
                            }
                            bl3 = false;
                        }
                    }
                    if (!bl3) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
            return bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u0004H\u0016R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/intellij/platform/lsp/impl/LspServerManagerImpl$LspServerStarterImpl;", "Lcom/intellij/platform/lsp/api/LspServerSupportProvider$LspServerStarter;", "()V", "descriptor", "Lcom/intellij/platform/lsp/api/LspServerDescriptor;", "getDescriptor", "()Lcom/intellij/platform/lsp/api/LspServerDescriptor;", "setDescriptor", "(Lcom/intellij/platform/lsp/api/LspServerDescriptor;)V", "ensureServerStarted", "", "intellij.platform.lsp.impl"})
    public static final class LspServerStarterImpl
    implements LspServerSupportProvider.LspServerStarter {
        @Nullable
        private LspServerDescriptor descriptor;

        @Nullable
        public final LspServerDescriptor getDescriptor() {
            return this.descriptor;
        }

        public final void setDescriptor(@Nullable LspServerDescriptor lspServerDescriptor) {
            this.descriptor = lspServerDescriptor;
        }

        @Override
        public void ensureServerStarted(@NotNull LspServerDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            this.descriptor = descriptor;
        }
    }
}

