/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.api.LspServerDescriptor;
import com.intellij.platform.lsp.api.LspServerState;
import com.intellij.platform.lsp.api.LspServerSupportProvider;
import com.intellij.platform.lsp.impl.LspFileEditorManagerListener;
import com.intellij.platform.lsp.impl.LspServerImpl;
import com.intellij.platform.lsp.impl.LspServerManagerImpl;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0016J\u0018\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0016J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/platform/lsp/impl/LspFileEditorManagerListener;", "Lcom/intellij/openapi/fileEditor/FileEditorManagerListener;", "()V", "openedFilesToHandle", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileClosed", "", "fileEditorManager", "Lcom/intellij/openapi/fileEditor/FileEditorManager;", "file", "fileOpened", "V", "project", "Lcom/intellij/openapi/project/Project;", "OpenedFilesData", "intellij.platform.lsp.impl"})
@SourceDebugExtension(value={"SMAP\nLspFileEditorManagerListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LspFileEditorManagerListener.kt\ncom/intellij/platform/lsp/impl/LspFileEditorManagerListener\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,108:1\n12474#2,2:109\n1#3:111\n1855#4,2:112\n*S KotlinDebug\n*F\n+ 1 LspFileEditorManagerListener.kt\ncom/intellij/platform/lsp/impl/LspFileEditorManagerListener\n*L\n56#1:109,2\n104#1:112,2\n*E\n"})
public final class LspFileEditorManagerListener
implements FileEditorManagerListener {
    @NotNull
    private final Set<VirtualFile> openedFilesToHandle;

    public LspFileEditorManagerListener() {
        Set set = Collections.synchronizedSet(new HashSet());
        Intrinsics.checkNotNullExpressionValue(set, (String)"synchronizedSet(...)");
        this.openedFilesToHandle = set;
    }

    public void fileOpened(@NotNull FileEditorManager fileEditorManager, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)fileEditorManager, (String)"fileEditorManager");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (fileEditorManager.getProject().isDefault()) {
            return;
        }
        if (!file2.isInLocalFileSystem()) {
            return;
        }
        if (!LspServerSupportProvider.Companion.getEP_NAME().hasAnyExtensions()) {
            return;
        }
        this.openedFilesToHandle.add(file2);
        Project project = fileEditorManager.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.V(project);
    }

    private final void V(Project project) {
        LspServerManagerImpl lspServerManagerImpl = LspServerManagerImpl.Companion.getInstanceImpl$intellij_platform_lsp_impl(project);
        Object[] objectArray = new Object[]{project, this};
        ReadAction.nonBlocking(() -> LspFileEditorManagerListener.V(this, lspServerManagerImpl, project)).coalesceBy(objectArray).expireWith((Disposable)lspServerManagerImpl).finishOnUiThread(ModalityState.nonModal(), arg_0 -> LspFileEditorManagerListener.V((Function1)new Function1<OpenedFilesData, Unit>(this, lspServerManagerImpl){
            final /* synthetic */ LspFileEditorManagerListener this$0;
            final /* synthetic */ LspServerManagerImpl $lspServerManager;
            {
                this.this$0 = $receiver;
                this.$lspServerManager = $lspServerManager;
                super(1);
            }

            public final void invoke(@NotNull OpenedFilesData data) {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                LspFileEditorManagerListener.access$getOpenedFilesToHandle$p(this.this$0).removeAll((Collection)data.getHandledFiles());
                if (!data.getServersToSendDidOpen().isEmpty()) {
                    WriteAction.run(() -> scheduleOpenedFilesProcessing.2.V(data));
                }
                Iterable iterable = data.getNewServersToStart();
                LspServerManagerImpl lspServerManagerImpl = this.$lspServerManager;
                boolean bl = false;
                for (T t2 : iterable) {
                    Pair pair = (Pair)t2;
                    boolean bl2 = false;
                    lspServerManagerImpl.ensureServerStarted$intellij_platform_lsp_impl(pair.getFirst().getClass(), (LspServerDescriptor)pair.getSecond());
                }
            }

            private static final void V(OpenedFilesData openedFilesData) {
                Intrinsics.checkNotNullParameter((Object)openedFilesData, (String)"$data");
                for (Map.Entry entry : openedFilesData.getServersToSendDidOpen().entrySet()) {
                    Intrinsics.checkNotNull((Object)entry);
                    LspServerImpl lspServerImpl = (LspServerImpl)entry.getKey();
                    Collection collection = (Collection)entry.getValue();
                    for (VirtualFile virtualFile : collection) {
                        Intrinsics.checkNotNull((Object)virtualFile);
                        lspServerImpl.sendDidOpenRequest$intellij_platform_lsp_impl(virtualFile);
                    }
                }
            }
        }, arg_0)).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    public void fileClosed(@NotNull FileEditorManager fileEditorManager, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)fileEditorManager, (String)"fileEditorManager");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (!file2.isInLocalFileSystem()) {
            return;
        }
        if (fileEditorManager.isFileOpen(file2)) {
            return;
        }
        Document document = FileDocumentManager.getInstance().getCachedDocument(file2);
        if (document == null) {
            return;
        }
        Document document2 = document;
        if (FileDocumentManager.getInstance().isDocumentUnsaved(document2)) {
            return;
        }
        Project project = fileEditorManager.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Collection<LspServerImpl> collection = LspServerManagerImpl.Companion.getInstanceImpl$intellij_platform_lsp_impl(project).getServersWithThisFileOpen$intellij_platform_lsp_impl(file2);
        if (!collection.isEmpty()) {
            WriteAction.run(() -> LspFileEditorManagerListener.V(collection, file2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final OpenedFilesData V(LspFileEditorManagerListener lspFileEditorManagerListener, LspServerManagerImpl lspServerManagerImpl, Project project) {
        Intrinsics.checkNotNullParameter((Object)lspFileEditorManagerListener, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)lspServerManagerImpl, (String)"$lspServerManager");
        Intrinsics.checkNotNullParameter((Object)project, (String)"$project");
        OpenedFilesData openedFilesData = new OpenedFilesData();
        Object object2 = lspFileEditorManagerListener.openedFilesToHandle;
        synchronized (object2) {
            boolean bl = false;
            bl = openedFilesData.getHandledFiles().addAll((Collection<VirtualFile>)lspFileEditorManagerListener.openedFilesToHandle);
        }
        for (Object object2 : LspServerSupportProvider.Companion.getEP_NAME().getExtensionList()) {
            Collection<LspServerImpl> collection = lspServerManagerImpl.getServersForProvider(object2.getClass());
            boolean bl = false;
            for (VirtualFile virtualFile : openedFilesData.getHandledFiles()) {
                LspServerDescriptor lspServerDescriptor;
                int n2;
                for (LspServerImpl lspServerImpl : collection) {
                    boolean bl2;
                    block8: {
                        ProgressManager.checkCanceled();
                        VirtualFile[] virtualFileArray = lspServerImpl.getDescriptor().getRoots();
                        boolean bl3 = false;
                        int n3 = virtualFileArray.length;
                        for (n2 = 0; n2 < n3; ++n2) {
                            VirtualFile virtualFile2;
                            VirtualFile virtualFile3 = virtualFile2 = virtualFileArray[n2];
                            boolean bl4 = false;
                            if (!VfsUtilCore.isAncestor((VirtualFile)virtualFile3, (VirtualFile)virtualFile, (boolean)true)) continue;
                            bl2 = true;
                            break block8;
                        }
                        bl2 = false;
                    }
                    if (bl2) {
                        bl = true;
                    }
                    if (lspServerImpl.getState() != LspServerState.Running || lspServerImpl.isFileOpened$intellij_platform_lsp_impl(virtualFile) || !lspServerImpl.isSupportedFile$intellij_platform_lsp_impl(virtualFile)) continue;
                    openedFilesData.getServersToSendDidOpen().putValue((Object)lspServerImpl, (Object)virtualFile);
                }
                if (bl || !ProjectFileIndex.getInstance((Project)project).isInContent(virtualFile)) continue;
                LspServerManagerImpl.LspServerStarterImpl lspServerStarterImpl = new LspServerManagerImpl.LspServerStarterImpl();
                object2.fileOpened(project, virtualFile, lspServerStarterImpl);
                if (lspServerStarterImpl.getDescriptor() == null) continue;
                n2 = 0;
                openedFilesData.getNewServersToStart().add((Pair<LspServerSupportProvider, LspServerDescriptor>)TuplesKt.to((Object)object2, (Object)lspServerDescriptor));
            }
        }
        return openedFilesData;
    }

    private static final void V(Function1 function1, Object object) {
        Intrinsics.checkNotNullParameter((Object)function1, (String)"$tmp0");
        function1.invoke(object);
    }

    private static final void V(Collection collection, VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)collection, (String)"$serversToSendDidClose");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"$file");
        Iterable iterable = collection;
        boolean bl = false;
        for (Object t2 : iterable) {
            LspServerImpl lspServerImpl = (LspServerImpl)t2;
            boolean bl2 = false;
            lspServerImpl.sendDidCloseRequest$intellij_platform_lsp_impl(virtualFile);
        }
    }

    public static final /* synthetic */ Set access$getOpenedFilesToHandle$p(LspFileEditorManagerListener $this) {
        return $this.openedFilesToHandle;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R#\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001d\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00050\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/intellij/platform/lsp/impl/LspFileEditorManagerListener$OpenedFilesData;", "", "()V", "handledFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getHandledFiles", "()Ljava/util/Set;", "newServersToStart", "", "Lkotlin/Pair;", "Lcom/intellij/platform/lsp/api/LspServerSupportProvider;", "Lcom/intellij/platform/lsp/api/LspServerDescriptor;", "getNewServersToStart", "()Ljava/util/Collection;", "serversToSendDidOpen", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/platform/lsp/impl/LspServerImpl;", "getServersToSendDidOpen", "()Lcom/intellij/util/containers/MultiMap;", "intellij.platform.lsp.impl"})
    private static final class OpenedFilesData {
        @NotNull
        private final Set<VirtualFile> handledFiles = new HashSet();
        @NotNull
        private final MultiMap<LspServerImpl, VirtualFile> serversToSendDidOpen = new MultiMap();
        @NotNull
        private final Collection<Pair<LspServerSupportProvider, LspServerDescriptor>> newServersToStart = new ArrayList();

        @NotNull
        public final Set<VirtualFile> getHandledFiles() {
            return this.handledFiles;
        }

        @NotNull
        public final MultiMap<LspServerImpl, VirtualFile> getServersToSendDidOpen() {
            return this.serversToSendDidOpen;
        }

        @NotNull
        public final Collection<Pair<LspServerSupportProvider, LspServerDescriptor>> getNewServersToStart() {
            return this.newServersToStart;
        }
    }
}

