/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.api.customization;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.api.LspServer;
import com.intellij.platform.lsp.api.customization.LspCommandsSupport;
import com.intellij.platform.lsp.util.Lsp4jUtilKt;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.PathUtil;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionDisabled;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.CreateFile;
import org.eclipse.lsp4j.DeleteFile;
import org.eclipse.lsp4j.RenameFile;
import org.eclipse.lsp4j.ResourceOperation;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\f\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J&\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J$\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001b2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fH\u0015J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J \u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J\u001c\u0010&\u001a\u0004\u0018\u00010\u000e2\u0006\u0010'\u001a\u00020\r2\b\b\u0002\u0010(\u001a\u00020)H\u0002J\u0006\u0010*\u001a\u00020\rJ\b\u0010+\u001a\u00020\rH\u0016J\u001e\u0010,\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e\u0018\u00010\f2\u0006\u0010-\u001a\u00020\u001bH\u0002J!\u0010.\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010/\u001a\u00020%H\u0096\u0002J\u0010\u0010.\u001a\u00020\u00122\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018J\u0018\u00100\u001a\u00020\u00122\u0006\u00101\u001a\u00020\u000e2\u0006\u00102\u001a\u00020\u000eH\u0002J\u0006\u00103\u001a\u00020\u0010J \u00103\u001a\u00020\u00102\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010/\u001a\u00020%H\u0016J\u0006\u00104\u001a\u00020\u0010R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/intellij/platform/lsp/api/customization/LspIntentionAction;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "lspServer", "Lcom/intellij/platform/lsp/api/LspServer;", "codeAction", "Lorg/eclipse/lsp4j/CodeAction;", "(Lcom/intellij/platform/lsp/api/LspServer;Lorg/eclipse/lsp4j/CodeAction;)V", "getCodeAction", "()Lorg/eclipse/lsp4j/CodeAction;", "getLspServer", "()Lcom/intellij/platform/lsp/api/LspServer;", "uriToDocumentMap", "", "", "Lcom/intellij/openapi/editor/Document;", "uriToDocumentMapInitialized", "", "V", "", "commandsSupport", "Lcom/intellij/platform/lsp/api/customization/LspCommandsSupport;", "command", "Lorg/eclipse/lsp4j/Command;", "contextFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "applyWorkspaceEdit", "workspaceEdit", "Lorg/eclipse/lsp4j/WorkspaceEdit;", "V", "Lorg/eclipse/lsp4j/CreateFile;", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "nonPhysicalFile", "Lcom/intellij/psi/PsiFile;", "V", "documentUri", "version", "", "getFamilyName", "getText", "V", "edit", "invoke", "psiFile", "V", "nonPhysicalDocument", "physicalDocument", "isAvailable", "startInWriteAction", "intellij.platform.lsp"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nLspIntentionAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LspIntentionAction.kt\ncom/intellij/platform/lsp/api/customization/LspIntentionAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,247:1\n1#2:248\n125#3:249\n152#3,3:250\n1855#4,2:253\n1747#4,3:255\n1855#4:258\n1856#4:260\n1855#4,2:264\n1855#4,2:266\n1855#4,2:272\n1855#4,2:274\n9#5:259\n9#5:261\n9#5:262\n9#5:263\n9#5:268\n9#5:269\n9#5:270\n9#5:271\n*S KotlinDebug\n*F\n+ 1 LspIntentionAction.kt\ncom/intellij/platform/lsp/api/customization/LspIntentionAction\n*L\n70#1:249\n70#1:250,3\n90#1:253,2\n99#1:255,3\n104#1:258\n104#1:260\n162#1:264,2\n171#1:266,2\n231#1:272,2\n238#1:274,2\n108#1:259\n135#1:261\n149#1:262\n155#1:263\n191#1:268\n196#1:269\n202#1:270\n208#1:271\n*E\n"})
public class LspIntentionAction
implements IntentionAction {
    @NotNull
    private final LspServer lspServer;
    @NotNull
    private final CodeAction codeAction;
    private boolean uriToDocumentMapInitialized;
    @Nullable
    private Map<String, ? extends Document> uriToDocumentMap;

    public LspIntentionAction(@NotNull LspServer lspServer, @NotNull CodeAction codeAction) {
        Intrinsics.checkNotNullParameter((Object)lspServer, (String)"lspServer");
        Intrinsics.checkNotNullParameter((Object)codeAction, (String)"codeAction");
        this.lspServer = lspServer;
        this.codeAction = codeAction;
    }

    @NotNull
    protected final LspServer getLspServer() {
        return this.lspServer;
    }

    @NotNull
    protected final CodeAction getCodeAction() {
        return this.codeAction;
    }

    @NotNull
    public final String getFamilyName() {
        return "";
    }

    public final boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public String getText() {
        String string = this.codeAction.getTitle();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTitle(...)");
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        return this.isAvailable();
    }

    public final boolean isAvailable() {
        CodeActionDisabled codeActionDisabled = this.codeAction.getDisabled();
        if (codeActionDisabled != null) {
            CodeActionDisabled codeActionDisabled2 = codeActionDisabled;
            boolean bl = false;
            return false;
        }
        if (!this.uriToDocumentMapInitialized) {
            Map<String, Document> map;
            if (this.codeAction.getEdit() != null) {
                WorkspaceEdit workspaceEdit = this.codeAction.getEdit();
                Intrinsics.checkNotNullExpressionValue((Object)workspaceEdit, (String)"getEdit(...)");
                map = this.V(workspaceEdit);
            } else {
                map = MapsKt.emptyMap();
            }
            this.uriToDocumentMap = map;
            this.uriToDocumentMapInitialized = true;
        }
        return this.uriToDocumentMap != null;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        this.invoke(psiFile.getVirtualFile());
    }

    public final void invoke(@Nullable VirtualFile contextFile) {
        WorkspaceEdit workspaceEdit;
        WorkspaceEdit workspaceEdit2 = this.uriToDocumentMap;
        if (workspaceEdit2 == null) {
            return;
        }
        WorkspaceEdit workspaceEdit3 = workspaceEdit = workspaceEdit2;
        boolean bl = false;
        WorkspaceEdit workspaceEdit4 = workspaceEdit3;
        Collection collection = new ArrayList(workspaceEdit3.size());
        boolean bl2 = false;
        Iterator<Map.Entry<String, ? extends Document>> iterator = workspaceEdit4.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ? extends Document> entry;
            Map.Entry<String, ? extends Document> entry2 = entry = iterator.next();
            Collection collection2 = collection;
            boolean bl3 = false;
            collection2.add(FileDocumentManager.getInstance().getFile(entry2.getValue()));
        }
        List list = (List)collection;
        if (!FileModificationService.getInstance().prepareVirtualFilesForWrite(this.lspServer.getProject(), (Collection)list)) {
            return;
        }
        WorkspaceEdit workspaceEdit5 = this.codeAction.getEdit();
        if (workspaceEdit5 != null) {
            workspaceEdit4 = workspaceEdit5;
            boolean bl4 = false;
            WriteAction.run(() -> LspIntentionAction.V(this, workspaceEdit4, (Map)workspaceEdit));
        }
        this.V(this.lspServer.getDescriptor().getLspCommandsSupport(), this.codeAction.getCommand(), contextFile);
    }

    private final void V(LspCommandsSupport lspCommandsSupport, Command command, VirtualFile virtualFile) {
        if (lspCommandsSupport != null && command != null && virtualFile != null) {
            lspCommandsSupport.executeCommand(this.lspServer, virtualFile, command);
        }
    }

    @RequiresWriteLock
    protected void applyWorkspaceEdit(@NotNull WorkspaceEdit workspaceEdit, @NotNull Map<String, ? extends Document> uriToDocumentMap) {
        block14: {
            boolean bl;
            boolean bl2;
            Iterable iterable;
            List list;
            Map map;
            block13: {
                Intrinsics.checkNotNullParameter((Object)workspaceEdit, (String)"workspaceEdit");
                Intrinsics.checkNotNullParameter(uriToDocumentMap, (String)"uriToDocumentMap");
                Map map2 = workspaceEdit.getChanges();
                if (map2 != null) {
                    Map map3 = map2;
                    boolean bl3 = false;
                    Iterable iterable2 = map3.entrySet();
                    boolean bl4 = false;
                    for (Object object : iterable2) {
                        Document document;
                        Map.Entry entry = (Map.Entry)object;
                        boolean bl5 = false;
                        Intrinsics.checkNotNull((Object)uriToDocumentMap.get(entry.getKey()));
                        Object v2 = entry.getValue();
                        Intrinsics.checkNotNullExpressionValue(v2, (String)"<get-value>(...)");
                        if (Lsp4jUtilKt.applyTextEdits(document, (List)v2)) continue;
                        return;
                    }
                }
                map = new LinkedHashMap();
                List list2 = workspaceEdit.getDocumentChanges();
                if (list2 == null) break block14;
                list = list2;
                boolean bl6 = false;
                iterable = list;
                bl2 = false;
                if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                    bl = false;
                } else {
                    for (Map.Entry entry : iterable) {
                        Either either = (Either)entry;
                        boolean bl7 = false;
                        if (!(either.isRight() && !(either.getRight() instanceof CreateFile))) continue;
                        bl = true;
                        break block13;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return;
            }
            iterable = list;
            bl2 = false;
            for (Map.Entry entry : iterable) {
                boolean bl8;
                LspIntentionAction lspIntentionAction;
                Document document;
                boolean bl9;
                TextDocumentEdit textDocumentEdit;
                TextDocumentEdit textDocumentEdit2;
                Either either = (Either)entry;
                boolean bl10 = false;
                TextDocumentEdit textDocumentEdit3 = textDocumentEdit2 = (TextDocumentEdit)either.getLeft();
                if (textDocumentEdit3 != null) {
                    Intrinsics.checkNotNull((Object)textDocumentEdit3);
                    textDocumentEdit = textDocumentEdit2;
                    bl9 = false;
                    Document document2 = uriToDocumentMap.get(textDocumentEdit.getTextDocument().getUri());
                    if (document2 == null) {
                        document2 = (Document)map.get(textDocumentEdit.getTextDocument().getUri());
                    }
                    if ((document = document2) == null) {
                        lspIntentionAction = this;
                        bl8 = false;
                        Logger logger = Logger.getInstance(LspIntentionAction.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                        logger.error("No Document for " + textDocumentEdit.getTextDocument().getUri());
                        return;
                    }
                    List list3 = textDocumentEdit.getEdits();
                    Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getEdits(...)");
                    if (!Lsp4jUtilKt.applyTextEdits(document, list3)) {
                        return;
                    }
                }
                TextDocumentEdit textDocumentEdit4 = textDocumentEdit2 = (ResourceOperation)either.getRight();
                if (textDocumentEdit4 == null) continue;
                Intrinsics.checkNotNull((Object)textDocumentEdit4);
                textDocumentEdit = textDocumentEdit2;
                bl9 = false;
                document = textDocumentEdit;
                if (document instanceof CreateFile) {
                    if (this.V((CreateFile)textDocumentEdit) != null) {
                        bl8 = false;
                        Map map4 = map;
                        String string = ((CreateFile)textDocumentEdit).getUri();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUri(...)");
                        map4.put(string, lspIntentionAction);
                    }
                    continue;
                }
                if (!(document instanceof DeleteFile) && !(document instanceof RenameFile)) continue;
            }
        }
    }

    private final Document V(CreateFile createFile) {
        Document document;
        VirtualFile virtualFile;
        String string = createFile.getUri();
        String string2 = PathUtil.getParentPath((String)string);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getParentPath(...)");
        String string3 = string2;
        VirtualFile virtualFile2 = this.lspServer.getDescriptor().findFileByUri(string3);
        while (virtualFile2 == null && !(((CharSequence)string3).length() == 0)) {
            Intrinsics.checkNotNullExpressionValue((Object)PathUtil.getParentPath((String)string3), (String)"getParentPath(...)");
            virtualFile2 = this.lspServer.getDescriptor().findFileByUri(string3);
        }
        if (virtualFile2 == null) {
            LspIntentionAction lspIntentionAction = this;
            boolean bl = false;
            Logger logger = Logger.getInstance(LspIntentionAction.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Ignoring CreateFile(" + string + "): base directory not found");
            return null;
        }
        Intrinsics.checkNotNull((Object)string);
        String string4 = string.substring(string3.length() + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
        String string5 = string4;
        String string6 = PathUtil.getFileName((String)string5);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getFileName(...)");
        String string7 = string6;
        String string8 = PathUtil.getParentPath((String)string5);
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"getParentPath(...)");
        String string9 = string8;
        VirtualFile virtualFile3 = virtualFile = ((CharSequence)string9).length() == 0 ? virtualFile2 : VfsUtil.createDirectoryIfMissing((String)(virtualFile2.getPath() + "/" + string9));
        if (virtualFile == null) {
            LspIntentionAction lspIntentionAction = this;
            boolean bl = false;
            Logger logger = Logger.getInstance(LspIntentionAction.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Failed to create parent directory for CreateFile(" + string + ")");
            return null;
        }
        VirtualFile virtualFile4 = virtualFile.createChildData((Object)this, string7);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile4, (String)"createChildData(...)");
        VirtualFile virtualFile5 = virtualFile4;
        Document document2 = document = FileDocumentManager.getInstance().getDocument(virtualFile5);
        boolean bl = false;
        if (document2 == null) {
            LspIntentionAction lspIntentionAction = this;
            boolean bl2 = false;
            Logger logger = Logger.getInstance(LspIntentionAction.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("No Document for created file " + virtualFile5.getPath());
        }
        return document;
    }

    private final Map<String, Document> V(WorkspaceEdit workspaceEdit) {
        Map map;
        block7: {
            map = new LinkedHashMap();
            Map map2 = workspaceEdit.getChanges();
            if (map2 != null) {
                Map map3 = map2;
                boolean bl = false;
                Iterable iterable = map3.keySet();
                boolean bl2 = false;
                for (Object object : iterable) {
                    Document document;
                    String string = (String)object;
                    boolean bl3 = false;
                    Intrinsics.checkNotNull((Object)string);
                    if (LspIntentionAction.getDocument$default(this, string, 0, 2, null) == null) {
                        return null;
                    }
                    map.put(string, document);
                }
            }
            Set set = new LinkedHashSet();
            List list = workspaceEdit.getDocumentChanges();
            if (list == null) break block7;
            List list2 = list;
            boolean bl = false;
            Iterable iterable = list2;
            boolean bl4 = false;
            for (String string : iterable) {
                TextDocumentEdit textDocumentEdit;
                Either either = (Either)string;
                boolean bl5 = false;
                TextDocumentEdit textDocumentEdit2 = textDocumentEdit = (TextDocumentEdit)either.getLeft();
                if (textDocumentEdit2 != null) {
                    Intrinsics.checkNotNull((Object)textDocumentEdit2);
                    TextDocumentEdit textDocumentEdit3 = textDocumentEdit;
                    boolean bl6 = false;
                    String string2 = textDocumentEdit3.getTextDocument().getUri();
                    if (!set.contains(string2)) {
                        Document document;
                        Integer n2 = textDocumentEdit3.getTextDocument().getVersion();
                        Intrinsics.checkNotNull((Object)string2);
                        Integer n3 = n2;
                        if (this.V(string2, n3 != null ? n3 : -1) == null) {
                            return null;
                        }
                        map.put(string2, document);
                    }
                }
                Object object = either.getRight();
                Object object2 = object instanceof CreateFile ? (CreateFile)object : null;
                if (object2 == null || (object2 = (object = object2.getUri())) == null) continue;
                Intrinsics.checkNotNull((Object)object2);
                Object object3 = object;
                boolean bl7 = false;
                set.add(object3);
            }
        }
        return map;
    }

    private final Document V(String string, int n2) {
        VirtualFile virtualFile = this.lspServer.getDescriptor().findFileByUri(string);
        if (virtualFile == null) {
            LspIntentionAction lspIntentionAction = this;
            boolean bl = false;
            Logger logger = Logger.getInstance(LspIntentionAction.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("File not found: " + string);
            return null;
        }
        if (!ProjectFileIndex.getInstance((Project)this.lspServer.getProject()).isInContent(virtualFile)) {
            LspIntentionAction lspIntentionAction = this;
            boolean bl = false;
            Logger logger = Logger.getInstance(LspIntentionAction.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("File is not within the project content: " + string);
            return null;
        }
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        if (document == null) {
            LspIntentionAction lspIntentionAction = this;
            boolean bl = false;
            Logger logger = Logger.getInstance(LspIntentionAction.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Document not found for file: " + virtualFile);
            return null;
        }
        int n3 = this.lspServer.getDocumentVersion(document);
        if (n2 != -1 && n3 != n2) {
            LspIntentionAction lspIntentionAction = this;
            boolean bl = false;
            Logger logger = Logger.getInstance(LspIntentionAction.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.info("Ignoring CodeAction for document version " + n2 + " (" + virtualFile.getName() + "); current document version: " + n3);
            return null;
        }
        return document;
    }

    static /* synthetic */ Document getDocument$default(LspIntentionAction lspIntentionAction, String string, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getDocument");
        }
        if ((n3 & 2) != 0) {
            n2 = -1;
        }
        return lspIntentionAction.V(string, n2);
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile nonPhysicalFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)nonPhysicalFile, (String)"nonPhysicalFile");
        Map<String, ? extends Document> map = this.uriToDocumentMap;
        if (map == null) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
            return intentionPreviewInfo;
        }
        Map<String, ? extends Document> map2 = map;
        PsiFile psiFile = nonPhysicalFile.getOriginalFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getOriginalFile(...)");
        PsiFile psiFile2 = psiFile;
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile2);
        if (document == null) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
            return intentionPreviewInfo;
        }
        Document document2 = document;
        if (!map2.containsValue(document2)) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
            return intentionPreviewInfo;
        }
        Document document3 = nonPhysicalFile.getViewProvider().getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document3, (String)"getDocument(...)");
        this.V(document3, document2);
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.DIFF;
        Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"DIFF");
        return intentionPreviewInfo;
    }

    private final void V(Document document, Document document2) {
        block5: {
            boolean bl;
            Map.Entry entry;
            boolean bl2;
            Iterable iterable;
            boolean bl3;
            Object object;
            Map<String, ? extends Document> map = this.uriToDocumentMap;
            if (map == null) {
                return;
            }
            Map<String, ? extends Document> map2 = map;
            WorkspaceEdit workspaceEdit = this.codeAction.getEdit();
            if (workspaceEdit == null) {
                return;
            }
            WorkspaceEdit workspaceEdit2 = workspaceEdit;
            Map map3 = workspaceEdit2.getChanges();
            if (map3 != null) {
                object = map3;
                bl3 = false;
                iterable = object.entrySet();
                bl2 = false;
                for (Object t2 : iterable) {
                    entry = (Map.Entry)t2;
                    bl = false;
                    if (!Intrinsics.areEqual((Object)document2, (Object)map2.get(entry.getKey()))) continue;
                    Object v2 = entry.getValue();
                    Intrinsics.checkNotNullExpressionValue(v2, (String)"<get-value>(...)");
                    if (Lsp4jUtilKt.applyTextEdits(document, (List)v2)) continue;
                    return;
                }
            }
            List list = workspaceEdit2.getDocumentChanges();
            if (list == null) break block5;
            object = list;
            bl3 = false;
            iterable = (Iterable)object;
            bl2 = false;
            for (Object t2 : iterable) {
                TextDocumentEdit textDocumentEdit;
                entry = (Either)t2;
                bl = false;
                TextDocumentEdit textDocumentEdit2 = textDocumentEdit = (TextDocumentEdit)entry.getLeft();
                if (textDocumentEdit2 == null) continue;
                Intrinsics.checkNotNull((Object)textDocumentEdit2);
                TextDocumentEdit textDocumentEdit3 = textDocumentEdit;
                boolean bl4 = false;
                if (!Intrinsics.areEqual((Object)document2, (Object)map2.get(textDocumentEdit3.getTextDocument().getUri()))) continue;
                List list2 = textDocumentEdit3.getEdits();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getEdits(...)");
                if (Lsp4jUtilKt.applyTextEdits(document, list2)) continue;
                return;
            }
        }
    }

    private static final void V(LspIntentionAction lspIntentionAction, WorkspaceEdit workspaceEdit, Map map) {
        Intrinsics.checkNotNullParameter((Object)lspIntentionAction, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)workspaceEdit, (String)"$edit");
        Intrinsics.checkNotNullParameter((Object)map, (String)"$uriToDocumentMap");
        lspIntentionAction.applyWorkspaceEdit(workspaceEdit, map);
    }
}

