/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.impl.builder;

import com.google.common.collect.BiMap;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.Graph;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.base.NodeCursor;
import com.intellij.openapi.graph.builder.GraphDataModel;
import com.intellij.openapi.graph.builder.NodeGroupDescriptor;
import com.intellij.openapi.graph.builder.edges.CollapsedEdge;
import com.intellij.openapi.graph.impl.builder.ComparableEdge;
import com.intellij.openapi.graph.impl.builder.ComparableNode;
import com.intellij.openapi.graph.impl.builder.GraphDataMaps;
import com.intellij.openapi.graph.view.EdgeLabel;
import com.intellij.openapi.graph.view.EdgeRealizer;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.NodeLabel;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.graph.view.hierarchy.HierarchyManager;
import com.intellij.openapi.util.Key;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GraphImplUtil {
    @NotNull
    public static final Key<?> NODE_DRAGGED_INFO = Key.create((String)"NODE_DRAGGED_INFO");

    private GraphImplUtil() {
    }

    @Nullable
    public static <N, E> Node getExistedNode(@NotNull GraphDataMaps<N, E> dataMaps, @NotNull String name, Object @NotNull [] equalityObjects) {
        if (dataMaps == null) {
            GraphImplUtil.V(0);
        }
        if (name == null) {
            GraphImplUtil.V(1);
        }
        if (equalityObjects == null) {
            GraphImplUtil.V(2);
        }
        ComparableNode comparableNode = GraphImplUtil.V(name, equalityObjects);
        BiMap<Node, ComparableNode> biMap = dataMaps.getNodeEqualityDataMap();
        return (Node)biMap.inverse().get((Object)comparableNode);
    }

    @Nullable
    public static <N, E> Edge getExistedEdge(@NotNull GraphDataMaps<N, E> dataMaps, @NotNull Node node1, @NotNull Node node2, @NotNull String name, Object ... equalityObjects) {
        if (dataMaps == null) {
            GraphImplUtil.V(3);
        }
        if (node1 == null) {
            GraphImplUtil.V(4);
        }
        if (node2 == null) {
            GraphImplUtil.V(5);
        }
        if (name == null) {
            GraphImplUtil.V(6);
        }
        if (equalityObjects == null) {
            GraphImplUtil.V(7);
        }
        ComparableEdge comparableEdge = GraphImplUtil.V(dataMaps, name, node1, node2, equalityObjects);
        BiMap<Edge, ComparableEdge> biMap = dataMaps.getEdgeEqualityDataMap();
        return (Edge)biMap.inverse().get((Object)comparableEdge);
    }

    @NotNull
    public static Node getNodeInRootGraph(@NotNull Node node, @NotNull HierarchyManager hierarchyManager) {
        if (node == null) {
            GraphImplUtil.V(8);
        }
        if (hierarchyManager == null) {
            GraphImplUtil.V(9);
        }
        Node node2 = node;
        while (!node2.getGraph().equals(hierarchyManager.getRootGraph())) {
            node2 = hierarchyManager.getParentNode(node2);
        }
        Node node3 = node2;
        if (node3 == null) {
            GraphImplUtil.V(10);
        }
        return node3;
    }

    @NotNull
    public static List<Node> getNodes(@NotNull Graph graph) {
        if (graph == null) {
            GraphImplUtil.V(11);
        }
        HierarchyManager hierarchyManager = HierarchyManager.Statics.getInstance((Graph)graph);
        ArrayList<Node> arrayList = new ArrayList<Node>(Arrays.asList(graph.getNodeArray()));
        Arrays.stream(graph.getNodeArray()).filter(node -> hierarchyManager.isFolderNode(node)).flatMap(node -> GraphImplUtil.getNodes(hierarchyManager.getInnerGraph(node)).stream()).forEach(arrayList::add);
        ArrayList<Node> arrayList2 = arrayList;
        if (arrayList2 == null) {
            GraphImplUtil.V(12);
        }
        return arrayList2;
    }

    @NotNull
    public static List<Edge> getEdges(@NotNull Graph graph) {
        if (graph == null) {
            GraphImplUtil.V(13);
        }
        HierarchyManager hierarchyManager = HierarchyManager.Statics.getInstance((Graph)graph);
        ArrayList<Edge> arrayList = new ArrayList<Edge>(Arrays.asList(graph.getEdgeArray()));
        Arrays.stream(graph.getNodeArray()).filter(node -> hierarchyManager.isFolderNode(node)).flatMap(node -> GraphImplUtil.getEdges(hierarchyManager.getInnerGraph(node)).stream()).forEach(arrayList::add);
        ArrayList<Edge> arrayList2 = arrayList;
        if (arrayList2 == null) {
            GraphImplUtil.V(14);
        }
        return arrayList2;
    }

    @RequiresEdt
    @NotNull
    public static <N, E> Node createNode(@NotNull Graph graph, @NotNull GraphDataMaps<N, E> dataMaps, @NotNull String name, Object ... equalityObjects) {
        if (graph == null) {
            GraphImplUtil.V(15);
        }
        if (dataMaps == null) {
            GraphImplUtil.V(16);
        }
        if (name == null) {
            GraphImplUtil.V(17);
        }
        if (equalityObjects == null) {
            GraphImplUtil.V(18);
        }
        ThreadingAssertions.assertEventDispatchThread();
        return GraphImplUtil.createNode(graph, null, dataMaps, name, equalityObjects);
    }

    @RequiresEdt
    @NotNull
    public static <N, E> Node createNode(@NotNull Graph rootGraph, @Nullable Graph innerGraph, @NotNull GraphDataMaps<N, E> dataMaps, @NotNull String name, Object ... equalityObjects) {
        if (rootGraph == null) {
            GraphImplUtil.V(19);
        }
        if (dataMaps == null) {
            GraphImplUtil.V(20);
        }
        if (name == null) {
            GraphImplUtil.V(21);
        }
        if (equalityObjects == null) {
            GraphImplUtil.V(22);
        }
        ThreadingAssertions.assertEventDispatchThread();
        Node node = innerGraph == null ? rootGraph.createNode() : innerGraph.createNode();
        GraphImplUtil.setNodeName(dataMaps, node, name);
        dataMaps.getNodeEqualityDataMap().put((Object)node, (Object)GraphImplUtil.V(name, equalityObjects));
        Node node2 = node;
        if (node2 == null) {
            GraphImplUtil.V(23);
        }
        return node2;
    }

    @NotNull
    private static ComparableNode V(@NotNull String string, Object ... objectArray) {
        if (string == null) {
            GraphImplUtil.V(24);
        }
        if (objectArray == null) {
            GraphImplUtil.V(25);
        }
        return new ComparableNode("", objectArray);
    }

    @NotNull
    private static <N, E> ComparableEdge V(@NotNull GraphDataMaps<N, E> graphDataMaps, @NotNull String string, @NotNull Node node, @NotNull Node node2, Object ... objectArray) {
        if (graphDataMaps == null) {
            GraphImplUtil.V(26);
        }
        if (string == null) {
            GraphImplUtil.V(27);
        }
        if (node == null) {
            GraphImplUtil.V(28);
        }
        if (node2 == null) {
            GraphImplUtil.V(29);
        }
        if (objectArray == null) {
            GraphImplUtil.V(30);
        }
        return new ComparableEdge(string, GraphImplUtil.V(graphDataMaps, node), GraphImplUtil.V(graphDataMaps, node2), objectArray);
    }

    @NotNull
    private static <N, E> ComparableNode V(@NotNull GraphDataMaps<N, E> graphDataMaps, @NotNull Node node) {
        if (graphDataMaps == null) {
            GraphImplUtil.V(31);
        }
        if (node == null) {
            GraphImplUtil.V(32);
        }
        return GraphImplUtil.V(GraphImplUtil.getNodeName(graphDataMaps, node), GraphImplUtil.W(graphDataMaps, node));
    }

    @NotNull
    public static <N, E> String getNodeName(@NotNull GraphDataMaps<N, E> graphDataMaps, @NotNull Node node) {
        String string;
        if (graphDataMaps == null) {
            GraphImplUtil.V(33);
        }
        if (node == null) {
            GraphImplUtil.V(34);
        }
        String string2 = (string = graphDataMaps.getNodeNameDataMap().get(node)) == null ? "" : string;
        if (string2 == null) {
            GraphImplUtil.V(35);
        }
        return string2;
    }

    @RequiresEdt
    public static <N, E> void setNodeName(@NotNull GraphDataMaps<N, E> dataMaps, @NotNull Node node, @NotNull String name) {
        if (dataMaps == null) {
            GraphImplUtil.V(36);
        }
        if (node == null) {
            GraphImplUtil.V(37);
        }
        if (name == null) {
            GraphImplUtil.V(38);
        }
        ThreadingAssertions.assertEventDispatchThread();
        dataMaps.getNodeNameDataMap().put(node, name);
    }

    @RequiresEdt
    public static <N, E> void setNodeObject(@NotNull GraphDataMaps<N, E> graphDataMaps, @NotNull Node node, @NotNull N nodeObject) {
        if (graphDataMaps == null) {
            GraphImplUtil.V(39);
        }
        if (node == null) {
            GraphImplUtil.V(40);
        }
        if (nodeObject == null) {
            GraphImplUtil.V(41);
        }
        ThreadingAssertions.assertEventDispatchThread();
        graphDataMaps.getNodeObjectDataBiMap().forcePut((Object)node, nodeObject);
    }

    public static void expandAllParentNodes(@NotNull Node node, @NotNull HierarchyManager hierarchyManager) {
        Node node2;
        if (node == null) {
            GraphImplUtil.V(42);
        }
        if (hierarchyManager == null) {
            GraphImplUtil.V(43);
        }
        if (hierarchyManager.isFolderNode(node)) {
            hierarchyManager.openFolder(node);
        }
        if ((node2 = hierarchyManager.getParentNode(node)) != null) {
            GraphImplUtil.expandAllParentNodes(node2, hierarchyManager);
        }
    }

    @RequiresEdt
    @NotNull
    public static <N, E> Node getOrCreateGroupNode(@NotNull Graph2D graph, @NotNull HierarchyManager hierarchyManager, @NotNull NodeGroupDescriptor groupDescriptor, @NotNull GraphDataMaps<N, E> dataMaps, @NotNull GraphDataModel<N, E> dataModel) {
        if (graph == null) {
            GraphImplUtil.V(44);
        }
        if (hierarchyManager == null) {
            GraphImplUtil.V(45);
        }
        if (groupDescriptor == null) {
            GraphImplUtil.V(46);
        }
        if (dataMaps == null) {
            GraphImplUtil.V(47);
        }
        if (dataModel == null) {
            GraphImplUtil.V(48);
        }
        ThreadingAssertions.assertEventDispatchThread();
        Node node = GraphImplUtil.V(graph, groupDescriptor, hierarchyManager, dataMaps);
        if (node != null) {
            Node node2 = node;
            if (node2 == null) {
                GraphImplUtil.V(49);
            }
            return node2;
        }
        NodeGroupDescriptor nodeGroupDescriptor = dataModel.getGroup(groupDescriptor);
        if (nodeGroupDescriptor != null) {
            Node node3 = GraphImplUtil.V(graph, nodeGroupDescriptor, hierarchyManager, dataMaps);
            if (node3 == null) {
                node3 = GraphImplUtil.getOrCreateGroupNode(graph, hierarchyManager, nodeGroupDescriptor, dataMaps, dataModel);
            } else {
                GraphImplUtil.expandAllParentNodes(node3, hierarchyManager);
            }
            return GraphImplUtil.V(hierarchyManager, graph, groupDescriptor, node3, dataMaps);
        }
        return GraphImplUtil.V(hierarchyManager, graph, groupDescriptor, dataMaps);
    }

    @Nullable
    public static <N, E> NodeGroupDescriptor getGroup(@NotNull GraphDataMaps<N, E> dataMaps, @NotNull Node groupNode) {
        if (dataMaps == null) {
            GraphImplUtil.V(50);
        }
        if (groupNode == null) {
            GraphImplUtil.V(51);
        }
        return dataMaps.getGroupNodeDataMap().get(groupNode);
    }

    @Nullable
    public static <N, E> Node getGroupNode(@NotNull GraphDataMaps<N, E> dataMaps, @NotNull NodeGroupDescriptor groupDescriptor) {
        if (dataMaps == null) {
            GraphImplUtil.V(52);
        }
        if (groupDescriptor == null) {
            GraphImplUtil.V(53);
        }
        Map<Node, NodeGroupDescriptor> map = dataMaps.getGroupNodeDataMap();
        return (Node)ContainerUtil.find(map.keySet(), node -> map.get(node) == groupDescriptor);
    }

    @Nullable
    public static <N, E> Edge getCollapsedEdge(@NotNull GraphDataMaps<N, E> dataMaps, @NotNull CollapsedEdge collapsedEdge) {
        if (dataMaps == null) {
            GraphImplUtil.V(54);
        }
        if (collapsedEdge == null) {
            GraphImplUtil.V(55);
        }
        Map<Edge, CollapsedEdge> map = dataMaps.getCollapsedEdgeDataMap();
        return (Edge)ContainerUtil.find(map.keySet(), edge -> map.get(edge) == collapsedEdge);
    }

    @NotNull
    private static <N, E> Node V(@NotNull HierarchyManager hierarchyManager, @NotNull Graph2D graph2D, @NotNull NodeGroupDescriptor nodeGroupDescriptor, @NotNull GraphDataMaps<N, E> graphDataMaps) {
        if (hierarchyManager == null) {
            GraphImplUtil.V(56);
        }
        if (graph2D == null) {
            GraphImplUtil.V(57);
        }
        if (nodeGroupDescriptor == null) {
            GraphImplUtil.V(58);
        }
        if (graphDataMaps == null) {
            GraphImplUtil.V(59);
        }
        return GraphImplUtil.V(hierarchyManager, graph2D, nodeGroupDescriptor, null, graphDataMaps);
    }

    @NotNull
    private static <N, E> Node V(@NotNull HierarchyManager hierarchyManager, @NotNull Graph2D graph2D, @NotNull NodeGroupDescriptor nodeGroupDescriptor, @Nullable Node node, @NotNull GraphDataMaps<N, E> graphDataMaps) {
        if (hierarchyManager == null) {
            GraphImplUtil.V(60);
        }
        if (graph2D == null) {
            GraphImplUtil.V(61);
        }
        if (nodeGroupDescriptor == null) {
            GraphImplUtil.V(62);
        }
        if (graphDataMaps == null) {
            GraphImplUtil.V(63);
        }
        Node node2 = node != null ? hierarchyManager.createGroupNode(node) : hierarchyManager.createGroupNode((Graph)graph2D);
        graph2D.setLabelText(node2, nodeGroupDescriptor.getGroupName());
        graphDataMaps.getGroupNodeDataMap().put(node2, nodeGroupDescriptor);
        Node node3 = node2;
        if (node3 == null) {
            GraphImplUtil.V(64);
        }
        return node3;
    }

    @Nullable
    private static <N, E> Node V(@NotNull Graph2D graph2D, @NotNull NodeGroupDescriptor nodeGroupDescriptor, @NotNull HierarchyManager hierarchyManager, @NotNull GraphDataMaps<N, E> graphDataMaps) {
        if (graph2D == null) {
            GraphImplUtil.V(65);
        }
        if (nodeGroupDescriptor == null) {
            GraphImplUtil.V(66);
        }
        if (hierarchyManager == null) {
            GraphImplUtil.V(67);
        }
        if (graphDataMaps == null) {
            GraphImplUtil.V(68);
        }
        for (Node node : graph2D.getNodeArray()) {
            if (!hierarchyManager.isFolderNode(node) && !hierarchyManager.isGroupNode(node)) continue;
            if (nodeGroupDescriptor.equals(GraphImplUtil.getGroupNode(graphDataMaps, node))) {
                return node;
            }
            Node node2 = GraphImplUtil.V(nodeGroupDescriptor, hierarchyManager, hierarchyManager.getChildren(node), graphDataMaps);
            if (node2 == null) continue;
            return node2;
        }
        return null;
    }

    @Nullable
    private static <N, E> Node V(@NotNull NodeGroupDescriptor nodeGroupDescriptor, @NotNull HierarchyManager hierarchyManager, @NotNull NodeCursor nodeCursor, @NotNull GraphDataMaps<N, E> graphDataMaps) {
        if (nodeGroupDescriptor == null) {
            GraphImplUtil.V(69);
        }
        if (hierarchyManager == null) {
            GraphImplUtil.V(70);
        }
        if (nodeCursor == null) {
            GraphImplUtil.V(71);
        }
        if (graphDataMaps == null) {
            GraphImplUtil.V(72);
        }
        while (nodeCursor.ok()) {
            Node node = nodeCursor.node();
            if (nodeGroupDescriptor.equals(GraphImplUtil.getGroupNode(graphDataMaps, node))) {
                return node;
            }
            Node node2 = GraphImplUtil.V(nodeGroupDescriptor, hierarchyManager, hierarchyManager.getChildren(node), graphDataMaps);
            if (node2 != null) {
                return node2;
            }
            nodeCursor.next();
        }
        return null;
    }

    @Nullable
    public static <N, E> NodeGroupDescriptor getGroupNode(@NotNull GraphDataMaps<N, E> dataMaps, @NotNull Node node) {
        if (dataMaps == null) {
            GraphImplUtil.V(73);
        }
        if (node == null) {
            GraphImplUtil.V(74);
        }
        return dataMaps.getGroupNodeDataMap().get(node);
    }

    public static <N, E> boolean isGroupNode(@NotNull GraphDataMaps<N, E> dataMaps, @NotNull Node node) {
        if (dataMaps == null) {
            GraphImplUtil.V(75);
        }
        if (node == null) {
            GraphImplUtil.V(76);
        }
        return dataMaps.getGroupNodeDataMap().get(node) != null;
    }

    @RequiresEdt
    public static <N, E> void setEdgeObject(@NotNull GraphDataMaps<N, E> dataMaps, @NotNull Edge edge, @NotNull E edgeObject) {
        if (dataMaps == null) {
            GraphImplUtil.V(77);
        }
        if (edge == null) {
            GraphImplUtil.V(78);
        }
        if (edgeObject == null) {
            GraphImplUtil.V(79);
        }
        ThreadingAssertions.assertEventDispatchThread();
        dataMaps.getEdgeObjectDataBiMap().forcePut((Object)edge, edgeObject);
    }

    @Nullable
    public static <N, E> String getEdgeName(@NotNull GraphDataMaps<N, E> dataMaps, @NotNull E e10) {
        if (dataMaps == null) {
            GraphImplUtil.V(80);
        }
        if (e10 == null) {
            GraphImplUtil.V(81);
        }
        return dataMaps.getEdgeNameDataMap().get(GraphImplUtil.getEdge(dataMaps, e10));
    }

    @NotNull
    public static <N, E> String getEdgeName(@NotNull GraphDataMaps<N, E> dataMaps, @NotNull Edge edge) {
        String string;
        if (dataMaps == null) {
            GraphImplUtil.V(82);
        }
        if (edge == null) {
            GraphImplUtil.V(83);
        }
        String string2 = (string = dataMaps.getEdgeNameDataMap().get(edge)) == null ? "" : string;
        if (string2 == null) {
            GraphImplUtil.V(84);
        }
        return string2;
    }

    @RequiresEdt
    public static <N, E> void setEdgeName(@NotNull GraphDataMaps<N, E> dataMaps, @NotNull Edge edge, @NotNull String name) {
        if (dataMaps == null) {
            GraphImplUtil.V(85);
        }
        if (edge == null) {
            GraphImplUtil.V(86);
        }
        if (name == null) {
            GraphImplUtil.V(87);
        }
        ThreadingAssertions.assertEventDispatchThread();
        dataMaps.getEdgeNameDataMap().put(edge, name);
    }

    @RequiresEdt
    @NotNull
    public static <N, E> Edge createEdge(@NotNull Graph2D graph, @NotNull GraphDataMaps<N, E> dataMaps, @NotNull Node node1, @NotNull Node node2, @NotNull String name, Object @NotNull [] equalityObjects) {
        if (graph == null) {
            GraphImplUtil.V(88);
        }
        if (dataMaps == null) {
            GraphImplUtil.V(89);
        }
        if (node1 == null) {
            GraphImplUtil.V(90);
        }
        if (node2 == null) {
            GraphImplUtil.V(91);
        }
        if (name == null) {
            GraphImplUtil.V(92);
        }
        if (equalityObjects == null) {
            GraphImplUtil.V(93);
        }
        ThreadingAssertions.assertEventDispatchThread();
        Edge edge = graph.createEdge(node1, node2);
        GraphImplUtil.setEdgeName(dataMaps, edge, name);
        dataMaps.getEdgeEqualityDataMap().put((Object)edge, (Object)GraphImplUtil.V(dataMaps, name, node1, node2, equalityObjects));
        Edge edge2 = edge;
        if (edge2 == null) {
            GraphImplUtil.V(94);
        }
        return edge2;
    }

    @RequiresEdt
    @NotNull
    public static <N, E> Edge createEdge(@NotNull HierarchyManager hierarchyManager, @NotNull GraphDataMaps<N, E> dataMaps, @NotNull Node node1, @NotNull Node node2, @NotNull String name, Object @NotNull [] equalityObjects) {
        if (hierarchyManager == null) {
            GraphImplUtil.V(95);
        }
        if (dataMaps == null) {
            GraphImplUtil.V(96);
        }
        if (node1 == null) {
            GraphImplUtil.V(97);
        }
        if (node2 == null) {
            GraphImplUtil.V(98);
        }
        if (name == null) {
            GraphImplUtil.V(99);
        }
        if (equalityObjects == null) {
            GraphImplUtil.V(100);
        }
        ThreadingAssertions.assertEventDispatchThread();
        Edge edge = hierarchyManager.createEdge(node1, node2);
        GraphImplUtil.setEdgeName(dataMaps, edge, name);
        dataMaps.getEdgeEqualityDataMap().put((Object)edge, (Object)GraphImplUtil.V(dataMaps, name, node1, node2, equalityObjects));
        Edge edge2 = edge;
        if (edge2 == null) {
            GraphImplUtil.V(101);
        }
        return edge2;
    }

    @RequiresEdt
    @NotNull
    public static <N, E> Edge createCollapsedEdge(@NotNull HierarchyManager hierarchyManager, @NotNull GraphDataMaps<N, E> dataMaps, @NotNull CollapsedEdge collapsedEdge, @NotNull String name, Object @NotNull [] equalityObjects) {
        if (hierarchyManager == null) {
            GraphImplUtil.V(102);
        }
        if (dataMaps == null) {
            GraphImplUtil.V(103);
        }
        if (collapsedEdge == null) {
            GraphImplUtil.V(104);
        }
        if (name == null) {
            GraphImplUtil.V(105);
        }
        if (equalityObjects == null) {
            GraphImplUtil.V(106);
        }
        ThreadingAssertions.assertEventDispatchThread();
        Edge edge = hierarchyManager.createEdge(collapsedEdge.getSource(), collapsedEdge.getTarget());
        GraphImplUtil.setEdgeName(dataMaps, edge, name);
        Edge edge2 = edge;
        if (edge2 == null) {
            GraphImplUtil.V(107);
        }
        return edge2;
    }

    @Nullable
    public static <N, E> N getNodeObject(@NotNull GraphDataMaps<N, E> dataMaps, @NotNull Node node) {
        if (dataMaps == null) {
            GraphImplUtil.V(108);
        }
        if (node == null) {
            GraphImplUtil.V(109);
        }
        return (N)dataMaps.getNodeObjectDataBiMap().get((Object)node);
    }

    @Nullable
    public static <N, E> E getEdgeObject(@NotNull GraphDataMaps<N, E> dataMaps, @NotNull Edge edge) {
        if (dataMaps == null) {
            GraphImplUtil.V(110);
        }
        if (edge == null) {
            GraphImplUtil.V(111);
        }
        return (E)dataMaps.getEdgeObjectDataBiMap().get((Object)edge);
    }

    @Nullable
    public static <N, E> NodeGroupDescriptor getGroupNodeObject(@NotNull GraphDataMaps<N, E> dataMaps, @NotNull Node node) {
        if (dataMaps == null) {
            GraphImplUtil.V(112);
        }
        if (node == null) {
            GraphImplUtil.V(113);
        }
        return dataMaps.getGroupNodeDataMap().get(node);
    }

    @Nullable
    public static <N, E> CollapsedEdge getCollapsedEdgeObject(@NotNull GraphDataMaps<N, E> dataMaps, @NotNull Edge edge) {
        if (dataMaps == null) {
            GraphImplUtil.V(114);
        }
        if (edge == null) {
            GraphImplUtil.V(115);
        }
        return dataMaps.getCollapsedEdgeDataMap().get(edge);
    }

    @Nullable
    public static <N, E> Node getNode(@NotNull GraphDataMaps<N, E> dataMaps, @NotNull N node) {
        if (dataMaps == null) {
            GraphImplUtil.V(116);
        }
        if (node == null) {
            GraphImplUtil.V(117);
        }
        return (Node)dataMaps.getNodeObjectDataBiMap().inverse().get(node);
    }

    @Nullable
    public static <N, E> Edge getEdge(@NotNull GraphDataMaps<N, E> dataMaps, @NotNull E edge) {
        if (dataMaps == null) {
            GraphImplUtil.V(118);
        }
        if (edge == null) {
            GraphImplUtil.V(119);
        }
        return (Edge)dataMaps.getEdgeObjectDataBiMap().inverse().get(edge);
    }

    @RequiresEdt
    public static <N, E> void setNodeWasDragged(@NotNull GraphDataMaps<N, E> dataMaps, @NotNull Node node) {
        if (dataMaps == null) {
            GraphImplUtil.V(120);
        }
        if (node == null) {
            GraphImplUtil.V(121);
        }
        ThreadingAssertions.assertEventDispatchThread();
        dataMaps.getDraggedNodesList().add(node);
    }

    @Nullable
    private static <N, E> ComparableNode W(@NotNull GraphDataMaps<N, E> graphDataMaps, @NotNull Node node) {
        if (graphDataMaps == null) {
            GraphImplUtil.V(122);
        }
        if (node == null) {
            GraphImplUtil.V(123);
        }
        return (ComparableNode)graphDataMaps.getNodeEqualityDataMap().get((Object)node);
    }

    @NotNull
    public static List<NodeLabel> getNodeLabels(@Nullable NodeRealizer nodeRealizer) {
        if (nodeRealizer == null) {
            List<NodeLabel> list = Collections.emptyList();
            if (list == null) {
                GraphImplUtil.V(124);
            }
            return list;
        }
        int n2 = nodeRealizer.labelCount();
        ArrayList<NodeLabel> arrayList = new ArrayList<NodeLabel>();
        for (int i2 = 0; i2 < n2; ++i2) {
            arrayList.add(nodeRealizer.getLabel(i2));
        }
        ArrayList<NodeLabel> arrayList2 = arrayList;
        if (arrayList2 == null) {
            GraphImplUtil.V(125);
        }
        return arrayList2;
    }

    @NotNull
    public static List<EdgeLabel> getEdgeLabels(@Nullable EdgeRealizer edgeRealizer) {
        if (edgeRealizer == null) {
            List<EdgeLabel> list = Collections.emptyList();
            if (list == null) {
                GraphImplUtil.V(126);
            }
            return list;
        }
        int n2 = edgeRealizer.labelCount();
        ArrayList<EdgeLabel> arrayList = new ArrayList<EdgeLabel>();
        for (int i2 = 0; i2 < n2; ++i2) {
            arrayList.add(edgeRealizer.getLabel(i2));
        }
        ArrayList<EdgeLabel> arrayList2 = arrayList;
        if (arrayList2 == null) {
            GraphImplUtil.V(127);
        }
        return arrayList2;
    }

    @Deprecated
    @RequiresEdt
    @NotNull
    public static <N, E> Node getOrCreateGroupNode(@NotNull Graph2D graph, @NotNull HierarchyManager hierarchyManager, @NotNull NodeGroupDescriptor groupDescriptor, @NotNull GraphDataMaps<N, E> dataMaps) {
        if (graph == null) {
            GraphImplUtil.V(128);
        }
        if (hierarchyManager == null) {
            GraphImplUtil.V(129);
        }
        if (groupDescriptor == null) {
            GraphImplUtil.V(130);
        }
        if (dataMaps == null) {
            GraphImplUtil.V(131);
        }
        ThreadingAssertions.assertEventDispatchThread();
        return GraphImplUtil.getOrCreateGroupNode(graph, hierarchyManager, groupDescriptor, dataMaps, null);
    }

    private static /* synthetic */ void V(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 10, 12, 14, 23, 35, 49, 64, 84, 94, 101, 107, 124, 125, 126, 127 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataMaps";
                break;
            }
            case 1: 
            case 6: 
            case 17: 
            case 21: 
            case 24: 
            case 27: 
            case 38: 
            case 87: 
            case 92: 
            case 99: 
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 7: 
            case 18: 
            case 22: 
            case 25: 
            case 30: 
            case 93: 
            case 100: 
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "equalityObjects";
                break;
            }
            case 4: 
            case 90: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node1";
                break;
            }
            case 5: 
            case 91: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node2";
                break;
            }
            case 8: 
            case 34: 
            case 37: 
            case 40: 
            case 42: 
            case 74: 
            case 76: 
            case 109: 
            case 113: 
            case 117: 
            case 121: 
            case 123: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 9: 
            case 43: 
            case 45: 
            case 56: 
            case 60: 
            case 67: 
            case 70: 
            case 95: 
            case 102: 
            case 129: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hierarchyManager";
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 23: 
            case 35: 
            case 49: 
            case 64: 
            case 84: 
            case 94: 
            case 101: 
            case 107: 
            case 124: 
            case 125: 
            case 126: 
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/graph/impl/builder/GraphImplUtil";
                break;
            }
            case 11: 
            case 13: 
            case 15: 
            case 26: 
            case 44: 
            case 57: 
            case 61: 
            case 65: 
            case 88: 
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootGraph";
                break;
            }
            case 28: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromNode";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toNode";
                break;
            }
            case 33: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphDataMaps";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeObject";
                break;
            }
            case 46: 
            case 53: 
            case 62: 
            case 66: 
            case 69: 
            case 130: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupDescriptor";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataModel";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupNode";
                break;
            }
            case 55: 
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collapsedEdge";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 78: 
            case 83: 
            case 86: 
            case 111: 
            case 115: 
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edge";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edgeObject";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/graph/impl/builder/GraphImplUtil";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeInRootGraph";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdges";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createNode";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeName";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateGroupNode";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "createGroupNode";
                break;
            }
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdgeName";
                break;
            }
            case 94: 
            case 101: {
                objectArray = objectArray2;
                objectArray2[1] = "createEdge";
                break;
            }
            case 107: {
                objectArray = objectArray2;
                objectArray2[1] = "createCollapsedEdge";
                break;
            }
            case 124: 
            case 125: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeLabels";
                break;
            }
            case 126: 
            case 127: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdgeLabels";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getExistedNode";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getExistedEdge";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getNodeInRootGraph";
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 23: 
            case 35: 
            case 49: 
            case 64: 
            case 84: 
            case 94: 
            case 101: 
            case 107: 
            case 124: 
            case 125: 
            case 126: 
            case 127: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getNodes";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getEdges";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createNode";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createComparableNode";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createComparableEdge";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getComparableNode";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getNodeName";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "setNodeName";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "setNodeObject";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "expandAllParentNodes";
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 128: 
            case 129: 
            case 130: 
            case 131: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateGroupNode";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getGroup";
                break;
            }
            case 52: 
            case 53: 
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "getGroupNode";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getCollapsedEdge";
                break;
            }
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "createGroupNode";
                break;
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "findGroupNode";
                break;
            }
            case 69: 
            case 70: 
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "findChildrenGroupNode";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "isGroupNode";
                break;
            }
            case 77: 
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "setEdgeObject";
                break;
            }
            case 80: 
            case 81: 
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "getEdgeName";
                break;
            }
            case 85: 
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "setEdgeName";
                break;
            }
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "createEdge";
                break;
            }
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "createCollapsedEdge";
                break;
            }
            case 108: 
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "getNodeObject";
                break;
            }
            case 110: 
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "getEdgeObject";
                break;
            }
            case 112: 
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "getGroupNodeObject";
                break;
            }
            case 114: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "getCollapsedEdgeObject";
                break;
            }
            case 116: 
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "getNode";
                break;
            }
            case 118: 
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "getEdge";
                break;
            }
            case 120: 
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "setNodeWasDragged";
                break;
            }
            case 122: 
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "getNodeComparableObject";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 10, 12, 14, 23, 35, 49, 64, 84, 94, 101, 107, 124, 125, 126, 127 -> new IllegalStateException(string);
        };
    }
}

