/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.impl.builder;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.NodeGroupDescriptor;
import com.intellij.openapi.graph.builder.edges.CollapsedEdge;
import com.intellij.openapi.graph.impl.builder.ComparableEdge;
import com.intellij.openapi.graph.impl.builder.ComparableNode;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.BidirectionalMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class GraphDataMaps<N, E> {
    @NotNull
    private final BiMap<Node, N> myNodeObjectDataMap = HashBiMap.create();
    @NotNull
    private final BiMap<Edge, E> myEdgeObjectDataMap = HashBiMap.create();
    @NotNull
    private final BiMap<Node, ComparableNode> myNodeEqualityDataMap = HashBiMap.create();
    @NotNull
    private final BiMap<Edge, ComparableEdge> myEdgeEqualityDataMap = HashBiMap.create();
    @NotNull
    private final Map<Node, String> myNodeNameDataMap = new HashMap<Node, String>();
    @NotNull
    private final Map<Edge, String> myEdgeNameDataMap = new HashMap<Edge, String>();
    @NotNull
    private final Map<Node, NodeGroupDescriptor> myNodeGroupDataMap = new HashMap<Node, NodeGroupDescriptor>();
    @NotNull
    private final BiMap<Edge, CollapsedEdge> myCollapsedEdgeDataMap = HashBiMap.create();
    @NotNull
    private final Map<E, CollapsedEdge> myEdgeObjects2ParentCollapsedEdgesMap = new HashMap<E, CollapsedEdge>();
    @NotNull
    private final Set<Node> myDraggedNodesList = new HashSet<Node>();

    @NotNull
    public BiMap<Node, N> getNodeObjectDataBiMap() {
        BiMap<Node, N> biMap = this.myNodeObjectDataMap;
        if (biMap == null) {
            GraphDataMaps.V(0);
        }
        return biMap;
    }

    @NotNull
    public BiMap<Edge, E> getEdgeObjectDataBiMap() {
        BiMap<Edge, E> biMap = this.myEdgeObjectDataMap;
        if (biMap == null) {
            GraphDataMaps.V(1);
        }
        return biMap;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public BidirectionalMap<Node, N> getNodeObjectDataMap() {
        BidirectionalMap bidirectionalMap = new BidirectionalMap();
        bidirectionalMap.putAll(this.myNodeObjectDataMap);
        BidirectionalMap bidirectionalMap2 = bidirectionalMap;
        if (bidirectionalMap2 == null) {
            GraphDataMaps.V(2);
        }
        return bidirectionalMap2;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public BidirectionalMap<Edge, E> getEdgeObjectDataMap() {
        BidirectionalMap bidirectionalMap = new BidirectionalMap();
        bidirectionalMap.putAll(this.myEdgeObjectDataMap);
        BidirectionalMap bidirectionalMap2 = bidirectionalMap;
        if (bidirectionalMap2 == null) {
            GraphDataMaps.V(3);
        }
        return bidirectionalMap2;
    }

    @NotNull
    public BiMap<Node, ComparableNode> getNodeEqualityDataMap() {
        BiMap<Node, ComparableNode> biMap = this.myNodeEqualityDataMap;
        if (biMap == null) {
            GraphDataMaps.V(4);
        }
        return biMap;
    }

    @NotNull
    public BiMap<Edge, ComparableEdge> getEdgeEqualityDataMap() {
        BiMap<Edge, ComparableEdge> biMap = this.myEdgeEqualityDataMap;
        if (biMap == null) {
            GraphDataMaps.V(5);
        }
        return biMap;
    }

    @NotNull
    public Map<Node, String> getNodeNameDataMap() {
        Map<Node, String> map = this.myNodeNameDataMap;
        if (map == null) {
            GraphDataMaps.V(6);
        }
        return map;
    }

    @NotNull
    public Map<Edge, String> getEdgeNameDataMap() {
        Map<Edge, String> map = this.myEdgeNameDataMap;
        if (map == null) {
            GraphDataMaps.V(7);
        }
        return map;
    }

    @NotNull
    public Map<Node, NodeGroupDescriptor> getGroupNodeDataMap() {
        Map<Node, NodeGroupDescriptor> map = this.myNodeGroupDataMap;
        if (map == null) {
            GraphDataMaps.V(8);
        }
        return map;
    }

    @NotNull
    public Map<Edge, CollapsedEdge> getCollapsedEdgeDataMap() {
        BiMap<Edge, CollapsedEdge> biMap = this.myCollapsedEdgeDataMap;
        if (biMap == null) {
            GraphDataMaps.V(9);
        }
        return biMap;
    }

    @NotNull
    public Map<E, CollapsedEdge> getEdgeObjects2ParentCollapsedEdgesMap() {
        Map<E, CollapsedEdge> map = this.myEdgeObjects2ParentCollapsedEdgesMap;
        if (map == null) {
            GraphDataMaps.V(10);
        }
        return map;
    }

    @NotNull
    public Set<Node> getDraggedNodesList() {
        Set<Node> set = this.myDraggedNodesList;
        if (set == null) {
            GraphDataMaps.V(11);
        }
        return set;
    }

    @RequiresEdt
    public void replaceEdge(@NotNull E edgeObject, @NotNull Edge edgeToReplace) {
        if (edgeObject == null) {
            GraphDataMaps.V(12);
        }
        if (edgeToReplace == null) {
            GraphDataMaps.V(13);
        }
        ThreadingAssertions.assertEventDispatchThread();
        Edge edge = (Edge)this.myEdgeObjectDataMap.inverse().get(edgeObject);
        this.myEdgeObjectDataMap.remove((Object)edge);
        this.myEdgeObjectDataMap.put((Object)edgeToReplace, edgeObject);
        ComparableEdge comparableEdge = (ComparableEdge)this.myEdgeEqualityDataMap.get((Object)edge);
        this.myEdgeEqualityDataMap.remove((Object)edge);
        this.myEdgeEqualityDataMap.put((Object)edgeToReplace, (Object)comparableEdge);
        String string = this.myEdgeNameDataMap.get(edge);
        this.myEdgeNameDataMap.remove(edge);
        this.myEdgeNameDataMap.put(edgeToReplace, string);
    }

    @RequiresEdt
    public void removeNode(@NotNull Node node) {
        if (node == null) {
            GraphDataMaps.V(14);
        }
        ThreadingAssertions.assertEventDispatchThread();
        this.myNodeObjectDataMap.remove((Object)node);
        this.myNodeEqualityDataMap.remove((Object)node);
        this.myNodeNameDataMap.remove(node);
        this.myNodeGroupDataMap.remove(node);
    }

    @RequiresEdt
    public void removeNodes(@NotNull Collection<Node> nodes2) {
        if (nodes2 == null) {
            GraphDataMaps.V(15);
        }
        ThreadingAssertions.assertEventDispatchThread();
        this.myNodeObjectDataMap.entrySet().removeIf(entry -> nodes2.contains(entry.getKey()));
        this.myNodeEqualityDataMap.entrySet().removeIf(entry -> nodes2.contains(entry.getKey()));
        this.myNodeNameDataMap.entrySet().removeIf(entry -> nodes2.contains(entry.getKey()));
        this.myNodeGroupDataMap.entrySet().removeIf(entry -> nodes2.contains(entry.getKey()));
    }

    @RequiresEdt
    public void removeEdge(@NotNull Edge edge) {
        if (edge == null) {
            GraphDataMaps.V(16);
        }
        ThreadingAssertions.assertEventDispatchThread();
        if (this.myEdgeObjectDataMap.containsKey((Object)edge) && this.myEdgeObjects2ParentCollapsedEdgesMap.containsKey(this.myEdgeObjectDataMap.get((Object)edge))) {
            this.myEdgeObjects2ParentCollapsedEdgesMap.get(this.myEdgeObjectDataMap.get((Object)edge)).getEdges().removeIf(singleEdge -> singleEdge.getOriginalEdge() == this.myEdgeObjectDataMap.get((Object)edge));
            this.myEdgeObjects2ParentCollapsedEdgesMap.remove(this.myEdgeObjectDataMap.get((Object)edge));
        }
        this.myEdgeObjectDataMap.remove((Object)edge);
        this.myEdgeEqualityDataMap.remove((Object)edge);
        this.myEdgeNameDataMap.remove(edge);
        this.myCollapsedEdgeDataMap.remove((Object)edge);
    }

    @RequiresEdt
    public void removeEdges(@NotNull Collection<Edge> edges) {
        if (edges == null) {
            GraphDataMaps.V(17);
        }
        ThreadingAssertions.assertEventDispatchThread();
        for (Map.Entry<E, CollapsedEdge> entry2 : this.myEdgeObjects2ParentCollapsedEdgesMap.entrySet()) {
            entry2.getValue().getEdges().removeIf(singleEdge -> edges.contains(this.myEdgeObjectDataMap.inverse().get(singleEdge.getOriginalEdge())));
        }
        this.myEdgeObjects2ParentCollapsedEdgesMap.entrySet().removeIf(entry -> edges.contains(entry.getKey()));
        this.myEdgeObjectDataMap.entrySet().removeIf(entry -> edges.contains(entry.getKey()));
        this.myEdgeEqualityDataMap.entrySet().removeIf(entry -> edges.contains(entry.getKey()));
        this.myEdgeNameDataMap.entrySet().removeIf(entry -> edges.contains(entry.getKey()));
        this.myCollapsedEdgeDataMap.entrySet().removeIf(entry -> edges.contains(entry.getKey()));
    }

    public void clearAll() {
        this.myNodeObjectDataMap.clear();
        this.myEdgeObjectDataMap.clear();
        this.myNodeEqualityDataMap.clear();
        this.myEdgeEqualityDataMap.clear();
        this.myNodeNameDataMap.clear();
        this.myEdgeNameDataMap.clear();
        this.myNodeGroupDataMap.clear();
        this.myCollapsedEdgeDataMap.clear();
        this.myDraggedNodesList.clear();
    }

    public void dispose() {
        this.clearAll();
    }

    private static /* synthetic */ void V(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 2;
            case 12, 13, 14, 15, 16, 17 -> 3;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/graph/impl/builder/GraphDataMaps";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edgeObject";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edgeToReplace";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edge";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edges";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeObjectDataBiMap";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdgeObjectDataBiMap";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeObjectDataMap";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdgeObjectDataMap";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeEqualityDataMap";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdgeEqualityDataMap";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeNameDataMap";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdgeNameDataMap";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupNodeDataMap";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCollapsedEdgeDataMap";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdgeObjects2ParentCollapsedEdgesMap";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDraggedNodesList";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/graph/impl/builder/GraphDataMaps";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "replaceEdge";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "removeNode";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "removeNodes";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "removeEdge";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "removeEdges";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalStateException(string);
            case 12, 13, 14, 15, 16, 17 -> new IllegalArgumentException(string);
        };
    }
}

