/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.impl.builder;

import com.intellij.codeWithMe.ClientId;
import com.intellij.diagnostic.Checks;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.graph.GraphDataKeys;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.Graph;
import com.intellij.openapi.graph.base.GraphListener;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.CustomGraphUpdater;
import com.intellij.openapi.graph.builder.DeleteProvider;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.GraphDataModel;
import com.intellij.openapi.graph.builder.GraphEditModeFactory;
import com.intellij.openapi.graph.builder.GraphIdentifiable;
import com.intellij.openapi.graph.builder.GraphPresentationModel;
import com.intellij.openapi.graph.builder.NodeGroupDescriptor;
import com.intellij.openapi.graph.builder.components.BasicGraphPresentationModel;
import com.intellij.openapi.graph.builder.edges.CollapsedEdge;
import com.intellij.openapi.graph.builder.event.GraphBuilderEvent;
import com.intellij.openapi.graph.builder.event.GraphBuilderListener;
import com.intellij.openapi.graph.impl.GraphBase;
import com.intellij.openapi.graph.impl.GraphGroupingUtil;
import com.intellij.openapi.graph.impl.builder.GraphDataMaps;
import com.intellij.openapi.graph.impl.builder.GraphImplUtil;
import com.intellij.openapi.graph.impl.builder.GraphUpdateModel;
import com.intellij.openapi.graph.impl.builder.GraphZoomManager;
import com.intellij.openapi.graph.impl.builder.YBundlesInitializer;
import com.intellij.openapi.graph.impl.popups.GraphPopupMode;
import com.intellij.openapi.graph.layout.Layouter;
import com.intellij.openapi.graph.services.GraphAnimationService;
import com.intellij.openapi.graph.services.GraphEdgeRealizerService;
import com.intellij.openapi.graph.services.GraphGroupingService;
import com.intellij.openapi.graph.services.GraphLayoutService;
import com.intellij.openapi.graph.services.GraphNodeRealizerService;
import com.intellij.openapi.graph.services.GraphSelectionService;
import com.intellij.openapi.graph.services.GraphUndoService;
import com.intellij.openapi.graph.util.Futures;
import com.intellij.openapi.graph.view.CellEditorMode;
import com.intellij.openapi.graph.view.EdgeLabel;
import com.intellij.openapi.graph.view.EdgeRealizer;
import com.intellij.openapi.graph.view.EditMode;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DSelectionListener;
import com.intellij.openapi.graph.view.Graph2DUndoManager;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.Graph2DViewActions;
import com.intellij.openapi.graph.view.MagnifierViewMode;
import com.intellij.openapi.graph.view.NodeCellRenderer;
import com.intellij.openapi.graph.view.NodeLabel;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.graph.view.StandardGraphViewControllerBuilder;
import com.intellij.openapi.graph.view.View;
import com.intellij.openapi.graph.view.View2DConstants;
import com.intellij.openapi.graph.view.ViewMode;
import com.intellij.openapi.graph.view.hierarchy.GroupNodeRealizer;
import com.intellij.openapi.graph.view.hierarchy.HierarchyManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.Gray;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.MathUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.DefaultFocusTraversalPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import net.jcip.annotations.GuardedBy;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class GraphBuilderImpl<N, E>
extends GraphBuilder<N, E> {
    @NotNull
    private static final Logger LOG = Logger.getInstance(GraphBuilderImpl.class);
    @Nullable
    private volatile Project myProject;
    @NotNull
    private final Graph2DView myView;
    @NotNull
    private final Graph2D myGraph;
    @NotNull
    private HierarchyManager myHierarchyManager;
    @NotNull
    private final Graph2DUndoManager myUndoManager;
    @NotNull
    private final GraphZoomManager myGraphZoomManager;
    @NotNull
    private final Map<GraphIdentifiable.Node.Identity, NodeRealizer> myNodeRealizers;
    @NotNull
    private final Map<GraphIdentifiable.Edge.Identity, EdgeRealizer> myEdgeRealizers;
    @NotNull
    private final GraphDataMaps<N, E> myGraphDataMaps;
    @NotNull
    private final GraphUpdateModel myGraphUpdateModel;
    @NotNull
    private final GraphDataModel<N, E> myGraphDataModel;
    @NotNull
    private final GraphPresentationModel<N, E> myGraphPresentationModel;
    @NotNull
    private final MergingUpdateQueue myMergingUpdateQueue;
    @NotNull
    private final AtomicBoolean myIsInitialized;
    @NotNull
    private final AtomicBoolean myIsDisposed;
    @NotNull
    private final AtomicReference<Promise<Void>> myUpdatingPromise;
    @NotNull
    private final Set<CustomGraphUpdater> myUpdaters;
    @GuardedBy(value="this")
    @NotNull
    private final EventDispatcher<GraphBuilderListener> myGraphBuilderDispatcher;
    @Nullable
    private EditMode myEditMode;
    @Nullable
    private ViewMode myActiveMode;

    @Deprecated(forRemoval=true)
    public GraphBuilderImpl(@NotNull Project project, @NotNull Graph2D graph, @NotNull Graph2DView view2, @NotNull GraphDataModel<N, E> graphDataModel, @NotNull GraphPresentationModel<N, E> graphPresentationModel) {
        if (project == null) {
            GraphBuilderImpl.V(0);
        }
        if (graph == null) {
            GraphBuilderImpl.V(1);
        }
        if (view2 == null) {
            GraphBuilderImpl.V(2);
        }
        if (graphDataModel == null) {
            GraphBuilderImpl.V(3);
        }
        if (graphPresentationModel == null) {
            GraphBuilderImpl.V(4);
        }
        this(project, graph, view2, graphDataModel, graphPresentationModel, null);
    }

    public GraphBuilderImpl(@NotNull Project project, @NotNull Graph2D graph, @NotNull Graph2DView view2, @NotNull GraphDataModel<N, E> graphDataModel, @NotNull GraphPresentationModel<N, E> graphPresentationModel, @Nullable EditMode editMode2) {
        if (project == null) {
            GraphBuilderImpl.V(5);
        }
        if (graph == null) {
            GraphBuilderImpl.V(6);
        }
        if (view2 == null) {
            GraphBuilderImpl.V(7);
        }
        if (graphDataModel == null) {
            GraphBuilderImpl.V(8);
        }
        if (graphPresentationModel == null) {
            GraphBuilderImpl.V(9);
        }
        this.myNodeRealizers = new HashMap<GraphIdentifiable.Node.Identity, NodeRealizer>();
        this.myEdgeRealizers = new HashMap<GraphIdentifiable.Edge.Identity, EdgeRealizer>();
        this.myIsInitialized = new AtomicBoolean(false);
        this.myIsDisposed = new AtomicBoolean(false);
        this.myUpdatingPromise = new AtomicReference();
        this.myUpdaters = new HashSet<CustomGraphUpdater>();
        this.myGraphBuilderDispatcher = EventDispatcher.create(GraphBuilderListener.class);
        this.myProject = project;
        this.myGraph = graph;
        this.myGraph.setCurrentView((View)view2);
        this.myView = view2;
        this.myGraphDataMaps = new GraphDataMaps();
        this.myHierarchyManager = GraphManager.getGraphManager().createHierarchyManager((Graph)this.getGraph());
        this.myUndoManager = GraphUndoService.getInstance().setupUndoManagerFor((GraphBuilder)this);
        this.myGraphZoomManager = GraphZoomManager.getInstance(project);
        this.myGraphDataModel = graphDataModel;
        this.myGraphPresentationModel = graphPresentationModel;
        this.myGraphUpdateModel = new GraphUpdateModel((Graph)graph);
        this.myMergingUpdateQueue = new MergingUpdateQueue("YFiles", 100, true, this.myView.getJComponent(), (Disposable)this, null, true);
        this.m();
        Disposer.register((Disposable)this, this.myGraphDataModel);
        Disposer.register((Disposable)this, this.myGraphPresentationModel);
        Disposer.register((Disposable)this, (Disposable)this.myMergingUpdateQueue);
        this.myEditMode = editMode2;
        this.myActiveMode = this.myEditMode;
    }

    public final void initialize() {
        if (this.myIsInitialized.compareAndSet(false, true)) {
            WriteAction.runAndWait(() -> {
                if (this.myIsDisposed.get()) {
                    return;
                }
                this.w();
                this.updateGraph(false, this.getNodeObjects());
            });
        }
    }

    private void w() {
        WriteAction.runAndWait(() -> {
            if (this.myIsDisposed.get()) {
                return;
            }
            this.myView.setGraph2D(this.getGraph());
            this.myView.getJComponent().setFocusTraversalPolicy(new DefaultFocusTraversalPolicy());
            this.myView.getCanvasComponent().putClientProperty(GraphDataKeys.GRAPH_BUILDER, (Object)this);
            GraphBuilderImpl.W(this.myView);
            GraphBuilderImpl.V(this.myView);
            this.myView.addViewMode(new GraphPopupMode(this));
            if (this.myEditMode == null) {
                this.myEditMode = this.createDefaultEditMode();
                this.myActiveMode = this.myEditMode;
            }
            this.setupViewControllers(this.myEditMode);
            this.getGraphPresentationModel().customizeSettings((GraphBuilder)this);
        });
    }

    @RequiresEdt
    protected void setupViewControllers(@NotNull EditMode editMode2) {
        if (editMode2 == null) {
            GraphBuilderImpl.V(10);
        }
        ThreadingAssertions.assertEventDispatchThread();
        MagnifierViewMode magnifierViewMode = new MagnifierViewMode();
        magnifierViewMode.setMagnifierRadius(200);
        ((StandardGraphViewControllerBuilder)((StandardGraphViewControllerBuilder)StandardGraphViewControllerBuilder.beginSetupFor((GraphBuilder)this, this.myGraphBuilderDispatcher).setEditMode(editMode2)).setMagnifierViewMode(magnifierViewMode)).endSetup();
    }

    @RequiresEdt
    @NotNull
    protected EditMode createDefaultEditMode() {
        ThreadingAssertions.assertEventDispatchThread();
        EditMode editMode2 = GraphEditModeFactory.getInstance((Project)this.getProject()).createEditMode((GraphBuilder)this);
        editMode2.assignNodeLabel(false);
        editMode2.allowResizeNodes(true);
        editMode2.allowNodeCreation(false);
        editMode2.allowEdgeCreation(true);
        editMode2.allowMoveLabels(true);
        editMode2.allowMovePorts(true);
        editMode2.allowMoveSelection(true);
        editMode2.allowMovingWithPopup(true);
        editMode2.showNodeTips(true);
        editMode2.showEdgeTips(true);
        EditMode editMode3 = editMode2;
        if (editMode3 == null) {
            GraphBuilderImpl.V(11);
        }
        return editMode3;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public void updateGraph(boolean bl) {
        void doLayout2;
        ThreadingAssertions.assertEventDispatchThread();
        if (this.myIsDisposed.get()) {
            return;
        }
        this.updateGraph((boolean)doLayout2, Collections.emptyList());
    }

    protected void updateGraph(boolean doLayout2, @NotNull Collection<N> nodesForSizeUpdate) {
        if (nodesForSizeUpdate == null) {
            GraphBuilderImpl.V(12);
        }
        try {
            this.updateDataModel();
            this.updateView(doLayout2 ? this.getGraphPresentationModel().getSettings().getCurrentLayouter() : null, nodesForSizeUpdate);
        }
        catch (ProcessCanceledException processCanceledException) {
            this.queueUpdate();
        }
    }

    @NotNull
    protected CompletableFuture<Void> updateGraphAsync(@Nullable Layouter layouter, @NotNull Collection<N> nodesForSizeUpdate) {
        if (nodesForSizeUpdate == null) {
            GraphBuilderImpl.V(13);
        }
        CompletionStage completionStage = ((CompletableFuture)Futures.runInEdtAsync(() -> this.updateGraph(false, nodesForSizeUpdate)).thenComposeAsync(ClientId.decorateFunction(void_ -> layouter != null ? this.V(layouter) : CompletableFuture.completedFuture(null)))).thenRunAsync(() -> this.getGraph().updateViews(), Futures.inEdt());
        if (completionStage == null) {
            GraphBuilderImpl.V(14);
        }
        return completionStage;
    }

    @NotNull
    public GraphBuilder.GraphUpdateQueryParams<N, E> queryGraphUpdate() {
        return new GraphUpdateQueryParamsImpl();
    }

    protected void runGraphUpdate(@NotNull GraphUpdateQueryParamsImpl params2) {
        if (params2 == null) {
            GraphBuilderImpl.V(15);
        }
        if (params2.V()) {
            this.updateGraph(params2.V() != null);
        } else {
            this.updateView(params2.V(), params2.V());
        }
    }

    @NotNull
    protected CompletableFuture<Void> runGraphUpdateAsync(@NotNull GraphUpdateQueryParamsImpl params2) {
        if (params2 == null) {
            GraphBuilderImpl.V(16);
        }
        if (params2.V()) {
            CompletableFuture<Void> completableFuture = this.updateGraphAsync(params2.V(), params2.V());
            if (completableFuture == null) {
                GraphBuilderImpl.V(17);
            }
            return completableFuture;
        }
        CompletableFuture<Void> completableFuture = this.updateViewAsync(params2.V(), params2.V());
        if (completableFuture == null) {
            GraphBuilderImpl.V(18);
        }
        return completableFuture;
    }

    @RequiresEdt
    public void updateDataModel() {
        ThreadingAssertions.assertEventDispatchThread();
        this.updateDataModelWithCustomMapping(null, null);
    }

    public void updateDataModelWithCustomMapping(@Nullable Function<? super N, ? extends Node> nodeMapping, @Nullable Function<? super E, ? extends Edge> edgeMapping) {
        if (!this.V()) {
            this.initialize();
        }
        GraphDataModel<N, E> graphDataModel = this.getGraphDataModel();
        HashSet hashSet = new HashSet(graphDataModel.getNodes());
        HashSet hashSet2 = new HashSet(graphDataModel.getEdges());
        for (Object e10 : hashSet) {
            this.V(graphDataModel.getNodeName(e10), e10, new Object[]{e10}, nodeMapping);
        }
        for (Object e10 : hashSet2) {
            this.V(graphDataModel.getSourceNode(e10), graphDataModel.getTargetNode(e10), graphDataModel.getEdgeName(e10), e10, new Object[]{e10}, edgeMapping);
        }
        this.V((Graph)this.getGraph(), hashSet);
        this.V((Graph)this.getGraph(), hashSet2);
    }

    private void V(@NotNull Graph graph, @NotNull Set<N> set) {
        if (graph == null) {
            GraphBuilderImpl.V(19);
        }
        if (set == null) {
            GraphBuilderImpl.V(20);
        }
        List<Node> list = Stream.of(Arrays.stream(graph.getNodeArray()), this.getDataMaps().getNodeObjectDataBiMap().keySet().stream(), this.getDataMaps().getNodeNameDataMap().keySet().stream(), this.getDataMaps().getNodeEqualityDataMap().keySet().stream(), this.getDataMaps().getDraggedNodesList().stream()).flatMap(stream -> stream).collect(Collectors.toList());
        list.removeIf(node -> set.contains(this.getNodeObject((Node)node)) || this.getGroupNodeObject((Node)node) != null);
        this.getDataMaps().removeNodes(list);
        for (Node node2 : list) {
            Graph graph2 = node2.getGraph();
            if (graph2 == null || !graph2.contains(node2)) continue;
            graph2.removeNode(node2);
        }
    }

    private void V(@NotNull Graph graph, @NotNull HashSet<E> hashSet) {
        if (graph == null) {
            GraphBuilderImpl.V(21);
        }
        if (hashSet == null) {
            GraphBuilderImpl.V(22);
        }
        List<Edge> list = Stream.of(Arrays.stream(graph.getEdgeArray()), this.getDataMaps().getEdgeObjectDataBiMap().keySet().stream(), this.getDataMaps().getEdgeNameDataMap().keySet().stream(), this.getDataMaps().getEdgeEqualityDataMap().keySet().stream()).flatMap(stream -> stream).collect(Collectors.toList());
        list.removeIf(edge -> hashSet.contains(this.getEdgeObject((Edge)edge)) || this.getCollapsedEdgeObject((Edge)edge) != null);
        this.getDataMaps().removeEdges(list);
        for (Edge edge2 : list) {
            Graph graph2 = edge2.getGraph();
            if (graph2 == null || !graph2.contains(edge2)) continue;
            graph2.removeEdge(edge2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public void updateView(boolean bl) {
        void doLayout2;
        ThreadingAssertions.assertEventDispatchThread();
        this.updateView(doLayout2 != false ? this.getGraphPresentationModel().getSettings().getCurrentLayouter() : null, Collections.emptyList());
    }

    @RequiresEdt
    protected void updateView(@Nullable Layouter layouter, @NotNull Collection<N> nodesForSizeUpdate) {
        if (nodesForSizeUpdate == null) {
            GraphBuilderImpl.V(23);
        }
        ThreadingAssertions.assertEventDispatchThread();
        this.updateGroups();
        this.updateRealizers(false, nodesForSizeUpdate);
        this.updateBridges();
        this.updateGrid();
        for (CustomGraphUpdater customGraphUpdater : this.myUpdaters) {
            customGraphUpdater.update(this.getGraph(), this.getView(), nodesForSizeUpdate);
        }
        if (layouter != null) {
            this.V(layouter);
        }
        this.getGraph().updateViews();
    }

    @NotNull
    protected CompletableFuture<Void> updateViewAsync(@Nullable Layouter layouter, @NotNull Collection<N> nodesForSizeUpdate) {
        if (nodesForSizeUpdate == null) {
            GraphBuilderImpl.V(24);
        }
        CompletionStage completionStage = ((CompletableFuture)Futures.runInEdtAsync(() -> {
            this.updateGroups();
            this.updateRealizers(false, nodesForSizeUpdate);
            this.updateBridges();
            this.updateGrid();
            for (CustomGraphUpdater customGraphUpdater : this.myUpdaters) {
                customGraphUpdater.update(this.getGraph(), this.getView(), nodesForSizeUpdate);
            }
        }).thenComposeAsync(ClientId.decorateFunction(void_ -> layouter != null ? this.V(layouter) : CompletableFuture.completedFuture(null)))).thenRunAsync(() -> this.getGraph().updateViews(), Futures.inEdt());
        if (completionStage == null) {
            GraphBuilderImpl.V(25);
        }
        return completionStage;
    }

    public void setNodeRealizer(@NotNull Node node, @NotNull NodeRealizer newNodeRealizer) {
        if (node == null) {
            GraphBuilderImpl.V(26);
        }
        if (newNodeRealizer == null) {
            GraphBuilderImpl.V(27);
        }
        this.getGraph().setRealizer(node, newNodeRealizer);
        this.myNodeRealizers.put(this.getNodeIdentity(node), newNodeRealizer);
    }

    @Nullable
    public NodeRealizer getNodeRealizer(@NotNull Node node) {
        if (node == null) {
            GraphBuilderImpl.V(28);
        }
        return this.myNodeRealizers.get(this.getNodeIdentity(node));
    }

    public void setEdgeRealizer(@NotNull Edge edge, @NotNull EdgeRealizer newEdgeRealizer) {
        if (edge == null) {
            GraphBuilderImpl.V(29);
        }
        if (newEdgeRealizer == null) {
            GraphBuilderImpl.V(30);
        }
        this.getGraph().setRealizer(edge, newEdgeRealizer);
        this.myEdgeRealizers.put(this.getEdgeIdentity(edge), newEdgeRealizer);
    }

    @Nullable
    public EdgeRealizer getEdgeRealizer(@NotNull Edge edge) {
        if (edge == null) {
            GraphBuilderImpl.V(31);
        }
        return this.myEdgeRealizers.get(this.getEdgeIdentity(edge));
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public void updateRealizers(boolean bl) {
        void updateAllNodes;
        ThreadingAssertions.assertEventDispatchThread();
        this.updateRealizers((boolean)updateAllNodes, Collections.emptyList());
    }

    protected void updateRealizers(boolean updateAllNodes, @NotNull Collection<? extends N> nodesForSizeUpdate) {
        if (nodesForSizeUpdate == null) {
            GraphBuilderImpl.V(32);
        }
        Set set = ContainerUtil.map2SetNotNull(nodesForSizeUpdate, this::getNode);
        for (Node node : GraphImplUtil.getNodes((Graph)this.getGraph())) {
            this.updateNodeRealizer(node, set.contains(node));
        }
        for (Edge edge : GraphImplUtil.getEdges((Graph)this.getGraph())) {
            this.updateEdgeRealizer(edge);
        }
    }

    protected void updateNodeRealizer(@NotNull Node node, boolean doNodeSizeUpdate) {
        if (node == null) {
            GraphBuilderImpl.V(33);
        }
        NodeRealizer nodeRealizer = this.getNodeRealizer(node);
        NodeRealizer nodeRealizer2 = this.V(node);
        this.setNodeRealizer(node, nodeRealizer2);
        if (nodeRealizer != null) {
            this.setRenderedNodeSizes(node, doNodeSizeUpdate ? null : nodeRealizer);
            nodeRealizer2.setX(nodeRealizer.getX());
            nodeRealizer2.setY(nodeRealizer.getY());
            nodeRealizer2.setSelected(nodeRealizer.isSelected());
            this.updateNodeLabels(node, nodeRealizer, nodeRealizer2);
        } else {
            this.setRenderedNodeSizes(node, null);
            this.updateNodeLabels(node, null, nodeRealizer2);
        }
    }

    @NotNull
    private NodeRealizer V(@NotNull Node node) {
        NodeGroupDescriptor nodeGroupDescriptor;
        if (node == null) {
            GraphBuilderImpl.V(34);
        }
        if (GraphGroupingService.getInstance().isGroupOrFolderNode((GraphBuilder)this, node) && (nodeGroupDescriptor = GraphGroupingService.getInstance().getGroupDescriptor((GraphBuilder)this, node)) != null) {
            NodeRealizer nodeRealizer = (NodeRealizer)Objects.requireNonNullElseGet(nodeGroupDescriptor.createGroupNodeRealizer(), () -> GraphGroupingUtil.createDefaultGroupNodeRealizer(nodeGroupDescriptor.getGroupName(), EditorColorsManager.getInstance().getGlobalScheme().getDefaultForeground(), null, nodeGroupDescriptor.isClosed()));
            if (nodeRealizer == null) {
                GraphBuilderImpl.V(35);
            }
            return nodeRealizer;
        }
        NodeRealizer nodeRealizer = this.getGraphPresentationModel().getNodeRealizer(this.getNodeObject(node));
        if (nodeRealizer == null) {
            GraphBuilderImpl.V(36);
        }
        return nodeRealizer;
    }

    protected void setRenderedNodeSizes(@NotNull Node node, @Nullable NodeRealizer oldRealizer) {
        if (node == null) {
            GraphBuilderImpl.V(37);
        }
        Graph2D graph2D = this.getGraph();
        NodeRealizer nodeRealizer = graph2D.getRealizer(node);
        if (oldRealizer != null) {
            graph2D.setSize(node, GraphManager.getGraphManager().createYDimension(oldRealizer.getWidth(), oldRealizer.getHeight()));
        } else {
            Object object;
            NodeCellRenderer nodeCellRenderer = GraphNodeRealizerService.getInstance().getNodeCellRenderer(nodeRealizer);
            N n2 = this.getNodeObject(node);
            if (nodeCellRenderer != null && n2 != null) {
                object = nodeCellRenderer.getNodeCellRendererComponent(this.getView(), nodeRealizer, n2, nodeRealizer.isSelected()).getPreferredSize();
                graph2D.setSize(node, GraphManager.getGraphManager().createYDimension((double)object.width, (double)object.height));
            }
            if (nodeRealizer instanceof GroupNodeRealizer) {
                object = (GroupNodeRealizer)nodeRealizer;
                if (object.isGroupClosed()) {
                    NodeLabel nodeLabel = object.getLabel();
                    if (nodeLabel != null) {
                        graph2D.setSize(node, nodeLabel.getWidth(), 2.0 * nodeLabel.getHeight());
                    }
                } else {
                    object.updateAutoSizeBounds();
                }
            }
        }
    }

    public void updateEdgeRealizer(@NotNull Edge edge) {
        if (edge == null) {
            GraphBuilderImpl.V(38);
        }
        EdgeRealizer edgeRealizer = this.getEdgeRealizer(edge);
        EdgeRealizer edgeRealizer2 = this.getGraphPresentationModel().getEdgeRealizer(this.getEdgeObject(edge));
        this.setEdgeRealizer(edge, edgeRealizer2);
        if (edgeRealizer != null) {
            GraphEdgeRealizerService.getInstance().copyEdgeLayout(edgeRealizer, edgeRealizer2);
            edgeRealizer2.setSelected(edgeRealizer.isSelected());
            this.updateEdgeLabels(edge, edgeRealizer, edgeRealizer2);
        } else {
            this.updateEdgeLabels(edge, null, edgeRealizer2);
        }
    }

    protected void updateNodeLabels(@NotNull Node node, @Nullable NodeRealizer oldNodeRealizer, @NotNull NodeRealizer newNodeRealizer) {
        if (node == null) {
            GraphBuilderImpl.V(39);
        }
        if (newNodeRealizer == null) {
            GraphBuilderImpl.V(40);
        }
        NodeLabel[] nodeLabelArray = this.getGraphPresentationModel().getNodeLabels(this.getNodeObject(node), GraphImplUtil.getNodeName(this.getDataMaps(), node));
        Map<String, List<NodeLabel>> map = GraphImplUtil.getNodeLabels(oldNodeRealizer).stream().collect(Collectors.groupingBy(nodeLabel -> nodeLabel.getText()));
        for (NodeLabel nodeLabel2 : nodeLabelArray) {
            List<NodeLabel> list = map.get(nodeLabel2.getText());
            if (list != null && list.size() > 0) {
                NodeLabel nodeLabel3 = list.remove(list.size() - 1);
                nodeLabel2.setLabelModel(nodeLabel3.getLabelModel(), nodeLabel3.getModelParameter());
            }
            newNodeRealizer.addLabel(nodeLabel2);
        }
    }

    protected void updateEdgeLabels(@NotNull Edge edge, @Nullable EdgeRealizer oldEdgeRealizer, @NotNull EdgeRealizer newEdgeRealizer) {
        if (edge == null) {
            GraphBuilderImpl.V(41);
        }
        if (newEdgeRealizer == null) {
            GraphBuilderImpl.V(42);
        }
        if (!this.getGraphPresentationModel().getSettings().isShowEdgeLabels()) {
            return;
        }
        EdgeLabel[] edgeLabelArray = this.getGraphPresentationModel().getEdgeLabels(this.getEdgeObject(edge), GraphImplUtil.getEdgeName(this.getDataMaps(), edge));
        Map<String, List<EdgeLabel>> map = GraphImplUtil.getEdgeLabels(oldEdgeRealizer).stream().collect(Collectors.groupingBy(edgeLabel -> edgeLabel.getText()));
        for (EdgeLabel edgeLabel2 : edgeLabelArray) {
            List<EdgeLabel> list = map.get(edgeLabel2.getText());
            if (list != null && list.size() > 0) {
                EdgeLabel edgeLabel3 = list.remove(list.size() - 1);
                edgeLabel2.setLabelModel(edgeLabel3.getLabelModel(), edgeLabel3.getModelParameter());
            }
            newEdgeRealizer.addLabel(edgeLabel2);
        }
    }

    protected void updateBridges() {
        GraphPresentationModel<N, E> graphPresentationModel = this.getGraphPresentationModel();
        if (graphPresentationModel instanceof BasicGraphPresentationModel) {
            BasicGraphPresentationModel basicGraphPresentationModel = (BasicGraphPresentationModel)graphPresentationModel;
            basicGraphPresentationModel.setupBridgesFor(this.getView().getGraph2DRenderer());
        }
    }

    protected void updateGrid() {
        this.getView().setGridVisible(this.getGraphPresentationModel().getSettings().isShowGrid());
    }

    @Deprecated
    private void V(@Nullable Layouter layouter) {
        if (this.getGraph().nodeCount() > 0) {
            GraphLayoutService.getInstance().queryLayout((GraphBuilder)this).withLayouter(layouter != null ? layouter : this.getGraphPresentationModel().getSettings().getCurrentLayouter()).run();
        }
    }

    @NotNull
    private CompletableFuture<Void> V(@Nullable Layouter layouter) {
        CompletableFuture completableFuture = GraphLayoutService.getInstance().queryLayout((GraphBuilder)this).withLayouter(layouter != null ? layouter : this.getGraphPresentationModel().getSettings().getCurrentLayouter()).runAsync();
        if (completableFuture == null) {
            GraphBuilderImpl.V(43);
        }
        return completableFuture;
    }

    public final boolean isUpdating() {
        return this.myUpdatingPromise.get() != null;
    }

    public final void queueUpdate() {
        this.doQueueUpdate(new GraphUpdateQueryParamsImpl().withDataReload().withRelayout());
    }

    @NotNull
    protected Promise<Void> doQueueUpdate(final @NotNull GraphUpdateQueryParamsImpl params2) {
        AsyncPromise asyncPromise;
        Promise<Void> promise;
        if (params2 == null) {
            GraphBuilderImpl.V(44);
        }
        if ((promise = this.myUpdatingPromise.compareAndExchange(null, (Promise<Void>)(asyncPromise = new AsyncPromise()))) == asyncPromise) {
            ApplicationManager.getApplication().invokeLater(() -> {
                final Cursor cursor = this.myView.getJComponent().getCursor();
                this.myView.getJComponent().setCursor(Cursor.getPredefinedCursor(3));
                this.myMergingUpdateQueue.queue(new Update("Update"){

                    public void run() {
                        GraphBuilderImpl.this.runGraphUpdate(params2);
                        GraphBuilderImpl.this.myView.getJComponent().setCursor(cursor);
                        ((AsyncPromise)promise).setResult(null);
                        GraphBuilderImpl.this.myUpdatingPromise.set(null);
                    }
                });
            });
        }
        Promise<Void> promise2 = promise;
        if (promise2 == null) {
            GraphBuilderImpl.V(45);
        }
        return promise2;
    }

    @NotNull
    public GraphDataModel<N, E> getGraphDataModel() {
        GraphDataModel<N, E> graphDataModel = this.myGraphDataModel;
        if (graphDataModel == null) {
            GraphBuilderImpl.V(46);
        }
        return graphDataModel;
    }

    @NotNull
    public String getNodeName(@NotNull Node node) {
        if (node == null) {
            GraphBuilderImpl.V(47);
        }
        String string = GraphImplUtil.getNodeName(this.getDataMaps(), node);
        if (string == null) {
            GraphBuilderImpl.V(48);
        }
        return string;
    }

    @Nullable
    public N getNodeObject(@Nullable Node node) {
        return node != null ? (N)GraphImplUtil.getNodeObject(this.getDataMaps(), node) : null;
    }

    @Nullable
    public E getEdgeObject(@Nullable Edge edge) {
        return edge != null ? (E)GraphImplUtil.getEdgeObject(this.getDataMaps(), edge) : null;
    }

    @Nullable
    public NodeGroupDescriptor getGroupNodeObject(@Nullable Node node) {
        return node != null ? GraphImplUtil.getGroupNodeObject(this.getDataMaps(), node) : null;
    }

    @Nullable
    public CollapsedEdge getCollapsedEdgeObject(@Nullable Edge edge) {
        return edge != null ? GraphImplUtil.getCollapsedEdgeObject(this.getDataMaps(), edge) : null;
    }

    protected void updateGroups() {
        GraphGroupingService.getInstance().updateGroups((GraphBuilder)this, this.myGraphPresentationModel.getSettings().isCollapseEdgesOnGrouping());
    }

    public void addNode(N nodeObject) {
        this.addNode(this.getGraphDataModel().getNodeName(nodeObject), nodeObject);
    }

    public void addNode(@NotNull String name, N nodeObject) {
        if (name == null) {
            GraphBuilderImpl.V(49);
        }
        this.V(name, nodeObject, new Object[]{nodeObject}, null);
    }

    private void V(@NotNull String string, N n2, Object[] objectArray, @Nullable Function<? super N, ? extends Node> function) {
        if (string == null) {
            GraphBuilderImpl.V(50);
        }
        if (function == null) {
            function = object2 -> Objects.requireNonNullElseGet(GraphImplUtil.getExistedNode(this.getDataMaps(), string, objectArray), () -> GraphImplUtil.createNode((Graph)this.getGraph(), this.V(n2), this.getDataMaps(), string, objectArray));
        }
        Node node = Objects.requireNonNull(function.apply(n2));
        GraphImplUtil.setNodeName(this.getDataMaps(), node, string);
        GraphImplUtil.setNodeObject(this.getDataMaps(), node, n2);
    }

    @Nullable
    private Graph V(N n2) {
        NodeGroupDescriptor nodeGroupDescriptor = this.getGraphDataModel().getGroup(n2);
        if (nodeGroupDescriptor != null) {
            Node node = GraphImplUtil.getOrCreateGroupNode(this.getGraph(), this.getHierarchyManager(), nodeGroupDescriptor, this.getDataMaps(), this.getGraphDataModel());
            return this.V(node);
        }
        return null;
    }

    @Nullable
    private Graph V(@NotNull Node node) {
        HierarchyManager hierarchyManager;
        if (node == null) {
            GraphBuilderImpl.V(51);
        }
        if ((hierarchyManager = this.getHierarchyManager()).getRootGraph().contains(node) && hierarchyManager.isFolderNode(node)) {
            return hierarchyManager.getInnerGraph(node);
        }
        return null;
    }

    @NotNull
    public Edge addEdge(@NotNull N nodeObject1, @NotNull N nodeObject2, E edgeObject) {
        if (nodeObject1 == null) {
            GraphBuilderImpl.V(52);
        }
        if (nodeObject2 == null) {
            GraphBuilderImpl.V(53);
        }
        Edge edge = this.addEdge(nodeObject1, nodeObject2, "", edgeObject);
        if (edge == null) {
            GraphBuilderImpl.V(54);
        }
        return edge;
    }

    @RequiresEdt
    @NotNull
    public Edge addEdge(@NotNull N nodeObject1, @NotNull N nodeObject2, @NotNull String name, E edgeObject) {
        if (nodeObject1 == null) {
            GraphBuilderImpl.V(55);
        }
        if (nodeObject2 == null) {
            GraphBuilderImpl.V(56);
        }
        if (name == null) {
            GraphBuilderImpl.V(57);
        }
        ThreadingAssertions.assertEventDispatchThread();
        return this.V(nodeObject1, nodeObject2, name, edgeObject, new Object[]{edgeObject}, null);
    }

    @NotNull
    private Edge V(@NotNull N n2, @NotNull N n3, @NotNull String string, E e10, Object[] objectArray, @Nullable Function<? super E, ? extends Edge> function) {
        if (n2 == null) {
            GraphBuilderImpl.V(58);
        }
        if (n3 == null) {
            GraphBuilderImpl.V(59);
        }
        if (string == null) {
            GraphBuilderImpl.V(60);
        }
        return this.V(this.V(n2), this.V(n3), string, e10, objectArray, function);
    }

    @NotNull
    private Edge V(@NotNull Node node, @NotNull Node node2, @NotNull String string, E e10, Object[] objectArray, @Nullable Function<? super E, ? extends Edge> function) {
        if (node == null) {
            GraphBuilderImpl.V(61);
        }
        if (node2 == null) {
            GraphBuilderImpl.V(62);
        }
        if (string == null) {
            GraphBuilderImpl.V(63);
        }
        if (function == null) {
            function = object -> Objects.requireNonNullElseGet(GraphImplUtil.getExistedEdge(this.getDataMaps(), node, node2, string, objectArray), () -> GraphImplUtil.createEdge(this.getHierarchyManager(), this.getDataMaps(), node, node2, string, objectArray));
        }
        Edge edge = Objects.requireNonNull(function.apply(e10));
        GraphImplUtil.setEdgeObject(this.getDataMaps(), edge, e10);
        Edge edge2 = edge;
        if (edge2 == null) {
            GraphBuilderImpl.V(64);
        }
        return edge2;
    }

    @NotNull
    private Node V(N n2) {
        Node node = this.getNode(n2);
        if (node == null) {
            this.addNode(n2);
            node = this.getNode(n2);
        }
        if (node == null) {
            LOG.error("null node for " + n2 + " in " + this.myGraphDataModel);
        }
        Node node2 = node;
        if (node2 == null) {
            GraphBuilderImpl.V(65);
        }
        return node2;
    }

    public void dispose() {
        if (this.myIsDisposed.compareAndSet(false, true)) {
            this.myProject = null;
            if (this.myEditMode != null) {
                Disposer.dispose((Disposable)this.myEditMode);
            }
            this.myMergingUpdateQueue.cancelAllUpdates();
            Disposer.dispose((Disposable)this.myMergingUpdateQueue);
            this.myGraphDataMaps.dispose();
            this.myHierarchyManager.dispose();
            this.myUndoManager.dispose();
            this.myGraphZoomManager.dispose();
            this.clearUserData();
            GraphSelectionService.getInstance().onGraphBuilderDispose((GraphBuilder)this);
            GraphBuilderImpl.V(this.myGraph);
            GraphBuilderImpl.P(this.myGraph);
            GraphBuilderImpl.W(this.myGraph);
            this.myGraph.clear();
        }
    }

    private static void V(@NotNull Graph2D graph2D) {
        if (graph2D == null) {
            GraphBuilderImpl.V(66);
        }
        for (Object object : ArrayUtil.copyOf((Object[])graph2D.getDataProviderKeys())) {
            graph2D.removeDataProvider(object);
        }
    }

    private static void P(@NotNull Graph2D graph2D) {
        if (graph2D == null) {
            GraphBuilderImpl.V(67);
        }
        ArrayList arrayList = new ArrayList();
        graph2D.getGraphListeners().forEachRemaining(object -> {
            Object object2;
            Object object3 = object2 = object instanceof GraphListener ? object : GraphBase.unwrap(object, null);
            if (object2 instanceof GraphListener) {
                arrayList.add((GraphListener)object2);
            }
        });
        for (GraphListener graphListener : arrayList) {
            graph2D.removeGraphListener(graphListener);
        }
    }

    private static void W(@NotNull Graph2D graph2D) {
        if (graph2D == null) {
            GraphBuilderImpl.V(68);
        }
        ArrayList arrayList = new ArrayList();
        graph2D.getGraph2DSelectionListeners().forEachRemaining(object -> {
            Object object2 = object instanceof Graph2DSelectionListener ? object : GraphBase.unwrap(object, null);
            arrayList.add((Graph2DSelectionListener)object2);
        });
        for (Graph2DSelectionListener graph2DSelectionListener : arrayList) {
            graph2D.removeGraph2DSelectionListener(graph2DSelectionListener);
        }
    }

    @Nullable
    public String getNodeName(@Nullable N nodeObject) {
        Node node = this.getNode(nodeObject);
        return node == null ? null : GraphImplUtil.getNodeName(this.getDataMaps(), node);
    }

    @Nullable
    public String getEdgeName(@Nullable E edgeObject) {
        Edge edge = this.getEdge(edgeObject);
        return edge == null ? null : GraphImplUtil.getEdgeName(this.getDataMaps(), edge);
    }

    @Nullable
    public Node getNode(@Nullable N nodeObject) {
        return nodeObject == null ? null : GraphImplUtil.getNode(this.getDataMaps(), nodeObject);
    }

    @Nullable
    public Edge getEdge(@Nullable E edgeObject) {
        return edgeObject != null ? GraphImplUtil.getEdge(this.getDataMaps(), edgeObject) : null;
    }

    @Nullable
    public Node getGroupNode(@Nullable NodeGroupDescriptor groupNodeObject) {
        return groupNodeObject == null ? null : GraphImplUtil.getGroupNode(this.getDataMaps(), groupNodeObject);
    }

    @Nullable
    public Edge getCollapsedEdge(@Nullable CollapsedEdge collapsedEdgeObject) {
        return collapsedEdgeObject == null ? null : GraphImplUtil.getCollapsedEdge(this.getDataMaps(), collapsedEdgeObject);
    }

    @NotNull
    public final Graph2D getGraph() {
        Graph2D graph2D = this.myGraph;
        if (graph2D == null) {
            GraphBuilderImpl.V(69);
        }
        return graph2D;
    }

    @NotNull
    public Graph2DView getView() {
        Graph2DView graph2DView = this.myView;
        if (graph2DView == null) {
            GraphBuilderImpl.V(70);
        }
        return graph2DView;
    }

    @NotNull
    public Project getProject() {
        String string = "GraphBuilder has been already disposed";
        if (this.myIsDisposed.get()) {
            throw new CancellationException(string);
        }
        Project project = Objects.requireNonNull(this.myProject, string);
        if (project == null) {
            GraphBuilderImpl.V(71);
        }
        return project;
    }

    @Deprecated
    @NotNull
    public GraphUpdateModel getGraphUpdateModel() {
        GraphUpdateModel graphUpdateModel = this.myGraphUpdateModel;
        if (graphUpdateModel == null) {
            GraphBuilderImpl.V(72);
        }
        return graphUpdateModel;
    }

    @NotNull
    public GraphPresentationModel<N, E> getGraphPresentationModel() {
        GraphPresentationModel<N, E> graphPresentationModel = this.myGraphPresentationModel;
        if (graphPresentationModel == null) {
            GraphBuilderImpl.V(73);
        }
        return graphPresentationModel;
    }

    public double getZoom() {
        return this.getView().getZoom();
    }

    public void setZoom(double zoom) {
        this.setZoom(zoom, true);
    }

    public void setZoom(double zoom, boolean fireEvents) {
        this.setZoom(zoom, fireEvents, () -> {});
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public void setZoom(double d2, boolean bl, GraphBuilder.ZoomChangedEvent zoomChangedEvent) {
        void zoomChangedEvent2;
        void fireEvents;
        void zoom;
        ThreadingAssertions.assertEventDispatchThread();
        double d3 = MathUtil.clamp((double)zoom, (double)1.4E-45f, (double)20.0);
        this.myGraphZoomManager.setZoom(this, d3, (Function0<Unit>)((Function0)() -> this.V((boolean)fireEvents)), (Function0<Unit>)((Function0)() -> this.V((boolean)fireEvents, (GraphBuilder.ZoomChangedEvent)zoomChangedEvent2)));
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public void fitContent(boolean bl) {
        void animated;
        ThreadingAssertions.assertEventDispatchThread();
        this.fireEvent(GraphBuilderEvent.ZOOM_CHANGED, true);
        Graph2DView graph2DView = this.getView();
        GraphAnimationService.getInstance().fitContent(graph2DView, (boolean)animated);
        graph2DView.updateView();
        this.fireEvent(GraphBuilderEvent.ZOOM_CHANGED, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireEvent(@NotNull GraphBuilderEvent event, boolean before) {
        if (event == null) {
            GraphBuilderImpl.V(74);
        }
        EventDispatcher<GraphBuilderListener> eventDispatcher = this.myGraphBuilderDispatcher;
        synchronized (eventDispatcher) {
            if (before) {
                ((GraphBuilderListener)this.myGraphBuilderDispatcher.getMulticaster()).beforeActionPerformed((GraphBuilder)this, event);
            } else {
                ((GraphBuilderListener)this.myGraphBuilderDispatcher.getMulticaster()).actionPerformed((GraphBuilder)this, event);
            }
        }
    }

    private boolean V() {
        return this.myIsInitialized.get();
    }

    private void m() {
        GraphDataKeys.addDataProvider((Graph2DView)this.getView(), string -> {
            if (DeleteProvider.DELETE_PROVIDER.is(string)) {
                return this.getGraphPresentationModel().getDeleteProvider();
            }
            if (GraphDataKeys.GRAPH_BUILDER.is(string)) {
                return this;
            }
            return null;
        });
    }

    @NotNull
    public HierarchyManager getHierarchyManager() {
        HierarchyManager hierarchyManager = this.myHierarchyManager;
        if (hierarchyManager == null) {
            GraphBuilderImpl.V(75);
        }
        return hierarchyManager;
    }

    public void setHierarchyManager(@NotNull HierarchyManager hierarchyManager) {
        if (hierarchyManager == null) {
            GraphBuilderImpl.V(76);
        }
        this.myHierarchyManager = hierarchyManager;
    }

    @NotNull
    public Graph2DUndoManager getUndoManager() {
        Graph2DUndoManager graph2DUndoManager = this.myUndoManager;
        if (graph2DUndoManager == null) {
            GraphBuilderImpl.V(77);
        }
        return graph2DUndoManager;
    }

    public void addCustomUpdater(@NotNull CustomGraphUpdater updater) {
        if (updater == null) {
            GraphBuilderImpl.V(78);
        }
        this.myUpdaters.add(updater);
    }

    public void removeCustomUpdater(@NotNull CustomGraphUpdater updater) {
        if (updater == null) {
            GraphBuilderImpl.V(79);
        }
        this.myUpdaters.remove(updater);
    }

    @NotNull
    public EditMode getEditMode() {
        EditMode editMode2 = (EditMode)ReadAction.compute(() -> this.myEditMode);
        if (editMode2 == null) {
            GraphBuilderImpl.V(80);
        }
        return editMode2;
    }

    @NotNull
    public ViewMode getActiveMode() {
        assert (this.myActiveMode != null);
        ViewMode viewMode = this.myActiveMode;
        if (viewMode == null) {
            GraphBuilderImpl.V(81);
        }
        return viewMode;
    }

    @RequiresEdt
    public void setActiveMode(@NotNull ViewMode activeMode) {
        if (activeMode == null) {
            GraphBuilderImpl.V(82);
        }
        ThreadingAssertions.assertEventDispatchThread();
        this.myActiveMode = activeMode;
    }

    @RequiresReadLock
    public boolean isCellEditing() {
        ThreadingAssertions.softAssertReadAccess();
        assert (this.myEditMode != null);
        ViewMode viewMode = this.myEditMode.getEditNodeMode();
        return viewMode instanceof CellEditorMode && ((CellEditorMode)viewMode).isCellEditing();
    }

    @ApiStatus.Internal
    @NotNull
    public EventDispatcher<GraphBuilderListener> getGraphBuilderDispatcher() {
        EventDispatcher<GraphBuilderListener> eventDispatcher = this.myGraphBuilderDispatcher;
        if (eventDispatcher == null) {
            GraphBuilderImpl.V(83);
        }
        return eventDispatcher;
    }

    @NotNull
    public GraphDataMaps<N, E> getDataMaps() {
        GraphDataMaps<N, E> graphDataMaps = this.myGraphDataMaps;
        if (graphDataMaps == null) {
            GraphBuilderImpl.V(84);
        }
        return graphDataMaps;
    }

    @RequiresReadLock
    @NotNull
    public Collection<N> getNodeObjects() {
        ThreadingAssertions.softAssertReadAccess();
        Collection collection = Collections.unmodifiableCollection(this.getDataMaps().getNodeObjectDataBiMap().values());
        if (collection == null) {
            GraphBuilderImpl.V(85);
        }
        return collection;
    }

    @RequiresReadLock
    @NotNull
    public Collection<E> getEdgeObjects() {
        ThreadingAssertions.softAssertReadAccess();
        Collection collection = Collections.unmodifiableCollection(this.getDataMaps().getEdgeObjectDataBiMap().values());
        if (collection == null) {
            GraphBuilderImpl.V(86);
        }
        return collection;
    }

    @RequiresReadLock
    @NotNull
    public Collection<NodeGroupDescriptor> getGroupNodeObjects() {
        ThreadingAssertions.softAssertReadAccess();
        Collection<NodeGroupDescriptor> collection = Collections.unmodifiableCollection(this.getDataMaps().getGroupNodeDataMap().values());
        if (collection == null) {
            GraphBuilderImpl.V(87);
        }
        return collection;
    }

    @RequiresReadLock
    @NotNull
    public Collection<CollapsedEdge> getCollapsedEdgeObjects() {
        ThreadingAssertions.softAssertReadAccess();
        Collection<CollapsedEdge> collection = Collections.unmodifiableCollection(this.getDataMaps().getCollapsedEdgeDataMap().values());
        if (collection == null) {
            GraphBuilderImpl.V(88);
        }
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public boolean removeNode(@Nullable N n2) {
        void n3;
        ThreadingAssertions.assertEventDispatchThread();
        Node node = this.getNode(n3);
        if (node != null) {
            node.getGraph().removeNode(node);
            this.getDataMaps().removeNode(node);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public boolean removeEdge(@Nullable E e10) {
        void e11;
        ThreadingAssertions.assertEventDispatchThread();
        Edge edge = this.getEdge(e11);
        if (edge != null) {
            this.getGraph().removeEdge(edge);
            this.getDataMaps().removeEdge(edge);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGraphBuilderListener(@NotNull GraphBuilderListener listener2, @NotNull Disposable parent) {
        if (listener2 == null) {
            GraphBuilderImpl.V(89);
        }
        if (parent == null) {
            GraphBuilderImpl.V(90);
        }
        EventDispatcher<GraphBuilderListener> eventDispatcher = this.myGraphBuilderDispatcher;
        synchronized (eventDispatcher) {
            this.myGraphBuilderDispatcher.addListener((EventListener)listener2, parent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGraphBuilderListener(@NotNull GraphBuilderListener listener2) {
        if (listener2 == null) {
            GraphBuilderImpl.V(91);
        }
        EventDispatcher<GraphBuilderListener> eventDispatcher = this.myGraphBuilderDispatcher;
        synchronized (eventDispatcher) {
            this.myGraphBuilderDispatcher.removeListener((EventListener)listener2);
        }
    }

    @RequiresEdt
    private static void V(@NotNull Graph2DView graph2DView) {
        if (graph2DView == null) {
            GraphBuilderImpl.V(92);
        }
        ThreadingAssertions.assertEventDispatchThread();
        Graph2DViewActions graph2DViewActions = GraphManager.getGraphManager().createGraph2DViewActions(graph2DView);
        graph2DViewActions.install(graph2DView, 1);
    }

    @RequiresEdt
    private static void W(@NotNull Graph2DView graph2DView) {
        if (graph2DView == null) {
            GraphBuilderImpl.V(93);
        }
        ThreadingAssertions.assertEventDispatchThread();
        graph2DView.setAntialiasedPainting(Registry.is((String)"diagrams.rendering.antialiasing"));
        graph2DView.setFitContentOnResize(true);
        graph2DView.setGridVisible(true);
        graph2DView.setGridResolution(20.0);
        graph2DView.setGridColor((Color)Gray._239);
        graph2DView.setGridType(View2DConstants.GRID_LINES);
    }

    private /* synthetic */ Unit V(boolean bl, GraphBuilder.ZoomChangedEvent zoomChangedEvent) {
        if (bl) {
            this.fireEvent(GraphBuilderEvent.ZOOM_CHANGED, false);
            zoomChangedEvent.execute();
        }
        return Unit.INSTANCE;
    }

    private /* synthetic */ Unit V(boolean bl) {
        if (bl) {
            this.fireEvent(GraphBuilderEvent.ZOOM_CHANGED, true);
        }
        return Unit.INSTANCE;
    }

    static {
        YBundlesInitializer.init();
    }

    private static /* synthetic */ void V(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 11, 14, 17, 18, 25, 35, 36, 43, 45, 46, 48, 54, 64, 65, 69, 70, 71, 72, 73, 75, 77, 80, 81, 83, 84, 85, 86, 87, 88 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: 
            case 19: 
            case 21: 
            case 66: 
            case 67: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 2: 
            case 7: 
            case 92: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphDataModel";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphPresentationModel";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editMode";
                break;
            }
            case 11: 
            case 14: 
            case 17: 
            case 18: 
            case 25: 
            case 35: 
            case 36: 
            case 43: 
            case 45: 
            case 46: 
            case 48: 
            case 54: 
            case 64: 
            case 65: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 75: 
            case 77: 
            case 80: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/graph/impl/builder/GraphBuilderImpl";
                break;
            }
            case 12: 
            case 13: 
            case 23: 
            case 24: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodesForSizeUpdate";
                break;
            }
            case 15: 
            case 16: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newNodes";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newEdges";
                break;
            }
            case 26: 
            case 28: 
            case 33: 
            case 34: 
            case 37: 
            case 39: 
            case 47: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 27: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newNodeRealizer";
                break;
            }
            case 29: 
            case 31: 
            case 38: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edge";
                break;
            }
            case 30: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newEdgeRealizer";
                break;
            }
            case 49: 
            case 50: 
            case 57: 
            case 60: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 52: 
            case 55: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeObject1";
                break;
            }
            case 53: 
            case 56: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeObject2";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node1";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node2";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hierarchyManager";
                break;
            }
            case 78: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeMode";
                break;
            }
            case 89: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/graph/impl/builder/GraphBuilderImpl";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefaultEditMode";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "updateGraphAsync";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "runGraphUpdateAsync";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "updateViewAsync";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewNodeRealizer";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "doLayoutAsync";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "doQueueUpdate";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getGraphDataModel";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeName";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "addEdge";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "createEdge";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateNode";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "getGraph";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "getView";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "getGraphUpdateModel";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "getGraphPresentationModel";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "getHierarchyManager";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "getUndoManager";
                break;
            }
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditMode";
                break;
            }
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveMode";
                break;
            }
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "getGraphBuilderDispatcher";
                break;
            }
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataMaps";
                break;
            }
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeObjects";
                break;
            }
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdgeObjects";
                break;
            }
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupNodeObjects";
                break;
            }
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "getCollapsedEdgeObjects";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setupViewControllers";
                break;
            }
            case 11: 
            case 14: 
            case 17: 
            case 18: 
            case 25: 
            case 35: 
            case 36: 
            case 43: 
            case 45: 
            case 46: 
            case 48: 
            case 54: 
            case 64: 
            case 65: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 75: 
            case 77: 
            case 80: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "updateGraph";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "updateGraphAsync";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "runGraphUpdate";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "runGraphUpdateAsync";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "removeOutdatedNodes";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "removeOutdatedEdges";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "updateView";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "updateViewAsync";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "setNodeRealizer";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getNodeRealizer";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "setEdgeRealizer";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getEdgeRealizer";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "updateRealizers";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "updateNodeRealizer";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "createNewNodeRealizer";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "setRenderedNodeSizes";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "updateEdgeRealizer";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "updateNodeLabels";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "updateEdgeLabels";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "doQueueUpdate";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getNodeName";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "addNode";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getInnerGraph";
                break;
            }
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "addEdge";
                break;
            }
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "createEdge";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "removeAllGraphDataProviders";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "removeAllGraphListeners";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "removeAllGraphSelectionListeners";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "fireEvent";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "setHierarchyManager";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "addCustomUpdater";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "removeCustomUpdater";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "setActiveMode";
                break;
            }
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "addGraphBuilderListener";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "removeGraphBuilderListener";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "setupDefaultKeyBindingsForYFilesPredefinedActions";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultViewSettings";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 11, 14, 17, 18, 25, 35, 36, 43, 45, 46, 48, 54, 64, 65, 69, 70, 71, 72, 73, 75, 77, 80, 81, 83, 84, 85, 86, 87, 88 -> new IllegalStateException(string);
        };
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    private class GraphUpdateQueryParamsImpl
    implements GraphBuilder.GraphUpdateQueryParams<N, E> {
        private boolean myDoReloadData = false;
        @NotNull
        private final List<N> myNodesForSizeUpdate = new ArrayList();
        @Nullable
        private Layouter myLayouter;
        private boolean mySealed = false;

        private GraphUpdateQueryParamsImpl() {
        }

        @NotNull
        public GraphUpdateQueryParamsImpl withDataReload() {
            Checks.check((!this.mySealed ? 1 : 0) != 0);
            this.myDoReloadData = true;
            GraphUpdateQueryParamsImpl graphUpdateQueryParamsImpl = this;
            if (graphUpdateQueryParamsImpl == null) {
                GraphUpdateQueryParamsImpl.V(0);
            }
            return graphUpdateQueryParamsImpl;
        }

        @NotNull
        public GraphUpdateQueryParamsImpl withRelayout() {
            Checks.check((!this.mySealed ? 1 : 0) != 0);
            this.myLayouter = GraphBuilderImpl.this.getGraphPresentationModel().getSettings().getCurrentLayouter();
            GraphUpdateQueryParamsImpl graphUpdateQueryParamsImpl = this;
            if (graphUpdateQueryParamsImpl == null) {
                GraphUpdateQueryParamsImpl.V(1);
            }
            return graphUpdateQueryParamsImpl;
        }

        @NotNull
        public GraphUpdateQueryParamsImpl withRelayout(@NotNull Layouter layouter) {
            if (layouter == null) {
                GraphUpdateQueryParamsImpl.V(2);
            }
            Checks.check((!this.mySealed ? 1 : 0) != 0);
            this.myLayouter = layouter;
            GraphUpdateQueryParamsImpl graphUpdateQueryParamsImpl = this;
            if (graphUpdateQueryParamsImpl == null) {
                GraphUpdateQueryParamsImpl.V(3);
            }
            return graphUpdateQueryParamsImpl;
        }

        @NotNull
        public GraphUpdateQueryParamsImpl withAllNodeSizeUpdate() {
            Checks.check((!this.mySealed ? 1 : 0) != 0);
            ContainerUtil.addAll(this.myNodesForSizeUpdate, GraphBuilderImpl.this.getNodeObjects());
            GraphUpdateQueryParamsImpl graphUpdateQueryParamsImpl = this;
            if (graphUpdateQueryParamsImpl == null) {
                GraphUpdateQueryParamsImpl.V(4);
            }
            return graphUpdateQueryParamsImpl;
        }

        @NotNull
        public GraphUpdateQueryParamsImpl withNodeSizeUpdate(N ... nodes2) {
            if (nodes2 == null) {
                GraphUpdateQueryParamsImpl.V(5);
            }
            Checks.check((!this.mySealed ? 1 : 0) != 0);
            ContainerUtil.addAll(this.myNodesForSizeUpdate, (Object[])nodes2);
            GraphUpdateQueryParamsImpl graphUpdateQueryParamsImpl = this;
            if (graphUpdateQueryParamsImpl == null) {
                GraphUpdateQueryParamsImpl.V(6);
            }
            return graphUpdateQueryParamsImpl;
        }

        private boolean V() {
            return this.myDoReloadData;
        }

        @NotNull
        private List<N> V() {
            List list = this.myNodesForSizeUpdate;
            if (list == null) {
                GraphUpdateQueryParamsImpl.V(7);
            }
            return list;
        }

        @Nullable
        private Layouter V() {
            return this.myLayouter;
        }

        public void run() {
            this.mySealed = true;
            GraphBuilderImpl.this.runGraphUpdate(this);
        }

        @NotNull
        public CompletableFuture<Void> runAsync() {
            this.mySealed = true;
            CompletionStage completionStage = GraphBuilderImpl.this.runGraphUpdateAsync(this).whenComplete(Futures.logIfFailed(GraphBuilderImpl.class));
            if (completionStage == null) {
                GraphUpdateQueryParamsImpl.V(8);
            }
            return completionStage;
        }

        private static /* synthetic */ void V(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n2) {
                default -> 2;
                case 2, 5 -> 3;
            }];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/graph/impl/builder/GraphBuilderImpl$GraphUpdateQueryParamsImpl";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "layouter";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodes";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withDataReload";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withRelayout";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/graph/impl/builder/GraphBuilderImpl$GraphUpdateQueryParamsImpl";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withAllNodeSizeUpdate";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withNodeSizeUpdate";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNodesForSizeUpdate";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "runAsync";
                    break;
                }
            }
            switch (n2) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "withRelayout";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "withNodeSizeUpdate";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n2) {
                default -> new IllegalStateException(string);
                case 2, 5 -> new IllegalArgumentException(string);
            };
        }
    }
}

