/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.impl;

import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.EdgeCursor;
import com.intellij.openapi.graph.base.Graph;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.base.NodeCursor;
import com.intellij.openapi.graph.base.NodeList;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.GraphDataModel;
import com.intellij.openapi.graph.builder.GraphIdentifiable;
import com.intellij.openapi.graph.builder.NodeGroupDescriptor;
import com.intellij.openapi.graph.builder.edges.CollapsedEdge;
import com.intellij.openapi.graph.builder.edges.CollapsedEdgeImpl;
import com.intellij.openapi.graph.builder.edges.SingleEdge;
import com.intellij.openapi.graph.builder.edges.SingleEdgeWrapper;
import com.intellij.openapi.graph.impl.builder.GraphBuilderImpl;
import com.intellij.openapi.graph.impl.builder.GraphDataMaps;
import com.intellij.openapi.graph.impl.builder.GraphImplUtil;
import com.intellij.openapi.graph.services.GraphGroupingService;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.NodeLabel;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.graph.view.hierarchy.GroupNodeRealizer;
import com.intellij.openapi.graph.view.hierarchy.HierarchyManager;
import com.intellij.openapi.util.Key;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 A*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0004:\u0001AB\u0005\u00a2\u0006\u0002\u0010\u0005J$\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J6\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\t2\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\rH\u0002J*\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\r2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\"\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\r2\u0006\u0010\u0011\u001a\u00020\u000bH\u0002J\"\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\r2\u0006\u0010\u0011\u001a\u00020\u000bH\u0002J\u001c\u0010\u0016\u001a\u00020\u00072\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\tH\u0002J8\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u00192\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\t2\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001bH\u0002JT\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u000b0\r2\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\t2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001f2\u0006\u0010\u0006\u001a\u00020\u00132\u0014\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u001d0!H\u0002J$\u0010\"\u001a\u00020\u00072\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J(\u0010(\u001a\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020\u001d0)2\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\tH\u0002J(\u0010+\u001a\u0004\u0018\u00010\u001d2\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J(\u0010,\u001a\u0004\u0018\u00010\u000b2\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\t2\b\u0010-\u001a\u0004\u0018\u00010\u001dH\u0016J2\u0010.\u001a\u00020\u000b2\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\t2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001f2\u0006\u0010-\u001a\u00020\u001dH\u0016J$\u0010/\u001a\u00020\u00132\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\t2\u0006\u0010\u0011\u001a\u00020\u000bH\u0016J@\u00100\u001a\u00020\u00072\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u00101\u001a\u0004\u0018\u0001022\b\u00103\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0006\u001a\u00020\u0013H\u0002J@\u00104\u001a\u00020\u00072\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u00101\u001a\u0004\u0018\u0001022\b\u00103\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0006\u001a\u00020\u0013H\u0002J,\u00105\u001a\u00020\u00072\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\t2\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\u000fH\u0002J\u001c\u00109\u001a\u00020\u00072\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\tH\u0002JX\u0010:\u001a\u00020\u00072\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\t2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001b2\u000e\u0010;\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u00192\u0006\u0010\u0006\u001a\u00020\u0013H\u0002J,\u0010<\u001a\u00020\u00072\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010=\u001a\u00020\u0013H\u0016J$\u0010>\u001a\u00020\u00072\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\t2\u0006\u0010\u0011\u001a\u00020\u000bH\u0002J$\u0010?\u001a\u00020\u00072\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\t2\u0006\u0010-\u001a\u00020\u001dH\u0016J$\u0010@\u001a\u00020\u00072\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\t2\u0006\u0010=\u001a\u00020\u0013H\u0016\u00a8\u0006B"}, d2={"Lcom/intellij/openapi/graph/impl/GraphGroupingServiceImpl;", "N", "", "E", "Lcom/intellij/openapi/graph/services/GraphGroupingService;", "()V", "V", "", "graphBuilder", "Lcom/intellij/openapi/graph/builder/GraphBuilder;", "groupNode", "Lcom/intellij/openapi/graph/base/Node;", "nodes2Edges", "", "", "Lcom/intellij/openapi/graph/base/Edge;", "V", "node", "inEdges", "", "W", "V", "W", "builder", "V", "", "dataMaps", "Lcom/intellij/openapi/graph/impl/builder/GraphDataMaps;", "V", "Lcom/intellij/openapi/graph/builder/NodeGroupDescriptor;", "nodesToGroup", "", "nodeToGroupDescriptor", "Ljava/util/function/Function;", "W", "V", "graph", "Lcom/intellij/openapi/graph/base/Graph;", "hierarchyManager", "Lcom/intellij/openapi/graph/view/hierarchy/HierarchyManager;", "V", "", "Lcom/intellij/openapi/graph/builder/GraphIdentifiable$Node$Identity;", "getGroupDescriptor", "getGroupNode", "groupDescriptor", "groupNodesExternally", "isGroupOrFolderNode", "V", "realizer", "Lcom/intellij/openapi/graph/view/hierarchy/GroupNodeRealizer;", "group", "W", "V", "collapsedEdge", "Lcom/intellij/openapi/graph/builder/edges/CollapsedEdge;", "graphCollapsedEdge", "V", "V", "newNodes", "toggleGroup", "withCollapsedEdges", "P", "ungroupNodesExternally", "updateGroups", "Companion", "intellij.platform.graph.impl"})
@SourceDebugExtension(value={"SMAP\nGraphGroupingServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GraphGroupingServiceImpl.kt\ncom/intellij/openapi/graph/impl/GraphGroupingServiceImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,466:1\n1549#2:467\n1620#2,3:468\n1477#2:471\n1502#2,3:472\n1505#2,3:482\n766#2:485\n857#2,2:486\n1855#2,2:488\n1549#2:490\n1620#2,3:491\n1549#2:494\n1620#2,2:495\n1622#2:499\n766#2:500\n857#2,2:501\n1855#2,2:503\n766#2:505\n857#2,2:506\n1855#2,2:508\n372#3,7:475\n37#4,2:497\n*S KotlinDebug\n*F\n+ 1 GraphGroupingServiceImpl.kt\ncom/intellij/openapi/graph/impl/GraphGroupingServiceImpl\n*L\n128#1:467\n128#1:468,3\n143#1:471\n143#1:472,3\n143#1:482,3\n147#1:485\n147#1:486,2\n148#1:488,2\n153#1:490\n153#1:491,3\n162#1:494\n162#1:495,2\n162#1:499\n163#1:500\n163#1:501,2\n164#1:503,2\n168#1:505\n168#1:506,2\n176#1:508,2\n143#1:475,7\n162#1:497,2\n*E\n"})
public final class GraphGroupingServiceImpl<N, E>
implements GraphGroupingService<N, E> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Key<Map<GraphIdentifiable.Node.Identity, NodeGroupDescriptor>> EXTERNAL_GROUPING_KEY;

    @Nullable
    public Node getGroupNode(@NotNull GraphBuilder<N, E> builder, @Nullable NodeGroupDescriptor groupDescriptor) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        return groupDescriptor == null ? null : GraphImplUtil.getGroupNode(((GraphBuilderImpl)builder).getDataMaps(), groupDescriptor);
    }

    @Nullable
    public NodeGroupDescriptor getGroupDescriptor(@NotNull GraphBuilder<N, E> builder, @Nullable Node groupNode) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        return groupNode == null ? null : GraphImplUtil.getGroup(((GraphBuilderImpl)builder).getDataMaps(), groupNode);
    }

    public boolean isGroupOrFolderNode(@NotNull GraphBuilder<N, E> builder, @NotNull Node node) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return !builder.getHierarchyManager().isNormalNode(node);
    }

    private final Set<Node> V(Graph graph, HierarchyManager hierarchyManager) {
        Node[] nodeArray = graph.getNodeArray();
        Intrinsics.checkNotNullExpressionValue((Object)nodeArray, (String)"getNodeArray(...)");
        Set set = ArraysKt.toMutableSet((Object[])nodeArray);
        Node[] nodeArray2 = hierarchyManager.getFolderNodes(graph, false).toNodeArray();
        Intrinsics.checkNotNullExpressionValue((Object)nodeArray2, (String)"toNodeArray(...)");
        for (Node node : nodeArray2) {
            Graph graph2 = hierarchyManager.getInnerGraph(node);
            Intrinsics.checkNotNullExpressionValue((Object)graph2, (String)"getInnerGraph(...)");
            set.addAll((Collection)this.V(graph2, hierarchyManager));
        }
        return set;
    }

    private final void P(GraphBuilder<N, E> graphBuilder, Node node) {
        Node node2 = graphBuilder.getHierarchyManager().getParentNode(node);
        if (node2 == null) {
            return;
        }
        if (graphBuilder.getHierarchyManager().isFolderNode(node2)) {
            graphBuilder.getHierarchyManager().unfoldSubgraph(node.getGraph(), GraphManager.getGraphManager().createNodeList(node));
        } else if (graphBuilder.getHierarchyManager().isGroupNode(node2)) {
            graphBuilder.getHierarchyManager().ungroupSubgraph(GraphManager.getGraphManager().createNodeList(node));
        }
    }

    public void updateGroups(@NotNull GraphBuilder<N, E> builder, boolean withCollapsedEdges) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        GraphDataModel graphDataModel = builder.getGraphDataModel();
        Intrinsics.checkNotNull((Object)graphDataModel, (String)"null cannot be cast to non-null type com.intellij.openapi.graph.builder.GraphDataModel<N of com.intellij.openapi.graph.impl.GraphGroupingServiceImpl, E of com.intellij.openapi.graph.impl.GraphGroupingServiceImpl>");
        GraphDataModel graphDataModel2 = graphDataModel;
        GraphDataMaps graphDataMaps = ((GraphBuilderImpl)builder).getDataMaps();
        Intrinsics.checkNotNullExpressionValue(graphDataMaps, (String)"getDataMaps(...)");
        GraphDataMaps graphDataMaps2 = graphDataMaps;
        Set<Node> set = this.V(builder, graphDataMaps2);
        Graph2D graph2D = builder.getGraph();
        Intrinsics.checkNotNullExpressionValue((Object)graph2D, (String)"getGraph(...)");
        Graph graph = (Graph)graph2D;
        HierarchyManager hierarchyManager = builder.getHierarchyManager();
        Intrinsics.checkNotNullExpressionValue((Object)hierarchyManager, (String)"getHierarchyManager(...)");
        this.V(builder, graph, hierarchyManager, graphDataMaps2, set, withCollapsedEdges);
        if (withCollapsedEdges) {
            this.W(builder);
            this.V(builder);
        }
        Graph2D graph2D2 = builder.getGraph();
        Intrinsics.checkNotNullExpressionValue((Object)graph2D2, (String)"getGraph(...)");
        Graph graph2 = (Graph)graph2D2;
        HierarchyManager hierarchyManager2 = builder.getHierarchyManager();
        Intrinsics.checkNotNullExpressionValue((Object)hierarchyManager2, (String)"getHierarchyManager(...)");
        this.V(builder, (Collection<Node>)this.V(graph2, hierarchyManager2), withCollapsedEdges, arg_0 -> GraphGroupingServiceImpl.V(builder, graphDataModel2, this, arg_0));
    }

    private final Set<Node> V(GraphBuilder<N, E> graphBuilder, GraphDataMaps<N, E> graphDataMaps) {
        GraphDataModel graphDataModel = graphBuilder.getGraphDataModel();
        Intrinsics.checkNotNullExpressionValue((Object)graphDataModel, (String)"getGraphDataModel(...)");
        GraphDataModel graphDataModel2 = graphDataModel;
        for (NodeGroupDescriptor nodeGroupDescriptor : graphDataModel2.getGroupNodes()) {
            GraphImplUtil.getOrCreateGroupNode(graphBuilder.getGraph(), graphBuilder.getHierarchyManager(), nodeGroupDescriptor, graphDataMaps, graphDataModel2);
        }
        Collection collection = graphDataModel2.getGroupNodes();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getGroupNodes(...)");
        Iterable iterable = collection;
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean bl2 = false;
        Iterator iterator = iterable2.iterator();
        while (iterator.hasNext()) {
            Object t2 = iterator.next();
            NodeGroupDescriptor nodeGroupDescriptor = (NodeGroupDescriptor)t2;
            Collection collection3 = collection2;
            boolean bl3 = false;
            collection3.add(graphBuilder.getGroupNode(nodeGroupDescriptor));
        }
        return CollectionsKt.toSet((Iterable)((List)collection2));
    }

    private final Map<NodeGroupDescriptor, Node> V(GraphBuilder<N, E> graphBuilder, Collection<? extends Node> collection, boolean bl, Function<Node, NodeGroupDescriptor> function) {
        Collection collection2;
        Object object;
        boolean bl2;
        Object object2;
        boolean bl3;
        Object object3;
        Object object4;
        if (!(graphBuilder instanceof GraphBuilderImpl)) {
            return MapsKt.emptyMap();
        }
        HierarchyManager hierarchyManager = graphBuilder.getHierarchyManager();
        Intrinsics.checkNotNullExpressionValue((Object)hierarchyManager, (String)"getHierarchyManager(...)");
        HierarchyManager hierarchyManager2 = hierarchyManager;
        GraphDataMaps graphDataMaps = ((GraphBuilderImpl)graphBuilder).getDataMaps();
        Intrinsics.checkNotNullExpressionValue(graphDataMaps, (String)"getDataMaps(...)");
        GraphDataMaps graphDataMaps2 = graphDataMaps;
        Iterable iterable = collection;
        boolean bl4 = false;
        Object object5 = iterable;
        Iterator iterator3 = new LinkedHashMap();
        boolean bl5 = false;
        Iterator iterator2 = object5.iterator();
        while (iterator2.hasNext()) {
            Object object6;
            object4 = iterator2.next();
            object3 = (Node)object4;
            bl3 = false;
            NodeGroupDescriptor nodeGroupDescriptor = function.apply((Node)object3);
            object2 = iterator3;
            bl2 = false;
            object = object2.get(nodeGroupDescriptor);
            if (object == null) {
                boolean bl6 = false;
                List list = new ArrayList();
                object2.put(nodeGroupDescriptor, list);
                object6 = list;
            } else {
                object6 = object;
            }
            List list = (List)object6;
            list.add(object4);
        }
        Map map = iterator3;
        iterable = map.getOrDefault(null, CollectionsKt.emptyList());
        bl4 = false;
        object5 = iterable;
        iterator3 = new ArrayList();
        bl5 = false;
        iterator2 = object5.iterator();
        while (iterator2.hasNext()) {
            object4 = iterator2.next();
            object3 = (Node)object4;
            bl3 = false;
            if (!(!hierarchyManager2.isRootGraph(object3.getGraph()))) continue;
            iterator3.add(object4);
        }
        iterable = (List)((Object)iterator3);
        bl4 = false;
        for (Iterator iterator3 : iterable) {
            Node node = (Node)iterator3;
            boolean bl7 = false;
            this.P(graphBuilder, node);
        }
        Iterable iterable2 = CollectionsKt.filterNotNull((Iterable)map.keySet());
        boolean bl8 = false;
        iterator3 = iterable2;
        Collection<Object> collection32 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable2, (int)10));
        boolean bl9 = false;
        object4 = iterator3.iterator();
        while (object4.hasNext()) {
            object3 = object4.next();
            NodeGroupDescriptor nodeGroupDescriptor = (NodeGroupDescriptor)object3;
            collection2 = collection32;
            boolean bl10 = false;
            collection2.add(TuplesKt.to((Object)nodeGroupDescriptor, (Object)GraphImplUtil.getOrCreateGroupNode(graphBuilder.getGraph(), hierarchyManager2, nodeGroupDescriptor, graphDataMaps2, graphBuilder.getGraphDataModel())));
        }
        iterable = (List)collection32;
        iterable2 = CollectionsKt.sortedWith((Iterable)iterable, (arg_0, arg_1) -> GraphGroupingServiceImpl.V((Function2)new Function2<Pair<? extends NodeGroupDescriptor, ? extends Node>, Pair<? extends NodeGroupDescriptor, ? extends Node>, Integer>(hierarchyManager2){
            final /* synthetic */ HierarchyManager $hierarchyManager;
            {
                this.$hierarchyManager = $hierarchyManager;
                super(2);
            }

            @NotNull
            public final Integer invoke(Pair<? extends NodeGroupDescriptor, ? extends Node> o12, Pair<? extends NodeGroupDescriptor, ? extends Node> o22) {
                return this.$hierarchyManager.getLocalGroupDepth((Node)o22.getSecond()) - this.$hierarchyManager.getLocalGroupDepth((Node)o12.getSecond());
            }
        }, arg_0, arg_1));
        bl8 = false;
        iterator3 = iterable2;
        collection32 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable2, (int)10));
        bl9 = false;
        object4 = iterator3.iterator();
        while (object4.hasNext()) {
            object3 = object4.next();
            Pair pair = (Pair)object3;
            collection2 = collection32;
            boolean bl11 = false;
            Object object7 = pair.getSecond();
            GraphManager graphManager = GraphManager.getGraphManager();
            Object v2 = map.get(pair.getFirst());
            Intrinsics.checkNotNull(v2);
            object2 = (Collection)v2;
            bl2 = false;
            object = object2;
            collection2.add(TuplesKt.to((Object)object7, (Object)graphManager.createNodeList(object.toArray((Node[])new Node[0]))));
        }
        iterable2 = (List)collection32;
        bl8 = false;
        iterator3 = iterable2;
        collection32 = new ArrayList();
        bl9 = false;
        object4 = iterator3.iterator();
        while (object4.hasNext()) {
            object3 = object4.next();
            Pair pair = (Pair)object3;
            boolean bl12 = false;
            if (!(!((NodeList)pair.getSecond()).isEmpty())) continue;
            collection32.add(object3);
        }
        iterable2 = (List)collection32;
        bl8 = false;
        for (Collection<Object> collection32 : iterable2) {
            Pair pair = (Pair)collection32;
            boolean bl13 = false;
            hierarchyManager2.groupSubgraph((NodeList)pair.getSecond(), (Node)pair.getFirst());
        }
        iterable2 = iterable;
        bl8 = false;
        iterator3 = iterable2;
        collection32 = new ArrayList();
        boolean bl14 = false;
        Iterator iterator4 = iterator3.iterator();
        while (iterator4.hasNext()) {
            object3 = iterator4.next();
            Pair pair = (Pair)object3;
            boolean bl15 = false;
            Object object8 = object2 = GraphImplUtil.getGroup(graphDataMaps2, (Node)pair.getSecond());
            bl2 = object8 != null ? object8.isClosed() : ((NodeGroupDescriptor)pair.getFirst()).isClosed();
            if (!(bl2 && hierarchyManager2.isGroupNode((Node)pair.getSecond()))) continue;
            collection32.add(object3);
        }
        iterable2 = CollectionsKt.sortedWith((Iterable)((List)collection32), (arg_0, arg_1) -> GraphGroupingServiceImpl.W((Function2)new Function2<Pair<? extends NodeGroupDescriptor, ? extends Node>, Pair<? extends NodeGroupDescriptor, ? extends Node>, Integer>(hierarchyManager2){
            final /* synthetic */ HierarchyManager $hierarchyManager;
            {
                this.$hierarchyManager = $hierarchyManager;
                super(2);
            }

            @NotNull
            public final Integer invoke(Pair<? extends NodeGroupDescriptor, ? extends Node> o12, Pair<? extends NodeGroupDescriptor, ? extends Node> o22) {
                return this.$hierarchyManager.getLocalGroupDepth((Node)o22.getSecond()) - this.$hierarchyManager.getLocalGroupDepth((Node)o12.getSecond());
            }
        }, arg_0, arg_1));
        bl8 = false;
        for (Collection<Object> collection32 : iterable2) {
            Pair pair = (Pair)collection32;
            boolean bl16 = false;
            Object object9 = pair.getSecond();
            Intrinsics.checkNotNullExpressionValue((Object)object9, (String)"<get-second>(...)");
            this.V(graphBuilder, (Node)object9, ((NodeGroupDescriptor)pair.getFirst()).createGroupNodeRealizer(), (NodeGroupDescriptor)pair.getFirst(), bl);
        }
        return MapsKt.toMap((Iterable)iterable);
    }

    private final void V(GraphBuilder<N, E> graphBuilder, Graph graph, HierarchyManager hierarchyManager, GraphDataMaps<N, E> graphDataMaps, Set<? extends Node> set, boolean bl) {
        Set<Node> set2 = this.V(graph, hierarchyManager);
        set2.removeIf(arg_0 -> GraphGroupingServiceImpl.V((Function1)new Function1<Node, Boolean>(set, hierarchyManager){
            final /* synthetic */ Set<Node> $newNodes;
            final /* synthetic */ HierarchyManager $hierarchyManager;
            {
                this.$newNodes = $newNodes;
                this.$hierarchyManager = $hierarchyManager;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@Nullable Node node) {
                return this.$newNodes.contains(node) || this.$hierarchyManager.isNormalNode(node);
            }
        }, arg_0));
        hierarchyManager.preTraverse(arg_0 -> GraphGroupingServiceImpl.V(set2, hierarchyManager, this, graphBuilder, bl, arg_0));
        graphDataMaps.removeNodes((Collection<Node>)set2);
        NodeCursor nodeCursor = graph.nodes();
        while (nodeCursor.ok()) {
            if (set2.contains(nodeCursor.node()) && graph.contains(nodeCursor.node())) {
                graph.removeNode(nodeCursor.node());
            }
            nodeCursor.next();
        }
    }

    private final void W(GraphBuilder<N, E> graphBuilder) {
        graphBuilder.getHierarchyManager().preTraverse(arg_0 -> GraphGroupingServiceImpl.V(graphBuilder, this, arg_0));
    }

    private final void W(GraphBuilder<N, E> graphBuilder, Node node) {
        EdgeCursor edgeCursor = node.edges();
        while (edgeCursor.ok()) {
            CollapsedEdge collapsedEdge = graphBuilder.getCollapsedEdgeObject(edgeCursor.edge());
            if (collapsedEdge == null) {
                edgeCursor.next();
                continue;
            }
            Edge edge = edgeCursor.edge();
            Intrinsics.checkNotNullExpressionValue((Object)edge, (String)"edge(...)");
            this.V(graphBuilder, collapsedEdge, edge);
            NodeCursor nodeCursor = graphBuilder.getHierarchyManager().getChildren(node);
            while (nodeCursor.ok()) {
                if (graphBuilder.getHierarchyManager().isFolderNode(nodeCursor.node())) {
                    Node node2 = nodeCursor.node();
                    Intrinsics.checkNotNullExpressionValue((Object)node2, (String)"node(...)");
                    this.V(graphBuilder, node2);
                }
                nodeCursor.next();
            }
            edgeCursor.next();
        }
    }

    private final void V(GraphBuilder<N, E> graphBuilder, Node node) {
        this.V(graphBuilder, this.W(node));
        this.V(graphBuilder, this.V(node));
    }

    private final void V(GraphBuilder<N, E> graphBuilder, Map<Node, ? extends Set<Edge>> map) {
        Iterator<Map.Entry<Node, ? extends Set<Edge>>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            CollapsedEdge collapsedEdge;
            Object object2;
            Set<Edge> set = iterator.next().getValue();
            if (set.size() <= 1) continue;
            Node node = ((Edge)CollectionsKt.first((Iterable)set)).source();
            Node node2 = ((Edge)CollectionsKt.first((Iterable)set)).target();
            Intrinsics.checkNotNull((Object)node);
            Intrinsics.checkNotNull((Object)node2);
            CollapsedEdge collapsedEdge2 = (CollapsedEdge)new CollapsedEdgeImpl(node, node2, (Collection)new ArrayList());
            for (Edge edge : set) {
                Intrinsics.checkNotNull(graphBuilder, (String)"null cannot be cast to non-null type com.intellij.openapi.graph.impl.builder.GraphBuilderImpl<N of com.intellij.openapi.graph.impl.GraphGroupingServiceImpl, E of com.intellij.openapi.graph.impl.GraphGroupingServiceImpl>");
                object2 = GraphImplUtil.getEdgeObject(((GraphBuilderImpl)graphBuilder).getDataMaps(), edge);
                collapsedEdge = GraphImplUtil.getCollapsedEdgeObject(((GraphBuilderImpl)graphBuilder).getDataMaps(), edge);
                if (object2 != null) {
                    Collection collection = collapsedEdge2.getEdges();
                    Node node3 = graphBuilder.getHierarchyManager().getRealSource(edge);
                    Intrinsics.checkNotNullExpressionValue((Object)node3, (String)"getRealSource(...)");
                    Node node4 = graphBuilder.getHierarchyManager().getRealTarget(edge);
                    Intrinsics.checkNotNullExpressionValue((Object)node4, (String)"getRealTarget(...)");
                    collection.add(new SingleEdgeWrapper(object2, node3, node4));
                } else if (collapsedEdge != null) {
                    collapsedEdge2.getEdges().addAll(collapsedEdge.getEdges());
                }
                edge.getGraph().removeEdge(edge);
            }
            HierarchyManager hierarchyManager = graphBuilder.getHierarchyManager();
            Intrinsics.checkNotNull(graphBuilder, (String)"null cannot be cast to non-null type com.intellij.openapi.graph.impl.builder.GraphBuilderImpl<N of com.intellij.openapi.graph.impl.GraphGroupingServiceImpl, E of com.intellij.openapi.graph.impl.GraphGroupingServiceImpl>");
            object2 = new Object[]{collapsedEdge2};
            Edge edge = GraphImplUtil.createCollapsedEdge(hierarchyManager, ((GraphBuilderImpl)graphBuilder).getDataMaps(), collapsedEdge2, "", object2);
            Intrinsics.checkNotNullExpressionValue((Object)edge, (String)"createCollapsedEdge(...)");
            Edge edge2 = edge;
            Map<Edge, CollapsedEdge> map2 = ((GraphBuilderImpl)graphBuilder).getDataMaps().getCollapsedEdgeDataMap();
            Intrinsics.checkNotNullExpressionValue(map2, (String)"getCollapsedEdgeDataMap(...)");
            map2.put(edge2, collapsedEdge2);
            for (Object object2 : collapsedEdge2.getEdges()) {
                Intrinsics.checkNotNullExpressionValue(((GraphBuilderImpl)graphBuilder).getDataMaps().getEdgeObjects2ParentCollapsedEdgesMap(), (String)"getEdgeObjects2ParentCollapsedEdgesMap(...)");
                Object object3 = object2.getOriginalEdge();
                Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type E of com.intellij.openapi.graph.impl.GraphGroupingServiceImpl");
                collapsedEdge.put(object3, collapsedEdge2);
            }
        }
    }

    private final Map<Node, Set<Edge>> W(Node node) {
        return this.V(node, true);
    }

    private final Map<Node, Set<Edge>> V(Node node) {
        return this.V(node, false);
    }

    private final Map<Node, Set<Edge>> V(Node node, boolean bl) {
        EdgeCursor edgeCursor;
        Map map = new HashMap();
        EdgeCursor edgeCursor2 = edgeCursor = bl ? node.inEdges() : node.outEdges();
        while (edgeCursor.ok()) {
            Node node2;
            Node node3 = node2 = bl ? edgeCursor.edge().source() : edgeCursor.edge().target();
            if (!map.containsKey(node2)) {
                Intrinsics.checkNotNull((Object)node2);
                map.put(node2, new HashSet());
            }
            Object v2 = map.get(node2);
            Intrinsics.checkNotNull(v2);
            Set set = (Set)v2;
            Edge edge = edgeCursor.edge();
            Intrinsics.checkNotNullExpressionValue((Object)edge, (String)"edge(...)");
            set.add(edge);
            edgeCursor.next();
        }
        return map;
    }

    private final void V(GraphBuilder<N, E> graphBuilder) {
        EdgeCursor edgeCursor = graphBuilder.getGraph().edges();
        while (edgeCursor.ok()) {
            CollapsedEdge collapsedEdge = graphBuilder.getCollapsedEdgeObject(edgeCursor.edge());
            if (collapsedEdge != null && collapsedEdge.getEdges().size() <= 1) {
                Edge edge = edgeCursor.edge();
                Intrinsics.checkNotNullExpressionValue((Object)edge, (String)"edge(...)");
                this.V(graphBuilder, collapsedEdge, edge);
            }
            edgeCursor.next();
        }
    }

    private final void V(GraphBuilder<N, E> graphBuilder, CollapsedEdge collapsedEdge, Edge edge) {
        for (SingleEdge singleEdge : collapsedEdge.getEdges()) {
            Edge edge2 = graphBuilder.getHierarchyManager().createEdge(singleEdge.getSource(), singleEdge.getTarget());
            Intrinsics.checkNotNull(graphBuilder, (String)"null cannot be cast to non-null type com.intellij.openapi.graph.impl.builder.GraphBuilderImpl<N of com.intellij.openapi.graph.impl.GraphGroupingServiceImpl, E of com.intellij.openapi.graph.impl.GraphGroupingServiceImpl>");
            GraphDataMaps graphDataMaps = ((GraphBuilderImpl)graphBuilder).getDataMaps();
            Object object = singleEdge.getOriginalEdge();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type E of com.intellij.openapi.graph.impl.GraphGroupingServiceImpl");
            graphDataMaps.replaceEdge(object, edge2);
        }
        edge.getGraph().removeEdge(edge);
        Intrinsics.checkNotNull(graphBuilder, (String)"null cannot be cast to non-null type com.intellij.openapi.graph.impl.builder.GraphBuilderImpl<N of com.intellij.openapi.graph.impl.GraphGroupingServiceImpl, E of com.intellij.openapi.graph.impl.GraphGroupingServiceImpl>");
        ((GraphBuilderImpl)graphBuilder).getDataMaps().removeEdge(edge);
    }

    public void toggleGroup(@NotNull GraphBuilder<N, E> builder, @NotNull Node groupNode, boolean withCollapsedEdges) {
        GroupNodeRealizer groupNodeRealizer;
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)groupNode, (String)"groupNode");
        NodeGroupDescriptor nodeGroupDescriptor = this.getGroupDescriptor(builder, groupNode);
        NodeRealizer nodeRealizer = builder.getGraph().getRealizer(groupNode);
        GroupNodeRealizer groupNodeRealizer2 = groupNodeRealizer = nodeRealizer instanceof GroupNodeRealizer ? (GroupNodeRealizer)nodeRealizer : null;
        if (builder.getHierarchyManager().isFolderNode(groupNode)) {
            this.W(builder, groupNode, groupNodeRealizer, nodeGroupDescriptor, withCollapsedEdges);
        } else if (builder.getHierarchyManager().isGroupNode(groupNode)) {
            this.V(builder, groupNode, groupNodeRealizer, nodeGroupDescriptor, withCollapsedEdges);
        }
    }

    private final void W(GraphBuilder<N, E> graphBuilder, Node node, GroupNodeRealizer groupNodeRealizer, NodeGroupDescriptor nodeGroupDescriptor, boolean bl) {
        graphBuilder.getHierarchyManager().openFolder(node);
        if (groupNodeRealizer != null) {
            groupNodeRealizer.setGroupClosed(false);
        }
        if (nodeGroupDescriptor != null) {
            nodeGroupDescriptor.setClosed(false);
        }
        if (bl) {
            this.W(graphBuilder, node);
        }
    }

    private final void V(GraphBuilder<N, E> graphBuilder, Node node, GroupNodeRealizer groupNodeRealizer, NodeGroupDescriptor nodeGroupDescriptor, boolean bl) {
        graphBuilder.getHierarchyManager().closeGroup(node);
        if (groupNodeRealizer != null) {
            NodeLabel nodeLabel = groupNodeRealizer.getLabel();
            groupNodeRealizer.setGroupClosed(true);
            graphBuilder.getGraph().setSize(node, nodeLabel.getWidth(), (double)2 * nodeLabel.getHeight());
        }
        if (nodeGroupDescriptor != null) {
            nodeGroupDescriptor.setClosed(true);
        }
        if (bl) {
            this.V(graphBuilder, node);
        }
    }

    @NotNull
    public Node groupNodesExternally(@NotNull GraphBuilder<N, E> builder, @NotNull Collection<? extends Node> nodesToGroup, @NotNull NodeGroupDescriptor groupDescriptor) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Intrinsics.checkNotNullParameter(nodesToGroup, (String)"nodesToGroup");
        Intrinsics.checkNotNullParameter((Object)groupDescriptor, (String)"groupDescriptor");
        Map<GraphIdentifiable.Node.Identity, NodeGroupDescriptor> map = this.V(builder);
        for (Node node : nodesToGroup) {
            Map<GraphIdentifiable.Node.Identity, NodeGroupDescriptor> map2 = map;
            GraphIdentifiable.Node.Identity identity = builder.getNodeIdentity(node);
            Intrinsics.checkNotNullExpressionValue((Object)identity, (String)"getNodeIdentity(...)");
            map2.put(identity, groupDescriptor);
        }
        Map<NodeGroupDescriptor, Node> map3 = this.V(builder, nodesToGroup, false, arg_0 -> GraphGroupingServiceImpl.V(groupDescriptor, arg_0));
        Object v2 = map3.get(groupDescriptor);
        Intrinsics.checkNotNull(v2);
        return (Node)v2;
    }

    public void ungroupNodesExternally(@NotNull GraphBuilder<N, E> builder, @NotNull NodeGroupDescriptor groupDescriptor) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)groupDescriptor, (String)"groupDescriptor");
        Node node = this.getGroupNode(builder, groupDescriptor);
        if (node == null) {
            return;
        }
        List list = NodeCursor.toList((NodeCursor)builder.getHierarchyManager().getChildren(node));
        Map<GraphIdentifiable.Node.Identity, NodeGroupDescriptor> map = this.V(builder);
        for (Node node2 : list) {
            map.remove(builder.getNodeIdentity(node2));
            Intrinsics.checkNotNull((Object)node2);
            this.P(builder, node2);
        }
    }

    private final Map<GraphIdentifiable.Node.Identity, NodeGroupDescriptor> V(GraphBuilder<N, E> graphBuilder) {
        Map map = (Map)graphBuilder.getUserData(EXTERNAL_GROUPING_KEY);
        if (map == null) {
            map = new HashMap();
            graphBuilder.putUserData(EXTERNAL_GROUPING_KEY, (Object)map);
        }
        return map;
    }

    private static final NodeGroupDescriptor V(GraphBuilder graphBuilder, GraphDataModel graphDataModel, GraphGroupingServiceImpl graphGroupingServiceImpl, Node node) {
        Intrinsics.checkNotNullParameter((Object)graphBuilder, (String)"$builder");
        Intrinsics.checkNotNullParameter((Object)graphDataModel, (String)"$dataModel");
        Intrinsics.checkNotNullParameter((Object)graphGroupingServiceImpl, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Object object = graphBuilder.getNodeObject(node);
        if (object != null) {
            return graphDataModel.getGroup(object);
        }
        NodeGroupDescriptor nodeGroupDescriptor = graphBuilder.getGroupNodeObject(node);
        if (nodeGroupDescriptor != null) {
            return graphDataModel.getGroup(nodeGroupDescriptor);
        }
        return graphGroupingServiceImpl.V(graphBuilder).get(graphBuilder.getNodeIdentity(node));
    }

    private static final int V(Function2 function2, Object object, Object object2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"$tmp0");
        return ((Number)function2.invoke(object, object2)).intValue();
    }

    private static final int W(Function2 function2, Object object, Object object2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"$tmp0");
        return ((Number)function2.invoke(object, object2)).intValue();
    }

    private static final boolean V(Function1 function1, Object object) {
        Intrinsics.checkNotNullParameter((Object)function1, (String)"$tmp0");
        return (Boolean)function1.invoke(object);
    }

    private static final void V(Set set, HierarchyManager hierarchyManager, GraphGroupingServiceImpl graphGroupingServiceImpl, GraphBuilder graphBuilder, boolean bl, Node node) {
        Intrinsics.checkNotNullParameter((Object)set, (String)"$nodesToRemove");
        Intrinsics.checkNotNullParameter((Object)hierarchyManager, (String)"$hierarchyManager");
        Intrinsics.checkNotNullParameter((Object)graphGroupingServiceImpl, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)graphBuilder, (String)"$builder");
        if (set.contains(node) && hierarchyManager.isFolderNode(node)) {
            Intrinsics.checkNotNull((Object)node);
            NodeRealizer nodeRealizer = graphBuilder.getGraph().getRealizer(node);
            graphGroupingServiceImpl.W(graphBuilder, node, nodeRealizer instanceof GroupNodeRealizer ? (GroupNodeRealizer)nodeRealizer : null, null, bl);
        }
    }

    private static final void V(GraphBuilder graphBuilder, GraphGroupingServiceImpl graphGroupingServiceImpl, Node node) {
        Intrinsics.checkNotNullParameter((Object)graphBuilder, (String)"$builder");
        Intrinsics.checkNotNullParameter((Object)graphGroupingServiceImpl, (String)"this$0");
        if (graphBuilder.getHierarchyManager().isFolderNode(node)) {
            Intrinsics.checkNotNull((Object)node);
            graphGroupingServiceImpl.V(graphBuilder, node);
        }
    }

    private static final NodeGroupDescriptor V(NodeGroupDescriptor nodeGroupDescriptor, Node node) {
        Intrinsics.checkNotNullParameter((Object)nodeGroupDescriptor, (String)"$groupDescriptor");
        Intrinsics.checkNotNullParameter((Object)node, (String)"it");
        return nodeGroupDescriptor;
    }

    static {
        Key key = Key.create((String)"com.intellij.openapi.graph.impl.GraphGroupingServiceImpl.EXTERNAL_GROUPING_KEY");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        EXTERNAL_GROUPING_KEY = key;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R9\u0010\u0003\u001a-\u0012$\u0012\"\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007 \b*\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/graph/impl/GraphGroupingServiceImpl$Companion;", "", "()V", "EXTERNAL_GROUPING_KEY", "Lcom/intellij/openapi/util/Key;", "", "Lcom/intellij/openapi/graph/builder/GraphIdentifiable$Node$Identity;", "Lcom/intellij/openapi/graph/builder/NodeGroupDescriptor;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.graph.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

