/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.utils;

import com.intellij.find.actions.ShowUsagesAction;
import com.intellij.microservices.utils.CommonFakeNavigatablePomTargetKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.pom.PomRenameableTarget;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.PomTargetPsiElementImpl;
import com.intellij.ui.awt.RelativePoint;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001:\u0001\u0013B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\u0010\u0004\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u00020\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\tH\u0016J\b\u0010\u0010\u001a\u00020\u000eH\u0004J\b\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/intellij/microservices/utils/CommonFakeNavigatablePomTarget;", "Lcom/intellij/psi/impl/PomTargetPsiElementImpl;", "project", "Lcom/intellij/openapi/project/Project;", "pomTarget", "Lcom/intellij/pom/PomRenameableTarget;", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/pom/PomRenameableTarget;)V", "canNavigate", "", "isEquivalentTo", "another", "Lcom/intellij/psi/PsiElement;", "navigate", "", "requestFocus", "showFindUsages", "toString", "", "SimpleNamePomTarget", "intellij.microservices"})
@ApiStatus.Internal
public class CommonFakeNavigatablePomTarget
extends PomTargetPsiElementImpl {
    public CommonFakeNavigatablePomTarget(@NotNull Project project, @NotNull PomRenameableTarget<? extends Object> pomTarget) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(pomTarget, (String)"pomTarget");
        super(project, (PomTarget)pomTarget);
    }

    public void navigate(boolean requestFocus) {
        this.showFindUsages();
    }

    protected final void showFindUsages() {
        if (CommonFakeNavigatablePomTargetKt.access$getMockedFindUsages$p() != null) {
            Function1 function1 = CommonFakeNavigatablePomTargetKt.access$getMockedFindUsages$p();
            Intrinsics.checkNotNull((Object)function1);
            function1.invoke((Object)this);
            return;
        }
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (DumbService.Companion.getInstance(project).isDumb()) {
            return;
        }
        Editor editor = FileEditorManager.getInstance((Project)this.getProject()).getSelectedTextEditor();
        if (editor == null) {
            return;
        }
        Editor editor2 = editor;
        RelativePoint relativePoint = JBPopupFactory.getInstance().guessBestPopupLocation(editor2);
        Intrinsics.checkNotNullExpressionValue((Object)relativePoint, (String)"guessBestPopupLocation(...)");
        RelativePoint relativePoint2 = relativePoint;
        ShowUsagesAction.startFindUsages((PsiElement)((PsiElement)this), (RelativePoint)relativePoint2, (Editor)editor2);
    }

    public boolean canNavigate() {
        return true;
    }

    @NotNull
    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "(" + this.getTarget() + ")";
    }

    public boolean isEquivalentTo(@Nullable PsiElement another) {
        return super.isEquivalentTo(another) || another instanceof PomTargetPsiElement && Intrinsics.areEqual((Object)((PomTargetPsiElement)another).getTarget(), (Object)this.getTarget());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\b\u0016\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0002H\u0096\u0002J\b\u0010\t\u001a\u00020\u0004H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u0007H\u0016J\b\u0010\r\u001a\u00020\u0007H\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000f\u001a\u00020\u0004H\u0016J\b\u0010\u0010\u001a\u00020\u0004H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/microservices/utils/CommonFakeNavigatablePomTarget$SimpleNamePomTarget;", "Lcom/intellij/pom/PomRenameableTarget;", "", "name", "", "(Ljava/lang/String;)V", "equals", "", "other", "getName", "hashCode", "", "isValid", "isWritable", "setName", "newName", "toString", "intellij.microservices"})
    public static class SimpleNamePomTarget
    implements PomRenameableTarget<Object> {
        @NotNull
        private String name;

        public SimpleNamePomTarget(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
        }

        @Nullable
        public Object setName(@NotNull String newName) {
            Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
            this.name = newName;
            return null;
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        public boolean isValid() {
            return true;
        }

        public boolean isWritable() {
            return true;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.intellij.microservices.utils.CommonFakeNavigatablePomTarget.SimpleNamePomTarget");
            SimpleNamePomTarget cfr_ignored_0 = (SimpleNamePomTarget)other;
            return Intrinsics.areEqual((Object)this.name, (Object)((SimpleNamePomTarget)other).name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        @NotNull
        public String toString() {
            return this.getClass().getSimpleName() + "(" + this.name + ")";
        }
    }
}

