/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.ui;

import com.intellij.icons.AllIcons;
import com.intellij.microservices.ui.FilterAllAction;
import com.intellij.microservices.ui.FilterApplier;
import com.intellij.microservices.ui.FilterItem;
import com.intellij.microservices.ui.FilterMultiSelectAction;
import com.intellij.microservices.ui.FilterValueAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u001aD\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0001\u0010\u0006\u001a\u00020\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b2\u0006\u0010\f\u001a\u00020\r\u001a:\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b2\u0006\u0010\u0010\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u0011"}, d2={"createFilterActions", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "filterField", "Ljava/awt/Component;", "attribute", "", "title", "items", "", "Lcom/intellij/microservices/ui/FilterItem;", "selectedItems", "", "applier", "Lcom/intellij/microservices/ui/FilterApplier;", "fillFilterItems", "", "group", "intellij.microservices"})
public final class FiltersKt {
    @NotNull
    public static final DefaultActionGroup createFilterActions(@NotNull Component filterField, @NotNull String attribute, @Nls @NotNull String title, @NotNull List<FilterItem> items2, @NotNull Collection<String> selectedItems, @NotNull FilterApplier applier) {
        Intrinsics.checkNotNullParameter((Object)filterField, (String)"filterField");
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter(items2, (String)"items");
        Intrinsics.checkNotNullParameter(selectedItems, (String)"selectedItems");
        Intrinsics.checkNotNullParameter((Object)applier, (String)"applier");
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup();
        defaultActionGroup.add((AnAction)new FilterAllAction(attribute, applier));
        defaultActionGroup.add((AnAction)new FilterMultiSelectAction(attribute, title, filterField, items2, selectedItems, applier));
        defaultActionGroup.add((AnAction)new Separator());
        FiltersKt.fillFilterItems(items2, attribute, selectedItems, defaultActionGroup, applier);
        return defaultActionGroup;
    }

    public static final void fillFilterItems(@NotNull List<FilterItem> items2, @NotNull String attribute, @NotNull Collection<String> selectedItems, @NotNull DefaultActionGroup group, @NotNull FilterApplier applier) {
        Intrinsics.checkNotNullParameter(items2, (String)"items");
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        Intrinsics.checkNotNullParameter(selectedItems, (String)"selectedItems");
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)applier, (String)"applier");
        for (FilterItem filterItem : items2) {
            FilterValueAction filterValueAction = new FilterValueAction(attribute, filterItem.getTitle(), filterItem.getValue(), applier);
            if (selectedItems.contains(filterItem.getValue())) {
                filterValueAction.getTemplatePresentation().setIcon(AllIcons.Actions.Checked);
            }
            group.add((AnAction)filterValueAction);
        }
    }
}

