/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.ui;

import com.intellij.microservices.MicroservicesBundle;
import com.intellij.microservices.ui.FilterApplier;
import com.intellij.microservices.ui.FilterItem;
import com.intellij.microservices.ui.FilterMultiSelectAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.CheckBoxList;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001a\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/microservices/ui/FilterMultiSelectAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "attribute", "", "title", "owner", "Ljava/awt/Component;", "items", "", "Lcom/intellij/microservices/ui/FilterItem;", "selectedValues", "", "applier", "Lcom/intellij/microservices/ui/FilterApplier;", "(Ljava/lang/String;Ljava/lang/String;Ljava/awt/Component;Ljava/util/List;Ljava/util/Collection;Lcom/intellij/microservices/ui/FilterApplier;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "V", "Ljava/awt/Dimension;", "ofContent", "locationOnScreen", "Ljava/awt/Point;", "intellij.microservices"})
public final class FilterMultiSelectAction
extends AnAction {
    @NotNull
    private final String attribute;
    @NotNull
    private final String title;
    @NotNull
    private final Component owner;
    @NotNull
    private final List<FilterItem> items;
    @NotNull
    private final Collection<String> selectedValues;
    @NotNull
    private final FilterApplier applier;

    public FilterMultiSelectAction(@NotNull String attribute, @Nls(capitalization=Nls.Capitalization.Title) @NotNull String title, @NotNull Component owner, @NotNull List<FilterItem> items2, @NotNull Collection<String> selectedValues, @NotNull FilterApplier applier) {
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter(items2, (String)"items");
        Intrinsics.checkNotNullParameter(selectedValues, (String)"selectedValues");
        Intrinsics.checkNotNullParameter((Object)applier, (String)"applier");
        super(MicroservicesBundle.message("frameworks.filters.select", new Object[0]));
        this.attribute = attribute;
        this.title = title;
        this.owner = owner;
        this.items = items2;
        this.selectedValues = selectedValues;
        this.applier = applier;
    }

    public void actionPerformed(@NotNull AnActionEvent e10) {
        FilterItem filterItem2;
        Intrinsics.checkNotNullParameter((Object)e10, (String)"e");
        CheckBoxList checkBoxList = new CheckBoxList();
        checkBoxList.setItems(this.items, arg_0 -> FilterMultiSelectAction.V(actionPerformed.1.INSTANCE, arg_0));
        for (FilterItem filterItem2 : this.items) {
            if (!this.selectedValues.contains(filterItem2.getValue())) continue;
            checkBoxList.setItemSelected((Object)filterItem2, true);
        }
        if (!((Collection)this.items).isEmpty()) {
            checkBoxList.addSelectionInterval(0, 0);
        }
        checkBoxList.setCheckBoxListListener((arg_0, arg_1) -> FilterMultiSelectAction.V(this, checkBoxList, arg_0, arg_1));
        JBScrollPane jBScrollPane = new JBScrollPane((Component)checkBoxList);
        jBScrollPane.setBorder((Border)JBUI.Borders.empty());
        Dimension dimension = checkBoxList.getPreferredSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getPreferredSize(...)");
        jBScrollPane.setPreferredSize(this.V(dimension, this.owner.getLocationOnScreen()));
        JBPopup jBPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)jBScrollPane, (JComponent)checkBoxList).setTitle(this.title).setRequestFocus(true).createPopup();
        Intrinsics.checkNotNullExpressionValue((Object)jBPopup, (String)"createPopup(...)");
        filterItem2 = jBPopup;
        filterItem2.setMinimumSize((Dimension)new JBDimension(250, 0));
        filterItem2.showUnderneathOf(this.owner);
    }

    private final Dimension V(Dimension dimension, Point point) {
        int n2;
        Dimension dimension2 = new Dimension(Integer.MAX_VALUE, 600);
        int n3 = n2 = dimension.height > dimension2.height ? dimension2.height : dimension.height;
        if (point != null) {
            Rectangle rectangle = ScreenUtil.getScreenRectangle((Point)point);
            Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getScreenRectangle(...)");
            Rectangle rectangle2 = rectangle;
            n2 = RangesKt.coerceAtMost((int)n2, (int)(rectangle2.height - rectangle2.height / 4));
        }
        int n4 = RangesKt.coerceAtMost((int)dimension.width, (int)dimension2.width);
        if (dimension.height > dimension2.height) {
            n4 += (int)ScrollPaneFactory.createScrollPane().getVerticalScrollBar().getPreferredSize().getWidth();
        }
        return new Dimension(n4, n2);
    }

    private static final String V(Function1 function1, Object object) {
        Intrinsics.checkNotNullParameter((Object)function1, (String)"$tmp0");
        return (String)function1.invoke(object);
    }

    private static final void V(FilterMultiSelectAction filterMultiSelectAction, CheckBoxList checkBoxList, int n2, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)((Object)filterMultiSelectAction), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)checkBoxList, (String)"$checkboxList");
        Set set = new LinkedHashSet();
        for (FilterItem filterItem : filterMultiSelectAction.items) {
            if (!checkBoxList.isItemSelected((Object)filterItem)) continue;
            set.add(filterItem.getValue());
        }
        filterMultiSelectAction.applier.applyFilter(filterMultiSelectAction.attribute, set);
    }
}

