/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.ui;

import com.intellij.microservices.ui.EndpointsCompletionPopupType;
import com.intellij.microservices.ui.EndpointsSearchPopupCallback;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindow;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.RectangularShape;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u0000 H2\u00020\u00012\u00020\u0002:\u0001HB3\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?H\u0016J\u0010\u0010@\u001a\u00020=2\u0006\u0010>\u001a\u00020AH\u0016J\u0010\u0010B\u001a\u00020=2\u0006\u0010>\u001a\u00020AH\u0016J\u0016\u0010C\u001a\u00020=2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010D\u001a\u00020(J\u0006\u0010E\u001a\u00020=J\b\u0010F\u001a\u00020=H\u0002J\u0006\u0010G\u001a\u00020=R\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u0010\u0010!\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010'\u001a\u00020(8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010)R\"\u0010*\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010+X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0010\u00102\u001a\u0004\u0018\u000103X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00104\u001a\u0002058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u00107R\u001a\u00108\u001a\u00020(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010)\"\u0004\b:\u0010;\u00a8\u0006I"}, d2={"Lcom/intellij/microservices/ui/EndpointsSearchPopup;", "Ljava/awt/event/ComponentAdapter;", "Ljavax/swing/event/CaretListener;", "searchTextField", "Lcom/intellij/ui/SearchTextField;", "listener", "Lcom/intellij/openapi/ui/popup/JBPopupListener;", "completionPlace", "Lcom/intellij/microservices/ui/EndpointsCompletionPopupType;", "model", "Lcom/intellij/ui/CollectionListModel;", "", "caretPosition", "", "(Lcom/intellij/ui/SearchTextField;Lcom/intellij/openapi/ui/popup/JBPopupListener;Lcom/intellij/microservices/ui/EndpointsCompletionPopupType;Lcom/intellij/ui/CollectionListModel;I)V", "callback", "Lcom/intellij/microservices/ui/EndpointsSearchPopupCallback;", "getCallback", "()Lcom/intellij/microservices/ui/EndpointsSearchPopupCallback;", "setCallback", "(Lcom/intellij/microservices/ui/EndpointsSearchPopupCallback;)V", "getCaretPosition", "()I", "setCaretPosition", "(I)V", "getCompletionPlace", "()Lcom/intellij/microservices/ui/EndpointsCompletionPopupType;", "data", "", "getData", "()Ljava/lang/Object;", "setData", "(Ljava/lang/Object;)V", "dialogComponent", "Ljava/awt/Component;", "editor", "Lcom/intellij/ui/components/JBTextField;", "event", "Lcom/intellij/openapi/ui/popup/LightweightWindowEvent;", "isValid", "", "()Z", "list", "Ljavax/swing/JList;", "getList", "()Ljavax/swing/JList;", "setList", "(Ljavax/swing/JList;)V", "getModel", "()Lcom/intellij/ui/CollectionListModel;", "popup", "Lcom/intellij/openapi/ui/popup/JBPopup;", "popupLocation", "Ljava/awt/Point;", "V", "()Ljava/awt/Point;", "skipCaretEvent", "getSkipCaretEvent", "setSkipCaretEvent", "(Z)V", "caretUpdate", "", "e", "Ljavax/swing/event/CaretEvent;", "componentMoved", "Ljava/awt/event/ComponentEvent;", "componentResized", "createAndShow", "async", "hide", "V", "update", "Companion", "intellij.microservices"})
@SourceDebugExtension(value={"SMAP\nEndpointsSearchPopup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EndpointsSearchPopup.kt\ncom/intellij/microservices/ui/EndpointsSearchPopup\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,161:1\n1#2:162\n*E\n"})
public final class EndpointsSearchPopup
extends ComponentAdapter
implements CaretListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JBPopupListener listener;
    @NotNull
    private final EndpointsCompletionPopupType completionPlace;
    @NotNull
    private final CollectionListModel<String> model;
    private int caretPosition;
    @NotNull
    private final JBTextField editor;
    @Nullable
    private JBPopup popup;
    @Nullable
    private LightweightWindowEvent event;
    @Nullable
    private Component dialogComponent;
    @Nullable
    private JList<String> list;
    @Nullable
    private EndpointsSearchPopupCallback callback;
    private boolean skipCaretEvent;
    @Nullable
    private Object data;

    public EndpointsSearchPopup(@NotNull SearchTextField searchTextField, @NotNull JBPopupListener listener2, @NotNull EndpointsCompletionPopupType completionPlace, @NotNull CollectionListModel<String> model, int caretPosition) {
        Intrinsics.checkNotNullParameter((Object)searchTextField, (String)"searchTextField");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)((Object)completionPlace), (String)"completionPlace");
        Intrinsics.checkNotNullParameter(model, (String)"model");
        this.listener = listener2;
        this.completionPlace = completionPlace;
        this.model = model;
        this.caretPosition = caretPosition;
        JBTextField jBTextField = searchTextField.getTextEditor();
        Intrinsics.checkNotNullExpressionValue((Object)jBTextField, (String)"getTextEditor(...)");
        this.editor = jBTextField;
    }

    @NotNull
    public final EndpointsCompletionPopupType getCompletionPlace() {
        return this.completionPlace;
    }

    @NotNull
    public final CollectionListModel<String> getModel() {
        return this.model;
    }

    public final int getCaretPosition() {
        return this.caretPosition;
    }

    public final void setCaretPosition(int n2) {
        this.caretPosition = n2;
    }

    @Nullable
    public final JList<String> getList() {
        return this.list;
    }

    public final void setList(@Nullable JList<String> jList) {
        this.list = jList;
    }

    @Nullable
    public final EndpointsSearchPopupCallback getCallback() {
        return this.callback;
    }

    public final void setCallback(@Nullable EndpointsSearchPopupCallback endpointsSearchPopupCallback) {
        this.callback = endpointsSearchPopupCallback;
    }

    public final boolean getSkipCaretEvent() {
        return this.skipCaretEvent;
    }

    public final void setSkipCaretEvent(boolean bl) {
        this.skipCaretEvent = bl;
    }

    @Nullable
    public final Object getData() {
        return this.data;
    }

    public final void setData(@Nullable Object object) {
        this.data = object;
    }

    public final void createAndShow(@NotNull EndpointsSearchPopupCallback callback, boolean async) {
        JBList jBList;
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.callback = callback;
        ColoredListCellRenderer coloredListCellRenderer = (ColoredListCellRenderer)new ColoredListCellRenderer<String>(){

            protected void customizeCellRenderer(@NotNull JList<? extends String> list, @Nullable String value2, int index2, boolean selected, boolean hasFocus) {
                Intrinsics.checkNotNullParameter(list, (String)"list");
                String string = value2;
                if (string == null) {
                    string = "";
                }
                this.append(string);
            }
        };
        Insets insets = coloredListCellRenderer.getIpad();
        Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"getIpad(...)");
        Insets insets2 = insets;
        insets2.left = insets2.right = EndpointsSearchPopup.Companion.V();
        coloredListCellRenderer.setFont(this.editor.getFont());
        JBList jBList2 = jBList = new JBList((ListModel)this.model);
        JBPopupFactory jBPopupFactory = JBPopupFactory.getInstance();
        boolean bl = false;
        this.list = (JList)jBList2;
        JBPopup jBPopup = jBPopupFactory.createListPopupBuilder((JList)jBList).setMovable(false).setResizable(false).setRequestFocus(false).setItemChosenCallback((Consumer)callback).setFont(this.editor.getFont()).setRenderer((ListCellRenderer)coloredListCellRenderer).createPopup();
        Intrinsics.checkNotNullExpressionValue((Object)jBPopup, (String)"createPopup(...)");
        JBPopup jBPopup2 = jBPopup;
        jBPopup2.addListener(this.listener);
        this.popup = jBPopup2;
        this.event = new LightweightWindowEvent((LightweightWindow)jBPopup2);
        this.skipCaretEvent = true;
        this.editor.addCaretListener((CaretListener)this);
        Component component = this.dialogComponent = (Component)this.editor.getRootPane().getParent();
        if (component != null) {
            component.addComponentListener(this);
        }
        if (async) {
            SwingUtilities.invokeLater(() -> EndpointsSearchPopup.V(this));
        } else {
            this.V();
        }
    }

    private final Point V() {
        Cloneable cloneable;
        try {
            cloneable = this.editor.modelToView2D(this.caretPosition);
            cloneable = new Point((int)((RectangularShape)cloneable).getMaxX(), (int)((RectangularShape)cloneable).getMaxY());
        }
        catch (BadLocationException badLocationException) {
            Point point = this.editor.getCaret().getMagicCaretPosition();
            Intrinsics.checkNotNull((Object)point);
            cloneable = point;
        }
        Cloneable cloneable2 = cloneable;
        SwingUtilities.convertPointToScreen((Point)cloneable2, (Component)this.editor);
        ((Point)cloneable2).x -= EndpointsSearchPopup.Companion.V() + JBUIScale.scale((int)2);
        ((Point)cloneable2).y += 2;
        return cloneable2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isValid() {
        JBPopup jBPopup = this.popup;
        Intrinsics.checkNotNull((Object)jBPopup);
        if (!jBPopup.isVisible()) return false;
        JBPopup jBPopup2 = this.popup;
        Intrinsics.checkNotNull((Object)jBPopup2);
        if (jBPopup2.getContent().getParent() == null) return false;
        return true;
    }

    public final void update() {
        block0: {
            JBPopup jBPopup;
            this.skipCaretEvent = true;
            JBPopup jBPopup2 = this.popup;
            if (jBPopup2 == null) break block0;
            JBPopup jBPopup3 = jBPopup = jBPopup2;
            boolean bl = false;
            jBPopup3.setLocation(this.V());
            jBPopup3.pack(true, true);
        }
    }

    private final void V() {
        block3: {
            JList<String> jList = this.list;
            if (jList != null) {
                if (jList.getModel().getSize() > 0) {
                    jList.setSelectedIndex(0);
                } else {
                    jList.clearSelection();
                }
            }
            JBPopup jBPopup = this.popup;
            if (jBPopup == null) break block3;
            jBPopup.showInScreenCoordinates((Component)this.editor, this.V());
        }
    }

    public final void hide() {
        this.editor.removeCaretListener((CaretListener)this);
        if (this.dialogComponent != null) {
            Component component = this.dialogComponent;
            if (component != null) {
                component.removeComponentListener(this);
            }
            this.dialogComponent = null;
        }
        if (this.popup != null) {
            JBPopup jBPopup = this.popup;
            if (jBPopup != null) {
                jBPopup.cancel();
            }
            this.popup = null;
        }
    }

    @Override
    public void caretUpdate(@NotNull CaretEvent e10) {
        block1: {
            block0: {
                Intrinsics.checkNotNullParameter((Object)e10, (String)"e");
                if (!this.skipCaretEvent) break block0;
                this.skipCaretEvent = false;
                break block1;
            }
            this.hide();
            LightweightWindowEvent lightweightWindowEvent = this.event;
            if (lightweightWindowEvent == null) break block1;
            LightweightWindowEvent lightweightWindowEvent2 = lightweightWindowEvent;
            boolean bl = false;
            this.listener.onClosed(lightweightWindowEvent2);
        }
    }

    @Override
    public void componentMoved(@NotNull ComponentEvent e10) {
        Intrinsics.checkNotNullParameter((Object)e10, (String)"e");
        if (this.popup != null && this.isValid()) {
            this.update();
        }
    }

    @Override
    public void componentResized(@NotNull ComponentEvent e10) {
        Intrinsics.checkNotNullParameter((Object)e10, (String)"e");
        this.componentMoved(e10);
    }

    private static final void V(EndpointsSearchPopup endpointsSearchPopup) {
        Intrinsics.checkNotNullParameter((Object)endpointsSearchPopup, (String)"this$0");
        endpointsSearchPopup.V();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/microservices/ui/EndpointsSearchPopup$Companion;", "", "()V", "xOffset", "", "V", "()I", "intellij.microservices"})
    public static final class Companion {
        private Companion() {
        }

        private final int V() {
            int n2 = UIUtil.isUnderWin10LookAndFeel() ? 5 : UIUtil.getListCellHPadding();
            return JBUIScale.scale((int)n2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

