/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.microservices.MicroservicesBundle;
import com.intellij.microservices.ui.EndpointsFilterFieldKt;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.ui.ClickListener;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextDelegate;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\f\b&\u0018\u00002\u00020\u0001:\u0002$%B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000e\u001a\u00020\u000fH%J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0011H\u0014J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0007H'J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0017H\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u001aH\u0002J\b\u0010\u001c\u001a\u00020\u001aH\u0002J\b\u0010\u001d\u001a\u00020\u001aH\u0002J\b\u0010\u001e\u001a\u00020\u001aH\u0002J\b\u0010\u001f\u001a\u00020\u001aH\u0002J\b\u0010 \u001a\u00020\u001aH\u0002J\b\u0010!\u001a\u00020\u001aH\u0002J\u0010\u0010\"\u001a\u00020\u00112\u0006\u0010#\u001a\u00020\u0011H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/microservices/ui/EndpointsFilterField;", "Ljavax/swing/JPanel;", "project", "Lcom/intellij/openapi/project/Project;", "filterLoadingScope", "Lkotlinx/coroutines/CoroutineScope;", "originalMessage", "", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;Ljava/lang/String;)V", "nameLabel", "Ljavax/swing/JLabel;", "getOriginalMessage", "()Ljava/lang/String;", "valueLabel", "createActionGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "V", "Ljavax/swing/border/Border;", "createUnfocusedBorder", "getAccessibleContext", "Ljavax/accessibility/AccessibleContext;", "getCurrentText", "W", "Ljava/awt/Color;", "V", "W", "", "E", "w", "V", "f", "o", "m", "P", "V", "outerBorder", "AccessiblePopupComponent", "FilledRoundedBorder", "intellij.microservices"})
public abstract class EndpointsFilterField
extends JPanel {
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope filterLoadingScope;
    @NotNull
    private final String originalMessage;
    @NotNull
    private final JLabel nameLabel;
    @NotNull
    private final JLabel valueLabel;

    public EndpointsFilterField(@NotNull Project project, @NotNull CoroutineScope filterLoadingScope, @Nls(capitalization=Nls.Capitalization.Title) @NotNull String originalMessage) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)filterLoadingScope, (String)"filterLoadingScope");
        Intrinsics.checkNotNullParameter((Object)originalMessage, (String)"originalMessage");
        this.project = project;
        this.filterLoadingScope = filterLoadingScope;
        this.originalMessage = originalMessage;
        this.nameLabel = new JLabel(this){
            final /* synthetic */ EndpointsFilterField this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public String getText() {
                String string = this.this$0.getCurrentText();
                return string == null ? this.this$0.getOriginalMessage() + " " : this.this$0.getOriginalMessage() + ": ";
            }
        };
        this.valueLabel = new JLabel(this){
            final /* synthetic */ EndpointsFilterField this$0;
            {
                this.this$0 = $receiver;
            }

            @Nullable
            public String getText() {
                return this.this$0.getCurrentText();
            }
        };
        this.w();
    }

    @NotNull
    public final String getOriginalMessage() {
        return this.originalMessage;
    }

    private final void w() {
        this.setFocusable(true);
        this.setLayout(new BoxLayout(this, 0));
        this.setBorder(this.V(this.createUnfocusedBorder()));
        this.add(this.nameLabel);
        this.add(this.valueLabel);
        this.add(new JLabel(AllIcons.General.ArrowDown));
        this.nameLabel.setForeground(this.W());
        this.valueLabel.setForeground(this.V());
        this.P();
        this.m();
        this.E();
        this.W();
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    @RequiresBackgroundThread
    @RequiresReadLock
    @NotNull
    protected abstract ActionGroup createActionGroup();

    @Nls
    @Nullable
    public abstract String getCurrentText();

    private final void W() {
        this.addFocusListener(new FocusAdapter(this){
            final /* synthetic */ EndpointsFilterField this$0;
            {
                this.this$0 = $receiver;
            }

            public void focusGained(@NotNull FocusEvent e10) {
                Intrinsics.checkNotNullParameter((Object)e10, (String)"e");
                this.this$0.setBorder(EndpointsFilterField.access$wrapBorder(this.this$0, EndpointsFilterField.access$createFocusedBorder(this.this$0)));
            }

            public void focusLost(@NotNull FocusEvent e10) {
                Intrinsics.checkNotNullParameter((Object)e10, (String)"e");
                this.this$0.setBorder(EndpointsFilterField.access$wrapBorder(this.this$0, this.this$0.createUnfocusedBorder()));
            }
        });
    }

    private final void m() {
        this.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ EndpointsFilterField this$0;
            {
                this.this$0 = $receiver;
            }

            public void keyPressed(@NotNull KeyEvent e10) {
                Intrinsics.checkNotNullParameter((Object)e10, (String)"e");
                if (e10.getKeyCode() == 10 || e10.getKeyCode() == 40) {
                    EndpointsFilterField.access$showPopupMenu(this.this$0);
                }
            }
        });
    }

    private final void P() {
        new ClickListener(this){
            final /* synthetic */ EndpointsFilterField this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                EndpointsFilterField.access$showPopupMenu(this.this$0);
                return true;
            }
        }.installOn((Component)this);
    }

    private final void E() {
        this.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ EndpointsFilterField this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseEntered(@NotNull MouseEvent e10) {
                Intrinsics.checkNotNullParameter((Object)e10, (String)"e");
                EndpointsFilterField.access$setOnHoverForeground(this.this$0);
            }

            public void mouseExited(@NotNull MouseEvent e10) {
                Intrinsics.checkNotNullParameter((Object)e10, (String)"e");
                EndpointsFilterField.access$setDefaultForeground(this.this$0);
            }
        });
    }

    private final void o() {
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)this);
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        DataContext dataContext2 = dataContext;
        EndpointsFilterFieldKt.access$showAsyncChooserPopup(this, this.filterLoadingScope, FlowKt.flow((Function2)((Function2)new Function2<FlowCollector<? super Result<? extends ActionGroup>>, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ EndpointsFilterField this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        var2_3 = (FlowCollector)this.L$0;
                        this.L$0 = var2_3;
                        this.label = 1;
                        v0 = CoroutinesKt.smartReadActionBlocking((Project)EndpointsFilterField.access$getProject$p(this.this$0), (Function0)((Function0)new Function0<ActionGroup>(this.this$0){
                            final /* synthetic */ EndpointsFilterField this$0;
                            {
                                this.this$0 = $receiver;
                                super(0);
                            }

                            @NotNull
                            public final ActionGroup invoke() {
                                return this.this$0.createActionGroup();
                            }
                        }), (Continuation)((Continuation)this));
                        if (v0 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl16
                    }
                    case 1: {
                        var2_3 = (FlowCollector)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl16:
                        // 2 sources

                        var3_4 = (ActionGroup)v0;
                        this.L$0 = null;
                        this.label = 2;
                        v1 = var2_3.emit((Object)Result.box-impl((Object)Result.constructor-impl((Object)var3_4)), (Continuation)this);
                        if (v1 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl27
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl27:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value2;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull FlowCollector<? super Result<? extends ActionGroup>> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), dataContext2);
    }

    private final void V() {
        this.nameLabel.setForeground(this.W());
        this.valueLabel.setForeground(this.V());
    }

    private final Color W() {
        Color color = UIUtil.getLabelInfoForeground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getLabelInfoForeground(...)");
        return color;
    }

    private final Color V() {
        Color color;
        if (StartupUiUtil.INSTANCE.isDarkTheme()) {
            Color color2 = UIUtil.getLabelForeground();
            color = color2;
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getLabelForeground(...)");
        } else {
            Color color3 = NamedColorUtil.getInactiveTextColor().darker().darker();
            color = color3;
            Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"darker(...)");
        }
        return color;
    }

    private final void f() {
        this.nameLabel.setForeground(StartupUiUtil.INSTANCE.isDarkTheme() ? UIUtil.getLabelForeground() : UIUtil.getTextAreaForeground());
        this.valueLabel.setForeground(StartupUiUtil.INSTANCE.isDarkTheme() ? UIUtil.getLabelForeground() : UIUtil.getTextFieldForeground());
    }

    private final Border V() {
        Color color = UIUtil.getFocusedBorderColor();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getFocusedBorderColor(...)");
        return new FilledRoundedBorder(color, 10, 2);
    }

    @NotNull
    protected Border createUnfocusedBorder() {
        Border border = JBUI.Borders.empty((int)2);
        Intrinsics.checkNotNullExpressionValue((Object)border, (String)"empty(...)");
        return border;
    }

    private final Border V(Border border) {
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(border, JBUI.Borders.empty((int)2));
        Intrinsics.checkNotNullExpressionValue((Object)compoundBorder, (String)"createCompoundBorder(...)");
        return compoundBorder;
    }

    @Override
    @NotNull
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            AccessibleContext accessibleContext = super.getAccessibleContext();
            Intrinsics.checkNotNullExpressionValue((Object)accessibleContext, (String)"getAccessibleContext(...)");
            this.accessibleContext = (AccessibleContext)((Object)new AccessiblePopupComponent(accessibleContext));
        }
        AccessibleContext accessibleContext = this.accessibleContext;
        Intrinsics.checkNotNullExpressionValue((Object)accessibleContext, (String)"accessibleContext");
        return accessibleContext;
    }

    public static final /* synthetic */ Border access$wrapBorder(EndpointsFilterField $this, Border outerBorder) {
        return $this.V(outerBorder);
    }

    public static final /* synthetic */ Border access$createFocusedBorder(EndpointsFilterField $this) {
        return $this.V();
    }

    public static final /* synthetic */ void access$showPopupMenu(EndpointsFilterField $this) {
        $this.o();
    }

    public static final /* synthetic */ void access$setOnHoverForeground(EndpointsFilterField $this) {
        $this.f();
    }

    public static final /* synthetic */ void access$setDefaultForeground(EndpointsFilterField $this) {
        $this.V();
    }

    public static final /* synthetic */ Project access$getProject$p(EndpointsFilterField $this) {
        return $this.project;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0014\u00a8\u0006\u000b"}, d2={"Lcom/intellij/microservices/ui/EndpointsFilterField$AccessiblePopupComponent;", "Lcom/intellij/util/ui/accessibility/AccessibleContextDelegate;", "context", "Ljavax/accessibility/AccessibleContext;", "(Lcom/intellij/microservices/ui/EndpointsFilterField;Ljavax/accessibility/AccessibleContext;)V", "getAccessibleName", "", "getAccessibleRole", "Ljavax/accessibility/AccessibleRole;", "getDelegateParent", "Ljava/awt/Container;", "intellij.microservices"})
    private final class AccessiblePopupComponent
    extends AccessibleContextDelegate {
        public AccessiblePopupComponent(AccessibleContext context2) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            super(context2);
        }

        @Nullable
        protected Container getDelegateParent() {
            return null;
        }

        @NotNull
        public AccessibleRole getAccessibleRole() {
            AccessibleRole accessibleRole = AccessibleRole.POPUP_MENU;
            Intrinsics.checkNotNullExpressionValue((Object)accessibleRole, (String)"POPUP_MENU");
            return accessibleRole;
        }

        @NotNull
        public String getAccessibleName() {
            Object[] objectArray = new Object[2];
            Intrinsics.checkNotNullExpressionValue((Object)EndpointsFilterField.this.nameLabel.getText(), (String)"getText(...)");
            Intrinsics.checkNotNullExpressionValue((Object)EndpointsFilterField.this.valueLabel.getText(), (String)"getText(...)");
            return MicroservicesBundle.message("frameworks.accessibility.filter.label", objectArray);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J8\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/microservices/ui/EndpointsFilterField$FilledRoundedBorder;", "Ljavax/swing/border/Border;", "myColor", "Ljava/awt/Color;", "myArcSize", "", "myThickness", "(Ljava/awt/Color;II)V", "getBorderInsets", "Ljava/awt/Insets;", "c", "Ljava/awt/Component;", "isBorderOpaque", "", "paintBorder", "", "g", "Ljava/awt/Graphics;", "x", "y", "width", "height", "intellij.microservices"})
    private static final class FilledRoundedBorder
    implements Border {
        @NotNull
        private final Color myColor;
        private final int myArcSize;
        private final int myThickness;

        public FilledRoundedBorder(@NotNull Color myColor, int myArcSize, int myThickness) {
            Intrinsics.checkNotNullParameter((Object)myColor, (String)"myColor");
            this.myColor = myColor;
            this.myArcSize = myArcSize;
            this.myThickness = myThickness;
        }

        @Override
        public void paintBorder(@NotNull Component c2, @NotNull Graphics g2, int x2, int y2, int width, int height) {
            Intrinsics.checkNotNullParameter((Object)c2, (String)"c");
            Intrinsics.checkNotNullParameter((Object)g2, (String)"g");
            GraphicsConfig graphicsConfig = GraphicsUtil.setupAAPainting((Graphics)g2);
            g2.setColor(this.myColor);
            int n2 = JBUI.scale((int)this.myThickness);
            int n3 = JBUI.scale((int)this.myArcSize);
            Area area = new Area(new RoundRectangle2D.Double(x2, y2, width, height, n3, n3));
            int n4 = RangesKt.coerceAtLeast((int)(n3 - n2), (int)0);
            area.subtract(new Area(new RoundRectangle2D.Double(x2 + n2, y2 + n2, width - 2 * n2, height - 2 * n2, n4, n4)));
            ((Graphics2D)g2).fill(area);
            graphicsConfig.restore();
        }

        @Override
        @NotNull
        public Insets getBorderInsets(@NotNull Component c2) {
            Intrinsics.checkNotNullParameter((Object)c2, (String)"c");
            JBInsets jBInsets = JBUI.insets((int)this.myThickness);
            Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"insets(...)");
            return (Insets)jBInsets;
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    }
}

