/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.http;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.microservices.MicroservicesBundle;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.meta.PsiPresentableMetaData;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\u001d\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0016J\u0013\u0010\u000e\u001a\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0006H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\bH\u0016J\u0010\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0006H\u0016J\b\u0010\u0018\u001a\u00020\u0006H\u0016J\b\u0010\u0019\u001a\u00020\u0006H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\bH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u001dH\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0006H\u0016J\u0012\u0010%\u001a\u00020\r2\b\u0010&\u001a\u0004\u0018\u00010\u0006H\u0016J\u0010\u0010'\u001a\u00020#2\u0006\u0010(\u001a\u00020\rH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/microservices/http/HttpMethodElement;", "Lcom/intellij/psi/impl/FakePsiElement;", "Lcom/intellij/psi/SyntheticElement;", "Lcom/intellij/psi/meta/PsiMetaOwner;", "Lcom/intellij/psi/meta/PsiPresentableMetaData;", "parent", "Lcom/intellij/psi/PsiElement;", "methodName", "", "refTextRange", "Lcom/intellij/openapi/util/TextRange;", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;Lcom/intellij/openapi/util/TextRange;)V", "canNavigate", "", "equals", "other", "", "getDeclaration", "getIcon", "Ljavax/swing/Icon;", "getMetaData", "Lcom/intellij/psi/meta/PsiMetaData;", "getName", "context", "getNavigationElement", "getParent", "getResolveScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "getTextOffset", "", "getTypeName", "getUseScope", "Lcom/intellij/psi/search/SearchScope;", "hashCode", "init", "", "element", "isEquivalentTo", "another", "navigate", "requestFocus", "intellij.microservices"})
public final class HttpMethodElement
extends FakePsiElement
implements SyntheticElement,
PsiMetaOwner,
PsiPresentableMetaData {
    @NotNull
    private final PsiElement parent;
    @NotNull
    private final String methodName;
    @NotNull
    private final TextRange refTextRange;

    public HttpMethodElement(@NotNull PsiElement parent, @NotNull String methodName, @NotNull TextRange refTextRange) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter((Object)refTextRange, (String)"refTextRange");
        this.parent = parent;
        this.methodName = methodName;
        this.refTextRange = refTextRange;
    }

    @NotNull
    public String getName() {
        return this.methodName;
    }

    @NotNull
    public String getName(@NotNull PsiElement context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return this.getName();
    }

    @NotNull
    public PsiElement getParent() {
        return this.parent;
    }

    @NotNull
    public PsiElement getDeclaration() {
        return (PsiElement)this;
    }

    @NotNull
    public PsiMetaData getMetaData() {
        return (PsiMetaData)this;
    }

    @NotNull
    public PsiElement getNavigationElement() {
        return (PsiElement)this;
    }

    public boolean canNavigate() {
        return true;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Nodes.PpWeb;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"PpWeb");
        return icon;
    }

    @NotNull
    public String getTypeName() {
        return MicroservicesBundle.message("http.method.element", new Object[0]);
    }

    @NotNull
    public SearchScope getUseScope() {
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(...)");
        return (SearchScope)globalSearchScope;
    }

    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(...)");
        return globalSearchScope;
    }

    public void init(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
    }

    public boolean isEquivalentTo(@Nullable PsiElement another) {
        return another instanceof HttpMethodElement && Intrinsics.areEqual((Object)((HttpMethodElement)another).methodName, (Object)this.methodName);
    }

    public int getTextOffset() {
        return this.getParent().getTextOffset() + this.refTextRange.getStartOffset();
    }

    public void navigate(boolean requestFocus) {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (DumbService.Companion.getInstance(project).isDumb()) {
            return;
        }
        PsiFile psiFile = this.getContainingFile();
        if (psiFile != null && psiFile.isValid()) {
            Navigatable navigatable = PsiNavigationSupport.getInstance().createNavigatable(this.getProject(), psiFile.getVirtualFile(), this.getTextOffset());
            Intrinsics.checkNotNullExpressionValue((Object)navigatable, (String)"createNavigatable(...)");
            Navigatable navigatable2 = navigatable;
            navigatable2.navigate(requestFocus);
        }
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(((Object)((Object)this)).getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.intellij.microservices.http.HttpMethodElement");
        HttpMethodElement cfr_ignored_0 = (HttpMethodElement)((Object)other);
        return Intrinsics.areEqual((Object)this.methodName, (Object)((HttpMethodElement)((Object)other)).methodName);
    }

    public int hashCode() {
        return this.methodName.hashCode();
    }
}

