/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.http;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HttpHeaderDocumentation {
    private static final String CC_LICENSE = " is licensed under <a href=\"https://creativecommons.org/licenses/by-sa/2.5/\">CC-BY-SA 2.5</a>.";
    private static final String URL_PREFIX = "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/";
    private static final String RFC_PREFIX = "https://tools.ietf.org/html/rfc";
    private final String myName;
    private final String myRfc;
    private final String myRfcTitle;
    private final String myDescription;
    private final boolean myIsDeprecated;

    private HttpHeaderDocumentation(String name, String rfc, String rfcTitle, String description, boolean isDeprecated) {
        this.myName = name;
        this.myRfc = rfc;
        this.myRfcTitle = rfcTitle;
        this.myDescription = description;
        this.myIsDeprecated = isDeprecated;
    }

    public HttpHeaderDocumentation(String name) {
        this(name, "", "", "", false);
    }

    @Nullable
    public static HttpHeaderDocumentation read(@NotNull JsonObject obj) {
        String string;
        if (obj == null) {
            HttpHeaderDocumentation.V(0);
        }
        if (StringUtil.isNotEmpty((String)(string = HttpHeaderDocumentation.V(obj, "name")))) {
            String string2 = HttpHeaderDocumentation.V(obj, "rfc-title");
            String string3 = HttpHeaderDocumentation.V(obj, "rfc-ref");
            String string4 = HttpHeaderDocumentation.V(obj, "descr");
            JsonElement jsonElement = obj.get("obsolete");
            boolean bl = jsonElement != null && jsonElement.isJsonPrimitive() && jsonElement.getAsBoolean();
            return new HttpHeaderDocumentation(string, string3, string2, string4, bl);
        }
        return null;
    }

    @NotNull
    private static String V(@NotNull JsonObject jsonObject, @NotNull String string) {
        JsonElement jsonElement;
        if (jsonObject == null) {
            HttpHeaderDocumentation.V(1);
        }
        if (string == null) {
            HttpHeaderDocumentation.V(2);
        }
        return (jsonElement = jsonObject.get(string)) != null && jsonElement.isJsonPrimitive() ? jsonElement.getAsString() : "";
    }

    @Nullable
    @NlsSafe
    public String generateDoc() {
        if (StringUtil.isNotEmpty((String)this.myDescription)) {
            StringBuilder stringBuilder = new StringBuilder().append(this.myDescription);
            if (StringUtil.isNotEmpty((String)this.myRfc) && StringUtil.isNotEmpty((String)this.myRfcTitle)) {
                stringBuilder.append("<br/><br/>");
                stringBuilder.append("<a href=\"").append(RFC_PREFIX).append(this.myRfc).append("\">").append(this.myRfcTitle).append("</a>");
            }
            String string = this.getUrl();
            stringBuilder.append("<br/><br/>");
            stringBuilder.append("<a href=\"").append(string).append("\">").append(this.getName()).append("</a> by ");
            stringBuilder.append("<a href=\"").append(string).append("$history").append("\">").append("Mozilla Contributors").append("</a>");
            stringBuilder.append(CC_LICENSE);
            return stringBuilder.toString();
        }
        return null;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            HttpHeaderDocumentation.V(3);
        }
        return string;
    }

    public boolean isDeprecated() {
        return this.myIsDeprecated;
    }

    @NotNull
    public String getDescription() {
        String string = this.myDescription;
        if (string == null) {
            HttpHeaderDocumentation.V(4);
        }
        return string;
    }

    @NotNull
    public String getUrl() {
        String string = URL_PREFIX + this.getName();
        if (string == null) {
            HttpHeaderDocumentation.V(5);
        }
        return string;
    }

    private static /* synthetic */ void V(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 3, 4, 5 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/microservices/http/HttpHeaderDocumentation";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/microservices/http/HttpHeaderDocumentation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrl";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "read";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAsString";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

