/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.cron.psi;

import com.intellij.lang.ASTNode;
import com.intellij.microservices.cron.impl.CronExpIdImpl;
import com.intellij.microservices.cron.impl.CronExpNumberLiteralImpl;
import com.intellij.microservices.cron.impl.CronExpOperatorImpl;
import com.intellij.microservices.cron.impl.CronExpPunctuationImpl;
import com.intellij.microservices.cron.impl.CronExpRangeImpl;
import com.intellij.microservices.cron.psi.CronExpElementType;
import com.intellij.microservices.cron.psi.CronExpTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;

public interface CronExpTypes {
    public static final IElementType ID = new CronExpElementType("ID");
    public static final IElementType NUMBER_LITERAL = new CronExpElementType("NUMBER_LITERAL");
    public static final IElementType OPERATOR = new CronExpElementType("OPERATOR");
    public static final IElementType PUNCTUATION = new CronExpElementType("PUNCTUATION");
    public static final IElementType RANGE = new CronExpElementType("RANGE");
    public static final IElementType ASTERISK = new CronExpTokenType("*");
    public static final IElementType COMMA = new CronExpTokenType(",");
    public static final IElementType DASH = new CronExpTokenType("-");
    public static final IElementType HASH = new CronExpTokenType("#");
    public static final IElementType IDENTIFIER = new CronExpTokenType("IDENTIFIER");
    public static final IElementType MACRO_MARK = new CronExpTokenType("@");
    public static final IElementType NUMBER = new CronExpTokenType("NUMBER");
    public static final IElementType PERCENT = new CronExpTokenType("%");
    public static final IElementType QUESTION_MARK = new CronExpTokenType("?");
    public static final IElementType SLASH = new CronExpTokenType("/");

    public static class Factory {
        public static PsiElement createElement(ASTNode node) {
            IElementType iElementType = node.getElementType();
            if (iElementType == ID) {
                return new CronExpIdImpl(node);
            }
            if (iElementType == NUMBER_LITERAL) {
                return new CronExpNumberLiteralImpl(node);
            }
            if (iElementType == OPERATOR) {
                return new CronExpOperatorImpl(node);
            }
            if (iElementType == PUNCTUATION) {
                return new CronExpPunctuationImpl(node);
            }
            if (iElementType == RANGE) {
                return new CronExpRangeImpl(node);
            }
            throw new AssertionError((Object)("Unknown element type: " + iElementType));
        }
    }
}

