/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea.cloudConfig;

import com.intellij.ide.W.L.dn;
import com.intellij.ide.W.X;
import com.intellij.idea.cloudConfig.CloudConfigClientUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.BrowserLink;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.V.W.d;
import com.jetbrains.ls.responses.ObtainUserIdResponse;
import com.jetbrains.ls.responses.ResponseCode;
import java.awt.Component;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CloudConfigLoginDialog
extends DialogWrapper {
    private static final Logger LOG;
    private final JTextField myLoginField;
    private final JTextField myPasswordField;
    private final BrowserLink myForgotLink;
    private final JProgressBar myProgress;
    private final String myInitialLogin;
    private @NlsContexts.DialogMessage String myServerError;
    private ProgressIndicator myIndicator;
    private static final long a;

    public CloudConfigLoginDialog(boolean checkChangeName) {
        long l2 = a ^ 0x7B6F0799349AL;
        long l3 = l2 ^ 0x1AFD3081A5BAL;
        super(false);
        this.myLoginField = new JTextField(18);
        this.myPasswordField = new JPasswordField(18);
        this.myForgotLink = new BrowserLink(X.V(l3, "label.forgot", new Object[0]), "https://account.jetbrains.com/secured/ForgotPasswordForm");
        this.myProgress = new JProgressBar(0);
        this.setTitle(X.V(l3, "dialog.title.log.in.to.jetbrains.account", new Object[0]));
        this.getOKAction().putValue("Name", X.V(l3, "button.log.in", new Object[0]));
        this.getOKAction().setEnabled(false);
        String string = CloudConfigClientUtil.getUserLogin();
        this.myInitialLogin = checkChangeName ? StringUtil.defaultIfEmpty((String)string, null) : null;
        this.myLoginField.setText(string);
        this.myPasswordField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e10) {
                if (e10 == null) {
                    1.V(0);
                }
                CloudConfigLoginDialog.this.myPasswordField.getDocument().removeDocumentListener((DocumentListener)((Object)this));
                CloudConfigLoginDialog.this.initValidation();
                CloudConfigLoginDialog.this.getOKAction().setEnabled(!CloudConfigLoginDialog.this.myPasswordField.getText().isEmpty());
            }

            private static /* synthetic */ void V(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/idea/cloudConfig/CloudConfigLoginDialog$1", "textChanged"));
            }
        });
        UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.MINI, (Component)this.myProgress);
        this.myProgress.setIndeterminate(true);
        this.myProgress.setVisible(false);
        this.init();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        long l2 = a ^ 0x3A304077363L;
        long l3 = l2 ^ 0x6231331FE243L;
        FormBuilder formBuilder = FormBuilder.createFormBuilder();
        formBuilder.addLabeledComponent(X.V(l3, "label.username", new Object[0]), (JComponent)this.myLoginField);
        formBuilder.addLabeledComponent(X.V(l3, "label.password", new Object[0]), (JComponent)this.myPasswordField);
        formBuilder.addComponent((JComponent)this.myForgotLink);
        formBuilder.addComponent((JComponent)this.myProgress);
        return formBuilder.getPanel();
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myLoginField.getText().isEmpty() ? this.myLoginField : this.myPasswordField;
    }

    @NotNull
    protected List<ValidationInfo> doValidateAll() {
        long l2 = a ^ 0x663EEAADC014L;
        long l3 = l2 ^ 0x7ACDDB55134L;
        ArrayList<ValidationInfo> arrayList = new ArrayList<ValidationInfo>();
        String string = this.myLoginField.getText();
        if (StringUtil.isEmpty((String)string)) {
            arrayList.add(new ValidationInfo(X.V(l3, "validation.message.username.cannot.be.empty", new Object[0]), (JComponent)this.myLoginField));
        } else if (this.myInitialLogin != null && !this.myInitialLogin.equals(string)) {
            arrayList.add(new ValidationInfo(X.V(l3, "validation.message.change.the.username", new Object[0]), (JComponent)this.myLoginField).asWarning());
        }
        if (this.myPasswordField.getText().isEmpty()) {
            arrayList.add(new ValidationInfo(X.V(l3, "validation.message.password.cannot.be.empty", new Object[0]), (JComponent)this.myPasswordField));
        }
        if (this.myServerError != null) {
            arrayList.add(new ValidationInfo(this.myServerError).withOKEnabled());
        }
        ArrayList<ValidationInfo> arrayList2 = arrayList;
        if (arrayList2 == null) {
            CloudConfigLoginDialog.V(0);
        }
        return arrayList2;
    }

    protected void doOKAction() {
        long l2 = a ^ 0xAB80A9F6F2FL;
        long l3 = l2 ^ 0x6B2A3D87FE0FL;
        final String string = this.myLoginField.getText();
        final String string2 = this.myPasswordField.getText();
        final boolean bl = this.myLoginField.isEditable();
        this.myLoginField.setEditable(false);
        this.myPasswordField.setEditable(false);
        this.myForgotLink.setEnabled(false);
        this.myProgress.setVisible(true);
        this.getOKAction().setEnabled(false);
        this.myServerError = null;
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(null, X.V(l3, "task.title.authorization.to.jetbrains.account", new Object[0])){
            @NlsContexts.DialogMessage String error;

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.V(0);
                }
                CloudConfigLoginDialog.this.V(indicator);
                this.error = CloudConfigLoginDialog.V(string, string2);
            }

            public void onFinished() {
                CloudConfigLoginDialog.this.V(null);
                CloudConfigLoginDialog.this.myProgress.setVisible(false);
                CloudConfigLoginDialog.this.myLoginField.setEditable(bl);
                CloudConfigLoginDialog.this.myPasswordField.setEditable(true);
                CloudConfigLoginDialog.this.myForgotLink.setEnabled(true);
                CloudConfigLoginDialog.this.getOKAction().setEnabled(true);
                if (this.error == null) {
                    CloudConfigLoginDialog.super.doOKAction();
                } else {
                    CloudConfigLoginDialog.this.myServerError = this.error;
                }
            }

            private static /* synthetic */ void V(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/idea/cloudConfig/CloudConfigLoginDialog$2", "run"));
            }
        });
    }

    public void doCancelAction() {
        ProgressIndicator progressIndicator = this.V();
        if (progressIndicator != null) {
            progressIndicator.cancel();
        }
        super.doCancelAction();
    }

    @Nullable
    private synchronized ProgressIndicator V() {
        return this.myIndicator;
    }

    private synchronized void V(@Nullable ProgressIndicator progressIndicator) {
        this.myIndicator = progressIndicator;
    }

    @Nullable
    @NlsContexts.DialogMessage
    private static String V(@NotNull String string, @NotNull String string2) {
        long l2;
        long l3 = l2 = a ^ 0x5E923CFBAC56L;
        long l4 = l3 ^ 0x29BD87367924L;
        long l5 = l3 ^ 0x3F000BE33D76L;
        if (string == null) {
            CloudConfigLoginDialog.V(1);
        }
        if (string2 == null) {
            CloudConfigLoginDialog.V(2);
        }
        try {
            ObtainUserIdResponse obtainUserIdResponse = d.V(string, string2, l4);
            if (obtainUserIdResponse.getResponseCode() == ResponseCode.OK) {
                CloudConfigClientUtil.setUserAndId(string, obtainUserIdResponse.getUserId());
                return null;
            }
            return X.V(l5, "dialog.message.authorization.failed", obtainUserIdResponse.getMessage());
        }
        catch (Exception exception) {
            LOG.info((Throwable)exception);
            return X.V(l5, "dialog.message.jetbrains.account.communication.error", exception.getMessage());
        }
    }

    static {
        a = dn.a(-1047048408068190158L, -2394226127455937838L, MethodHandles.lookup().lookupClass()).a(79863544013772L);
        LOG = Logger.getInstance(CloudConfigLoginDialog.class);
    }

    private static /* synthetic */ void V(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/idea/cloudConfig/CloudConfigLoginDialog";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "login";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "password";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "doValidateAll";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/idea/cloudConfig/CloudConfigLoginDialog";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setUserId";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

