/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.ultimate.project;

import com.intellij.indexing.shared.download.SharedIndexId;
import com.intellij.indexing.shared.download.SharedIndexSuggestion;
import com.intellij.indexing.shared.message.SharedIndexesBundle;
import com.intellij.indexing.shared.ultimate.project.ProjectIndexLookupRequest;
import com.intellij.indexing.shared.ultimate.project.ProjectSharedIndexSetting;
import com.intellij.indexing.shared.ultimate.project.ProjectSharedIndexesKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\fH\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u0014\u0010\u0011\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\nR\u0014\u0010\u0013\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000eR\u0014\u0010\u0015\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lcom/intellij/indexing/shared/ultimate/project/ProjectSharedIndexSuggestion;", "Lcom/intellij/indexing/shared/download/SharedIndexSuggestion;", "setting", "Lcom/intellij/indexing/shared/ultimate/project/ProjectSharedIndexSetting;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/indexing/shared/ultimate/project/ProjectSharedIndexSetting;Lcom/intellij/openapi/project/Project;)V", "id", "Lcom/intellij/indexing/shared/download/SharedIndexId;", "getId", "()Lcom/intellij/indexing/shared/download/SharedIndexId;", "sharedIndexConsentNotificationKindPresentableText", "", "getSharedIndexConsentNotificationKindPresentableText", "()Ljava/lang/String;", "sharedIndexDownloadedPresentableText", "getSharedIndexDownloadedPresentableText", "sharedIndexId", "getSharedIndexId", "testConnectionUrl", "getTestConnectionUrl", "url", "getUrl", "resolveRequest", "Lcom/intellij/indexing/shared/ultimate/project/ProjectIndexLookupRequest;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "toString", "intellij.indexing.shared.ultimate"})
public class ProjectSharedIndexSuggestion
implements SharedIndexSuggestion {
    @NotNull
    private final ProjectSharedIndexSetting setting;
    @Nullable
    private final Project project;
    @NotNull
    private final SharedIndexId id;
    @NotNull
    private final SharedIndexId sharedIndexId;
    @NotNull
    private final String url;
    @NotNull
    private final String testConnectionUrl;

    public ProjectSharedIndexSuggestion(@NotNull ProjectSharedIndexSetting setting, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)setting, (String)"setting");
        this.setting = setting;
        this.project = project;
        this.sharedIndexId = this.id = new SharedIndexId("project", this.setting.getUrl(), this.setting.getIndexId());
        this.url = this.setting.getUrl();
        char[] cArray = new char[]{'/'};
        this.testConnectionUrl = StringsKt.trimEnd((String)this.setting.getUrl(), (char[])cArray) + "/index.json.xz";
    }

    @NotNull
    public final SharedIndexId getId() {
        return this.id;
    }

    @NotNull
    public SharedIndexId getSharedIndexId() {
        return this.sharedIndexId;
    }

    @NotNull
    public String getUrl() {
        return this.url;
    }

    @NotNull
    public String getTestConnectionUrl() {
        return this.testConnectionUrl;
    }

    @NotNull
    public ProjectIndexLookupRequest resolveRequest(@NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        return new ProjectIndexLookupRequest(this.setting, ProjectSharedIndexesKt.buildProjectLookupUrlList(this.project, indicator, this.setting));
    }

    @NotNull
    public String toString() {
        return "ProjectSharedIndexSuggestion(" + this.id + ", " + this.setting.getUrl() + ")";
    }

    @NotNull
    public String getSharedIndexDownloadedPresentableText() {
        String string = SharedIndexesBundle.message((String)"eventLog.downloaded.project", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getSharedIndexConsentNotificationKindPresentableText() {
        String string = SharedIndexesBundle.message((String)"notification.consent.content.kind.project", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }
}

