/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.ultimate.git;

import com.intellij.indexing.shared.platform.hash.SharedIndexContentHash;
import com.intellij.indexing.shared.platform.hash.SharedIndexContentHashProvider;
import com.intellij.indexing.shared.ultimate.git.GitBlobSet;
import com.intellij.indexing.shared.ultimate.git.SharedIndexGitBackedHash;
import com.intellij.indexing.shared.ultimate.git.SharedIndexHashProviderBase;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.IndexedHashesSupport;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JB\u0010\u0007\u001a\u0004\u0018\u0001H\b\"\b\b\u0000\u0010\b*\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u001f\u0010\f\u001a\u001b\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u0001H\b0\r\u00a2\u0006\u0002\b\u000fH$\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lcom/intellij/indexing/shared/ultimate/git/SharedIndexHashProviderBase;", "Lcom/intellij/indexing/shared/platform/hash/SharedIndexContentHashProvider;", "()V", "info", "Lcom/intellij/indexing/shared/platform/hash/SharedIndexContentHash;", "getInfo", "()Lcom/intellij/indexing/shared/platform/hash/SharedIndexContentHash;", "computeGitHash", "Y", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "action", "Lkotlin/Function2;", "Lcom/intellij/indexing/shared/ultimate/git/GitBlobSet;", "Lkotlin/ExtensionFunctionType;", "(Lcom/intellij/openapi/vfs/VirtualFile;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "computeHash", "", "content", "Lcom/intellij/util/indexing/IndexedFile;", "intellij.indexing.shared.ultimate.git"})
public abstract class SharedIndexHashProviderBase
implements SharedIndexContentHashProvider {
    @NotNull
    private final SharedIndexContentHash info = SharedIndexGitBackedHash.INSTANCE;

    @NotNull
    public final SharedIndexContentHash getInfo() {
        return this.info;
    }

    @Nullable
    public final byte[] computeHash(@NotNull IndexedFile content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        VirtualFile virtualFile = content.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        VirtualFile file = virtualFile;
        if (!file.isValid() || file.isDirectory() || !(file.getFileSystem() instanceof LocalFileSystem)) {
            return null;
        }
        byte[] hash2 = (byte[])this.computeGitHash(file, computeHash.hash.1.INSTANCE);
        if (hash2 == null) {
            return null;
        }
        return IndexedHashesSupport.calculateIndexedHash((IndexedFile)content, (byte[])hash2);
    }

    @Nullable
    protected abstract <Y> Y computeGitHash(@NotNull VirtualFile var1, @NotNull Function2<? super GitBlobSet, ? super VirtualFile, ? extends Y> var2);
}

