/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.ultimate.git;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.externalProcessAuthHelper.AuthenticationMode;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JV\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f26\u0010\r\u001a2\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\u00060\u000eJ\u001c\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00152\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ(\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00172\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0018\u001a\u00020\n2\b\b\u0002\u0010\u0019\u001a\u00020\u001aJZ\u0010\u001b\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00172\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\b\u0002\u0010\u001f\u001a\u00020 2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00060\"H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/indexing/shared/ultimate/git/ProjectGitHelper;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "logGitBlobHashes", "", "project", "Lcom/intellij/openapi/project/Project;", "repo", "Ljava/nio/file/Path;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "consumer", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "relPath", "hash", "logGitModifiedFiles", "", "logRecentCommits", "", "root", "limit", "", "runGitCommand", "command", "Lgit4idea/commands/GitCommand;", "params", "throwOnError", "", "stdoutLinesConsumer", "Lkotlin/Function1;", "intellij.indexing.shared.ultimate.git"})
@SourceDebugExtension(value={"SMAP\nProjectGitHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectGitHelper.kt\ncom/intellij/indexing/shared/ultimate/git/ProjectGitHelper\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,93:1\n37#2,2:94\n11#3:96\n*S KotlinDebug\n*F\n+ 1 ProjectGitHelper.kt\ncom/intellij/indexing/shared/ultimate/git/ProjectGitHelper\n*L\n33#1:94,2\n18#1:96\n*E\n"})
public final class ProjectGitHelper {
    @NotNull
    public static final ProjectGitHelper INSTANCE = new ProjectGitHelper();
    @NotNull
    private static final Logger LOG;

    private ProjectGitHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void runGitCommand(Project project, Path root, GitCommand command, List<String> params, ProgressIndicator indicator, boolean throwOnError, Function1<? super String, Unit> stdoutLinesConsumer) {
        long startTime = System.currentTimeMillis();
        try {
            GitLineHandler handler = new GitLineHandler(project, root.toFile(), command);
            handler.setIgnoreAuthenticationMode(AuthenticationMode.SILENT);
            handler.setWithMediator(false);
            Collection $this$toTypedArray$iv = params;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            handler.addParameters(Arrays.copyOf(stringArray, stringArray.length));
            handler.addLineListener(new GitLineHandlerListener(indicator, stdoutLinesConsumer){
                final /* synthetic */ ProgressIndicator $indicator;
                final /* synthetic */ Function1<String, Unit> $stdoutLinesConsumer;
                {
                    this.$indicator = $indicator;
                    this.$stdoutLinesConsumer = $stdoutLinesConsumer;
                }

                public void onLineAvailable(@Nullable String line, @Nullable Key<?> outputType) {
                    ProgressIndicator progressIndicator = this.$indicator;
                    if (progressIndicator != null) {
                        progressIndicator.checkCanceled();
                    }
                    if (!Intrinsics.areEqual(outputType, (Object)ProcessOutputTypes.STDOUT) || line == null) {
                        return;
                    }
                    this.$stdoutLinesConsumer.invoke((Object)line);
                }
            });
            GitCommandResult gitCommandResult = Git.getInstance().runCommandWithoutCollectingOutput(handler);
            Intrinsics.checkNotNullExpressionValue((Object)gitCommandResult, (String)"runCommandWithoutCollectingOutput(...)");
            GitCommandResult result = gitCommandResult;
            if (throwOnError) {
                result.throwOnError(new int[0]);
            }
        }
        catch (Exception t) {
            if (t instanceof ControlFlowException) {
                throw t;
            }
            LOG.debug("Shared Indexes Git command " + command + " with " + params + " failed " + t.getMessage(), (Throwable)t);
        }
        finally {
            long duration = RangesKt.coerceAtLeast((long)(System.currentTimeMillis() - startTime), (long)1L);
            LOG.info("Shared Indexes git " + command.name() + " took " + StringUtil.formatDuration((long)duration));
        }
    }

    static /* synthetic */ void runGitCommand$default(ProjectGitHelper projectGitHelper, Project project, Path path, GitCommand gitCommand, List list, ProgressIndicator progressIndicator, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 0x10) != 0) {
            progressIndicator = null;
        }
        if ((n & 0x20) != 0) {
            bl = true;
        }
        projectGitHelper.runGitCommand(project, path, gitCommand, list, progressIndicator, bl, (Function1<? super String, Unit>)function1);
    }

    @NotNull
    public final List<String> logRecentCommits(@Nullable Project project, @NotNull Path root, int limit) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        GitCommand gitCommand = GitCommand.LOG;
        Intrinsics.checkNotNullExpressionValue((Object)gitCommand, (String)"LOG");
        Object[] objectArray = new String[]{"-" + limit, "--topo-order", "--format=%H"};
        ProjectGitHelper.runGitCommand$default(this, project, root, gitCommand, CollectionsKt.listOf((Object[])objectArray), null, false, (Function1)new Function1<String, Unit>(result){
            final /* synthetic */ LinkedHashSet<String> $result;
            {
                this.$result = $result;
                super(1);
            }

            public final void invoke(@NotNull String line) {
                Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                String text = ((Object)StringsKt.trim((CharSequence)line)).toString();
                if (!StringsKt.isBlank((CharSequence)text)) {
                    Collection collection = this.$result;
                    String string = text.toLowerCase();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                    collection.add(string);
                }
            }
        }, 48, null);
        return CollectionsKt.toList((Iterable)result);
    }

    public static /* synthetic */ List logRecentCommits$default(ProjectGitHelper projectGitHelper, Project project, Path path, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 2048;
        }
        return projectGitHelper.logRecentCommits(project, path, n);
    }

    public final void logGitBlobHashes(@NotNull Project project, @NotNull Path repo, @NotNull ProgressIndicator indicator, @NotNull Function2<? super String, ? super String, Unit> consumer) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        GitCommand gitCommand = GitCommand.LS_TREE;
        Intrinsics.checkNotNullExpressionValue((Object)gitCommand, (String)"LS_TREE");
        Object[] objectArray = new String[]{"--full-tree", "-r", "HEAD"};
        ProjectGitHelper.runGitCommand$default(this, project, repo, gitCommand, CollectionsKt.listOf((Object[])objectArray), indicator, false, (Function1)new Function1<String, Unit>(consumer){
            final /* synthetic */ Function2<String, String, Unit> $consumer;
            {
                this.$consumer = $consumer;
                super(1);
            }

            public final void invoke(@NotNull String line) {
                Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                char[] cArray = new char[]{' ', '\t'};
                List it = StringsKt.split$default((CharSequence)line, (char[])cArray, (boolean)false, (int)0, (int)6, null);
                if (it.size() == 4 && Intrinsics.areEqual(it.get(1), (Object)"blob")) {
                    String path = (String)it.get(3);
                    String hash2 = (String)it.get(2);
                    this.$consumer.invoke((Object)path, (Object)hash2);
                }
            }
        }, 32, null);
    }

    @NotNull
    public final Set<String> logGitModifiedFiles(@NotNull Project project, @NotNull Path repo) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
        HashSet<String> result = new HashSet<String>();
        GitCommand gitCommand = GitCommand.STATUS;
        Intrinsics.checkNotNullExpressionValue((Object)gitCommand, (String)"STATUS");
        Object[] objectArray = new String[]{"--no-renames", "--porcelain=1", "--ignore-submodules"};
        ProjectGitHelper.runGitCommand$default(this, project, repo, gitCommand, CollectionsKt.listOf((Object[])objectArray), null, false, (Function1)new Function1<String, Unit>(result){
            final /* synthetic */ HashSet<String> $result;
            {
                this.$result = $result;
                super(1);
            }

            public final void invoke(@NotNull String line) {
                Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                String[] stringArray = new String[]{" "};
                String path = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)line, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
                if (!StringsKt.isBlank((CharSequence)path)) {
                    ((Collection)this.$result).add(path);
                }
            }
        }, 48, null);
        return result;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ProjectGitHelper.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

