/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.ultimate.git;

import com.intellij.indexing.shared.ultimate.git.GitBlobKey;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u001e\n\u0002\b\t\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\u0002\u0010\u000bJ\u0012\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\u0003H\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000e\u001a\u00020\u0006H\u0002J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\u0003J\u0006\u0010\u0010\u001a\u00020\u0011J\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u0015J\b\u0010\u0016\u001a\u00020\u0000H\u0002J\b\u0010\u0017\u001a\u00020\u0006H\u0016J\u001b\u0010\u0018\u001a\u00020\u00002\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\u0015H\u0007\u00a2\u0006\u0002\b\u001aJ\u001b\u0010\u0018\u001a\u00020\u00002\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u0015H\u0007\u00a2\u0006\u0002\b\u001bJ\u001b\u0010\u0018\u001a\u00020\u00002\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\t0\u0013H\u0007\u00a2\u0006\u0002\b\u001dR\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/indexing/shared/ultimate/git/GitBlobSet;", "", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "namesMap", "", "", "", "items", "Lcom/intellij/indexing/shared/ultimate/git/GitBlobKey;", "", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/util/Map;Ljava/util/Map;)V", "fileToKey", "file", "relName", "find", "isEmpty", "", "mapFilesToExistingKeys", "", "files", "", "removeAll", "toString", "withIgnoredItems", "relNames", "withIgnoredItems-VirtualFiles", "withIgnoredItems-Strings", "namesToRemove", "withIgnoredItems-GitBlobKey", "intellij.indexing.shared.ultimate.git"})
@SourceDebugExtension(value={"SMAP\nGitHashesProjectService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitHashesProjectService.kt\ncom/intellij/indexing/shared/ultimate/git/GitBlobSet\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,218:1\n511#2,6:219\n1611#3:225\n1855#3:226\n1856#3:228\n1612#3:229\n1611#3:230\n1855#3:231\n1856#3:233\n1612#3:234\n1#4:227\n1#4:232\n*S KotlinDebug\n*F\n+ 1 GitHashesProjectService.kt\ncom/intellij/indexing/shared/ultimate/git/GitBlobSet\n*L\n157#1:219,6\n172#1:225\n172#1:226\n172#1:228\n172#1:229\n181#1:230\n181#1:231\n181#1:233\n181#1:234\n172#1:227\n181#1:232\n*E\n"})
public final class GitBlobSet {
    @NotNull
    private final VirtualFile root;
    @NotNull
    private final Map<String, Integer> namesMap;
    @NotNull
    private final Map<GitBlobKey, byte[]> items;

    public GitBlobSet(@NotNull VirtualFile root, @NotNull Map<String, Integer> namesMap, @NotNull Map<GitBlobKey, byte[]> items) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(namesMap, (String)"namesMap");
        Intrinsics.checkNotNullParameter(items, (String)"items");
        this.root = root;
        this.namesMap = namesMap;
        this.items = items;
    }

    public final boolean isEmpty() {
        return this.items.isEmpty();
    }

    @NotNull
    public String toString() {
        return "GitBlobSet(root=" + this.root + ", items=" + this.items.size() + ")";
    }

    @JvmName(name="withIgnoredItems-VirtualFiles")
    @NotNull
    public final GitBlobSet withIgnoredItems-VirtualFiles(@NotNull Collection<? extends VirtualFile> relNames) {
        Intrinsics.checkNotNullParameter(relNames, (String)"relNames");
        if (this.isEmpty()) {
            return this;
        }
        if (relNames.isEmpty()) {
            return this;
        }
        Set<GitBlobKey> mappedFiles = this.mapFilesToExistingKeys(relNames);
        return this.withIgnoredItems-GitBlobKey(mappedFiles);
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="withIgnoredItems-GitBlobKey")
    @NotNull
    public final GitBlobSet withIgnoredItems-GitBlobKey(@NotNull Set<GitBlobKey> namesToRemove) {
        void $this$filterTo$iv;
        Intrinsics.checkNotNullParameter(namesToRemove, (String)"namesToRemove");
        if (this.isEmpty()) {
            return this;
        }
        if (namesToRemove.isEmpty()) {
            return this;
        }
        Map<GitBlobKey, byte[]> map = this.items;
        Map destination$iv = new HashMap(this.items.size());
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator.next();
            boolean bl = false;
            if (!(!namesToRemove.contains(it.getKey()))) continue;
            destination$iv.put(element$iv.getKey(), element$iv.getValue());
        }
        HashMap copy = (HashMap)destination$iv;
        if (copy.isEmpty()) {
            return this.removeAll();
        }
        if (copy.size() == this.items.size()) {
            return this;
        }
        return new GitBlobSet(this.root, this.namesMap, copy);
    }

    private final GitBlobSet removeAll() {
        return new GitBlobSet(this.root, MapsKt.emptyMap(), MapsKt.emptyMap());
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="withIgnoredItems-Strings")
    @NotNull
    public final GitBlobSet withIgnoredItems-Strings(@NotNull Collection<String> relNames) {
        void $this$mapNotNullTo$iv;
        Intrinsics.checkNotNullParameter(relNames, (String)"relNames");
        if (this.isEmpty()) {
            return this;
        }
        if (relNames.isEmpty()) {
            return this;
        }
        Iterable iterable = relNames;
        Collection destination$iv = new HashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            GitBlobKey it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv;
            boolean bl2 = false;
            if (this.fileToKey(it) == null) continue;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        HashSet mappedNames = (HashSet)destination$iv;
        return this.withIgnoredItems-GitBlobKey(mappedNames);
    }

    @Nullable
    public final byte[] find(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        GitBlobKey gitBlobKey = this.fileToKey(file);
        if (gitBlobKey == null) {
            return null;
        }
        return this.items.get(gitBlobKey);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<GitBlobKey> mapFilesToExistingKeys(@NotNull Collection<? extends VirtualFile> files) {
        void var3_3;
        void $this$mapNotNullTo$iv;
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Iterable iterable = files;
        Collection destination$iv = new HashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            GitBlobKey it$iv;
            GitBlobKey key;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator.next();
            boolean bl = false;
            VirtualFile it = (VirtualFile)element$iv;
            boolean bl2 = false;
            if ((this.fileToKey(it) == null ? null : (!this.items.containsKey(key) ? null : key)) == null) continue;
            it$iv = it$iv;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        return (Set)var3_3;
    }

    private final GitBlobKey fileToKey(String relName) {
        String[] stringArray = new String[]{"/"};
        List elements = StringsKt.split$default((CharSequence)relName, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        String name2 = (String)CollectionsKt.last((List)elements);
        int[] ids = new int[elements.size() - 1];
        int n = elements.size() - 1;
        for (int i = 0; i < n; ++i) {
            Integer n2 = this.namesMap.get(elements.get(i));
            if (n2 == null) {
                return null;
            }
            ids[i] = n2;
        }
        return new GitBlobKey(ids, name2);
    }

    private final GitBlobKey fileToKey(VirtualFile file) {
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String name2 = string;
        VirtualFile virtualFile = file.getParent();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile parent = virtualFile;
        ArrayList invertedIds = new ArrayList();
        VirtualFile tmp = parent;
        while (!Intrinsics.areEqual((Object)tmp, (Object)this.root)) {
            Collection collection = invertedIds;
            Integer n = this.namesMap.get(tmp.getName());
            if (n == null) {
                return null;
            }
            collection.add(Integer.valueOf(n));
            if (tmp.getParent() != null) continue;
            return null;
        }
        int[] ids = CollectionsKt.toIntArray((Collection)invertedIds);
        ArraysKt.reverse((int[])ids);
        return new GitBlobKey(ids, name2);
    }
}

