/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.generator;

import com.intellij.codeWithMe.ClientId;
import com.intellij.indexing.shared.generator.EnumeratedHashedIndexedFiles;
import com.intellij.indexing.shared.generator.ErrorsCollector;
import com.intellij.indexing.shared.generator.HashedIndexedFiles;
import com.intellij.indexing.shared.generator.IndexedFileHash;
import com.intellij.indexing.shared.generator.IndexedFilesReporter;
import com.intellij.indexing.shared.generator.IndexesExporterHashEnumerateTaskKt;
import com.intellij.indexing.shared.generator.IndexesExporterHashEnumerator;
import com.intellij.indexing.shared.message.SharedIndexesBundle;
import com.intellij.indexing.shared.platform.hash.SharedIndexContentHash;
import com.intellij.indexing.shared.platform.hash.SharedIndexHashStorage;
import com.intellij.indexing.shared.platform.hash.SharedIndexHashStorages;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ(\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J2\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u00132\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u00172\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/indexing/shared/generator/IndexesExporterHashEnumerateTask;", "", "errorsCollector", "Lcom/intellij/indexing/shared/generator/ErrorsCollector;", "reporter", "Lcom/intellij/indexing/shared/generator/IndexedFilesReporter;", "(Lcom/intellij/indexing/shared/generator/ErrorsCollector;Lcom/intellij/indexing/shared/generator/IndexedFilesReporter;)V", "enumerateHashes", "Lcom/intellij/indexing/shared/generator/EnumeratedHashedIndexedFiles;", "files", "Lcom/intellij/indexing/shared/generator/HashedIndexedFiles;", "chunkRoot", "Ljava/nio/file/Path;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "enumerateHashesImpl", "lifetime", "Lcom/intellij/openapi/Disposable;", "openStorages", "", "Lcom/intellij/indexing/shared/platform/hash/SharedIndexContentHash;", "Lcom/intellij/indexing/shared/platform/hash/SharedIndexHashStorage;", "hashes", "", "intellij.indexing.shared.generator"})
@SourceDebugExtension(value={"SMAP\nIndexesExporterHashEnumerateTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexesExporterHashEnumerateTask.kt\ncom/intellij/indexing/shared/generator/IndexesExporterHashEnumerateTask\n+ 2 ProgressIndicatorEx.kt\ncom/intellij/openapi/progress/ProgressIndicatorForCollections\n+ 3 extensions.kt\ncom/intellij/openapi/util/ExtensionsKt\n+ 4 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,125:1\n13#2,4:126\n19#2,2:136\n22#3,6:130\n42#4,3:138\n1045#5:141\n*S KotlinDebug\n*F\n+ 1 IndexesExporterHashEnumerateTask.kt\ncom/intellij/indexing/shared/generator/IndexesExporterHashEnumerateTask\n*L\n57#1:126,4\n57#1:136,2\n62#1:130,6\n74#1:138,3\n101#1:141\n*E\n"})
public final class IndexesExporterHashEnumerateTask {
    @NotNull
    private final ErrorsCollector errorsCollector;
    @Nullable
    private final IndexedFilesReporter reporter;

    public IndexesExporterHashEnumerateTask(@NotNull ErrorsCollector errorsCollector, @Nullable IndexedFilesReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)errorsCollector, (String)"errorsCollector");
        this.errorsCollector = errorsCollector;
        this.reporter = reporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final EnumeratedHashedIndexedFiles enumerateHashes(@NotNull HashedIndexedFiles files, @NotNull Path chunkRoot, @NotNull ProgressIndicator indicator) {
        EnumeratedHashedIndexedFiles enumeratedHashedIndexedFiles;
        Intrinsics.checkNotNullParameter((Object)files, (String)"files");
        Intrinsics.checkNotNullParameter((Object)chunkRoot, (String)"chunkRoot");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        ProgressIndicator $this$withPushPop$iv = indicator;
        boolean $i$f$withPushPop = false;
        boolean wasIndeterminate$iv = $this$withPushPop$iv.isIndeterminate();
        $this$withPushPop$iv.pushState();
        try {
            EnumeratedHashedIndexedFiles enumeratedHashedIndexedFiles2;
            boolean bl = false;
            indicator.setText(SharedIndexesBundle.message((String)"progress.text.hashing.files", (Object[])new Object[0]));
            indicator.setIndeterminate(false);
            indicator.setText2(null);
            Disposable $this$use$iv = Disposer.newDisposable();
            boolean $i$f$use = false;
            try {
                Disposable it = $this$use$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                enumeratedHashedIndexedFiles2 = this.enumerateHashesImpl(it, files, chunkRoot, indicator);
            }
            finally {
                if ($this$use$iv != null) {
                    Disposer.dispose((Disposable)$this$use$iv);
                }
            }
            enumeratedHashedIndexedFiles = enumeratedHashedIndexedFiles2;
        }
        finally {
            $this$withPushPop$iv.setIndeterminate(wasIndeterminate$iv);
            $this$withPushPop$iv.popState();
        }
        return enumeratedHashedIndexedFiles;
    }

    private final Map<SharedIndexContentHash, SharedIndexHashStorage> openStorages(Disposable lifetime, List<? extends SharedIndexContentHash> hashes, Path chunkRoot) {
        HashMap result = new HashMap();
        for (SharedIndexContentHash sharedIndexContentHash : hashes) {
            try {
                SharedIndexHashStorage storage;
                boolean $i$f$service = false;
                Class<SharedIndexHashStorages> serviceClass$iv = SharedIndexHashStorages.class;
                Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (object == null) {
                    throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
                }
                if (((SharedIndexHashStorages)object).createGeneratorStorage(chunkRoot, sharedIndexContentHash, lifetime) == null) continue;
                ((Map)result).put(sharedIndexContentHash, storage);
            }
            catch (Throwable t) {
                if (t instanceof ControlFlowException) {
                    throw t;
                }
                IndexesExporterHashEnumerateTaskKt.access$getLOG$p().warn("Failed to open hash storage for " + sharedIndexContentHash.getProviderId() + ". " + t.getMessage(), t);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final EnumeratedHashedIndexedFiles enumerateHashesImpl(Disposable lifetime, HashedIndexedFiles files, Path chunkRoot, ProgressIndicator indicator) {
        EnumeratedHashedIndexedFiles indexedFiles;
        block12: {
            Map<SharedIndexContentHash, SharedIndexHashStorage> storages = this.openStorages(lifetime, files.getUsedHashes(), chunkRoot);
            int totalNumberOfFilesForIndexing2 = files.getHashes().size();
            if (totalNumberOfFilesForIndexing2 == 0) {
                return IndexesExporterHashEnumerateTaskKt.getEmptyEnumeratedHashedIndexedFiles();
            }
            int finished = 0;
            Map hashEnumeration = new HashMap();
            AutoCloseable autoCloseable = new IndexesExporterHashEnumerator(chunkRoot);
            Throwable throwable = null;
            try {
                IndexesExporterHashEnumerator hashEnumerator = (IndexesExporterHashEnumerator)autoCloseable;
                boolean bl = false;
                Iterable $this$sortedBy$iv = files.getHashes().entrySet();
                boolean $i$f$sortedBy = false;
                List fileHashesStableOrdered = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        Map.Entry it = (Map.Entry)a;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Object)((VirtualFile)it.getKey()).getCanonicalPath());
                        it = (Map.Entry)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((VirtualFile)it.getKey()).getCanonicalPath())));
                    }
                });
                for (Map.Entry entry : fileHashesStableOrdered) {
                    VirtualFile file = (VirtualFile)entry.getKey();
                    IndexedFileHash hash2 = (IndexedFileHash)entry.getValue();
                    int n = finished;
                    finished = n + 1;
                    indicator.setFraction((double)n / (double)totalNumberOfFilesForIndexing2);
                    int hashId = hashEnumerator.enumerateHash(hash2);
                    Integer n2 = hashId;
                    hashEnumeration.put(file, n2);
                    for (Map.Entry<SharedIndexContentHash, SharedIndexHashStorage> entry2 : storages.entrySet()) {
                        SharedIndexContentHash provider = entry2.getKey();
                        SharedIndexHashStorage store = entry2.getValue();
                        try {
                            byte[] pHash;
                            if (hash2.hash(provider) == null) continue;
                            store.enumerate(pHash, hashId);
                        }
                        catch (Throwable t) {
                            if (t instanceof ControlFlowException) {
                                throw t;
                            }
                            this.errorsCollector.fileHashError(file, "Failed to write hash for " + provider.getProviderId() + ". " + t.getMessage(), t);
                        }
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            indexedFiles = new EnumeratedHashedIndexedFiles(files, hashEnumeration);
            IndexedFilesReporter indexedFilesReporter = this.reporter;
            if (indexedFilesReporter == null) break block12;
            indexedFilesReporter.dumpFileHashes(indexedFiles, indicator);
        }
        return indexedFiles;
    }
}

