/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.generator;

import com.intellij.indexing.shared.generator.DumpSharedIndexCommand;
import com.intellij.indexing.shared.generator.DumpVersionArgs;
import com.intellij.indexing.shared.metadata.SharedIndexMetadata;
import com.intellij.indexing.shared.platform.api.SharedIndexInfrastructureVersion;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.platform.util.ArgsParser;
import com.intellij.util.io.PathKt;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0096@\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/intellij/indexing/shared/generator/DumpIndexerVersionStarter;", "Lcom/intellij/indexing/shared/generator/DumpSharedIndexCommand;", "Lcom/intellij/indexing/shared/generator/DumpVersionArgs;", "()V", "commandDescription", "", "getCommandDescription", "()Ljava/lang/String;", "commandName", "getCommandName", "executeCommand", "", "args", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "(Lcom/intellij/indexing/shared/generator/DumpVersionArgs;Lcom/intellij/openapi/progress/ProgressIndicator;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "parseArgs", "parser", "Lcom/intellij/platform/util/ArgsParser;", "intellij.indexing.shared.generator"})
public final class DumpIndexerVersionStarter
implements DumpSharedIndexCommand<DumpVersionArgs> {
    @NotNull
    private final String commandName;
    @NotNull
    private final String commandDescription;

    public DumpIndexerVersionStarter() {
        this.commandName = "version";
        this.commandDescription = "Generates version metadata without indexing any file";
    }

    @Override
    @NotNull
    public String getCommandName() {
        return this.commandName;
    }

    @Override
    @NotNull
    public String getCommandDescription() {
        return this.commandDescription;
    }

    @Override
    @NotNull
    public DumpVersionArgs parseArgs(@NotNull ArgsParser parser) {
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        return new DumpVersionArgs(parser);
    }

    @Override
    @Nullable
    public Object executeCommand(@NotNull DumpVersionArgs args, @NotNull ProgressIndicator indicator, @NotNull Continuation<? super Unit> $completion) {
        SharedIndexInfrastructureVersion sharedIndexInfrastructureVersion = SharedIndexInfrastructureVersion.getIdeVersion();
        Intrinsics.checkNotNullExpressionValue((Object)sharedIndexInfrastructureVersion, (String)"getIdeVersion(...)");
        SharedIndexInfrastructureVersion version = sharedIndexInfrastructureVersion;
        byte[] bytes = SharedIndexMetadata.Companion.writeVersionInfo(version);
        System.out.println((Object)("Indexes Full Version (weak hash): " + version.getWeakVersionHash()));
        PathKt.write((Path)args.getOutputFile(), (byte[])bytes);
        return Unit.INSTANCE;
    }
}

