/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.exception;

import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.javascript.psi.JSCatchBlock;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSTryStatement;
import com.intellij.lang.javascript.psi.util.VariableAccessUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JavaScriptInspection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class UnusedCatchParameterJSInspection
extends JavaScriptInspection {
    public boolean m_ignoreCatchBlocksWithComments = false;

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"m_ignoreCatchBlocksWithComments", (String)InspectionJSBundle.message("unused.catch.parameter.ignore.catch.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            UnusedCatchParameterJSInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @Override
    @NotNull
    @InspectionMessage
    protected String buildErrorString(Object ... args) {
        String string = InspectionJSBundle.message("unused.catch.parameter.problem.descriptor", new Object[0]);
        if (string == null) {
            UnusedCatchParameterJSInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new EmptyCatchBlockVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/sixrr/inspectjs/exception/UnusedCatchParameterJSInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class EmptyCatchBlockVisitor
    extends BaseInspectionVisitor {
        private EmptyCatchBlockVisitor() {
        }

        @Override
        public void visitJSTryStatement(@NotNull JSTryStatement statement) {
            if (statement == null) {
                EmptyCatchBlockVisitor.$$$reportNull$$$0(0);
            }
            super.visitJSTryStatement(statement);
            JSCatchBlock jsCatchBlock = statement.getCatchBlock();
            if (jsCatchBlock == null) {
                return;
            }
            this.checkCatchSection(jsCatchBlock);
        }

        private void checkCatchSection(JSCatchBlock section) {
            JSParameter param = section.getParameter();
            JSStatement block = section.getStatement();
            if (param == null || block == null) {
                return;
            }
            @NonNls String paramName = param.getName();
            if ("ignore".equals(paramName) || "ignored".equals(paramName)) {
                return;
            }
            if (UnusedCatchParameterJSInspection.this.m_ignoreCatchBlocksWithComments) {
                PsiElement[] children;
                for (PsiElement child : children = block.getChildren()) {
                    if (!(child instanceof PsiComment)) continue;
                    return;
                }
            }
            if (!VariableAccessUtil.isLocalVariableUsed(param, (PsiElement)block)) {
                this.registerVariableError(param);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/sixrr/inspectjs/exception/UnusedCatchParameterJSInspection$EmptyCatchBlockVisitor", "visitJSTryStatement"));
        }
    }
}

