/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.dataflow;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.findUsages.JSReadWriteAccessDetector;
import com.intellij.lang.javascript.inspections.JSUnusedLocalSymbolsInspection;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSThrowStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSUseScopeProvider;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.javascript.psi.util.VariableAccessUtil;
import com.intellij.lang.javascript.validation.JSBundleMessageHighlighter;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JavaScriptInspection;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnnecessaryLocalVariableJSInspectionBase
extends JavaScriptInspection {
    public boolean m_ignoreImmediatelyReturnedVariables = false;
    public boolean m_ignoreAnnotatedVariables = false;

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"m_ignoreImmediatelyReturnedVariables", (String)InspectionJSBundle.message("redundant.local.variable.ignore.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            UnnecessaryLocalVariableJSInspectionBase.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    @InspectionMessage
    public String buildErrorString(Object ... args) {
        PsiElement element = (PsiElement)args[0];
        PsiElement var = element.getParent();
        if (var == null) {
            var = element;
        }
        String string = ((JSBundleMessageHighlighter)element.getProject().getService(JSBundleMessageHighlighter.class)).messageFromInspectionBundle("unnecessary.local.variable.problem.descriptor", new JSBundleMessageHighlighter.NameOfElement(element.getText(), var));
        if (string == null) {
            UnnecessaryLocalVariableJSInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryLocalVariableVisitor();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/sixrr/inspectjs/dataflow/UnnecessaryLocalVariableJSInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class UnnecessaryLocalVariableVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryLocalVariableVisitor() {
        }

        @Override
        public void visitJSVarStatement(@NotNull JSVarStatement varStatement) {
            JSVariable[] variables;
            if (varStatement == null) {
                UnnecessaryLocalVariableVisitor.$$$reportNull$$$0(0);
            }
            super.visitJSVarStatement(varStatement);
            if (varStatement.getVarKeyword() == JSVarStatement.VarKeyword.USING) {
                return;
            }
            for (JSVariable variable : variables = varStatement.getVariables()) {
                if (JSDestructuringUtil.isDestructuring(variable.getParent())) continue;
                if (this.isCopyVariable(variable) && this.validateTypeAndInitializer(variable)) {
                    this.registerVariableError(variable);
                    continue;
                }
                if (!UnnecessaryLocalVariableJSInspectionBase.this.m_ignoreImmediatelyReturnedVariables && this.isImmediatelyReturned(variable)) {
                    JSFunction scope2 = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)variable, JSFunction.class, (boolean)true);
                    if (scope2 != null && scope2.getReturnTypeElement() == null && !this.validateTypeAndInitializer(variable)) continue;
                    this.registerVariableError(variable);
                    continue;
                }
                if (!UnnecessaryLocalVariableJSInspectionBase.this.m_ignoreImmediatelyReturnedVariables && this.isImmediatelyThrown(variable)) {
                    this.registerVariableError(variable);
                    continue;
                }
                if (this.isImmediatelyAssigned(variable)) {
                    this.registerVariableError(variable);
                    continue;
                }
                if (!this.isImmediatelyAssignedAsDeclaration(variable) || !this.validateTypeAndInitializer(variable)) continue;
                this.registerVariableError(variable);
            }
        }

        private boolean validateTypeAndInitializer(@NotNull JSVariable variable) {
            PsiElement typeElement2;
            if (variable == null) {
                UnnecessaryLocalVariableVisitor.$$$reportNull$$$0(1);
            }
            if ((typeElement2 = variable.getTypeElement()) == null) {
                return true;
            }
            JSType explicitType = variable.getJSType();
            if (explicitType == null) {
                return true;
            }
            JSExpression initializer = variable.getInitializer();
            if (initializer == null) {
                return false;
            }
            JSType type2 = JSTypeUtils.widenLiteralTypes(JSResolveUtil.getExpressionJSType(initializer));
            if (type2 == null) {
                return false;
            }
            return explicitType.isEquivalentTo(type2, null);
        }

        private boolean isCopyVariable(final JSVariable variable) {
            JSExpression initializer = variable.getInitializer();
            if (!(initializer instanceof JSReferenceExpression)) {
                return false;
            }
            final PsiElement referent = ((JSReferenceExpression)initializer).resolve();
            if (!(referent instanceof JSVariable) || JSResolveUtil.findParent(referent) instanceof JSClass) {
                return false;
            }
            JSVarStatement declarationStatement = (JSVarStatement)PsiTreeUtil.getParentOfType((PsiElement)variable, JSVarStatement.class);
            if (declarationStatement == null) {
                return false;
            }
            final JSStatement nextStatement = this.getNextStatement(declarationStatement);
            if (nextStatement == null) {
                return false;
            }
            PsiElement containingScope = variable.getDeclarationScope();
            if (containingScope instanceof JSFunction) {
                JSBlockStatement body2 = ((JSFunction)containingScope).getBlock();
                if (body2 == null) {
                    return false;
                }
                containingScope = body2;
            }
            if (containingScope == null) {
                return false;
            }
            final Flags flags = new Flags();
            containingScope.accept((PsiElementVisitor)new JSRecursiveElementVisitor(){
                private boolean withinNextStatement = false;
                private boolean withinClosure = false;

                @Override
                public void visitElement(@NotNull PsiElement element) {
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (flags.isUnsatisfiable()) {
                        return;
                    }
                    super.visitElement(element);
                }

                @Override
                public void visitJSFunctionDeclaration(@NotNull JSFunction node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    boolean _withinClosure = this.withinClosure;
                    this.withinClosure = true;
                    super.visitJSFunctionDeclaration(node);
                    this.withinClosure = _withinClosure;
                }

                @Override
                public void visitJSFunctionExpression(@NotNull JSFunctionExpression node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    boolean _withinClosure = this.withinClosure;
                    this.withinClosure = true;
                    super.visitJSFunctionExpression(node);
                    this.withinClosure = _withinClosure;
                }

                @Override
                public void visitJSStatement(@NotNull JSStatement node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    if (nextStatement == node) {
                        this.withinNextStatement = true;
                    }
                    super.visitJSStatement(node);
                    if (nextStatement == node) {
                        this.withinNextStatement = false;
                    }
                }

                @Override
                public void visitJSReferenceExpression(@NotNull JSReferenceExpression node) {
                    boolean isReferenceToLocalVar;
                    if (node == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    if (isReferenceToLocalVar = UnnecessaryLocalVariableVisitor.this.isReferenceTo(node, variable)) {
                        PsiElement parent;
                        if (this.isReadUsage(node)) {
                            if (flags.usedAnywhere) {
                                flags.canBeCopy = false;
                            }
                            flags.usedAnywhere = true;
                            if (!this.withinNextStatement) {
                                flags.canBeCopy = false;
                            }
                            if (this.withinClosure) {
                                flags.usedWithinClosure = true;
                            }
                        } else {
                            flags.canBeCopy = false;
                        }
                        if ((parent = node.getParent()) instanceof ES6Property && ((ES6Property)parent).isShorthanded()) {
                            flags.hasShorthandPropertyUsages = true;
                        }
                    } else if (UnnecessaryLocalVariableVisitor.this.isReferenceTo(node, (JSVariable)referent) && !this.isReadUsage(node)) {
                        flags.hasReferentWrites = true;
                    }
                    super.visitJSReferenceExpression(node);
                }

                private boolean isReadUsage(JSReferenceExpression node) {
                    return JSReadWriteAccessDetector.ourInstance.getExpressionAccess((PsiElement)node) == ReadWriteAccessDetector.Access.Read;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "element";
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "node";
                            break;
                        }
                    }
                    objectArray2[1] = "com/sixrr/inspectjs/dataflow/UnnecessaryLocalVariableJSInspectionBase$UnnecessaryLocalVariableVisitor$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitElement";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitJSFunctionDeclaration";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitJSFunctionExpression";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitJSStatement";
                            break;
                        }
                        case 4: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitJSReferenceExpression";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            return flags.usedAnywhere && !flags.isUnsatisfiable();
        }

        private boolean isReferenceTo(JSReferenceExpression node, JSVariable varr) {
            return node.getQualifier() == null && Objects.equals(node.getReferenceName(), varr.getName()) && node.resolve() == varr;
        }

        private boolean isImmediateReturnExpression(JSExpression returnValue, JSVariable variable) {
            return returnValue instanceof JSReferenceExpression && this.isReferenceTo((JSReferenceExpression)returnValue, variable);
        }

        private boolean isImmediatelyReturned(JSVariable variable) {
            JSStatement nextStatement = this.getNextStatement(variable);
            if (!(nextStatement instanceof JSReturnStatement)) {
                return false;
            }
            JSReturnStatement returnStatement = (JSReturnStatement)nextStatement;
            if (this.isImmediateReturnExpression(returnStatement.getExpression(), variable)) {
                PsiElement scopeNode = JSUseScopeProvider.getLexicalScopeOrFile((PsiElement)returnStatement);
                if (!(scopeNode instanceof JSFunction)) {
                    return false;
                }
                boolean found = JSUnusedLocalSymbolsInspection.checkUsages(variable, scopeNode, it -> true, 2);
                return !found;
            }
            return false;
        }

        @Nullable
        private JSStatement getNextStatement(JSVariable variable) {
            JSVarStatement declarationStatement = (JSVarStatement)PsiTreeUtil.getParentOfType((PsiElement)variable, JSVarStatement.class);
            return this.getNextStatement(declarationStatement);
        }

        private JSStatement getNextStatement(JSStatement statement) {
            return (JSStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)statement, JSStatement.class);
        }

        private boolean isImmediatelyThrown(JSVariable variable) {
            JSStatement nextStatement = this.getNextStatement(variable);
            if (!(nextStatement instanceof JSThrowStatement)) {
                return false;
            }
            JSThrowStatement throwStatement = (JSThrowStatement)nextStatement;
            return this.isImmediateReturnExpression(throwStatement.getExpression(), variable);
        }

        private boolean isImmediatelyAssigned(JSVariable variable) {
            JSAssignmentExpression assignmentExpression;
            JSSourceElement[] statements;
            int followingStatementNumber;
            block14: {
                block13: {
                    JSVarStatement declarationStatement;
                    JSBlockStatement containingScope = (JSBlockStatement)PsiTreeUtil.getParentOfType((PsiElement)variable, JSBlockStatement.class);
                    if (containingScope == null) {
                        return false;
                    }
                    PsiElement parent = variable.getParent();
                    JSVarStatement jSVarStatement = declarationStatement = parent instanceof JSVarStatement ? (JSVarStatement)parent : null;
                    if (declarationStatement == null) {
                        return false;
                    }
                    JSSourceElement nextStatement = null;
                    followingStatementNumber = 0;
                    statements = containingScope.getStatementListItems();
                    for (int i = 0; i < statements.length - 1; ++i) {
                        if (!statements[i].equals(declarationStatement)) continue;
                        nextStatement = statements[i + 1];
                        followingStatementNumber = i + 2;
                    }
                    if (nextStatement == null) {
                        return false;
                    }
                    if (!(nextStatement instanceof JSExpressionStatement)) {
                        return false;
                    }
                    JSExpressionStatement expressionStatement = (JSExpressionStatement)nextStatement;
                    JSExpression expression = expressionStatement.getExpression();
                    if (!(expression instanceof JSAssignmentExpression)) break block13;
                    assignmentExpression = (JSAssignmentExpression)expression;
                    if (((JSAssignmentExpression)expression).getOperationSign() == JSTokenTypes.EQ) break block14;
                }
                return false;
            }
            JSExpression rhs = assignmentExpression.getROperand();
            if (rhs == null) {
                return false;
            }
            if (!(rhs instanceof JSReferenceExpression)) {
                return false;
            }
            JSReferenceExpression reference = (JSReferenceExpression)rhs;
            PsiElement referent = reference.resolve();
            if (referent == null || !referent.equals(variable)) {
                return false;
            }
            JSExpression lhs = assignmentExpression.getLOperand();
            if (VariableAccessUtil.isLocalVariableUsed(variable, (PsiElement)lhs)) {
                return false;
            }
            for (int i = followingStatementNumber; i < statements.length; ++i) {
                if (!VariableAccessUtil.isLocalVariableUsed(variable, (PsiElement)statements[i])) continue;
                return false;
            }
            return !VariableAccessUtil.isLocalVariableUsed(variable, (PsiElement)statements[followingStatementNumber - 2]);
        }

        private boolean isImmediatelyAssignedAsDeclaration(JSVariable variable) {
            JSBlockStatement containingScope = (JSBlockStatement)PsiTreeUtil.getParentOfType((PsiElement)variable, JSBlockStatement.class);
            if (containingScope == null) {
                return false;
            }
            JSVarStatement declarationStatement = (JSVarStatement)PsiTreeUtil.getParentOfType((PsiElement)variable, JSVarStatement.class);
            if (declarationStatement == null) {
                return false;
            }
            JSSourceElement nextStatement = null;
            int followingStatementNumber = 0;
            JSSourceElement[] statements = containingScope.getStatementListItems();
            for (int i = 0; i < statements.length - 1; ++i) {
                if (!statements[i].equals(declarationStatement)) continue;
                nextStatement = statements[i + 1];
                followingStatementNumber = i + 2;
            }
            if (nextStatement == null) {
                return false;
            }
            if (!(nextStatement instanceof JSVarStatement)) {
                return false;
            }
            JSVarStatement declaration = (JSVarStatement)nextStatement;
            JSVariable[] declarations = declaration.getVariables();
            if (declarations.length != 1) {
                return false;
            }
            JSExpression rhs = declarations[0].getInitializer();
            if (rhs == null) {
                return false;
            }
            if (!(rhs instanceof JSReferenceExpression)) {
                return false;
            }
            PsiElement referent = ((PsiReference)rhs).resolve();
            if (referent == null || !referent.equals(variable)) {
                return false;
            }
            for (int i = followingStatementNumber; i < statements.length; ++i) {
                if (!VariableAccessUtil.isLocalVariableUsed(variable, (PsiElement)statements[i])) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "varStatement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
            }
            objectArray2[1] = "com/sixrr/inspectjs/dataflow/UnnecessaryLocalVariableJSInspectionBase$UnnecessaryLocalVariableVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSVarStatement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "validateTypeAndInitializer";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static class Flags {
            boolean usedAnywhere = false;
            boolean usedWithinClosure = false;
            boolean hasReferentWrites = false;
            boolean canBeCopy = true;
            boolean hasShorthandPropertyUsages = false;

            private Flags() {
            }

            private boolean isUnsatisfiable() {
                return !this.canBeCopy || this.usedWithinClosure || this.hasReferentWrites || this.hasShorthandPropertyUsages;
            }
        }
    }
}

