/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.dataflow;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.refactoring.inline.JSInlineHandler;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.InspectionJSFix;
import com.sixrr.inspectjs.dataflow.UnnecessaryLocalVariableJSInspectionBase;
import org.jetbrains.annotations.NotNull;

public class UnnecessaryLocalVariableJSInspection
extends UnnecessaryLocalVariableJSInspectionBase {
    @Override
    protected InspectionJSFix buildFix(PsiElement location) {
        return new Fix();
    }

    public static class Fix
    extends InspectionJSFix {
        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement parent;
            PsiElement element = descriptor.getPsiElement();
            PsiElement psiElement = parent = element != null ? element.getParent() : null;
            if (parent instanceof JSVariable) {
                Editor editor = (Editor)CommonDataKeys.EDITOR.getData(DataManager.getInstance().getDataContext());
                if (editor == null) {
                    return;
                }
                PsiFile containingFile2 = parent.getContainingFile();
                if (InjectedLanguageManager.getInstance((Project)containingFile2.getProject()).getInjectionHost((PsiElement)containingFile2) != null && !(editor instanceof EditorWindow)) {
                    editor = InjectedLanguageUtil.getInjectedEditorForInjectedFile((Editor)editor, (PsiFile)containingFile2);
                }
                new JSInlineHandler(true).inlineElement(project, editor, parent);
            }
        }

        public boolean startInWriteAction() {
            return false;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionJSBundle.message("redundant.local.variable.quickfix", new Object[0]);
            if (string == null) {
                Fix.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/dataflow/UnnecessaryLocalVariableJSInspection$Fix", "getFamilyName"));
        }
    }
}

