/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.control;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCommonTypeNames;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.InspectionJSFix;
import com.sixrr.inspectjs.JavaScriptInspection;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTypeOfValuesInspection
extends JavaScriptInspection {
    private static final Set<String> typeofValuesSet = ContainerUtil.newHashSet((Object[])JSCommonTypeNames.TYPEOF_VALUES);

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BaseInspectionVisitor(){

            @Override
            public void visitJSBinaryExpression(@NotNull JSBinaryExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitJSBinaryExpression(node);
                if (!JSTypeOfValuesInspection.isComparingOperation(node)) {
                    return;
                }
                boolean acceptedType = true;
                JSLiteralExpression literal = null;
                if (node.getLOperand() instanceof JSPrefixExpression && node.getROperand() instanceof JSLiteralExpression) {
                    literal = (JSLiteralExpression)node.getROperand();
                    acceptedType = JSTypeOfValuesInspection.isAcceptedType((JSPrefixExpression)node.getLOperand(), (JSLiteralExpression)node.getROperand());
                } else if (node.getLOperand() instanceof JSLiteralExpression && node.getROperand() instanceof JSPrefixExpression) {
                    literal = (JSLiteralExpression)node.getLOperand();
                    acceptedType = JSTypeOfValuesInspection.isAcceptedType((JSPrefixExpression)node.getROperand(), (JSLiteralExpression)node.getLOperand());
                }
                if (!acceptedType) {
                    this.registerError((PsiElement)literal);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/sixrr/inspectjs/control/JSTypeOfValuesInspection$1", "visitJSBinaryExpression"));
            }
        };
    }

    private static boolean isComparingOperation(JSBinaryExpression node) {
        return node.getOperationSign() == JSTokenTypes.EQEQ || node.getOperationSign() == JSTokenTypes.EQEQEQ || node.getOperationSign() == JSTokenTypes.NEQEQ || node.getOperationSign() == JSTokenTypes.NE;
    }

    @Override
    @InspectionMessage
    @NotNull
    protected String buildErrorString(Object ... args) {
        String string = InspectionJSBundle.message("typeof.using.incorrect.case.error", new Object[0]);
        if (string == null) {
            JSTypeOfValuesInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static boolean isAcceptedType(JSPrefixExpression pref, JSLiteralExpression expr) {
        if (pref.getOperationSign() != JSTokenTypes.TYPEOF_KEYWORD || !expr.isQuotedLiteral()) {
            return true;
        }
        String stringValue = expr.getStringValue();
        if (stringValue == null) {
            return true;
        }
        return typeofValuesSet.contains(stringValue);
    }

    @Override
    @Nullable
    protected InspectionJSFix buildFix(PsiElement location) {
        final JSLiteralExpression literalExpression = (JSLiteralExpression)location;
        String text2 = literalExpression.getText();
        if (StringUtil.isEmpty((String)text2)) {
            return null;
        }
        String value = literalExpression.getStringValue();
        if (value == null) {
            return null;
        }
        char quote = text2.charAt(0);
        String stringValue = StringUtil.toLowerCase((String)value);
        if (!typeofValuesSet.contains(stringValue)) {
            return null;
        }
        final String quotedValue = quote + stringValue + quote;
        return new InspectionJSFix(){

            @Nls
            @NotNull
            public String getName() {
                String string = InspectionJSBundle.message("typeof.using.incorrect.convert", quotedValue);
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Nls
            @NotNull
            public String getFamilyName() {
                String string = InspectionJSBundle.message("typeof.using.incorrect.family.name", new Object[0]);
                if (string == null) {
                    2.$$$reportNull$$$0(1);
                }
                return string;
            }

            @Override
            protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
                JSChangeUtil.replaceExpression(literalExpression, JSPsiElementFactory.createJSExpression(quotedValue, (PsiElement)literalExpression));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/sixrr/inspectjs/control/JSTypeOfValuesInspection$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/JSTypeOfValuesInspection", "buildErrorString"));
    }
}

