/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.control;

import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.psi.PsiElement;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JavaScriptInspection;
import org.jetbrains.annotations.NotNull;

public class IfStatementWithTooManyBranchesJSInspection
extends JavaScriptInspection {
    private static final int DEFAULT_BRANCH_LIMIT = 3;
    public int m_limit = 3;

    private int getLimit() {
        return this.m_limit;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.number((String)"m_limit", (String)InspectionJSBundle.message("maximum.number.of.branches.parameter", new Object[0]), (int)1, (int)1000)});
        if (optPane == null) {
            IfStatementWithTooManyBranchesJSInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @Override
    @InspectionMessage
    @NotNull
    protected String buildErrorString(Object ... args) {
        JSIfStatement statement = (JSIfStatement)args[0];
        int branches = IfStatementWithTooManyBranchesJSInspection.calculateNumBranches(statement);
        String string = InspectionJSBundle.message("if.statement.with.too.many.branches.error.string", branches);
        if (string == null) {
            IfStatementWithTooManyBranchesJSInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static int calculateNumBranches(JSIfStatement statement) {
        JSStatement branch = (JSStatement)statement.getElseBranch();
        if (branch == null) {
            return 1;
        }
        if (!(branch instanceof JSIfStatement)) {
            return 2;
        }
        return 1 + IfStatementWithTooManyBranchesJSInspection.calculateNumBranches((JSIfStatement)branch);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/sixrr/inspectjs/control/IfStatementWithTooManyBranchesJSInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitJSIfStatement(@NotNull JSIfStatement statement) {
            JSIfStatement parentStatement;
            JSStatement elseBranch;
            if (statement == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitJSIfStatement(statement);
            PsiElement parent = statement.getParent();
            if (parent instanceof JSIfStatement && statement.equals(elseBranch = (JSStatement)(parentStatement = (JSIfStatement)parent).getElseBranch())) {
                return;
            }
            int branches = IfStatementWithTooManyBranchesJSInspection.calculateNumBranches(statement);
            if (branches <= IfStatementWithTooManyBranchesJSInspection.this.getLimit()) {
                return;
            }
            this.registerStatementError(statement, statement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/sixrr/inspectjs/control/IfStatementWithTooManyBranchesJSInspection$Visitor", "visitJSIfStatement"));
        }
    }
}

