/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.control;

import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JavaScriptInspection;
import com.sixrr.inspectjs.utils.EquivalenceChecker;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DuplicateConditionJSInspection
extends JavaScriptInspection {
    @Override
    @InspectionMessage
    @NotNull
    public String buildErrorString(Object ... args) {
        String string = InspectionJSBundle.message("duplicate.condition.error.string", new Object[0]);
        if (string == null) {
            DuplicateConditionJSInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new DuplicateConditionVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/DuplicateConditionJSInspection", "buildErrorString"));
    }

    private static class DuplicateConditionVisitor
    extends BaseInspectionVisitor {
        private DuplicateConditionVisitor() {
        }

        @Override
        public void visitJSIfStatement(@NotNull JSIfStatement statement) {
            JSIfStatement parentStatement;
            JSStatement elseBranch;
            if (statement == null) {
                DuplicateConditionVisitor.$$$reportNull$$$0(0);
            }
            super.visitJSIfStatement(statement);
            PsiElement parent = statement.getParent();
            if (parent instanceof JSIfStatement && statement.equals(elseBranch = (JSStatement)(parentStatement = (JSIfStatement)parent).getElseBranch())) {
                return;
            }
            HashSet<JSExpression> conditions = new HashSet<JSExpression>();
            this.collectConditionsForIfStatement(statement, conditions);
            int numConditions = conditions.size();
            if (numConditions < 2) {
                return;
            }
            JSExpression[] conditionArray = conditions.toArray(new JSExpression[numConditions]);
            boolean[] matched = new boolean[conditionArray.length];
            Arrays.fill(matched, false);
            for (int i = 0; i < conditionArray.length; ++i) {
                if (matched[i]) continue;
                JSExpression condition = conditionArray[i];
                for (int j = i + 1; j < conditionArray.length; ++j) {
                    JSExpression testCondition;
                    boolean areEquivalent;
                    if (matched[j] || !(areEquivalent = EquivalenceChecker.expressionsAreEquivalent(condition, testCondition = conditionArray[j]))) continue;
                    this.registerError((PsiElement)testCondition);
                    if (!matched[i]) {
                        this.registerError((PsiElement)condition);
                    }
                    matched[i] = true;
                    matched[j] = true;
                }
            }
        }

        private void collectConditionsForIfStatement(JSIfStatement statement, Set<JSExpression> conditions) {
            JSExpression condition = statement.getCondition();
            this.collectConditionsForExpression(condition, conditions);
            JSStatement branch = (JSStatement)statement.getElseBranch();
            if (branch instanceof JSIfStatement) {
                this.collectConditionsForIfStatement((JSIfStatement)branch, conditions);
            }
        }

        private void collectConditionsForExpression(JSExpression condition, Set<JSExpression> conditions) {
            JSBinaryExpression binaryExpression;
            IElementType sign;
            if (condition == null) {
                return;
            }
            if (condition instanceof JSParenthesizedExpression) {
                JSExpression contents = ((JSParenthesizedExpression)condition).getInnerExpression();
                this.collectConditionsForExpression(contents, conditions);
                return;
            }
            if (condition instanceof JSBinaryExpression && JSTokenTypes.OROR.equals(sign = (binaryExpression = (JSBinaryExpression)condition).getOperationSign())) {
                JSExpression lhs = binaryExpression.getLOperand();
                this.collectConditionsForExpression(lhs, conditions);
                JSExpression rhs = binaryExpression.getROperand();
                this.collectConditionsForExpression(rhs, conditions);
                return;
            }
            conditions.add(condition);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/sixrr/inspectjs/control/DuplicateConditionJSInspection$DuplicateConditionVisitor", "visitJSIfStatement"));
        }
    }
}

