/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.confusing;

import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JavaScriptInspection;
import org.jetbrains.annotations.NotNull;

public class NestedFunctionJSInspection
extends JavaScriptInspection {
    public boolean m_includeAnonymousFunctions = false;

    @Override
    @InspectionMessage
    @NotNull
    protected String buildErrorString(Object ... args) {
        JSFunction function2 = (JSFunction)((PsiElement)args[0]).getParent();
        if (NestedFunctionJSInspection.functionHasIdentifier(function2)) {
            String string = InspectionJSBundle.message("nested.function.error.string", new Object[0]);
            if (string == null) {
                NestedFunctionJSInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = InspectionJSBundle.message("nested.anonymous.function.error.string", new Object[0]);
        if (string == null) {
            NestedFunctionJSInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"m_includeAnonymousFunctions", (String)InspectionJSBundle.message("include.anonymous.functions.parameter", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            NestedFunctionJSInspection.$$$reportNull$$$0(2);
        }
        return optPane;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/sixrr/inspectjs/confusing/NestedFunctionJSInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitJSFunctionDeclaration(@NotNull JSFunction function2) {
            if (function2 == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitJSFunctionDeclaration(function2);
            if (!NestedFunctionJSInspection.this.m_includeAnonymousFunctions && function2 instanceof JSFunctionExpression) {
                return;
            }
            if (function2.getParent() instanceof JSClass) {
                return;
            }
            JSFunction containingFunction = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)function2, JSFunction.class, (boolean)true);
            if (containingFunction == null) {
                return;
            }
            this.registerFunctionError(function2);
        }

        @Override
        public void visitJSFunctionExpression(@NotNull JSFunctionExpression node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            this.visitJSFunctionDeclaration(node);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "function";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
            }
            objectArray2[1] = "com/sixrr/inspectjs/confusing/NestedFunctionJSInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSFunctionDeclaration";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSFunctionExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

