/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsconfig;

import com.intellij.json.JsonLanguage;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.Language;
import com.intellij.lang.html.HtmlCompatibleFile;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.config.JSConfigProvider;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.frameworks.modules.JSPathMappingsUtil;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.lang.typescript.tsconfig.TypeScriptExtendedConfig;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptConfigUtil {
    public static String getNonStandardProjectFileName(@NotNull Project project, @NotNull VirtualFile el) {
        if (project == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(0);
        }
        if (el == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(1);
        }
        TypeScriptConfig config = TypeScriptConfigUtil.getConfigForFile(project, el);
        return TypeScriptConfigUtil.getNonStandardProjectFileName(config);
    }

    @Nullable
    public static String getNonStandardProjectFileName(@Nullable TypeScriptConfig config) {
        return TypeScriptConfigUtil.isNonStandardName(config) ? TypeScriptConfigUtil.getConfigProjectFileName(config) : null;
    }

    @NotNull
    public static String getConfigProjectFileName(@NotNull TypeScriptConfig config) {
        if (config == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(2);
        }
        String string = FileUtil.toSystemDependentName((String)config.getConfigFile().getPath());
        if (string == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public static VirtualFile finDefaultTypesDirectory(@NotNull VirtualFile context2) {
        VirtualFile nodeModules;
        if (context2 == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(4);
        }
        return (nodeModules = JSLibraryUtil.findUpClosestNodeModulesResolveRoot(context2)) != null ? nodeModules.findChild("@types") : null;
    }

    public static String toLibraryName(@NotNull String rawName) {
        if (rawName == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(5);
        }
        if ((rawName = StringUtil.toLowerCase((String)rawName)).equals("es6")) {
            return "es2015";
        }
        if (rawName.equals("es7")) {
            return "es2016";
        }
        return rawName;
    }

    public static boolean isNonStandardName(@Nullable TypeScriptConfig config) {
        if (config == null) {
            return false;
        }
        return TypeScriptConfigUtil.isNonStandardName(config.getConfigFile());
    }

    public static boolean isNonStandardName(@NotNull VirtualFile configFile) {
        if (configFile == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(6);
        }
        return !configFile.getName().equalsIgnoreCase("tsconfig.json");
    }

    @Nullable
    private static JsonProperty getFilesProperty(Project project, TypeScriptConfig config) {
        PsiFile file = PsiManager.getInstance((Project)project).findFile(config.getConfigFile());
        return TypeScriptConfigUtil.getProperty(file, "files");
    }

    @Nullable
    private static JsonProperty getIncludeProperty(Project project, TypeScriptConfig config) {
        PsiFile file = PsiManager.getInstance((Project)project).findFile(config.getConfigFile());
        return TypeScriptConfigUtil.getProperty(file, "include");
    }

    @Nullable
    private static JsonProperty getProperty(@Nullable PsiFile file, @NotNull String propertyName) {
        if (propertyName == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(7);
        }
        if (file == null) {
            return null;
        }
        JsonObject jsonObject = (JsonObject)PsiTreeUtil.getChildOfType((PsiElement)file, JsonObject.class);
        if (jsonObject == null) {
            return null;
        }
        return jsonObject.findProperty(propertyName);
    }

    public static boolean addVirtualFileToConfigFiles(Project project, VirtualFile file, TypeScriptConfig config) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        assert (!config.isDirectoryBased());
        JsonProperty property = TypeScriptConfigUtil.getFilesProperty(project, config);
        if (property == null && (property = TypeScriptConfigUtil.getIncludeProperty(project, config)) == null) {
            return false;
        }
        JsonArray value = (JsonArray)property.getValue();
        if (value == null) {
            return false;
        }
        String path2 = VfsUtilCore.findRelativePath((VirtualFile)config.getConfigFile(), (VirtualFile)file, (char)'/');
        if (path2 == null) {
            return false;
        }
        PsiElement result2 = TypeScriptConfigUtil.addValueToJsonArray(project, value, path2);
        return result2 != null;
    }

    @Nullable
    public static PsiElement addValueToJsonArray(@NotNull Project project, @NotNull JsonArray value, @NotNull String toAdd) {
        if (project == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(8);
        }
        if (value == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(9);
        }
        if (toAdd == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(10);
        }
        List list2 = value.getValueList();
        String text2 = value.getText();
        StringBuilder builder2 = new StringBuilder(text2);
        int i = text2.lastIndexOf("]");
        String str = (list2.isEmpty() ? "" : ",") + "\"" + toAdd + "\"";
        builder2.insert(i, str);
        return value.replace((PsiElement)TypeScriptConfigUtil.createJSONAndGetPropertyValue(project, builder2.toString()));
    }

    @NotNull
    private static JsonValue createJSONAndGetPropertyValue(@NotNull Project project, @NotNull String propertyValue) {
        if (project == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(11);
        }
        if (propertyValue == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(12);
        }
        String tempName = "tempName";
        JsonProperty property = TypeScriptConfigUtil.createJsonProperty(project, tempName, propertyValue, false);
        JsonValue jsonValue = Objects.requireNonNull(property.getValue());
        if (jsonValue == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(13);
        }
        return jsonValue;
    }

    @NotNull
    public static JsonProperty createJsonProperty(@NotNull Project project, @NotNull String propertyName, @NotNull String propertyValue, boolean withComma) {
        if (project == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(14);
        }
        if (propertyName == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(15);
        }
        if (propertyValue == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(16);
        }
        String json = String.format("{ \"" + propertyName + "\":%s" + (withComma ? "," : "") + " }", propertyValue);
        PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText((Language)JsonLanguage.INSTANCE, (CharSequence)json);
        JsonProperty jsonProperty = Objects.requireNonNull(TypeScriptConfigUtil.getProperty(psiFile, propertyName));
        if (jsonProperty == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(17);
        }
        return jsonProperty;
    }

    public static boolean strictNullChecks(@Nullable PsiElement context2) {
        if (context2 == null || !context2.isValid()) {
            return false;
        }
        return JSDialectSpecificHandlersFactory.forElement(context2).strictNullChecks(context2);
    }

    @Nullable
    public static String getOutDirectory(@NotNull VirtualFile baseFile, @Nullable String relativeOrAbsolutePath) {
        VirtualFile file;
        if (baseFile == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(18);
        }
        return (file = TypeScriptConfigUtil.getOutDirectoryFile(baseFile, relativeOrAbsolutePath)) == null ? null : file.getCanonicalPath();
    }

    @Nullable
    public static VirtualFile getOutDirectoryFile(@NotNull VirtualFile baseFile, @Nullable String relativeOrAbsolutePath) {
        if (baseFile == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(19);
        }
        if (StringUtil.isEmpty((String)relativeOrAbsolutePath)) {
            return null;
        }
        if (FileUtil.isAbsolute((String)relativeOrAbsolutePath)) {
            return baseFile.getFileSystem().findFileByPath(relativeOrAbsolutePath);
        }
        VirtualFile file = VfsUtil.findRelativeFile((VirtualFile)baseFile, (String[])ArrayUtilRt.toStringArray((Collection)FileUtil.splitPath((String)FileUtil.toCanonicalPath((String)relativeOrAbsolutePath))));
        return file;
    }

    @Nullable
    public static TypeScriptConfig getConfigForPsiFile(@Nullable PsiFile file) {
        return TypeScriptConfigUtil.getConfigForPsiFile(file, false);
    }

    @Nullable
    public static TypeScriptConfig getConfigForPsiFile(@Nullable PsiFile psiFile, boolean includeJSConfig) {
        if (psiFile != null) {
            psiFile = psiFile.getOriginalFile();
        }
        if (psiFile == null || DumbService.isDumb((Project)psiFile.getProject())) {
            return null;
        }
        if (psiFile instanceof JSConfigProvider) {
            JSConfigProvider providerFile = (JSConfigProvider)psiFile;
            return (TypeScriptConfig)ObjectUtils.tryCast((Object)providerFile.getJSConfig(), TypeScriptConfig.class);
        }
        VirtualFile file = psiFile.getOriginalFile().getViewProvider().getVirtualFile();
        Project project = psiFile.getProject();
        TypeScriptConfigService service2 = TypeScriptConfigService.Provider.get(project);
        TypeScriptConfig config = (psiFile instanceof JSFile || psiFile instanceof HtmlCompatibleFile) && !DialectDetector.isTypeScript((PsiElement)psiFile) ? service2.getPreferableJSConfig(file) : service2.getPreferableConfig(file);
        if (!includeJSConfig && config != null && config.isJSConfig()) {
            return null;
        }
        return config;
    }

    @Nullable
    public static TypeScriptConfig getConfigForFile(@Nullable Project project, @NotNull VirtualFile file) {
        if (file == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(20);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (project == null) {
            return null;
        }
        TypeScriptConfigService service2 = TypeScriptConfigService.Provider.get(project);
        return service2.getPreferableConfig(file);
    }

    public static boolean configGraphIncludesFile(@NotNull Project project, @NotNull VirtualFile file, @NotNull VirtualFile tsConfigFile) {
        if (project == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(21);
        }
        if (file == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(22);
        }
        if (tsConfigFile == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(23);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        TypeScriptConfigService service2 = TypeScriptConfigService.Provider.get(project);
        TypeScriptConfig tsConfig = service2.parseConfigFile(tsConfigFile);
        return tsConfig != null && service2.configGraphIncludesFile(file, tsConfig);
    }

    @Nullable
    public static VirtualFile getParentConfigWithName(@Nullable VirtualFile file, @NotNull String name) {
        VirtualFile toSearch;
        if (name == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(24);
        }
        if (file == null) {
            return null;
        }
        VirtualFile virtualFile = toSearch = file.isDirectory() ? file : file.getParent();
        while (toSearch != null && toSearch.isValid()) {
            VirtualFile child = toSearch.findChild(name);
            if (child != null) {
                return child;
            }
            toSearch = toSearch.getParent();
        }
        return null;
    }

    @Nullable
    public static PathMatcher getExcludeMatchers(@NotNull TypeScriptConfig config) {
        if (config == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(25);
        }
        TypeScriptConfig effectiveConfig = TypeScriptConfigUtil.getEffectiveConfig(config, (Condition<TypeScriptConfig>)((Condition)TypeScriptConfig::hasExcludeList));
        Collection<String> patterns = config.getExcludePatterns();
        return TypeScriptConfigUtil.getMatcher(effectiveConfig, patterns, true);
    }

    @Nullable
    public static PathMatcher getIncludeMatchers(@NotNull TypeScriptConfig config) {
        if (config == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(26);
        }
        TypeScriptConfig effectiveConfig = TypeScriptConfigUtil.getEffectiveConfig(config, (Condition<TypeScriptConfig>)((Condition)TypeScriptConfig::hasIncludesList));
        Collection<String> patterns = config.getIncludePatterns();
        return TypeScriptConfigUtil.getMatcher(effectiveConfig, patterns, false);
    }

    @NotNull
    private static TypeScriptConfig getEffectiveConfig(@NotNull TypeScriptConfig config, Condition<TypeScriptConfig> check) {
        if (config == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(27);
        }
        if (config instanceof TypeScriptExtendedConfig) {
            TypeScriptConfig typeScriptConfig = ((TypeScriptExtendedConfig)config).getEffectiveConfig(arg_0 -> check.value(arg_0));
            if (typeScriptConfig == null) {
                TypeScriptConfigUtil.$$$reportNull$$$0(28);
            }
            return typeScriptConfig;
        }
        TypeScriptConfig typeScriptConfig = config;
        if (typeScriptConfig == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(29);
        }
        return typeScriptConfig;
    }

    public static boolean areIncludePatternsInsideConfigDirectory(@NotNull TypeScriptConfig config) {
        TypeScriptConfig effectiveConfig;
        VirtualFile effectiveDirectory;
        if (config == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(30);
        }
        if (!(effectiveDirectory = (effectiveConfig = TypeScriptConfigUtil.getEffectiveConfig(config, (Condition<TypeScriptConfig>)((Condition)TypeScriptConfig::hasIncludesList))).getConfigDirectory()).equals(config.getConfigDirectory())) {
            return false;
        }
        Collection<String> patterns = config.getIncludePatterns();
        for (String pattern : patterns) {
            if (!JSPathMappingsUtil.isAbsolutePath(pattern) && !pattern.startsWith("..")) continue;
            return false;
        }
        return true;
    }

    public static boolean areExcludePatternsContainNodeModules(@NotNull TypeScriptConfig config) {
        if (config == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(31);
        }
        Collection<String> patterns = config.getExcludePatterns();
        for (String pattern : patterns) {
            if (!pattern.equals("node_modules")) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static PathMatcher getMatcher(@NotNull TypeScriptConfig config, @NotNull Collection<String> patterns, boolean allowTrailingRecursion) {
        if (config == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(32);
        }
        if (patterns == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(33);
        }
        return TypeScriptConfigUtil.getMatcher(config.getConfigDirectory(), patterns, allowTrailingRecursion);
    }

    @Nullable
    public static PathMatcher getMatcher(@NotNull VirtualFile baseDir, @NotNull Collection<String> patterns, boolean allowTrailingRecursion) {
        if (baseDir == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(34);
        }
        if (patterns == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(35);
        }
        String tsConfigDirectoryPath = baseDir.getPath();
        ArrayList<String> patternList = new ArrayList<String>();
        String invalidTrailingRecursionPattern = "(^|/)\\*\\*/?$";
        String invalidDotDotAfterRecursiveWildcardPattern = "(^|/)\\*\\*/(.*/)?\\.\\.($|/\\*?)";
        for (String pattern : patterns) {
            if (!allowTrailingRecursion && pattern.matches(invalidTrailingRecursionPattern) || pattern.matches(invalidDotDotAfterRecursiveWildcardPattern)) {
                return null;
            }
            String stringPath = TypeScriptConfigUtil.escapeGlobPattern(JSPathMappingsUtil.getStringPathRelativeBaseUrlOrSelfIfAbsolute(tsConfigDirectoryPath, pattern));
            TypeScriptConfigUtil.preprocessPatterns(patternList, stringPath);
        }
        if (patternList.isEmpty()) {
            return null;
        }
        FileSystem fs = FileSystems.getDefault();
        String result2 = "glob:{" + String.join((CharSequence)",", patternList) + "}";
        try {
            return fs.getPathMatcher(result2);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            Logger.getInstance(TypeScriptConfigUtil.class).error((Throwable)e);
            Path path2 = Paths.get(tsConfigDirectoryPath, new String[0]);
            return candidate -> candidate.startsWith(path2);
        }
    }

    private static void preprocessPatterns(@NotNull List<String> patternList, @NotNull String stringPath) {
        if (patternList == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(36);
        }
        if (stringPath == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(37);
        }
        patternList.add(stringPath);
        if (!stringPath.endsWith("*")) {
            patternList.add(stringPath + "/**");
        }
        String replace = StringUtil.replace((String)stringPath, (String)"/**", (String)"");
        patternList.add(replace);
        if (!replace.endsWith("*")) {
            patternList.add(replace + "/**");
        }
    }

    @NotNull
    private static String escapeGlobPattern(@NotNull String pattern) {
        if (pattern == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(38);
        }
        String string = pattern.replace("{", "\\{").replace("}", "\\}");
        if (string == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(39);
        }
        return string;
    }

    @Nullable
    public static PathMatcher getPathMatcher(@NotNull Collection<String> rawPaths) {
        if (rawPaths == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(40);
        }
        if (rawPaths.isEmpty()) {
            return null;
        }
        FileSystem fs = FileSystems.getDefault();
        ArrayList objects = new ArrayList();
        rawPaths.forEach(el -> TypeScriptConfigUtil.preprocessPatterns(objects, el));
        String result2 = "glob:{" + String.join((CharSequence)",", objects) + "}";
        try {
            return fs.getPathMatcher(result2);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            Logger.getInstance(TypeScriptConfigUtil.class).warn((Throwable)e);
            return candidate -> false;
        }
    }

    public static boolean allowJS(@Nullable PsiFile file) {
        TypeScriptConfig config = TypeScriptConfigUtil.getConfigForPsiFile(file);
        if (config == null) {
            return false;
        }
        return config.allowJs();
    }

    @NotNull
    public static List<VirtualFile> getRootConfigFiles(@NotNull Project project) {
        if (project == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(41);
        }
        TypeScriptConfigService service2 = TypeScriptConfigService.Provider.get(project);
        List<VirtualFile> list2 = service2.getRootConfigFiles();
        if (list2 == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(42);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 13, 17, 28, 29, 39, 42 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "el";
                break;
            }
            case 2: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 3: 
            case 13: 
            case 17: 
            case 28: 
            case 29: 
            case 39: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/tsconfig/TypeScriptConfigUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
            case 7: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toAdd";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyValue";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseFile";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tsConfigFile";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patterns";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternList";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringPath";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/tsconfig/TypeScriptConfigUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigProjectFileName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createJSONAndGetPropertyValue";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createJsonProperty";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getEffectiveConfig";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeGlobPattern";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootConfigFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNonStandardProjectFileName";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getConfigProjectFileName";
                break;
            }
            case 3: 
            case 13: 
            case 17: 
            case 28: 
            case 29: 
            case 39: 
            case 42: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "finDefaultTypesDirectory";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "toLibraryName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isNonStandardName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getProperty";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addValueToJsonArray";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createJSONAndGetPropertyValue";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createJsonProperty";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getOutDirectory";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getOutDirectoryFile";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getConfigForFile";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "configGraphIncludesFile";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getParentConfigWithName";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getExcludeMatchers";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getIncludeMatchers";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getEffectiveConfig";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "areIncludePatternsInsideConfigDirectory";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "areExcludePatternsContainNodeModules";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getMatcher";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "preprocessPatterns";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "escapeGlobPattern";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getPathMatcher";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getRootConfigFiles";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 13, 17, 28, 29, 39, 42 -> new IllegalStateException(string);
        };
    }
}

