/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsc;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.typescript.tsc.TypeScriptCompilerEvaluationFacadeImpl;
import com.intellij.lang.typescript.tsc.TypeScriptCompilerServiceResponseStatistics;
import com.intellij.lang.typescript.tsc.TypeScriptCompilerServiceStatisticsCollectorKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0017J\u0018\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\n2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cJ\u000e\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u0012J\u001a\u0010\u001f\u001a\u00020\u00152\n\u0010 \u001a\u0006\u0012\u0002\b\u00030!2\u0006\u0010\"\u001a\u00020\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R \u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/lang/typescript/tsc/TypeScriptCompilerServiceStatisticsCollector;", "Lcom/intellij/openapi/Disposable;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "(Lkotlinx/coroutines/CoroutineScope;)V", "getCs", "()Lkotlinx/coroutines/CoroutineScope;", "failedTypeFlags", "Ljava/util/concurrent/atomic/AtomicReference;", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Ljava/util/concurrent/atomic/AtomicInteger;", "typeConversionFailed", "typeConversionLogged", "Ljava/util/concurrent/atomic/AtomicBoolean;", "typeConversionSucceeded", "unknownClassProperties", "", "", "unknownClasses", "dispose", "", "getResponseStatistics", "Lcom/intellij/lang/typescript/tsc/TypeScriptCompilerServiceResponseStatistics;", "pullResponseStatistics", "typeConverted", "typeFlags", "converted", "Lcom/intellij/lang/javascript/psi/JSType;", "unknownClassReceived", "typeName", "unknownPropertyReceived", "clazz", "Ljava/lang/Class;", "propertyName", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nTypeScriptCompilerServiceStatisticsCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeScriptCompilerServiceStatisticsCollector.kt\ncom/intellij/lang/typescript/tsc/TypeScriptCompilerServiceStatisticsCollector\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,234:1\n72#2,2:235\n1#3:237\n453#4:238\n403#4:239\n453#4:244\n403#4:245\n1238#5,4:240\n1238#5,4:246\n*S KotlinDebug\n*F\n+ 1 TypeScriptCompilerServiceStatisticsCollector.kt\ncom/intellij/lang/typescript/tsc/TypeScriptCompilerServiceStatisticsCollector\n*L\n63#1:235,2\n63#1:237\n81#1:238\n81#1:239\n89#1:244\n89#1:245\n81#1:240,4\n89#1:246,4\n*E\n"})
public final class TypeScriptCompilerServiceStatisticsCollector
implements Disposable {
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final AtomicInteger typeConversionSucceeded;
    @NotNull
    private final AtomicInteger typeConversionFailed;
    @NotNull
    private final AtomicReference<ConcurrentHashMap<Integer, AtomicInteger>> failedTypeFlags;
    @NotNull
    private final AtomicReference<Set<String>> unknownClasses;
    @NotNull
    private final AtomicReference<Set<String>> unknownClassProperties;
    @NotNull
    private final AtomicBoolean typeConversionLogged;

    public TypeScriptCompilerServiceStatisticsCollector(@NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.cs = cs;
        this.typeConversionSucceeded = new AtomicInteger(0);
        this.typeConversionFailed = new AtomicInteger(0);
        this.failedTypeFlags = new AtomicReference(new ConcurrentHashMap());
        this.unknownClasses = new AtomicReference(ConcurrentHashMap.newKeySet());
        this.unknownClassProperties = new AtomicReference(ConcurrentHashMap.newKeySet());
        this.typeConversionLogged = new AtomicBoolean(false);
    }

    @NotNull
    public final CoroutineScope getCs() {
        return this.cs;
    }

    /*
     * WARNING - void declaration
     */
    public final void typeConverted(int typeFlags, @Nullable JSType converted) {
        if (converted != null) {
            this.typeConversionSucceeded.incrementAndGet();
        } else {
            void $this$getOrPut$iv;
            this.typeConversionFailed.incrementAndGet();
            ConcurrentHashMap<Integer, AtomicInteger> concurrentHashMap = this.failedTypeFlags.get();
            Intrinsics.checkNotNullExpressionValue(concurrentHashMap, (String)"get(...)");
            ConcurrentMap concurrentMap = concurrentHashMap;
            Integer key$iv = typeFlags;
            boolean $i$f$getOrPut = false;
            Object object = $this$getOrPut$iv.get(key$iv);
            if (object == null) {
                boolean bl = false;
                AtomicInteger default$iv = new AtomicInteger(0);
                boolean bl2 = false;
                object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
                if (object == null) {
                    object = default$iv;
                }
            }
            ((AtomicInteger)object).incrementAndGet();
        }
        if (this.typeConversionLogged.compareAndSet(false, true)) {
            TypeScriptCompilerEvaluationFacadeImpl.Companion.getLOG().info("TypeScript server evaluation was used");
        }
    }

    public final void unknownClassReceived(@NotNull String typeName) {
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        this.unknownClasses.get().add(typeName);
    }

    public final void unknownPropertyReceived(@NotNull Class<?> clazz, @NotNull String propertyName) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        this.unknownClassProperties.get().add(clazz.getSimpleName() + "." + propertyName);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TypeScriptCompilerServiceResponseStatistics getResponseStatistics() {
        Map map;
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        int n = this.typeConversionSucceeded.get();
        int n2 = this.typeConversionFailed.get();
        ConcurrentHashMap<Integer, AtomicInteger> concurrentHashMap = this.failedTypeFlags.get();
        Intrinsics.checkNotNullExpressionValue(concurrentHashMap, (String)"get(...)");
        Map map2 = concurrentHashMap;
        int n3 = n2;
        int n4 = n;
        boolean $i$f$mapValues = false;
        void var3_5 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            map = map3;
            boolean bl2 = false;
            Integer n5 = ((AtomicInteger)it.getValue()).get();
            map.put(k, n5);
        }
        map = destination$iv$iv;
        Set<String> set = this.unknownClasses.get();
        Intrinsics.checkNotNullExpressionValue(set, (String)"get(...)");
        Set<String> set2 = this.unknownClassProperties.get();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"get(...)");
        Set<String> set3 = set2;
        Set<String> set4 = set;
        Map map4 = map;
        int n6 = n3;
        int n7 = n4;
        return new TypeScriptCompilerServiceResponseStatistics(n7, n6, map4, set4, set3);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TypeScriptCompilerServiceResponseStatistics pullResponseStatistics() {
        Map map;
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        int n = this.typeConversionSucceeded.getAndSet(0);
        int n2 = this.typeConversionFailed.getAndSet(0);
        ConcurrentHashMap concurrentHashMap = this.failedTypeFlags.getAndSet(new ConcurrentHashMap());
        Intrinsics.checkNotNullExpressionValue(concurrentHashMap, (String)"getAndSet(...)");
        Map map2 = concurrentHashMap;
        int n3 = n2;
        int n4 = n;
        boolean $i$f$mapValues = false;
        void var3_5 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            map = map3;
            boolean bl2 = false;
            Integer n5 = ((AtomicInteger)it.getValue()).get();
            map.put(k, n5);
        }
        map = destination$iv$iv;
        Set<String> set = this.unknownClasses.get();
        Intrinsics.checkNotNullExpressionValue(set, (String)"get(...)");
        Set<String> set2 = this.unknownClassProperties.get();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"get(...)");
        Set<String> set3 = set2;
        Set<String> set4 = set;
        Map map4 = map;
        int n6 = n3;
        int n7 = n4;
        return new TypeScriptCompilerServiceResponseStatistics(n7, n6, map4, set4, set3);
    }

    public void dispose() {
        TypeScriptCompilerServiceResponseStatistics statistics = this.getResponseStatistics();
        if (statistics.getTypeConversionSucceeded() > 0 || statistics.getTypeConversionFailed() > 0) {
            StringBuilder builder2 = new StringBuilder();
            TypeScriptCompilerServiceStatisticsCollectorKt.printTscServiceStatistics(MapsKt.mapOf((Pair)TuplesKt.to((Object)"Totally", (Object)statistics)), builder2);
            TypeScriptCompilerEvaluationFacadeImpl.Companion.getLOG().info(builder2.toString());
        }
    }
}

