/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsc;

import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.TypeScriptService;
import com.intellij.lang.typescript.lsp.BaseLspTypeScriptService;
import com.intellij.lang.typescript.resolve.TypeScriptCompilerEvaluationFacade;
import com.intellij.lang.typescript.tsc.TypeScriptCompilerEvaluationEnabledState;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u0010\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/lang/typescript/tsc/TypeScriptCompilerEvaluationFacadeImpl;", "Lcom/intellij/lang/typescript/resolve/TypeScriptCompilerEvaluationFacade;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "doGetTypeFromService", "Lcom/intellij/lang/javascript/psi/JSType;", "element", "Lcom/intellij/psi/PsiElement;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getService", "Lcom/intellij/lang/typescript/compiler/TypeScriptService;", "getTypeFromService", "isAcceptedFile", "", "isEnabled", "Companion", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nTypeScriptCompilerEvaluationFacadeImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeScriptCompilerEvaluationFacadeImpl.kt\ncom/intellij/lang/typescript/tsc/TypeScriptCompilerEvaluationFacadeImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,160:1\n11#2:161\n*S KotlinDebug\n*F\n+ 1 TypeScriptCompilerEvaluationFacadeImpl.kt\ncom/intellij/lang/typescript/tsc/TypeScriptCompilerEvaluationFacadeImpl\n*L\n34#1:161\n*E\n"})
public final class TypeScriptCompilerEvaluationFacadeImpl
implements TypeScriptCompilerEvaluationFacade {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final Logger LOG;

    public TypeScriptCompilerEvaluationFacadeImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @Override
    public boolean isEnabled() {
        return TypeScriptCompilerEvaluationEnabledState.Companion.isCompilerEvaluationEnabled() && TypeScriptCompilerSettings.getSettings(this.project).useService();
    }

    @Override
    @Nullable
    public JSType getTypeFromService(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        VirtualFile virtualFile = JSLanguageServiceUtil.nonBlockingReadActionWithTimeout(() -> TypeScriptCompilerEvaluationFacadeImpl.getTypeFromService$lambda$0(element));
        if (virtualFile == null || !this.isAcceptedFile(virtualFile)) {
            return null;
        }
        JSType typeFromService = this.doGetTypeFromService(element, virtualFile);
        if (typeFromService == null && TypeScriptCompilerEvaluationEnabledState.ENABLED.isSelected()) {
            return JSAnyType.get(JSTypeSource.EMPTY_TS);
        }
        return typeFromService;
    }

    private final boolean isAcceptedFile(VirtualFile virtualFile) {
        return Intrinsics.areEqual((Object)virtualFile.getExtension(), (Object)"vue") || TypeScriptUtil.isTypeScriptFile(virtualFile);
    }

    private final JSType doGetTypeFromService(PsiElement element, VirtualFile virtualFile) {
        TypeScriptService typeScriptService = this.getService(virtualFile);
        if (typeScriptService == null) {
            return null;
        }
        TypeScriptService service2 = typeScriptService;
        return service2.getTypeEvaluationSupport().getElementType(element, virtualFile);
    }

    private final TypeScriptService getService(VirtualFile virtualFile) {
        TypeScriptService service2 = JSLanguageServiceUtil.nonBlockingReadActionWithTimeout(() -> TypeScriptCompilerEvaluationFacadeImpl.getService$lambda$1(this, virtualFile));
        if (!(service2 instanceof BaseLspTypeScriptService) && !(service2 instanceof TypeScriptCompilerService)) {
            return null;
        }
        return service2;
    }

    private static final VirtualFile getTypeFromService$lambda$0(PsiElement $element) {
        Intrinsics.checkNotNullParameter((Object)$element, (String)"$element");
        return TypeScriptService.Companion.getServiceAwareVirtualFile($element);
    }

    private static final TypeScriptService getService$lambda$1(TypeScriptCompilerEvaluationFacadeImpl this$0, VirtualFile $virtualFile) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$virtualFile, (String)"$virtualFile");
        TypeScriptService typeScriptService = TypeScriptService.Companion.getForFile(this$0.project, $virtualFile);
        if (typeScriptService == null) {
            typeScriptService = ApplicationManager.getApplication().isUnitTestMode() ? TypeScriptCompilerService.Companion.getDefaultService(this$0.project) : null;
        }
        return typeScriptService;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(TypeScriptCompilerEvaluationFacadeImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/lang/typescript/tsc/TypeScriptCompilerEvaluationFacadeImpl$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.javascript.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

