/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsc;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\bJ\u001e\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\tRB\u0010\u0005\u001a6\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0004\u0012\u00020\t0\u0006j\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lcom/intellij/lang/typescript/tsc/JsTypeCache;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "myCachedTypes", "Ljava/util/LinkedHashMap;", "Lkotlin/Pair;", "", "Lcom/intellij/lang/javascript/psi/JSType;", "Lkotlin/collections/LinkedHashMap;", "myCurrentPsiModificationCount", "", "getProject", "()Lcom/intellij/openapi/project/Project;", "cleanIfPsiModified", "", "getType", "ideTypeCheckerId", "typeId", "putType", "jsType", "intellij.javascript.impl"})
public final class JsTypeCache {
    @NotNull
    private final Project project;
    private long myCurrentPsiModificationCount;
    @NotNull
    private final LinkedHashMap<Pair<Integer, Integer>, JSType> myCachedTypes;

    public JsTypeCache(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.myCachedTypes = new LinkedHashMap();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final JSType getType(int ideTypeCheckerId, int typeId) {
        JSType jSType;
        JsTypeCache jsTypeCache = this;
        synchronized (jsTypeCache) {
            boolean bl = false;
            this.cleanIfPsiModified();
            jSType = this.myCachedTypes.get(TuplesKt.to((Object)ideTypeCheckerId, (Object)typeId));
        }
        return jSType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void putType(int ideTypeCheckerId, int typeId, @NotNull JSType jsType) {
        Intrinsics.checkNotNullParameter((Object)jsType, (String)"jsType");
        int cacheMaxSize = Registry.intValue((String)"typescript.compiler.typeCacheSize");
        JsTypeCache jsTypeCache = this;
        synchronized (jsTypeCache) {
            boolean bl = false;
            this.cleanIfPsiModified();
            this.myCachedTypes.remove(TuplesKt.to((Object)ideTypeCheckerId, (Object)typeId));
            ((Map)this.myCachedTypes).put(TuplesKt.to((Object)ideTypeCheckerId, (Object)typeId), jsType);
            int toRemove = this.myCachedTypes.size() - cacheMaxSize;
            if (toRemove > 0) {
                Iterator itr = ((Map)this.myCachedTypes).entrySet().iterator();
                int i = 1;
                if (i <= toRemove) {
                    while (itr.hasNext()) {
                        itr.next();
                        itr.remove();
                        if (i == toRemove) break;
                        ++i;
                    }
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void cleanIfPsiModified() {
        long modificationCount = PsiModificationTracker.getInstance((Project)this.project).getModificationCount();
        if (this.myCurrentPsiModificationCount != modificationCount) {
            this.myCachedTypes.clear();
            this.myCurrentPsiModificationCount = modificationCount;
        }
    }
}

