/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.resolve;

import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.javascript.JSFunctionWithSubstitutor;
import com.intellij.lang.ecmascript6.psi.JSClassExpression;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.ecmascript6.TypeScriptImportHandler;
import com.intellij.lang.javascript.ecmascript6.TypeScriptQualifiedNameResolver;
import com.intellij.lang.javascript.ecmascript6.TypeScriptSignatureChooser;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCallItem;
import com.intellij.lang.javascript.psi.JSCallLikeExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptField;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptGenericOrMappedTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.ES6QualifiedNameResolver;
import com.intellij.lang.javascript.psi.resolve.JSGenericMappings;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluatorBase;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.resolve.JavaScriptQualifiedItemProcessor;
import com.intellij.lang.javascript.psi.resolve.generic.JSTypeSubstitutorImpl;
import com.intellij.lang.javascript.psi.stubs.TypeScriptProxyImplicitElement;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSExternalGenericId;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterType;
import com.intellij.lang.javascript.psi.types.JSGenericTypeEvaluationFunction;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSIntersectionType;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeSubstitutorType;
import com.intellij.lang.javascript.psi.types.JSRecursiveExpandTransformer;
import com.intellij.lang.javascript.psi.types.JSSimpleRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeComparingContextService;
import com.intellij.lang.javascript.psi.types.JSTypeGenericId;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.JSTypeWithOuterGenerics;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.JSWidenType;
import com.intellij.lang.javascript.psi.types.TypeScriptGenericThisTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptJSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptNeverType;
import com.intellij.lang.javascript.psi.types.typescript.TypeScriptGenericDeclarationTypeImpl;
import com.intellij.lang.javascript.psi.types.typescript.TypeScriptGenericParameterImpl;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptGenericTypesEvaluator
extends JSGenericTypesEvaluatorBase {
    private static final TypeScriptGenericTypesEvaluator INSTANCE = new TypeScriptGenericTypesEvaluator();

    private TypeScriptGenericTypesEvaluator() {
    }

    public static TypeScriptGenericTypesEvaluator getInstance() {
        return INSTANCE;
    }

    @Override
    public JSType evaluateGenerics(@Nullable JSType type2, @Nullable JSExpression methodExpression, @Nullable PsiElement resolvedFunction, @NotNull JSGenericTypesEvaluator.GenericEvaluationContext context2) {
        JSExpression qualifier;
        if (context2 == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(0);
        }
        if (methodExpression == null) {
            return type2;
        }
        Supplier<JSType> jsQualifierTypeSupplier = null;
        if (methodExpression instanceof JSReferenceExpression && (qualifier = ((JSReferenceExpression)methodExpression).getQualifier()) != null) {
            jsQualifierTypeSupplier = () -> JSResolveUtil.getElementJSType((PsiElement)qualifier);
        }
        JSCallLikeExpression callLikeExpression = TypeScriptSignatureChooser.getCallLikeExpression((PsiElement)methodExpression);
        return this.doEvaluateGenerics(type2, methodExpression, callLikeExpression, jsQualifierTypeSupplier, resolvedFunction, context2);
    }

    @Override
    public JSType evaluateGenerics(@Nullable JSType type2, @NotNull JSCallItem callItem, @Nullable PsiElement resolvedFunction, @NotNull JSGenericTypesEvaluator.GenericEvaluationContext context2) {
        if (callItem == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(1);
        }
        if (context2 == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(2);
        }
        JSExpression methodExpression = callItem instanceof JSCallLikeExpression ? ((JSCallLikeExpression)callItem).getMethodExpression() : null;
        return this.doEvaluateGenerics(type2, methodExpression, callItem, callItem::getQualifierType, resolvedFunction, context2);
    }

    private JSType doEvaluateGenerics(@Nullable JSType type2, @Nullable JSExpression place, @Nullable JSCallItem callItem, @Nullable Supplier<JSType> jsQualifierTypeSupplier, @Nullable PsiElement resolvedFunction, @NotNull JSGenericTypesEvaluator.GenericEvaluationContext context2) {
        JSType external;
        Predicate<JSType> acceptableGenericArguments;
        if (context2 == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(3);
        }
        if (!TypeScriptGenericTypesEvaluator.canHaveGenericParameters(type2)) {
            return type2;
        }
        resolvedFunction = TypeScriptGenericTypesEvaluator.getAssociatedElement(type2, resolvedFunction);
        if (jsQualifierTypeSupplier != null) {
            type2 = TypeScriptGenericTypesEvaluator.evaluateJSGenericsFromQualifier(type2, jsQualifierTypeSupplier);
        }
        if ((acceptableGenericArguments = TypeScriptGenericTypesEvaluator.getGenericArgumentsConditionForSubstitution(type2)) == null) {
            return type2;
        }
        JSTypeSubstitutor substitutor = this.getAllGenericTypeSubstitutor(place, resolvedFunction, callItem, new JSGenericTypesEvaluator.GenericEvaluationContext(context2, acceptableGenericArguments));
        if (!substitutor.isEmpty() && (external = substitutor.get(JSExternalGenericId.INSTANCE)) != null) {
            List<JSType> candidates;
            List<JSType> list2 = candidates = external instanceof JSUnionType ? ((JSUnionType)external).getTypes() : Collections.singletonList(external);
            if (!candidates.isEmpty()) {
                type2 = TypeScriptGenericTypesEvaluator.transferGenericParametersToFunctionalType(type2, substitutor, candidates);
            }
        }
        return JSTypeUtils.applyGenericArguments(type2, substitutor, callItem != null, context2.reporter);
    }

    @NotNull
    private static JSType transferGenericParametersToFunctionalType(@NotNull JSType type2, final @NotNull JSTypeSubstitutor substitutor, final @NotNull List<JSType> candidates) {
        if (type2 == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(4);
        }
        if (substitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(5);
        }
        if (candidates == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(6);
        }
        JSType jSType = type2 = type2.transformTypeHierarchy(new JSRecursiveExpandTransformer(true){

            @Override
            @NotNull
            protected JSType expand(@NotNull JSType type2) {
                if (type2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                JSType jSType = JSTypeUtils.expandForTypeSubstitutor(type2, substitutor);
                if (jSType == null) {
                    1.$$$reportNull$$$0(1);
                }
                return jSType;
            }

            @Override
            @NotNull
            protected JSType processExpanded(@NotNull JSType type2) {
                List parameters;
                if (type2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (type2 instanceof TypeScriptJSFunctionTypeImpl && ((TypeScriptJSFunctionTypeImpl)type2).getGenericIds().isEmpty() && !(parameters = ContainerUtil.mapNotNull((Collection)candidates, el -> el instanceof TypeScriptGenericDeclarationTypeImpl ? (TypeScriptGenericDeclarationTypeImpl)el : null)).isEmpty()) {
                    return new TypeScriptJSFunctionTypeImpl(type2.getSource(), parameters, ((TypeScriptJSFunctionTypeImpl)type2).getParameters(), ((TypeScriptJSFunctionTypeImpl)type2).getThisType(), ((TypeScriptJSFunctionTypeImpl)type2).getReturnType());
                }
                if (type2 instanceof JSWidenType) {
                    JSType jSType = type2;
                    if (jSType == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return jSType;
                }
                JSType jSType = JSTypeBaseImpl.getSelfNoTransformationType();
                if (jSType == null) {
                    1.$$$reportNull$$$0(4);
                }
                return jSType;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 3, 4 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "expand";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "processExpanded";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "expand";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "processExpanded";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 3, 4 -> new IllegalStateException(string);
                };
            }
        });
        if (jSType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(7);
        }
        return jSType;
    }

    private static PsiElement getAssociatedElement(@NotNull JSType type2, @Nullable PsiElement resolvedFunction) {
        if (type2 == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(8);
        }
        if (resolvedFunction == null) {
            PsiElement element;
            resolvedFunction = type2.getSourceElement();
            if (resolvedFunction instanceof JSFunction && resolvedFunction instanceof TypeScriptTypeParameterListOwner && ((TypeScriptTypeParameterListOwner)resolvedFunction).getTypeParameters().length > 0) {
                return null;
            }
            if (resolvedFunction instanceof JSDocComment && (element = JSStubBasedPsiTreeUtil.findAssociatedElement((JSDocComment)resolvedFunction)) != null) {
                return element;
            }
        }
        return resolvedFunction;
    }

    @Override
    @NotNull
    public JSGenericTypeEvaluationFunction getEvaluationFunction(@NotNull JSCallLikeExpression callLikeExpression, @NotNull PsiElement resolvedFunctionOrField, @NotNull JSGenericTypesEvaluator.GenericEvaluationContext context2) {
        JSExpression methodExpression;
        if (callLikeExpression == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(9);
        }
        if (resolvedFunctionOrField == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(10);
        }
        if (context2 == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(11);
        }
        if ((methodExpression = callLikeExpression.getMethodExpression()) == null) {
            JSGenericTypeEvaluationFunction jSGenericTypeEvaluationFunction = JSGenericTypeEvaluationFunction.SELF;
            if (jSGenericTypeEvaluationFunction == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(12);
            }
            return jSGenericTypeEvaluationFunction;
        }
        NotNullLazyValue qualifierGenericTypeEvaluator = NotNullLazyValue.createValue(() -> this.getJSQualifierGenericsRemapper(methodExpression));
        NotNullLazyValue substitutor = NotNullLazyValue.createValue(() -> this.getAllGenericTypeSubstitutor(methodExpression, resolvedFunctionOrField, callLikeExpression, context2));
        JSGenericTypeEvaluationFunction jSGenericTypeEvaluationFunction = type2 -> {
            if (!TypeScriptGenericTypesEvaluator.canHaveGenericParameters(type2)) {
                return type2;
            }
            type2 = (JSType)((Function.Mono)qualifierGenericTypeEvaluator.getValue()).fun((Object)type2);
            if (TypeScriptGenericTypesEvaluator.getGenericArgumentsConditionForSubstitution(type2) == null) {
                return type2;
            }
            return JSTypeUtils.applyGenericArguments(type2, (JSTypeSubstitutor)substitutor.getValue(), true, context2.reporter);
        };
        if (jSGenericTypeEvaluationFunction == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(13);
        }
        return jSGenericTypeEvaluationFunction;
    }

    @NotNull
    private JSTypeSubstitutor getAllGenericTypeSubstitutor(@Nullable JSExpression place, @Nullable PsiElement resolvedFunctionOrField, @Nullable JSCallItem callItem, @NotNull JSGenericTypesEvaluator.GenericEvaluationContext context2) {
        if (context2 == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(14);
        }
        JSTypeSubstitutor explicit = JSTypeSubstitutor.EMPTY;
        JSFunctionType functionType2 = TypeScriptTypeParser.asFunctionType(resolvedFunctionOrField, callItem);
        if (functionType2 != null && callItem != null) {
            Pair<JSTypeGenericId, Integer> arity = TypeScriptGenericTypesEvaluator.calculateImpliedArity(functionType2, ContainerUtil.map(functionType2.getParameters(), el -> el.getInferredType()), callItem.getArgumentSize());
            context2 = new JSGenericTypesEvaluator.GenericEvaluationContext(context2, arity);
        }
        if (place instanceof JSReferenceExpression) {
            JSExpression qualifier = ((JSReferenceExpression)place).getQualifier();
            if (qualifier != null) {
                explicit = this.getQualifierTypeSubstitutor(qualifier, (JSType)functionType2, resolvedFunctionOrField, place, context2);
            }
        } else if (place == null && callItem != null) {
            explicit = this.getQualifierTypeSubstitutor(callItem.getQualifierType(), (JSType)functionType2, resolvedFunctionOrField, null, context2);
        }
        explicit = JSTypeSubstitutorImpl.combine(explicit, TypeScriptGenericTypesEvaluator.getCallExplicitTypeSubstitutor(functionType2, callItem, JSTypeSubstitutor.EMPTY));
        if (place != null) {
            explicit = JSTypeSubstitutorImpl.combine(explicit, TypeScriptGenericTypesEvaluator.getConstructorTypeSubstitutor(resolvedFunctionOrField, place));
        }
        if (resolvedFunctionOrField != null && callItem != null) {
            return this.getAllGenericTypeSubstitutor(functionType2, callItem, context2, explicit);
        }
        JSTypeSubstitutor jSTypeSubstitutor = explicit;
        if (jSTypeSubstitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(15);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    private JSTypeSubstitutor getAllGenericTypeSubstitutor(@Nullable JSFunctionType functionType2, @NotNull JSCallItem callItem, @NotNull JSGenericTypesEvaluator.GenericEvaluationContext context2, @NotNull JSTypeSubstitutor explicit) {
        JSTypeSubstitutor callSubstitutor;
        if (callItem == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(16);
        }
        if (context2 == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(17);
        }
        if (explicit == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(18);
        }
        if (!(callSubstitutor = this.getInferredCallLikeTypeSubstitutor(functionType2, callItem, context2, explicit)).isEmpty()) {
            JSTypeSubstitutor callWithApplied = JSTypeSubstitutorImpl.combineWithApplying(explicit, callSubstitutor, JSTypeUtils::applyGenericArguments);
            callWithApplied = JSTypeSubstitutorImpl.combine(callWithApplied, explicit);
            JSTypeSubstitutor constraints = JSGenericTypesEvaluatorBase.getSubstitutorForGenericConstraints(functionType2, callWithApplied);
            return TypeScriptGenericTypesEvaluator.processInferredGenerics(callWithApplied, constraints, callItem);
        }
        JSTypeSubstitutor jSTypeSubstitutor = explicit;
        if (jSTypeSubstitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(19);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    private static JSTypeSubstitutor processInferredGenerics(@NotNull JSTypeSubstitutor inferred, @NotNull JSTypeSubstitutor constraints, @NotNull JSCallItem callItem) {
        if (inferred == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(20);
        }
        if (constraints == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(21);
        }
        if (callItem == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(22);
        }
        if (constraints.isEmpty()) {
            JSTypeSubstitutor jSTypeSubstitutor = inferred;
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(23);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutorImpl result2 = new JSTypeSubstitutorImpl(inferred);
        ProcessingContext processingContext = JSTypeComparingContextService.createProcessingContextWithCache(callItem.getPsiContext());
        for (Map.Entry<JSTypeGenericId, JSType> entry : constraints.map().entrySet()) {
            JSTypeGenericId key2 = entry.getKey();
            JSType constraintType = constraints.get(key2);
            if (constraintType == null || !JSTypeUtils.containsLiteralOrEnumOrPrimitiveTypes(constraintType) || JSResolveUtil.isAssignableJSType(constraintType, result2.get(key2), processingContext)) continue;
            result2.put(key2, constraintType);
        }
        JSTypeSubstitutorImpl jSTypeSubstitutorImpl = result2;
        if (jSTypeSubstitutorImpl == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(24);
        }
        return jSTypeSubstitutorImpl;
    }

    @Override
    @NotNull
    public JSType evaluateGenericsFromQualifier(@NotNull JSType type2, @NotNull JSExpression qualifier, @NotNull JSExpression methodExpression) {
        if (type2 == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(25);
        }
        if (qualifier == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(26);
        }
        if (methodExpression == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(27);
        }
        Function.Mono<JSType> mapper = this.getJSQualifierGenericsRemapper(methodExpression);
        JSTypeSubstitutor substitutor = this.getQualifierTypeSubstitutor(qualifier, null, type2.getSourceElement(), methodExpression, DEFAULT_CONTEXT);
        JSType jSType = JSTypeUtils.applyGenericArguments((JSType)mapper.fun((Object)type2), substitutor);
        if (jSType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(28);
        }
        return jSType;
    }

    @Nullable
    private static Predicate<JSType> getGenericArgumentsConditionForSubstitution(@Nullable JSType startType) {
        if (!TypeScriptGenericTypesEvaluator.canHaveGenericParameters(startType)) {
            return null;
        }
        return JSTypeUtils.getGenericArgumentsConditionForSubstitution(startType);
    }

    @NotNull
    private JSTypeSubstitutor getQualifierTypeSubstitutor(@NotNull JSExpression qualifier, @Nullable JSType jsType, @Nullable PsiElement sourceElement, @NotNull JSExpression context2, @NotNull JSGenericTypesEvaluator.GenericEvaluationContext evaluationContext) {
        if (qualifier == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(29);
        }
        if (context2 == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(30);
        }
        if (evaluationContext == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(31);
        }
        JSType qualifierType = JSResolveUtil.getElementJSType((PsiElement)qualifier);
        JSTypeSubstitutor jSTypeSubstitutor = this.getQualifierTypeSubstitutor(qualifierType, jsType, sourceElement, (PsiElement)context2, evaluationContext);
        if (jSTypeSubstitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(32);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    public JSTypeSubstitutor getQualifierTypeSubstitutor(@Nullable JSType qualifierType, @Nullable JSType jsType, @Nullable PsiElement sourceElement, @Nullable PsiElement context2, @NotNull JSGenericTypesEvaluator.GenericEvaluationContext evaluationContext) {
        if (evaluationContext == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(33);
        }
        if (qualifierType == null) {
            qualifierType = JSAnyType.get(context2);
        }
        JSType expanded = qualifierType.substitute();
        JSTypeSubstitutorImpl result2 = new JSTypeSubstitutorImpl();
        result2.putAll(TypeScriptGenericTypesEvaluator.getTypeSubstitutorForQualifierType(expanded, sourceElement, context2, evaluationContext));
        result2.putAll(jsType instanceof JSFunctionType ? TypeScriptGenericTypesEvaluator.getTypeSubstitutorForExplicitThisParameterType(() -> expanded, (JSFunctionType)jsType, context2, evaluationContext) : JSTypeSubstitutor.EMPTY);
        if (!(expanded instanceof JSRecordType) || TypeScriptGenericTypesEvaluator.isApplicableRecordTypeForThis((JSRecordType)expanded)) {
            result2.put(TypeScriptGenericThisTypeImpl.createThisTypeGenericId(expanded), expanded);
        }
        JSTypeSubstitutorImpl jSTypeSubstitutorImpl = result2;
        if (jSTypeSubstitutorImpl == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(34);
        }
        return jSTypeSubstitutorImpl;
    }

    private static boolean isApplicableRecordTypeForThis(@NotNull JSRecordType recordType) {
        if (recordType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(35);
        }
        if (!(recordType instanceof JSSimpleRecordTypeImpl)) {
            return false;
        }
        PsiElement sourceElement = recordType.getSource().getSourceElement();
        return sourceElement instanceof JSClassExpression;
    }

    public boolean hasGenericsCompatibilityErrors(@NotNull List<? extends JSType> parameterTypes, @NotNull List<? extends JSType> arguments, @NotNull TypeScriptFunction context2) {
        Object[] parameters;
        if (parameterTypes == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(36);
        }
        if (arguments == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(37);
        }
        if (context2 == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(38);
        }
        if ((parameters = TypeScriptPsiUtil.getTypeParametersForOwner(context2)).length == 0) {
            return false;
        }
        Set ids = StreamEx.of((Object[])parameters).map(el -> el.getGenericId()).toSet();
        List argumentProviders = ContainerUtil.map(arguments, el -> () -> el);
        Predicate<JSType> condition = type2 -> type2 instanceof JSGenericParameterImpl && ids.contains(((JSGenericParameterImpl)type2).getGenericId());
        Supplier<List<JSType>> functionGenericsSupplier = () -> TypeScriptGenericTypesEvaluator.lambda$hasGenericsCompatibilityErrors$10((TypeScriptTypeParameter[])parameters);
        JSGenericMappings genericArguments = TypeScriptGenericTypesEvaluator.inferGenericArgumentsFromCall(parameterTypes, argumentProviders, -1, TypeScriptTypeParser.asFunctionType(context2, null), context2, new JSGenericTypesEvaluator.GenericEvaluationContext(DEFAULT_CONTEXT, condition, functionGenericsSupplier));
        MultiMap<JSTypeGenericId, JSType> mapping = genericArguments.getMapping();
        ProcessingContext processingContext = JSTypeComparingContextService.createProcessingContextWithCache(context2);
        processingContext.put(genericParametersProvider, functionGenericsSupplier);
        return TypeScriptGenericTypesEvaluator.hasGenericsCompatibilityErrors(mapping, processingContext, context2);
    }

    public static boolean hasGenericsCompatibilityErrors(@NotNull MultiMap<JSTypeGenericId, JSType> mapping, @NotNull ProcessingContext processingContext, @Nullable PsiElement context2) {
        if (mapping == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(39);
        }
        if (processingContext == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(40);
        }
        if (mapping.isEmpty()) {
            return false;
        }
        final Ref hasErrors2 = Ref.create((Object)false);
        JSGenericTypesEvaluator.GenericErrorReporter reporter = new JSGenericTypesEvaluator.GenericErrorReporter(){

            @Override
            public void error(@NotNull @InspectionMessage String message) {
                if (message == null) {
                    2.$$$reportNull$$$0(0);
                }
                hasErrors2.set((Object)true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator$2", "error"));
            }
        };
        JSTypeSubstitutorImpl substitutor = TypeScriptGenericTypesEvaluator.intersectGenerics(mapping, processingContext, reporter, context2);
        if (((Boolean)hasErrors2.get()).booleanValue()) {
            return true;
        }
        Supplier provider = (Supplier)processingContext.get(genericParametersProvider);
        if (provider == null) {
            return false;
        }
        List functionGenerics = (List)provider.get();
        if (functionGenerics.isEmpty() || !ContainerUtil.exists((Iterable)functionGenerics, el -> el instanceof JSGenericParameterType && ((JSGenericParameterType)el).getConstraintType() != null)) {
            return false;
        }
        for (JSType generic : functionGenerics) {
            JSTypeUtils.applyGenericArguments(generic, substitutor, true, reporter);
            if (!((Boolean)hasErrors2.get()).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static JSTypeSubstitutor getTypeSubstitutorForQualifierType(@NotNull JSType qualifierType, @Nullable PsiElement sourceElement, @Nullable PsiElement context2, @NotNull JSGenericTypesEvaluator.GenericEvaluationContext evaluationContext) {
        JSType constraintType;
        List<JSType> arguments;
        if (qualifierType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(41);
        }
        if (evaluationContext == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(42);
        }
        JSTypeSubstitutor substitutor = new JSTypeSubstitutorImpl();
        if ((qualifierType = JSTypeUtils.unwrapDecorations(qualifierType)) instanceof JSIntersectionType) {
            for (JSType typeToProcess : ((JSIntersectionType)qualifierType).getTypes()) {
                JSTypeSubstitutor candidate = TypeScriptGenericTypesEvaluator.getTypeSubstitutorForQualifierType(typeToProcess, sourceElement, context2, evaluationContext);
                substitutor = JSTypeSubstitutorImpl.combine(substitutor, candidate);
            }
            JSTypeSubstitutorImpl jSTypeSubstitutorImpl = substitutor;
            if (jSTypeSubstitutorImpl == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(43);
            }
            return jSTypeSubstitutorImpl;
        }
        if (qualifierType instanceof JSTypeWithOuterGenerics) {
            JSTypeSubstitutor outerArguments = ((JSTypeWithOuterGenerics)qualifierType).getOuterArguments();
            if (!outerArguments.isEmpty()) {
                substitutor = JSTypeSubstitutorImpl.combine(substitutor, outerArguments);
            }
            qualifierType = ((JSTypeWithOuterGenerics)qualifierType).getType();
        }
        if (qualifierType instanceof JSGenericTypeImpl) {
            JSGenericTypeImpl genericType = (JSGenericTypeImpl)qualifierType;
            if (genericType.getType() instanceof TypeScriptGenericThisTypeImpl) {
                qualifierType = new JSGenericTypeImpl(genericType.getSource(), ((TypeScriptGenericThisTypeImpl)genericType.getType()).substituteCompletely(), genericType.getArguments());
            }
        } else {
            if (qualifierType instanceof JSRecordType) {
                JSRecordType type2 = (JSRecordType)qualifierType;
                JSTypeSubstitutor recordTypeSubstitutor = TypeScriptGenericTypesEvaluator.buildSubstitutorForQualifierRecordType(type2, evaluationContext);
                JSTypeSubstitutor jSTypeSubstitutor = substitutor = JSTypeSubstitutorImpl.combine(substitutor, recordTypeSubstitutor);
                if (jSTypeSubstitutor == null) {
                    TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(44);
                }
                return jSTypeSubstitutor;
            }
            if (qualifierType instanceof TypeScriptGenericThisTypeImpl) {
                qualifierType = ((TypeScriptGenericThisTypeImpl)qualifierType).getOwnerType();
            }
        }
        if ((arguments = JSTypeUtils.getGenericTypeArguments(qualifierType)) == null && qualifierType instanceof TypeScriptGenericParameterImpl && (constraintType = ((TypeScriptGenericParameterImpl)qualifierType).getConstraintType()) != null) {
            qualifierType = constraintType;
            arguments = JSTypeUtils.getGenericTypeArguments(qualifierType);
        }
        if (sourceElement == null) {
            JSTypeSubstitutor jSTypeSubstitutor = substitutor;
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(45);
            }
            return jSTypeSubstitutor;
        }
        JSClass parentClass = (JSClass)PsiTreeUtil.getContextOfType((PsiElement)sourceElement, (Class[])new Class[]{JSClass.class});
        if (parentClass == null) {
            JSTypeSubstitutor jSTypeSubstitutor = substitutor;
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(46);
            }
            return jSTypeSubstitutor;
        }
        if (arguments != null && JSTypeUtils.getQualifiedNameMatchingType(qualifierType, false) != null || qualifierType instanceof JSNamedType) {
            Collection<JSClass> qualifierClasses = TypeScriptGenericTypesEvaluator.getQualifierClasses(qualifierType, context2);
            for (JSClass qualifierClass : qualifierClasses) {
                List<JSType> argumentsList = arguments == null || arguments.isEmpty() ? TypeScriptGenericTypesEvaluator.getArgumentsListForTypeWithOwner(qualifierType, qualifierClass) : arguments;
                substitutor = TypeScriptGenericTypesEvaluator.processClassWithGenericArguments(qualifierClass, argumentsList, parentClass, substitutor);
            }
        } else if (qualifierType instanceof JSAnyType && parentClass instanceof TypeScriptTypeParameterListOwner && (sourceElement instanceof TypeScriptFunction || sourceElement instanceof TypeScriptField)) {
            List<JSType> defaults = TypeScriptGenericTypesEvaluator.getDefaultOrAnyTypes(parentClass);
            if (defaults != null && !defaults.isEmpty()) {
                substitutor = JSTypeSubstitutorImpl.combine(substitutor, TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments((TypeScriptTypeParameterListOwner)((Object)parentClass), defaults));
            }
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutorImpl.of(substitutor).transformValues((Function<? super JSType, ? extends JSType>)((Function)el -> {
                if (el instanceof TypeScriptNeverType) {
                    return JSAnyType.get(el.getSource());
                }
                if (el instanceof JSAnyType) {
                    return el;
                }
                return JSTypeUtils.copyWithStrictRecursive(el, false);
            }));
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(47);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor jSTypeSubstitutor = substitutor;
        if (jSTypeSubstitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(48);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    private static JSTypeSubstitutor buildSubstitutorForQualifierRecordType(@NotNull JSRecordType qualifierType, @NotNull JSGenericTypesEvaluator.GenericEvaluationContext evaluationContext) {
        if (qualifierType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(49);
        }
        if (evaluationContext == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(50);
        }
        PsiElement qualifierSource = qualifierType.getSource().getSourceElement();
        JSType objectType = null;
        if (qualifierSource instanceof TypeScriptObjectType) {
            objectType = ((TypeScriptObjectType)qualifierSource).getJSType();
        } else if (qualifierSource instanceof JSClass) {
            objectType = TypeScriptTypeParser.buildTypeFromClass((JSClass)qualifierSource, false);
        } else if (qualifierSource instanceof JSObjectLiteralExpression && DialectDetector.isTypeScript(qualifierSource)) {
            objectType = JSResolveUtil.getExpressionJSType((JSExpression)qualifierSource);
        }
        if (objectType != null) {
            if (objectType.isEquivalentTo(qualifierType, null, false)) {
                JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
                if (jSTypeSubstitutor == null) {
                    TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(51);
                }
                return jSTypeSubstitutor;
            }
            JSTypeSubstitutor jSTypeSubstitutor = TypeScriptGenericTypesEvaluator.findAndIntersectGenericsTypeValues(qualifierType, objectType, qualifierSource, evaluationContext);
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(52);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
        if (jSTypeSubstitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(53);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    public static List<JSType> getArgumentsListForTypeWithOwner(@NotNull JSType ownType, @NotNull PsiElement genericOwner) {
        List<JSType> parameters;
        if (ownType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(54);
        }
        if (genericOwner == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(55);
        }
        if (TypeScriptGenericTypesEvaluator.isInstanceJSTypeImpl(ownType) && (parameters = TypeScriptGenericTypesEvaluator.getDefaultOrAnyTypes(genericOwner)) != null) {
            List<JSType> list2 = parameters;
            if (list2 == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(56);
            }
            return list2;
        }
        List list3 = ContainerUtil.emptyList();
        if (list3 == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(57);
        }
        return list3;
    }

    @Nullable
    public static List<JSType> getDefaultOrAnyTypes(@NotNull PsiElement genericOwner) {
        Object[] parameters;
        if (genericOwner == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(58);
        }
        if ((parameters = TypeScriptPsiUtil.getTypeParametersForOwner(genericOwner)).length > 0) {
            return ContainerUtil.map((Object[])parameters, JSGenericTypesEvaluatorBase::getTypeParameterDefaultType);
        }
        return null;
    }

    public static boolean isInstanceJSTypeImpl(@NotNull JSType qualifierType) {
        if (qualifierType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(59);
        }
        return qualifierType instanceof JSTypeImpl && ((JSTypeImpl)qualifierType).getTypeContext().toJSContext() == JSContext.INSTANCE;
    }

    @NotNull
    public static JSType processClassWithGenericArguments(@Nullable JSClass aClass, @NotNull List<? extends JSType> typeArgumentsList, @Nullable JSClass requiredParentClass, @NotNull JSType appliedGenerics) {
        if (typeArgumentsList == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(60);
        }
        if (appliedGenerics == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(61);
        }
        JSTypeSubstitutor substitutor = TypeScriptGenericTypesEvaluator.processClassWithGenericArguments(aClass, typeArgumentsList, requiredParentClass, JSTypeSubstitutor.EMPTY);
        JSType jSType = JSTypeUtils.applyGenericArguments(appliedGenerics, substitutor);
        if (jSType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(62);
        }
        return jSType;
    }

    @NotNull
    public static JSTypeSubstitutor processClassWithGenericArguments(@Nullable JSClass startClass, @NotNull List<? extends JSType> typeArgumentsList, @Nullable JSClass expectedGenericOwnerClass, @NotNull JSTypeSubstitutor substitutor) {
        if (typeArgumentsList == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(63);
        }
        if (substitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(64);
        }
        if (!(expectedGenericOwnerClass instanceof TypeScriptTypeParameterListOwner) || startClass == null) {
            JSTypeSubstitutor jSTypeSubstitutor = substitutor;
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(65);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor typeArguments = startClass instanceof TypeScriptTypeParameterListOwner ? TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments((TypeScriptTypeParameterListOwner)((Object)startClass), typeArgumentsList) : JSTypeSubstitutor.EMPTY;
        Ref ref = Ref.create((Object)substitutor);
        JSClassUtils.processClassesInHierarchy(startClass, true, (contextClass, typeSubstitutor, fromImplements) -> {
            if (contextClass.isEquivalentTo(expectedGenericOwnerClass)) {
                if (!substitutor.isEmpty()) {
                    typeSubstitutor = new JSTypeSubstitutorImpl(typeSubstitutor);
                    ((JSTypeSubstitutorImpl)typeSubstitutor).putAll(substitutor);
                }
                ref.set((Object)typeSubstitutor);
                return false;
            }
            return true;
        }, (Condition<? super JSClass>)((Condition)superCandidate -> JSInheritanceUtil.isParentClass(superCandidate, expectedGenericOwnerClass, false)), typeArguments);
        JSTypeSubstitutor jSTypeSubstitutor = (JSTypeSubstitutor)ref.get();
        if (jSTypeSubstitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(66);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    public static List<JSType> getTypeArgumentsForDeclarations(JSTypeDeclaration @NotNull [] declarations, @Nullable JSTypeSubstitutor typeArguments) {
        if (declarations == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(67);
        }
        SmartList mappedArguments = new SmartList();
        for (JSTypeDeclaration typeArgument : declarations) {
            JSType expandedType = typeArgument.getJSType();
            if (typeArguments != null) {
                expandedType = JSTypeUtils.applyGenericArguments(expandedType, typeArguments);
            }
            mappedArguments.add(expandedType);
        }
        SmartList smartList = mappedArguments;
        if (smartList == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(68);
        }
        return smartList;
    }

    @Nullable
    public static JSTypeSubstitutor getSubstitutorForTypeArguments(@Nullable TypeScriptTypeParameterListOwner typeParameterListOwner, @Nullable JSType genericType) {
        List<JSType> arguments = JSTypeUtils.getGenericTypeArguments(genericType);
        return arguments == null ? null : TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments(typeParameterListOwner, arguments);
    }

    @NotNull
    public static JSTypeSubstitutor getSubstitutorForTypeArguments(@Nullable TypeScriptTypeParameterListOwner typeParameterListOwner, @NotNull List<? extends JSType> typeArgumentsList) {
        if (typeArgumentsList == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(69);
        }
        if (typeParameterListOwner == null) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(70);
            }
            return jSTypeSubstitutor;
        }
        return TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments(typeParameterListOwner.getTypeParameterList(), typeArgumentsList);
    }

    @NotNull
    public static JSTypeSubstitutor getSubstitutorForTypeArguments(@Nullable TypeScriptTypeParameterList typeParameterList, @NotNull List<? extends JSType> typeArgumentsList) {
        if (typeArgumentsList == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(71);
        }
        if (typeArgumentsList.isEmpty()) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(72);
            }
            return jSTypeSubstitutor;
        }
        TypeScriptTypeParameter[] parameters = typeParameterList == null ? TypeScriptTypeParameter.EMPTY_ARRAY : typeParameterList.getTypeParameters();
        return TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments(parameters, typeArgumentsList);
    }

    @NotNull
    public static JSTypeSubstitutor getSubstitutorForTypeArguments(TypeScriptTypeParameter @NotNull [] parameters, @NotNull List<? extends JSType> typeArgumentsList) {
        if (typeArgumentsList == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(73);
        }
        if (parameters == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(74);
        }
        if (parameters.length == 0 || typeArgumentsList.isEmpty() && ContainerUtil.and((Object[])parameters, p -> p.getDefault() == null)) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(75);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutorImpl genericArguments = new JSTypeSubstitutorImpl();
        for (int i = 0; i < parameters.length; ++i) {
            String name;
            TypeScriptTypeParameter parameter = parameters[i];
            JSType type2 = null;
            if (typeArgumentsList.size() > i) {
                type2 = typeArgumentsList.get(i);
            }
            if (TypeScriptGenericTypesEvaluator.addFromNamedSubstitutor(ContainerUtil.map((Object[])parameters, TypeScriptGenericOrMappedTypeParameter::getGenericId), genericArguments, type2)) continue;
            if (type2 == null) {
                type2 = JSTypeUtils.applyGenericArguments(TypeScriptGenericTypesEvaluator.getTypeParameterDefaultType(parameter), genericArguments);
            }
            if ((name = parameter.getName()) == null) continue;
            genericArguments.put(parameter.getGenericId(), type2);
        }
        JSTypeSubstitutor jSTypeSubstitutor = genericArguments.isEmpty() ? JSTypeSubstitutor.EMPTY : genericArguments;
        if (jSTypeSubstitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(76);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    private JSTypeSubstitutor getInferredCallLikeTypeSubstitutor(@Nullable JSFunctionType functionType2, @NotNull JSCallItem callItem, @NotNull JSGenericTypesEvaluator.GenericEvaluationContext context2, @NotNull JSTypeSubstitutor explicitSubstitutor) {
        if (callItem == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(77);
        }
        if (context2 == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(78);
        }
        if (explicitSubstitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(79);
        }
        if (context2.expectedTypeKind.isInferenceDepthExceeded()) {
            JSTypeSubstitutor jSTypeSubstitutor = TypeScriptGenericTypesEvaluator.getSubstitutorForDefaultParameters(functionType2);
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(80);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor jSTypeSubstitutor = this.inferGenericTypesForCall(functionType2, callItem, context2, explicitSubstitutor.keys());
        if (jSTypeSubstitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(81);
        }
        return jSTypeSubstitutor;
    }

    private static JSTypeSubstitutor getConstructorTypeSubstitutor(@Nullable PsiElement resolvedFunction, @NotNull JSExpression methodExpression) {
        JSReferenceList list2;
        TypeScriptClass tsClass;
        if (methodExpression == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(82);
        }
        if (!(resolvedFunction instanceof TypeScriptFunction)) {
            return JSTypeSubstitutor.EMPTY;
        }
        TypeScriptClass typeScriptClass = TypeScriptGenericTypesEvaluator.isConstructorSuperCall(resolvedFunction, (PsiElement)methodExpression) ? (TypeScriptClass)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)methodExpression, TypeScriptClass.class) : (tsClass = ((TypeScriptFunction)resolvedFunction).isConstructor() ? TypeScriptGenericTypesEvaluator.getClassIfNoOwnConstructor(methodExpression) : null);
        if (tsClass != null && (list2 = tsClass.getExtendsList()) != null) {
            if (tsClass.getIndirectSuperConstructors().contains(resolvedFunction)) {
                JSExpression element = (JSExpression)ArrayUtil.getFirstElement((Object[])list2.getExpressions());
                List<JSType> typesForGenerics = element != null ? TypeScriptGenericTypesEvaluator.getTypeArgumentsForDeclarations(TypeScriptPsiUtil.getNestedTypeArguments(element.getParent()), null) : ContainerUtil.emptyList();
                TypeScriptFunction tsFunction = (TypeScriptFunction)resolvedFunction;
                return TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments((TypeScriptTypeParameterListOwner)tsFunction, typesForGenerics);
            }
            JSClass parentClass = (JSClass)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)resolvedFunction, JSClass.class);
            return TypeScriptGenericTypesEvaluator.processClassWithGenericArguments((JSClass)tsClass, (List<? extends JSType>)ContainerUtil.emptyList(), parentClass, JSTypeSubstitutor.EMPTY);
        }
        return JSTypeSubstitutor.EMPTY;
    }

    private static TypeScriptClass getClassIfNoOwnConstructor(@NotNull JSExpression methodExpression) {
        if (methodExpression == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(83);
        }
        TypeScriptClass clazz = null;
        if (methodExpression instanceof JSReferenceExpression) {
            ResolveResult[] results;
            for (ResolveResult result2 : results = ((JSReferenceExpression)methodExpression).multiResolve(true)) {
                List expanded;
                PsiElement element = result2.getElement();
                Collection<Object> collection = expanded = element == null ? Collections.emptyList() : new TypeScriptQualifiedNameResolver((PsiElement)methodExpression).expandElement(element);
                if (expanded.isEmpty()) continue;
                PsiElement sourceElement = (PsiElement)ContainerUtil.getFirstItem(expanded);
                if (!(sourceElement instanceof TypeScriptClass) || ((TypeScriptClass)sourceElement).getConstructor() != null) break;
                clazz = (TypeScriptClass)sourceElement;
                break;
            }
        }
        return clazz;
    }

    @NotNull
    public JSTypeSubstitutor getTypeSubstitutorForMember(@Nullable PsiElement member, @Nullable PsiElement place, @Nullable JSTypeSubstitutor additionalSubstitutor) {
        if (member instanceof TypeScriptProxyImplicitElement) {
            member = ((TypeScriptProxyImplicitElement)member).getExplicitElement();
        }
        if (!(place instanceof JSExpression) || !(member instanceof JSQualifiedNamedElement)) {
            JSTypeSubstitutor jSTypeSubstitutor = additionalSubstitutor == null ? JSTypeSubstitutor.EMPTY : additionalSubstitutor;
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(84);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutorImpl substitutor = new JSTypeSubstitutorImpl();
        if (additionalSubstitutor != null) {
            substitutor.putAll(additionalSubstitutor);
        }
        JSCallLikeExpression callLikeExpression = TypeScriptSignatureChooser.getCallLikeExpression(place);
        substitutor.putAll(this.getAllGenericTypeSubstitutor((JSExpression)place, member, callLikeExpression, DEFAULT_CONTEXT));
        JSTypeSubstitutorImpl jSTypeSubstitutorImpl = substitutor;
        if (jSTypeSubstitutorImpl == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(85);
        }
        return jSTypeSubstitutorImpl;
    }

    @NotNull
    public JSTypeSubstitutor getTypeSubstitutorForCallItem(@NotNull JSFunctionType functionType2, @NotNull JSCallItem callItem, @Nullable JSTypeSubstitutor additionalSubstitutor) {
        if (functionType2 == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(86);
        }
        if (callItem == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(87);
        }
        JSTypeSubstitutorImpl substitutor = new JSTypeSubstitutorImpl();
        if (additionalSubstitutor != null) {
            substitutor.putAll(additionalSubstitutor);
        }
        substitutor.putAll(this.getAllGenericTypeSubstitutor(functionType2, callItem, DEFAULT_CONTEXT, JSTypeSubstitutor.EMPTY));
        JSTypeSubstitutorImpl jSTypeSubstitutorImpl = substitutor;
        if (jSTypeSubstitutorImpl == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(88);
        }
        return jSTypeSubstitutorImpl;
    }

    @NotNull
    public JSTypeSubstitutor getTypeSubstitutorForMember(@Nullable JSElement member, @NotNull PsiElement place) {
        List<JSFunctionWithSubstitutor> elements;
        JSFunctionWithSubstitutor functionWithSubstitutor;
        if (place == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(89);
        }
        if (member == null || !DialectDetector.isTypeScript((PsiElement)member) || !(place instanceof JSReferenceExpression)) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(90);
            }
            return jSTypeSubstitutor;
        }
        JSReferenceExpression referenceExpression = (JSReferenceExpression)place;
        if (referenceExpression.getParent() instanceof JSCallExpression && (functionWithSubstitutor = (JSFunctionWithSubstitutor)ContainerUtil.getFirstItem(elements = TypeScriptSignatureChooser.resolveConstructorOrCallSignature((PsiElement)referenceExpression))) != null) {
            JSFunctionItem functionItem = functionWithSubstitutor.myFunctionItem;
            JSTypeSubstitutor additionalSubstitutor = functionWithSubstitutor.myTypeSubstitutor;
            JSTypeSubstitutor jSTypeSubstitutor = this.getTypeSubstitutorForMember((PsiElement)functionItem, place, additionalSubstitutor);
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(91);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor jSTypeSubstitutor = this.getTypeSubstitutorForMember((PsiElement)member, place, null);
        if (jSTypeSubstitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(92);
        }
        return jSTypeSubstitutor;
    }

    private static boolean isConstructorSuperCall(@Nullable PsiElement resolveResult, @Nullable PsiElement callExpression) {
        return callExpression instanceof JSSuperExpression && callExpression.getParent() instanceof JSCallExpression && resolveResult instanceof JSFunction && ((JSFunction)resolveResult).isConstructor();
    }

    public static void fillExplicitGenericArguments(List<TypeScriptGenericDeclarationTypeImpl> typeParameters, JSTypeDeclaration @NotNull [] typeArguments, @NotNull JSTypeSubstitutorImpl genericArguments) {
        if (genericArguments == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(93);
        }
        if (typeArguments == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(94);
        }
        if (typeParameters.isEmpty() || typeArguments.length == 0) {
            return;
        }
        List ids = ContainerUtil.map(typeParameters, el -> el.getGenericId());
        for (int i = 0; i < typeParameters.size(); ++i) {
            JSType type2;
            TypeScriptGenericDeclarationTypeImpl parameter = typeParameters.get(i);
            JSTypeDeclaration typeArgument = typeArguments.length > i ? typeArguments[i] : null;
            JSType jSType = type2 = typeArgument != null ? typeArgument.getJSType() : null;
            if (TypeScriptGenericTypesEvaluator.addFromNamedSubstitutor(ids, genericArguments, type2)) continue;
            if (type2 == null) {
                type2 = TypeScriptGenericTypesEvaluator.getTypeParameterDefaultType(parameter);
            }
            genericArguments.put(parameter.getGenericId(), type2);
        }
    }

    private static boolean addFromNamedSubstitutor(@NotNull List<JSTypeGenericId> typeParameters, @NotNull JSTypeSubstitutorImpl genericArguments, JSType type2) {
        if (typeParameters == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(95);
        }
        if (genericArguments == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(96);
        }
        if (!(type2 instanceof JSNamedTypeSubstitutorType)) {
            return false;
        }
        String genericName = ((JSNamedTypeSubstitutorType)type2).getGenericName();
        Optional<JSTypeGenericId> first = typeParameters.stream().filter(p -> genericName.equals(p.getName())).findFirst();
        first.ifPresent(parameter -> genericArguments.put((JSTypeGenericId)parameter, ((JSNamedTypeSubstitutorType)type2).getRealType()));
        return true;
    }

    @NotNull
    public static JSTypeSubstitutor getCallExplicitTypeSubstitutor(@Nullable JSFunctionType jsFunctionType, @Nullable JSCallItem callItem, @Nullable JSTypeSubstitutor genericArguments) {
        if (!(jsFunctionType instanceof TypeScriptJSFunctionTypeImpl)) {
            return genericArguments == null ? JSTypeSubstitutor.EMPTY : new JSTypeSubstitutorImpl(genericArguments);
        }
        JSTypeSubstitutorImpl substitutor = genericArguments == null ? new JSTypeSubstitutorImpl() : new JSTypeSubstitutorImpl(genericArguments);
        List<TypeScriptGenericDeclarationTypeImpl> declarations = ((TypeScriptJSFunctionTypeImpl)jsFunctionType).getGenericDeclarations();
        if (!declarations.isEmpty()) {
            JSTypeDeclaration[] typeArguments = TypeScriptPsiUtil.getNestedTypeArguments(callItem);
            TypeScriptGenericTypesEvaluator.fillExplicitGenericArguments(declarations, typeArguments, substitutor);
        }
        JSTypeSubstitutorImpl jSTypeSubstitutorImpl = substitutor;
        if (jSTypeSubstitutorImpl == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(97);
        }
        return jSTypeSubstitutorImpl;
    }

    @NotNull
    public static JSType getExplicitTypeOrAnyIfTypeScript(@Nullable PsiElement context2, @Nullable JSType type2) {
        if (type2 == null) {
            JSAnyType jSAnyType = JSAnyType.get(context2);
            if (jSAnyType == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(98);
            }
            return jSAnyType;
        }
        if (context2 == null || !context2.isValid()) {
            JSType jSType = type2;
            if (jSType == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(99);
            }
            return jSType;
        }
        DialectOptionHolder holder = DialectDetector.dialectOfElement(context2);
        if (holder != null && holder.isTypeScript) {
            return TypeScriptGenericTypesEvaluator.getExplicitTypeOrAny(context2, type2);
        }
        JSType jSType = type2;
        if (jSType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(100);
        }
        return jSType;
    }

    @NotNull
    public static JSType getExplicitTypeOrAny(@NotNull PsiElement expression, @Nullable JSType type2) {
        if (expression == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(101);
        }
        JSType jSType = type2 == null ? JSAnyType.get(expression) : type2;
        if (jSType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(102);
        }
        return jSType;
    }

    @NotNull
    public static Collection<JSClass> getQualifierClasses(@Nullable JSType qualifierType, @Nullable PsiElement place) {
        if (qualifierType == null) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(103);
            }
            return list2;
        }
        JSTypeSource source = qualifierType.getSource();
        String type2 = JSTypeUtils.getQualifiedNameMatchingType(qualifierType, false);
        PsiElement element = source.getSourceElement();
        if (type2 == null || element == null) {
            List list3 = ContainerUtil.emptyList();
            if (list3 == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(104);
            }
            return list3;
        }
        Collection<? extends PsiElement> elements = TypeScriptGenericTypesEvaluator.getElementsForQualifierClassName(type2, element, place);
        SmartList result2 = new SmartList();
        for (PsiElement psiElement : elements) {
            if (!(psiElement instanceof JSClass)) continue;
            result2.add((JSClass)psiElement);
        }
        SmartList smartList = result2;
        if (smartList == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(105);
        }
        return smartList;
    }

    @NotNull
    private static Collection<? extends PsiElement> getElementsForQualifierClassName(@NotNull String type2, @NotNull PsiElement element, @Nullable PsiElement place) {
        boolean isJSPlace;
        if (type2 == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(106);
        }
        if (element == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(107);
        }
        boolean bl = isJSPlace = place != null && !DialectDetector.isTypeScript(place);
        if (isJSPlace) {
            if (JSCorePredefinedLibrariesProvider.isLibraryElement(element)) {
                Collection<PsiElement> collection = JavaScriptQualifiedItemProcessor.resolveGlobalTypeElementsByName(type2, place);
                if (collection == null) {
                    TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(108);
                }
                return collection;
            }
            if (!DialectDetector.isTypeScript(element)) {
                Collection<PsiElement> elements = new ES6QualifiedNameResolver(element).resolveQualifiedName(type2);
                if (!elements.isEmpty()) {
                    Collection<PsiElement> collection = elements;
                    if (collection == null) {
                        TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(109);
                    }
                    return collection;
                }
                Collection<PsiElement> collection = JavaScriptQualifiedItemProcessor.resolveGlobalTypeElementsByName(type2, place);
                if (collection == null) {
                    TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(110);
                }
                return collection;
            }
        }
        JSTypeResolveResult resolveResults = TypeScriptImportHandler.getInstance().resolveMainElementName(type2, element, JSContext.UNKNOWN);
        Collection<? extends PsiElement> collection = resolveResults.getElements();
        if (collection == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(111);
        }
        return collection;
    }

    @NotNull
    public static List<TypeScriptGenericDeclarationTypeImpl> buildGenericParameterDeclarations(TypeScriptTypeParameter @NotNull [] parameters) {
        if (parameters == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(112);
        }
        if (parameters.length == 0) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(113);
            }
            return list2;
        }
        ArrayList<TypeScriptGenericDeclarationTypeImpl> generics = new ArrayList<TypeScriptGenericDeclarationTypeImpl>();
        for (TypeScriptTypeParameter parameter : parameters) {
            TypeScriptGenericDeclarationTypeImpl declaration = TypeScriptGenericTypesEvaluator.buildGenericParameterDeclaration(parameter);
            generics.add(declaration);
        }
        ArrayList<TypeScriptGenericDeclarationTypeImpl> arrayList = generics;
        if (arrayList == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(114);
        }
        return arrayList;
    }

    @NotNull
    public static List<JSType> buildGenericParameters(TypeScriptTypeParameter @NotNull [] parameters) {
        if (parameters == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(115);
        }
        List list2 = ContainerUtil.map(TypeScriptGenericTypesEvaluator.buildGenericParameterDeclarations(parameters), el -> el.toGenericParameter());
        if (list2 == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(116);
        }
        return list2;
    }

    @NotNull
    public static TypeScriptGenericDeclarationTypeImpl buildGenericParameterDeclaration(@NotNull TypeScriptTypeParameter parameter) {
        if (parameter == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(117);
        }
        TypeScriptType constraint = parameter.getTypeConstraint();
        TypeScriptType parameterDefault = parameter.getDefault();
        NotNullLazyValue constraintType = constraint == null ? null : NotNullLazyValue.atomicLazy(() -> constraint.getJSType());
        NotNullLazyValue defaultType = parameterDefault == null ? null : NotNullLazyValue.atomicLazy(() -> parameterDefault.getJSType());
        JSTypeGenericId genericId = parameter.getGenericId();
        JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)parameter, true);
        return new TypeScriptGenericDeclarationTypeImpl(genericId, (NotNullLazyValue<? extends JSType>)constraintType, (NotNullLazyValue<? extends JSType>)defaultType, source, parameter.isConst());
    }

    @NotNull
    public static JSType applyTypeScriptGenericArguments(@NotNull JSFunctionTypeImpl functionType2, @NotNull JSCallExpression callExpression) {
        if (functionType2 == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(118);
        }
        if (callExpression == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(119);
        }
        return TypeScriptGenericTypesEvaluator.applyTypeScriptGenericArguments(functionType2, callExpression, (PsiElement)functionType2.getSourceFunctionItem());
    }

    @NotNull
    public static JSType applyTypeScriptGenericArguments(@NotNull JSFunctionType functionType2, @NotNull JSCallItem callItem, @Nullable PsiElement sourceElement) {
        if (functionType2 == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(120);
        }
        if (callItem == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(121);
        }
        JSType jSType = JSGenericTypesEvaluator.getEvaluator(callItem.getPsiContext()).evaluateGenerics((JSType)functionType2, callItem, sourceElement, DEFAULT_CONTEXT);
        if (jSType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(122);
        }
        return jSType;
    }

    @NotNull
    public static JSTypeSubstitutor getTypeSubstitutorForExtendClass(@NotNull JSClass contextClass, @NotNull JSClass genericOwner) {
        if (contextClass == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(123);
        }
        if (genericOwner == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(124);
        }
        if (!(genericOwner instanceof TypeScriptTypeParameterListOwner)) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(125);
            }
            return jSTypeSubstitutor;
        }
        TypeScriptTypeParameterList typeParameterList = ((TypeScriptTypeParameterListOwner)((Object)genericOwner)).getTypeParameterList();
        if (typeParameterList == null) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(126);
            }
            return jSTypeSubstitutor;
        }
        TypeScriptTypeParameter[] parameters = typeParameterList.getTypeParameters();
        if (parameters.length == 0) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(127);
            }
            return jSTypeSubstitutor;
        }
        return TypeScriptGenericTypesEvaluator.processClassWithGenericArguments(contextClass, (List<? extends JSType>)ContainerUtil.emptyList(), genericOwner, JSTypeSubstitutor.EMPTY);
    }

    private static /* synthetic */ List lambda$hasGenericsCompatibilityErrors$10(TypeScriptTypeParameter[] parameters) {
        return TypeScriptGenericTypesEvaluator.buildGenericParameters(parameters);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 12, 13, 15, 19, 23, 24, 28, 32, 34, 43, 44, 45, 46, 47, 48, 51, 52, 53, 56, 57, 62, 65, 66, 68, 70, 72, 75, 76, 80, 81, 84, 85, 88, 90, 91, 92, 97, 98, 99, 100, 102, 103, 104, 105, 108, 109, 110, 111, 113, 114, 116, 122, 125, 126, 127 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 16: 
            case 22: 
            case 77: 
            case 87: 
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callItem";
                break;
            }
            case 4: 
            case 8: 
            case 25: 
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 7: 
            case 12: 
            case 13: 
            case 15: 
            case 19: 
            case 23: 
            case 24: 
            case 28: 
            case 32: 
            case 34: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 51: 
            case 52: 
            case 53: 
            case 56: 
            case 57: 
            case 62: 
            case 65: 
            case 66: 
            case 68: 
            case 70: 
            case 72: 
            case 75: 
            case 76: 
            case 80: 
            case 81: 
            case 84: 
            case 85: 
            case 88: 
            case 90: 
            case 91: 
            case 92: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 113: 
            case 114: 
            case 116: 
            case 122: 
            case 125: 
            case 126: 
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callLikeExpression";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedFunctionOrField";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "explicit";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inferred";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraints";
                break;
            }
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 27: 
            case 82: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodExpression";
                break;
            }
            case 31: 
            case 33: 
            case 42: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluationContext";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recordType";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterTypes";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 41: 
            case 49: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierType";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownType";
                break;
            }
            case 55: 
            case 58: 
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "genericOwner";
                break;
            }
            case 60: 
            case 63: 
            case 69: 
            case 71: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeArgumentsList";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appliedGenerics";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarations";
                break;
            }
            case 74: 
            case 112: 
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "explicitSubstitutor";
                break;
            }
            case 86: 
            case 118: 
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionType";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 93: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "genericArguments";
                break;
            }
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeArguments";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameters";
                break;
            }
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 123: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "transferGenericParametersToFunctionalType";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getEvaluationFunction";
                break;
            }
            case 15: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllGenericTypeSubstitutor";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "processInferredGenerics";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluateGenericsFromQualifier";
                break;
            }
            case 32: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifierTypeSubstitutor";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSubstitutorForQualifierType";
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "buildSubstitutorForQualifierRecordType";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentsListForTypeWithOwner";
                break;
            }
            case 62: 
            case 65: 
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "processClassWithGenericArguments";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeArgumentsForDeclarations";
                break;
            }
            case 70: 
            case 72: 
            case 75: 
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitutorForTypeArguments";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "getInferredCallLikeTypeSubstitutor";
                break;
            }
            case 84: 
            case 85: 
            case 90: 
            case 91: 
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSubstitutorForMember";
                break;
            }
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSubstitutorForCallItem";
                break;
            }
            case 97: {
                objectArray = objectArray2;
                objectArray2[1] = "getCallExplicitTypeSubstitutor";
                break;
            }
            case 98: 
            case 99: 
            case 100: {
                objectArray = objectArray2;
                objectArray2[1] = "getExplicitTypeOrAnyIfTypeScript";
                break;
            }
            case 102: {
                objectArray = objectArray2;
                objectArray2[1] = "getExplicitTypeOrAny";
                break;
            }
            case 103: 
            case 104: 
            case 105: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifierClasses";
                break;
            }
            case 108: 
            case 109: 
            case 110: 
            case 111: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsForQualifierClassName";
                break;
            }
            case 113: 
            case 114: {
                objectArray = objectArray2;
                objectArray2[1] = "buildGenericParameterDeclarations";
                break;
            }
            case 116: {
                objectArray = objectArray2;
                objectArray2[1] = "buildGenericParameters";
                break;
            }
            case 122: {
                objectArray = objectArray2;
                objectArray2[1] = "applyTypeScriptGenericArguments";
                break;
            }
            case 125: 
            case 126: 
            case 127: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSubstitutorForExtendClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "evaluateGenerics";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doEvaluateGenerics";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "transferGenericParametersToFunctionalType";
                break;
            }
            case 7: 
            case 12: 
            case 13: 
            case 15: 
            case 19: 
            case 23: 
            case 24: 
            case 28: 
            case 32: 
            case 34: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 51: 
            case 52: 
            case 53: 
            case 56: 
            case 57: 
            case 62: 
            case 65: 
            case 66: 
            case 68: 
            case 70: 
            case 72: 
            case 75: 
            case 76: 
            case 80: 
            case 81: 
            case 84: 
            case 85: 
            case 88: 
            case 90: 
            case 91: 
            case 92: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 113: 
            case 114: 
            case 116: 
            case 122: 
            case 125: 
            case 126: 
            case 127: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAssociatedElement";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getEvaluationFunction";
                break;
            }
            case 14: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getAllGenericTypeSubstitutor";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "processInferredGenerics";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "evaluateGenericsFromQualifier";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getQualifierTypeSubstitutor";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableRecordTypeForThis";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "hasGenericsCompatibilityErrors";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSubstitutorForQualifierType";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "buildSubstitutorForQualifierRecordType";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getArgumentsListForTypeWithOwner";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultOrAnyTypes";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "isInstanceJSTypeImpl";
                break;
            }
            case 60: 
            case 61: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "processClassWithGenericArguments";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "getTypeArgumentsForDeclarations";
                break;
            }
            case 69: 
            case 71: 
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "getSubstitutorForTypeArguments";
                break;
            }
            case 77: 
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "getInferredCallLikeTypeSubstitutor";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "getConstructorTypeSubstitutor";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "getClassIfNoOwnConstructor";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSubstitutorForCallItem";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSubstitutorForMember";
                break;
            }
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "fillExplicitGenericArguments";
                break;
            }
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "addFromNamedSubstitutor";
                break;
            }
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "getExplicitTypeOrAny";
                break;
            }
            case 106: 
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "getElementsForQualifierClassName";
                break;
            }
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "buildGenericParameterDeclarations";
                break;
            }
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "buildGenericParameters";
                break;
            }
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "buildGenericParameterDeclaration";
                break;
            }
            case 118: 
            case 119: 
            case 120: 
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "applyTypeScriptGenericArguments";
                break;
            }
            case 123: 
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSubstitutorForExtendClass";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 12, 13, 15, 19, 23, 24, 28, 32, 34, 43, 44, 45, 46, 47, 48, 51, 52, 53, 56, 57, 62, 65, 66, 68, 70, 72, 75, 76, 80, 81, 84, 85, 88, 90, 91, 92, 97, 98, 99, 100, 102, 103, 104, 105, 108, 109, 110, 111, 113, 114, 116, 122, 125, 126, 127 -> new IllegalStateException(string);
        };
    }
}

