/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.refactoring;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.move.FileReferenceContextUtil;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFileHandler;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NullableFunction;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6MoveFileHandler
extends MoveFileHandler {
    private static final Key<Boolean> MARKER = Key.create((String)"marker.not.invalidated");
    private static final Logger LOG = Logger.getInstance(ES6MoveFileHandler.class);

    public boolean canProcessElement(PsiFile file) {
        return file instanceof JSFile && DialectDetector.hasFeature((PsiElement)file, JSLanguageFeature.IMPORT_DECLARATIONS);
    }

    public void prepareMovedFile(PsiFile file, PsiDirectory moveDestination, Map<PsiElement, PsiElement> oldToNewMap) {
    }

    @Nullable
    public List<UsageInfo> findUsages(PsiFile psiFile, PsiDirectory newParent, boolean searchInComments, boolean searchInNonJavaFiles) {
        if (!(psiFile instanceof JSFile)) {
            return null;
        }
        List<UsageInfo> result2 = this.doFindUsages(psiFile);
        if (result2.isEmpty()) {
            return null;
        }
        psiFile.putCopyableUserData(MARKER, (Object)true);
        return result2;
    }

    @NotNull
    protected List<UsageInfo> doFindUsages(@NotNull PsiFile psiFile) {
        Map encodedInfo;
        if (psiFile == null) {
            ES6MoveFileHandler.$$$reportNull$$$0(0);
        }
        if ((encodedInfo = FileReferenceContextUtil.encodeFileReferences((PsiElement)psiFile)).isEmpty()) {
            List<UsageInfo> list2 = Collections.emptyList();
            if (list2 == null) {
                ES6MoveFileHandler.$$$reportNull$$$0(1);
            }
            return list2;
        }
        Map<String, VirtualFile> resultMap = ES6MoveFileHandler.convertMap(encodedInfo, el -> el.getVirtualFile());
        List<UsageInfo> list3 = Collections.singletonList(new MyRestoreReferencesUsage(psiFile, resultMap));
        if (list3 == null) {
            ES6MoveFileHandler.$$$reportNull$$$0(2);
        }
        return list3;
    }

    public void retargetUsages(List<UsageInfo> usageInfos, Map<PsiElement, PsiElement> oldToNewMap) {
        HashSet<PsiElement> correctlyCopiedElements = new HashSet<PsiElement>();
        for (UsageInfo info2 : usageInfos) {
            PsiElement element;
            if (!(info2 instanceof RestoreReferencesUsage) || !((element = info2.getElement()) instanceof PsiFile) || !element.isValid()) continue;
            Boolean data = (Boolean)element.getCopyableUserData(MARKER);
            if (data != null) {
                element.putCopyableUserData(MARKER, null);
            }
            if (Boolean.TRUE.equals(data)) {
                correctlyCopiedElements.add(element);
                continue;
            }
            if (correctlyCopiedElements.contains(element)) continue;
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                LOG.error(ES6MoveFileHandler.getErrorMessage(element));
            } else {
                LOG.warn(ES6MoveFileHandler.getErrorMessage(element));
            }
            ((RestoreReferencesUsage)info2).restore((PsiFile)element);
        }
    }

    public void updateMovedFile(PsiFile file) throws IncorrectOperationException {
        if (DialectDetector.isTypeScript((PsiElement)file) && file instanceof JSFile && ((JSFile)file).getReferencedPaths().size() > 0) {
            PsiComment[] comments = (PsiComment[])PsiTreeUtil.getChildrenOfType((PsiElement)file, PsiComment.class);
            if (comments == null) {
                return;
            }
            for (PsiComment comment : comments) {
                FileReferenceContextUtil.decodeFileReferences((PsiElement)comment);
            }
        }
    }

    @NotNull
    private static String getErrorMessage(@NotNull PsiElement element) {
        PsiFile file;
        if (element == null) {
            ES6MoveFileHandler.$$$reportNull$$$0(3);
        }
        String path2 = (file = element.getContainingFile()) != null ? file.getVirtualFile().getPath() : "unknown";
        String string = "Psi file was invalidated after move file: '" + path2 + "'. All file references will be lost";
        if (string == null) {
            ES6MoveFileHandler.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    protected static <Old, New> Map<String, New> convertMap(@NotNull Map<String, Old> map, @NotNull NullableFunction<? super Old, ? extends New> func) {
        if (map == null) {
            ES6MoveFileHandler.$$$reportNull$$$0(5);
        }
        if (func == null) {
            ES6MoveFileHandler.$$$reportNull$$$0(6);
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        for (Map.Entry<String, Old> entry : map.entrySet()) {
            Old value = entry.getValue();
            String key2 = entry.getKey();
            Object newValue = func.fun(value);
            if (newValue == null) continue;
            resultMap.put(key2, newValue);
        }
        HashMap<String, Object> hashMap = resultMap;
        if (hashMap == null) {
            ES6MoveFileHandler.$$$reportNull$$$0(7);
        }
        return hashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/refactoring/ES6MoveFileHandler";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "func";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/refactoring/ES6MoveFileHandler";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "doFindUsages";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorMessage";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "convertMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doFindUsages";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessage";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "convertMap";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4, 7 -> new IllegalStateException(string);
        };
    }

    private static final class MyRestoreReferencesUsage
    extends RestoreReferencesUsage<Map<String, VirtualFile>> {
        MyRestoreReferencesUsage(@NotNull PsiFile element, Map<String, VirtualFile> refs) {
            if (element == null) {
                MyRestoreReferencesUsage.$$$reportNull$$$0(0);
            }
            super(element, refs);
        }

        @Override
        protected void restore(@NotNull PsiFile file) {
            if (file == null) {
                MyRestoreReferencesUsage.$$$reportNull$$$0(1);
            }
            PsiManager manager = file.getManager();
            Map map = ES6MoveFileHandler.convertMap((Map)this.myRefs, el -> FileReferenceHelper.getPsiFileSystemItem((PsiManager)manager, (VirtualFile)el));
            FileReferenceContextUtil.decodeFileReferences((PsiElement)file, map, (TextRange)file.getTextRange());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/typescript/refactoring/ES6MoveFileHandler$MyRestoreReferencesUsage";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "restore";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static abstract class RestoreReferencesUsage<T>
    extends UsageInfo {
        @NotNull
        protected final T myRefs;

        protected RestoreReferencesUsage(@NotNull PsiFile element, @NotNull T refs) {
            if (element == null) {
                RestoreReferencesUsage.$$$reportNull$$$0(0);
            }
            if (refs == null) {
                RestoreReferencesUsage.$$$reportNull$$$0(1);
            }
            super(element);
            this.myRefs = refs;
        }

        protected abstract void restore(@NotNull PsiFile var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "refs";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/typescript/refactoring/ES6MoveFileHandler$RestoreReferencesUsage";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

