/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.psi;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.ES6StubElementTypes;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.ecmascript6.resolve.ES6ImportHandler;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSDestructuringParameter;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeArgumentsOwner;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.ecma6.JSComputedPropertyNameOwner;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCompileTimeType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptExportAssignment;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptGenericOrMappedTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptGlobalModuleExportDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptIndexSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterfaceClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptParenthesizedType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptSingleType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptModuleImpl;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptParameterListImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSCoreLibraryElementsCollector;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.stubs.TypeScriptProxyImplicitElementWithBackingItem;
import com.intellij.lang.javascript.psi.stubs.impl.JSQualifiedObjectStubBase;
import com.intellij.lang.javascript.psi.types.JSCompositeFunctionPropertySignatureImpl;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.lang.typescript.TypeScriptStubElementTypes;
import com.intellij.lang.typescript.psi.TypeScriptEntityName;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptPsiUtil {
    public static final Pattern TYPESCRIPT_REFERENCE_PATH = Pattern.compile("^///\\s*<\\s*reference\\s*(path|lib|types)\\s*=\\s*(['\"])([^'\"]+)\\2[^/]*\\s*/>.*$");
    private static final String THIS_NAME = "this";

    private TypeScriptPsiUtil() {
    }

    @Nullable
    public static JSType getTypeFromDeclaration(StubBasedPsiElementBase element) {
        TypeScriptType resultType = TypeScriptPsiUtil.getStubOrPsiTypeElement(element);
        return resultType == null ? null : resultType.getJSType();
    }

    @Nullable
    public static JSTypeDeclaration unparenthesizeType(@Nullable JSTypeDeclaration type2) {
        while (type2 instanceof TypeScriptParenthesizedType) {
            type2 = ((TypeScriptParenthesizedType)type2).getInnerType();
        }
        return type2;
    }

    @Nullable
    public static PsiElement getParentSkipTypeParentheses(@NotNull JSTypeDeclaration type2) {
        if (type2 == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(0);
        }
        return PsiTreeUtil.skipParentsOfType((PsiElement)type2, (Class[])new Class[]{TypeScriptParenthesizedType.class});
    }

    @Nullable
    public static JSClass getParentClass(@Nullable PsiElement element) {
        PsiElement secondParent;
        if (element == null) {
            return null;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof JSClass) {
            return (JSClass)parent;
        }
        if (parent instanceof TypeScriptObjectType && (secondParent = parent.getParent()) instanceof JSClass) {
            return (JSClass)secondParent;
        }
        return null;
    }

    public static boolean hasImplicitExportForDeclarations(@Nullable PsiElement moduleOrFile) {
        if (moduleOrFile instanceof TypeScriptModule) {
            return ((TypeScriptModule)moduleOrFile).hasImplicitExportForDeclarations();
        }
        if (moduleOrFile instanceof JSFile) {
            if (!((JSFile)moduleOrFile).isCommonJSModule()) {
                return false;
            }
            if (TypeScriptUtil.isDefinitionFile((JSFile)moduleOrFile)) {
                return !TypeScriptPsiUtil.hasExportStatements(moduleOrFile);
            }
        }
        return false;
    }

    public static boolean hasExportStatements(@NotNull PsiElement moduleOrFile) {
        ES6ImportHandler.ES6ExportCache cache2;
        if (moduleOrFile == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(1);
        }
        return (cache2 = ES6ImportHandler.getExportedCacheForModule(moduleOrFile)) != null && cache2.hasExportStatements();
    }

    public static boolean isAmbientContext(@Nullable PsiElement element) {
        JSAttributeListOwner owner = (JSAttributeListOwner)PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{JSAttributeListOwner.class});
        return TypeScriptPsiUtil.isAmbientDeclaration((PsiElement)owner);
    }

    public static boolean isAmbientDeclaration(@Nullable PsiElement element) {
        if (element instanceof JSAttributeListOwner) {
            if (TypeScriptUtil.isDefinitionFile(element.getContainingFile())) {
                return true;
            }
            while (element != null && !(element instanceof JSFile)) {
                if (TypeScriptPsiUtil.hasAmbientAttribute((JSAttributeListOwner)element)) {
                    return true;
                }
                element = PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{JSClass.class, TypeScriptModule.class, JSFile.class});
            }
        }
        return false;
    }

    public static boolean hasAmbientAttribute(@NotNull JSAttributeListOwner element) {
        if (element == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(2);
        }
        if (element instanceof JSProperty || element instanceof JSRecordType.CallSignature || element instanceof JSRecordType.IndexSignature) {
            return false;
        }
        if (element instanceof TypeScriptModule && ((TypeScriptModule)element).isGlobalScopeAugmentation()) {
            return true;
        }
        JSAttributeList list2 = element.getAttributeList();
        return list2 != null && list2.hasModifier(JSAttributeList.ModifierType.DECLARE);
    }

    public static boolean isNamedTypeDefinition(PsiElement element) {
        return element instanceof JSClass || element instanceof TypeScriptGenericOrMappedTypeParameter || element instanceof ES6ImportExportSpecifier || element instanceof ES6ImportedBinding || element instanceof ES6ImportExportSpecifierAlias || element instanceof TypeScriptImportStatement || element instanceof TypeScriptEnumField;
    }

    public static boolean isNamedTypeContainerDefinition(PsiElement element) {
        return element instanceof JSClass || element instanceof TypeScriptGenericOrMappedTypeParameter || TypeScriptPsiUtil.isNamespaceDefinition(element);
    }

    public static boolean isNamespaceDefinition(@Nullable PsiElement element) {
        return element instanceof TypeScriptModule || element instanceof TypeScriptImportStatement || element instanceof ES6ImportExportSpecifierAlias || element instanceof ES6ExportDefaultAssignment || element instanceof JSFile || element instanceof ES6ImportExportDeclarationPart || element instanceof TypeScriptGlobalModuleExportDeclaration;
    }

    @Nullable
    public static TypeScriptExportAssignment findExportAssignment(@NotNull PsiElement module) {
        if (module == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(3);
        }
        if (!DialectDetector.isTypeScript(module)) {
            return null;
        }
        TypeScriptExportAssignment exportAssignment = null;
        if (module instanceof PsiFileImpl) {
            StubElement stub = ((PsiFileImpl)module).getGreenStub();
            if (stub != null) {
                StubElement exportAssignmentStub = stub.findChildStubByType(TypeScriptStubElementTypes.EXPORT_ASSIGNMENT);
                if (exportAssignmentStub != null) {
                    exportAssignment = (TypeScriptExportAssignment)exportAssignmentStub.getPsi();
                }
            } else {
                exportAssignment = (TypeScriptExportAssignment)((PsiFileImpl)module).findChildByClass(TypeScriptExportAssignment.class);
            }
        } else if (module instanceof TypeScriptModuleImpl) {
            exportAssignment = (TypeScriptExportAssignment)((TypeScriptModuleImpl)module).getStubOrPsiChild(TypeScriptStubElementTypes.EXPORT_ASSIGNMENT);
        }
        return exportAssignment;
    }

    public static boolean isClassMember(JSParameter parameter) {
        return TypeScriptPsiUtil.isFieldParameter(parameter);
    }

    @Nullable
    public static String getNameFromIdentifierOwner(@NotNull JSNamedElement identifierOwner) {
        String nameFromComputed;
        if (identifierOwner == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(4);
        }
        if (identifierOwner instanceof JSComputedPropertyNameOwner && (nameFromComputed = JSPsiImplUtils.getValidNameFromComputedName(((JSComputedPropertyNameOwner)((Object)identifierOwner)).getComputedPropertyName())) != null) {
            return nameFromComputed;
        }
        return TypeScriptPsiUtil.getNameFromIdentifier(identifierOwner.findNameIdentifier());
    }

    @Nullable
    public static String getNameFromIdentifier(@Nullable ASTNode identifier) {
        if (identifier == null) {
            return null;
        }
        if (identifier.getElementType() == JSElementTypes.REFERENCE_EXPRESSION) {
            identifier = identifier.getFirstChildNode();
        }
        if (identifier == null) {
            return null;
        }
        if (JSTokenTypes.STRING_LITERALS.contains(identifier.getElementType())) {
            return JSStringUtil.unquoteAndUnescapeStringLiteralValue(identifier.getText());
        }
        return JSStringUtil.replaceUnicodeEscapeSequences(identifier.getText());
    }

    @Nullable
    public static TypeScriptType getStubOrPsiTypeElement(@NotNull StubBasedPsiElementBase<?> element) {
        if (element == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(5);
        }
        return (TypeScriptType)JSStubBasedPsiTreeUtil.getStubOrPsiChild(element, TypeScriptElementTypes.TYPESCRIPT_TYPES);
    }

    public static TypeScriptType @NotNull [] getStubOrPsiTypeElements(@NotNull StubBasedPsiElementBase<?> element) {
        if (element == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(6);
        }
        TypeScriptType[] typeScriptTypeArray = (TypeScriptType[])element.getStubOrPsiChildren(TypeScriptElementTypes.TYPESCRIPT_TYPES, TypeScriptType.ARRAY_FACTORY);
        if (typeScriptTypeArray == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(7);
        }
        return typeScriptTypeArray;
    }

    @Nullable
    public static TypeScriptType getStubOrPsiTypeElement(@NotNull StubBasedPsiElementBase element, int index) {
        TypeScriptType[] elements;
        if (element == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(8);
        }
        return (elements = TypeScriptPsiUtil.getStubOrPsiTypeElements(element)).length > index ? elements[index] : null;
    }

    @Nullable
    public static TypeScriptType getPsiTypeElement(@NotNull PsiElement element) {
        if (element == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(9);
        }
        return element instanceof StubBasedPsiElementBase ? TypeScriptPsiUtil.getStubOrPsiTypeElement((StubBasedPsiElementBase)element) : (TypeScriptType)PsiTreeUtil.getChildOfType((PsiElement)element, TypeScriptType.class);
    }

    public static boolean isTopLevelContainer(@Nullable PsiElement element) {
        return element instanceof JSFile || element instanceof TypeScriptModule || element instanceof JSEmbeddedContent && !(element.getContainingFile() instanceof JSFile);
    }

    public static boolean isTopLevelContainerMember(@NotNull PsiElement element) {
        if (element == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(10);
        }
        if (!(element instanceof JSQualifiedNamedElement)) {
            return false;
        }
        PsiElement parent = TypeScriptPsiUtil.getParentOverDefaultAssignable(element);
        if (parent instanceof JSVarStatement) {
            parent = parent.getParent();
        }
        if (parent instanceof ES6ExportDefaultAssignment) {
            parent = parent.getParent();
        }
        return TypeScriptPsiUtil.isTopLevelContainer(parent);
    }

    public static boolean isTopLevelContainerMember(@NotNull JSQualifiedObjectStubBase<?> stubElement) {
        StubElement parentStub;
        if (stubElement == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(11);
        }
        if ((parentStub = stubElement.getParentStub()) != null && parentStub.getStubType() == ES6StubElementTypes.EXPORT_DEFAULT_ASSIGNMENT) {
            parentStub = parentStub.getParentStub();
        }
        if (parentStub != null && JSElementTypes.VAR_STATEMENTS.contains((IElementType)parentStub.getStubType())) {
            parentStub = parentStub.getParentStub();
        }
        IStubElementType type2 = parentStub != null ? parentStub.getStubType() : null;
        return type2 == JSStubElementTypes.TYPESCRIPT_MODULE || type2 == null;
    }

    public static PsiElement getParentOverDefaultAssignable(@NotNull PsiElement element) {
        PsiElement parent;
        if (element == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(12);
        }
        if ((parent = element.getContext()) instanceof ES6ExportDefaultAssignment) {
            parent = parent.getContext();
        }
        return parent;
    }

    public static boolean isAmbientModule(@NotNull TypeScriptModule module) {
        if (module == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(13);
        }
        return module.isGlobalScopeAugmentation() || !module.isInternal();
    }

    public static boolean isAugmentationModule(@Nullable PsiElement element) {
        return element instanceof TypeScriptModule && ((TypeScriptModule)element).isAugmentation();
    }

    public static boolean isFromAugmentationModule(@NotNull PsiElement element) {
        if (element == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(14);
        }
        return TypeScriptPsiUtil.isAugmentationModule(ES6PsiUtil.findExternalModule(element));
    }

    public static boolean isAbstractElement(@NotNull JSAttributeListOwner element) {
        JSAttributeList list2;
        if (element == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(15);
        }
        if ((list2 = element.getAttributeList()) == null) {
            return false;
        }
        return list2.hasModifier(JSAttributeList.ModifierType.ABSTRACT);
    }

    public static boolean referencesNamedTypeContainer(@NotNull ES6ImportExportSpecifier specifier) {
        ResolveResult[] results;
        if (specifier == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(16);
        }
        if ((results = specifier.resolveOverAliases()).length == 0) {
            return true;
        }
        for (ResolveResult result2 : results) {
            PsiElement element = result2.getElement();
            if (!TypeScriptPsiUtil.isNamedTypeContainerDefinition(element)) continue;
            return true;
        }
        return false;
    }

    public static boolean isFieldParameter(@NotNull JSParameter parameter) {
        JSAttributeList list2;
        if (parameter == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(17);
        }
        return (list2 = parameter.getAttributeList()) != null && (list2.getExplicitAccessType() != null || list2.hasModifier(JSAttributeList.ModifierType.READONLY) || list2.hasModifier(JSAttributeList.ModifierType.OVERRIDE));
    }

    public static boolean isThisParameter(@NotNull JSParameterItem parameter) {
        if (parameter == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(18);
        }
        return !(parameter instanceof JSDestructuringParameter) && THIS_NAME.equals(parameter.getName());
    }

    @Nullable
    public static JSParameter getThisParameter(@NotNull JSFunction function2) {
        JSParameterList list2;
        if (function2 == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(19);
        }
        if (!((list2 = function2.getParameterList()) instanceof TypeScriptParameterListImpl)) {
            return null;
        }
        JSParameter[] parameters = ((TypeScriptParameterListImpl)list2).getRawParameters();
        if (parameters.length == 0) {
            return null;
        }
        JSParameter parameter = parameters[0];
        return TypeScriptPsiUtil.isThisParameter(parameter) ? parameter : null;
    }

    @Nullable
    public static JSType getThisParameterType(@NotNull JSFunction function2) {
        JSParameter thisParameter;
        if (function2 == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(20);
        }
        return (thisParameter = TypeScriptPsiUtil.getThisParameter(function2)) == null ? null : thisParameter.getJSType();
    }

    @NotNull
    public static TypeScriptFunction getLastOverload(@NotNull TypeScriptFunction function2) {
        if (function2 == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(21);
        }
        TypeScriptFunction prev = null;
        if (!function2.isOverloadDeclaration()) {
            TypeScriptFunction typeScriptFunction = function2;
            if (typeScriptFunction == null) {
                TypeScriptPsiUtil.$$$reportNull$$$0(22);
            }
            return typeScriptFunction;
        }
        for (TypeScriptFunction currentFunction = function2; currentFunction != null; currentFunction = currentFunction.getNextOverloadOrImplementation()) {
            prev = currentFunction;
        }
        TypeScriptFunction typeScriptFunction = prev;
        if (typeScriptFunction == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(23);
        }
        return typeScriptFunction;
    }

    @NotNull
    public static Collection<? extends JSFunctionItem> getAllOverloadSignatures(@NotNull JSFunctionItem functionItem) {
        TypeScriptFunction implementation;
        if (functionItem == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(24);
        }
        if (!(functionItem instanceof TypeScriptFunction)) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                TypeScriptPsiUtil.$$$reportNull$$$0(25);
            }
            return list2;
        }
        TypeScriptFunction tsFunction = (TypeScriptFunction)functionItem;
        LinkedHashSet<JSFunctionItem> result2 = new LinkedHashSet<JSFunctionItem>();
        boolean isOverloadImpl = tsFunction.isOverloadImplementation();
        if (!isOverloadImpl) {
            result2.add(functionItem);
        }
        result2.addAll(TypeScriptPsiUtil.getAllOverloadsWithImplementation(tsFunction));
        TypeScriptFunction typeScriptFunction = implementation = isOverloadImpl ? tsFunction : TypeScriptPsiUtil.getOverloadImplementation(tsFunction);
        if (implementation != null) {
            result2.remove(implementation);
        }
        LinkedHashSet<JSFunctionItem> linkedHashSet = result2;
        if (linkedHashSet == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(26);
        }
        return linkedHashSet;
    }

    @Nullable
    public static TypeScriptFunction getOverloadImplementation(@NotNull TypeScriptFunction function2) {
        TypeScriptFunction overload;
        if (function2 == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(27);
        }
        return (overload = TypeScriptPsiUtil.getLastOverload(function2)) != function2 && overload.isOverloadImplementation() ? overload : null;
    }

    @NotNull
    public static Collection<TypeScriptFunction> getAllOverloadsWithImplementation(@NotNull TypeScriptFunction function2) {
        if (function2 == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(28);
        }
        return TypeScriptPsiUtil.getAllOverloadsWithImplementation(function2, true);
    }

    @NotNull
    public static Collection<TypeScriptFunction> getAllOverloadsWithImplementation(@NotNull TypeScriptFunction function2, boolean removeCurrent) {
        if (function2 == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(29);
        }
        JSClass containingClass = JSUtils.getMemberContainingClass(function2);
        String name = function2.getName();
        if (name != null && containingClass instanceof TypeScriptInterfaceClass) {
            JSFunction.FunctionKind kind = "constructor".equals(name) ? JSFunction.FunctionKind.CONSTRUCTOR : JSFunction.FunctionKind.SIMPLE;
            TypeScriptFunction[] functions = ((TypeScriptInterfaceClass)containingClass).findFunctionsByNameAndKind(name, kind);
            boolean isStatic = JSPsiImplUtils.hasModifier(function2, JSAttributeList.ModifierType.STATIC);
            Set<TypeScriptFunction> result2 = Arrays.stream(functions).filter(f -> JSPsiImplUtils.hasModifier(f, JSAttributeList.ModifierType.STATIC) == isStatic).collect(Collectors.toSet());
            if (removeCurrent) {
                result2.remove(function2);
            }
            Set<TypeScriptFunction> set = result2;
            if (set == null) {
                TypeScriptPsiUtil.$$$reportNull$$$0(30);
            }
            return set;
        }
        TypeScriptFunction overload = TypeScriptPsiUtil.getLastOverload(function2);
        LinkedHashSet result3 = overload == function2 ? new LinkedHashSet() : ContainerUtil.newLinkedHashSet((Object[])new TypeScriptFunction[]{overload});
        result3.addAll(overload.getOverloadDeclarations());
        if (removeCurrent) {
            result3.remove(function2);
        }
        LinkedHashSet linkedHashSet = result3;
        if (linkedHashSet == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(31);
        }
        return linkedHashSet;
    }

    @NotNull
    public static <T, Q extends Collection<T>> Q removeDuplicates(@NotNull Q results, @NotNull Function<? super T, ? extends PsiElement> getResolveResult, @Nullable PsiElement place) {
        if (results == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(32);
        }
        if (getResolveResult == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(33);
        }
        if (results.size() > 20) {
            Q q = results;
            if (q == null) {
                TypeScriptPsiUtil.$$$reportNull$$$0(34);
            }
            return q;
        }
        if (place == null || results.size() <= 1) {
            Q q = results;
            if (q == null) {
                TypeScriptPsiUtil.$$$reportNull$$$0(35);
            }
            return q;
        }
        DialectOptionHolder holder = DialectDetector.dialectOfElement(place);
        if (holder == null || holder.isECMA4) {
            Q q = results;
            if (q == null) {
                TypeScriptPsiUtil.$$$reportNull$$$0(36);
            }
            return q;
        }
        if (results.stream().map(getResolveResult).anyMatch(current -> !JSCoreLibraryElementsCollector.canBeMerged(current))) {
            Q q = results;
            if (q == null) {
                TypeScriptPsiUtil.$$$reportNull$$$0(37);
            }
            return q;
        }
        JSCoreLibraryElementsCollector<T> collector = new JSCoreLibraryElementsCollector<T>(place);
        ArrayList<T> newResult = new ArrayList<T>();
        for (T result2 : results) {
            PsiElement element = getResolveResult.apply(result2);
            if (collector.isLibraryElement(element)) {
                collector.addElement(element, result2);
                continue;
            }
            newResult.add(result2);
        }
        Collection values = collector.getValues();
        for (T currentResult : results) {
            if (!values.contains(currentResult)) continue;
            newResult.add(currentResult);
        }
        ArrayList<T> arrayList = newResult;
        if (arrayList == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(38);
        }
        return (Q)arrayList;
    }

    public static boolean elementsPossiblyContainDuplicates(@NotNull List<? extends ResolveResult> resolveResults) {
        if (resolveResults == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(39);
        }
        for (ResolveResult resolveResult : resolveResults) {
            if (!resolveResult.isValidResult()) {
                return false;
            }
            PsiElement element = resolveResult.getElement();
            if (JSCoreLibraryElementsCollector.canBeMerged(element)) continue;
            return false;
        }
        return true;
    }

    public static boolean isImplementationAndOverloadFunction(PsiElement _element, PsiElement resolvedElement) {
        if (_element instanceof TypeScriptFunction) {
            TypeScriptFunction resolvedFunction;
            TypeScriptFunction function2 = (TypeScriptFunction)_element;
            if (resolvedElement instanceof TypeScriptFunction && (resolvedFunction = (TypeScriptFunction)resolvedElement).isOverloadDeclaration() && function2.isOverloadImplementation() && function2.getOverloadDeclarations().contains(resolvedFunction)) {
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static String getMemberName(@NotNull JSComputedPropertyNameOwner function2) {
        String name;
        if (function2 == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(40);
        }
        if ((name = function2.getName()) == null) {
            name = JSPsiImplUtils.getComputedPropertyNameWithoutBrackets(function2);
        }
        String string = name == null ? "" : JSStringUtil.unquoteAndUnescapeString(name);
        if (string == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(41);
        }
        return string;
    }

    public static boolean isTopLevelThreeSlashComment(@NotNull PsiComment comment) {
        if (comment == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(42);
        }
        if (comment.getParent() instanceof JSFile && DialectDetector.isTypeScript((PsiElement)comment)) {
            ASTNode node = comment.getNode();
            return node.getElementType() == JSTokenTypes.END_OF_LINE_COMMENT && StringUtil.startsWith((CharSequence)node.getChars(), (CharSequence)"///");
        }
        return false;
    }

    public static boolean isLiteralModuleAugmentationName(@Nullable PsiElement element) {
        PsiElement parent;
        return element instanceof JSLiteralExpression && (parent = element.getParent()) instanceof TypeScriptModule && element.isEquivalentTo(((TypeScriptModule)parent).getNameIdentifier());
    }

    public static TypeScriptTypeParameter @NotNull [] getTypeParametersForOwner(@Nullable PsiElement sourceElement) {
        if (!(sourceElement instanceof TypeScriptTypeParameterListOwner)) {
            if (TypeScriptTypeParameter.EMPTY_ARRAY == null) {
                TypeScriptPsiUtil.$$$reportNull$$$0(43);
            }
            return TypeScriptTypeParameter.EMPTY_ARRAY;
        }
        TypeScriptTypeParameterList list2 = ((TypeScriptTypeParameterListOwner)sourceElement).getTypeParameterList();
        TypeScriptTypeParameter[] typeScriptTypeParameterArray = list2 == null ? TypeScriptTypeParameter.EMPTY_ARRAY : list2.getTypeParameters();
        if (typeScriptTypeParameterArray == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(44);
        }
        return typeScriptTypeParameterArray;
    }

    public static JSTypeDeclaration @NotNull [] getNestedTypeArguments(@Nullable Object element) {
        JSTypeDeclaration[] jSTypeDeclarationArray = element instanceof JSTypeArgumentsOwner ? ((JSTypeArgumentsOwner)element).getTypeArguments() : JSTypeDeclaration.EMPTY_ARRAY;
        if (jSTypeDeclarationArray == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(45);
        }
        return jSTypeDeclarationArray;
    }

    public static boolean isTsIndexerType(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        PsiElement parameterType = element.getParent();
        if (!(parameterType instanceof TypeScriptType)) {
            return false;
        }
        PsiElement parent = parameterType.getParent();
        if (parent instanceof TypeScriptUnionOrIntersectionType) {
            parameterType = parent;
            parent = parent.getParent();
        }
        if (parent instanceof JSParameter) {
            parent = parent.getParent();
        }
        return parent instanceof TypeScriptIndexSignature && ((TypeScriptIndexSignature)parent).getParameterType() == parameterType;
    }

    public static boolean isObjectBuiltInTypeProperty(JSRecordType.TypeMember member) {
        JSRecordType.MemberSource source = member.getMemberSource();
        if (source.isEmpty()) {
            if (member instanceof JSCompositeFunctionPropertySignatureImpl) {
                for (JSRecordType.TypeMember typeMember : ((JSCompositeFunctionPropertySignatureImpl)member).getMembers()) {
                    if (TypeScriptPsiUtil.isObjectBuiltInTypeProperty(typeMember)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        JSClass parent = JSUtils.getMemberContainingClass(source.getSingleElement());
        return parent instanceof TypeScriptInterface && "Object".equals(((TypeScriptInterface)parent).getQualifiedName());
    }

    @Contract(value="null, _ -> null; !null, _ -> !null")
    @Nullable
    public static TypeScriptType getParentTypeViaUnionsAndIntersections(@Nullable TypeScriptType type2, boolean includeIntersections) {
        if (type2 == null) {
            return null;
        }
        PsiElement parent = TypeScriptPsiUtil.getParentSkipTypeParentheses(type2);
        if (parent instanceof TypeScriptUnionOrIntersectionType && (includeIntersections || ((TypeScriptUnionOrIntersectionType)parent).isUnionType())) {
            return TypeScriptPsiUtil.getParentTypeViaUnionsAndIntersections((TypeScriptType)parent, includeIntersections);
        }
        return type2;
    }

    public static boolean returnTypeAnnotationForbidden(@NotNull JSElement node) {
        if (node == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(46);
        }
        JSFunction function2 = node instanceof JSFunction ? (JSFunction)node : null;
        return function2 != null && (function2.getKind() == JSFunction.FunctionKind.SETTER || function2.isConstructor());
    }

    @Nullable
    public static PsiElement getPsiElementByRange(@NotNull PsiFile psiFile, TextRange range) {
        int rangeStartOffset;
        PsiElement startElement;
        if (psiFile == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(47);
        }
        if ((startElement = psiFile.findElementAt(rangeStartOffset = range.getStartOffset())) == null) {
            return null;
        }
        PsiElement lastCandidate = startElement;
        int rangeEndOffset = range.getEndOffset();
        for (PsiElement currentElement = startElement; currentElement != null && !(currentElement instanceof PsiFile) && currentElement.getTextRange().getStartOffset() == rangeStartOffset && currentElement.getTextRange().getEndOffset() <= rangeEndOffset; currentElement = currentElement.getParent()) {
            if (currentElement.getTextRange().getEndOffset() == rangeEndOffset) {
                return currentElement;
            }
            lastCandidate = currentElement;
        }
        return lastCandidate;
    }

    @NotNull
    public static List<ResolveResultSink.JSResolveResultForSymbolProcessor> removeCompileTimeTypes(@NotNull List<ResolveResultSink.JSResolveResultForSymbolProcessor> results) {
        if (results == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(48);
        }
        if (results.isEmpty()) {
            List<ResolveResultSink.JSResolveResultForSymbolProcessor> list2 = results;
            if (list2 == null) {
                TypeScriptPsiUtil.$$$reportNull$$$0(49);
            }
            return list2;
        }
        LinkedHashSet<ResolveResult> compileTypeElements = null;
        for (ResolveResultSink.JSResolveResultForSymbolProcessor resultForSymbolProcessor : results) {
            ResolveResult result2 = resultForSymbolProcessor.getResolveResult();
            if (!result2.isValidResult() || !(result2 instanceof JSResolveResult)) continue;
            PsiElement element = result2.getElement();
            if (element instanceof TypeScriptProxyImplicitElementWithBackingItem) {
                element = ((TypeScriptProxyImplicitElementWithBackingItem)element).getBackingElement();
            }
            if (!(element instanceof TypeScriptCompileTimeType)) continue;
            if (compileTypeElements == null) {
                compileTypeElements = new LinkedHashSet<ResolveResult>();
            }
            compileTypeElements.add(result2);
        }
        if (compileTypeElements == null || compileTypeElements.isEmpty()) {
            List<ResolveResultSink.JSResolveResultForSymbolProcessor> list3 = results;
            if (list3 == null) {
                TypeScriptPsiUtil.$$$reportNull$$$0(50);
            }
            return list3;
        }
        if (compileTypeElements.size() != results.size()) {
            LinkedHashSet<ResolveResult> finalCompileTypeElements = compileTypeElements;
            List list4 = ContainerUtil.filter(results, el -> !finalCompileTypeElements.contains(el.getResolveResult()));
            if (list4 == null) {
                TypeScriptPsiUtil.$$$reportNull$$$0(51);
            }
            return list4;
        }
        List list5 = ContainerUtil.map((Collection)compileTypeElements, el -> new ResolveResultSink.JSResolveResultForSymbolProcessor(new JSResolveResult(el.getElement(), ((JSResolveResult)el).getES6Import(), JSResolveResult.ProblemKind.ELEMENT_IS_NOT_ACCESSIBLE)));
        if (list5 == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(52);
        }
        return list5;
    }

    public static boolean isPlaceRuntimeOnly(@Nullable PsiElement place, boolean checkTypeContext) {
        return place instanceof JSReferenceExpression && (!checkTypeContext || !JSResolveUtil.isExprInStrictTypeContext((JSReferenceExpression)place)) && !(place instanceof TypeScriptEntityName) && !(place.getParent() instanceof JSExportAssignment);
    }

    public static boolean isTypeSignature(@Nullable JSFunction function2) {
        return function2 instanceof JSTypeDeclaration || function2 instanceof TypeScriptTypeMember;
    }

    @Nullable
    public static String getPathText(@NotNull Matcher matcher) {
        if (matcher == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(53);
        }
        return matcher.group(3);
    }

    public static boolean isTypeofImport(@NotNull TypeScriptSingleType type2) {
        String qualifiedTypeName;
        if (type2 == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(54);
        }
        return (qualifiedTypeName = type2.getQualifiedTypeName()) != null && qualifiedTypeName.startsWith("typeof import(");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 22, 23, 25, 26, 30, 31, 34, 35, 36, 37, 38, 41, 43, 44, 45, 49, 50, 51, 52 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleOrFile";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifierOwner";
                break;
            }
            case 7: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 30: 
            case 31: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/psi/TypeScriptPsiUtil";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stubElement";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specifier";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 27: 
            case 28: 
            case 29: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionItem";
                break;
            }
            case 32: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getResolveResult";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResults";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/psi/TypeScriptPsiUtil";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubOrPsiTypeElements";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastOverload";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllOverloadSignatures";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllOverloadsWithImplementation";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "removeDuplicates";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getMemberName";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeParametersForOwner";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getNestedTypeArguments";
                break;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "removeCompileTimeTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getParentSkipTypeParentheses";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "hasExportStatements";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hasAmbientAttribute";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findExportAssignment";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNameFromIdentifierOwner";
                break;
            }
            case 5: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getStubOrPsiTypeElement";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getStubOrPsiTypeElements";
                break;
            }
            case 7: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 30: 
            case 31: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPsiTypeElement";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isTopLevelContainerMember";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getParentOverDefaultAssignable";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isAmbientModule";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isFromAugmentationModule";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isAbstractElement";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "referencesNamedTypeContainer";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isFieldParameter";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isThisParameter";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getThisParameter";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getThisParameterType";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getLastOverload";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getAllOverloadSignatures";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getOverloadImplementation";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getAllOverloadsWithImplementation";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "removeDuplicates";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "elementsPossiblyContainDuplicates";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getMemberName";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "isTopLevelThreeSlashComment";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "returnTypeAnnotationForbidden";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getPsiElementByRange";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "removeCompileTimeTypes";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getPathText";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "isTypeofImport";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 22, 23, 25, 26, 30, 31, 34, 35, 36, 37, 38, 41, 43, 44, 45, 49, 50, 51, 52 -> new IllegalStateException(string);
        };
    }
}

